/* accounts-manager.c generated by valac 0.56.3, the Vala compiler
 * generated from accounts-manager.vala, do not modify */

/*
 * Copyright 2017 Software Freedom Conservancy Inc.
 * Copyright 2018 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "geary-engine.h"
#include <goa/goa.h>
#include <gobject/gvaluecollector.h>

#define ACCOUNTS_MANAGER_LOCAL_ID_PREFIX "account_"
#define ACCOUNTS_MANAGER_LOCAL_ID_FORMAT "account_%02u"
#define ACCOUNTS_MANAGER_GOA_ID_PREFIX "goa_"
#define ACCOUNTS_MANAGER_CONFIG_VERSION 1
#define ACCOUNTS_MANAGER_GROUP_METADATA "Metadata"
#define ACCOUNTS_MANAGER_METADATA_STATUS "status"
#define ACCOUNTS_MANAGER_METADATA_VERSION "version"
#define ACCOUNTS_MANAGER_METADATA_GOA "goa_id"
#define ACCOUNTS_ACCOUNT_CONFIG_V1_GROUP_ACCOUNT "Account"
#define ACCOUNTS_ACCOUNT_CONFIG_V1_GROUP_FOLDERS "Folders"
#define ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_LABEL "label"
#define ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_ORDINAL "ordinal"
#define ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_PREFETCH "prefetch_days"
#define ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_PROVIDER "service_provider"
#define ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_SAVE_DRAFTS "save_drafts"
#define ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_SAVE_SENT "save_sent"
#define ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_SENDERS "sender_mailboxes"
#define ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_SIG "signature"
#define ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_USE_SIG "use_signature"
#define ACCOUNTS_ACCOUNT_CONFIG_V1_FOLDER_ARCHIVE "archive_folder"
#define ACCOUNTS_ACCOUNT_CONFIG_V1_FOLDER_DRAFTS "drafts_folder"
#define ACCOUNTS_ACCOUNT_CONFIG_V1_FOLDER_JUNK "junk_folder"
#define ACCOUNTS_ACCOUNT_CONFIG_V1_FOLDER_SENT "sent_folder"
#define ACCOUNTS_ACCOUNT_CONFIG_V1_FOLDER_SPAM "spam_folder"
#define ACCOUNTS_ACCOUNT_CONFIG_V1_FOLDER_TRASH "trash_folder"
#define ACCOUNTS_ACCOUNT_CONFIG_LEGACY_GROUP "AccountInformation"
#define ACCOUNTS_ACCOUNT_CONFIG_LEGACY_ALTERNATE_EMAILS_KEY "alternate_emails"
#define ACCOUNTS_ACCOUNT_CONFIG_LEGACY_ARCHIVE_FOLDER_KEY "archive_folder"
#define ACCOUNTS_ACCOUNT_CONFIG_LEGACY_CREDENTIALS_METHOD_KEY "credentials_method"
#define ACCOUNTS_ACCOUNT_CONFIG_LEGACY_CREDENTIALS_PROVIDER_KEY "credentials_provider"
#define ACCOUNTS_ACCOUNT_CONFIG_LEGACY_DRAFTS_FOLDER_KEY "drafts_folder"
#define ACCOUNTS_ACCOUNT_CONFIG_LEGACY_EMAIL_SIGNATURE_KEY "email_signature"
#define ACCOUNTS_ACCOUNT_CONFIG_LEGACY_NICKNAME_KEY "nickname"
#define ACCOUNTS_ACCOUNT_CONFIG_LEGACY_ORDINAL_KEY "ordinal"
#define ACCOUNTS_ACCOUNT_CONFIG_LEGACY_PREFETCH_PERIOD_DAYS_KEY "prefetch_period_days"
#define ACCOUNTS_ACCOUNT_CONFIG_LEGACY_PRIMARY_EMAIL_KEY "primary_email"
#define ACCOUNTS_ACCOUNT_CONFIG_LEGACY_REAL_NAME_KEY "real_name"
#define ACCOUNTS_ACCOUNT_CONFIG_LEGACY_SAVE_DRAFTS_KEY "save_drafts"
#define ACCOUNTS_ACCOUNT_CONFIG_LEGACY_SAVE_SENT_MAIL_KEY "save_sent_mail"
#define ACCOUNTS_ACCOUNT_CONFIG_LEGACY_SENT_MAIL_FOLDER_KEY "sent_mail_folder"
#define ACCOUNTS_ACCOUNT_CONFIG_LEGACY_SERVICE_PROVIDER_KEY "service_provider"
#define ACCOUNTS_ACCOUNT_CONFIG_LEGACY_SPAM_FOLDER_KEY "spam_folder"
#define ACCOUNTS_ACCOUNT_CONFIG_LEGACY_TRASH_FOLDER_KEY "trash_folder"
#define ACCOUNTS_ACCOUNT_CONFIG_LEGACY_USE_EMAIL_SIGNATURE_KEY "use_email_signature"
#define ACCOUNTS_SERVICE_CONFIG_V1_GROUP_INCOMING "Incoming"
#define ACCOUNTS_SERVICE_CONFIG_V1_GROUP_OUTGOING "Outgoing"
#define ACCOUNTS_SERVICE_CONFIG_V1_CREDENTIALS "credentials"
#define ACCOUNTS_SERVICE_CONFIG_V1_HOST "host"
#define ACCOUNTS_SERVICE_CONFIG_V1_LOGIN "login"
#define ACCOUNTS_SERVICE_CONFIG_V1_PORT "port"
#define ACCOUNTS_SERVICE_CONFIG_V1_REMEMBER_PASSWORD "remember_password"
#define ACCOUNTS_SERVICE_CONFIG_V1_SECURITY "transport_security"
#define ACCOUNTS_SERVICE_CONFIG_LEGACY_HOST "host"
#define ACCOUNTS_SERVICE_CONFIG_LEGACY_PORT "port"
#define ACCOUNTS_SERVICE_CONFIG_LEGACY_REMEMBER_PASSWORD "remember_password"
#define ACCOUNTS_SERVICE_CONFIG_LEGACY_SSL "ssl"
#define ACCOUNTS_SERVICE_CONFIG_LEGACY_STARTTLS "starttls"
#define ACCOUNTS_SERVICE_CONFIG_LEGACY_USERNAME "username"
#define ACCOUNTS_SERVICE_CONFIG_LEGACY_SMTP_NOAUTH "smtp_noauth"
#define ACCOUNTS_SERVICE_CONFIG_LEGACY_SMTP_USE_IMAP_CREDENTIALS "smtp_use_imap_credentials"

#define ACCOUNTS_MANAGER_TYPE_ACCOUNT_STATE (accounts_manager_account_state_get_type ())
#define ACCOUNTS_MANAGER_ACCOUNT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ACCOUNTS_MANAGER_TYPE_ACCOUNT_STATE, AccountsManagerAccountState))
#define ACCOUNTS_MANAGER_ACCOUNT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ACCOUNTS_MANAGER_TYPE_ACCOUNT_STATE, AccountsManagerAccountStateClass))
#define ACCOUNTS_MANAGER_IS_ACCOUNT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ACCOUNTS_MANAGER_TYPE_ACCOUNT_STATE))
#define ACCOUNTS_MANAGER_IS_ACCOUNT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ACCOUNTS_MANAGER_TYPE_ACCOUNT_STATE))
#define ACCOUNTS_MANAGER_ACCOUNT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ACCOUNTS_MANAGER_TYPE_ACCOUNT_STATE, AccountsManagerAccountStateClass))

typedef struct _AccountsManagerAccountState AccountsManagerAccountState;
typedef struct _AccountsManagerAccountStateClass AccountsManagerAccountStateClass;
enum  {
	ACCOUNTS_MANAGER_0_PROPERTY,
	ACCOUNTS_MANAGER_SIZE_PROPERTY,
	ACCOUNTS_MANAGER_CONFIG_DIR_PROPERTY,
	ACCOUNTS_MANAGER_DATA_DIR_PROPERTY,
	ACCOUNTS_MANAGER_NUM_PROPERTIES
};
static GParamSpec* accounts_manager_properties[ACCOUNTS_MANAGER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _AccountsManagerConnectGoaData AccountsManagerConnectGoaData;
#define _accounts_manager_account_state_unref0(var) ((var == NULL) ? NULL : (var = (accounts_manager_account_state_unref (var), NULL)))
typedef struct _AccountsManagerNewOrphanAccountData AccountsManagerNewOrphanAccountData;
typedef struct _AccountsManagerCreateAccountData AccountsManagerCreateAccountData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AccountsManagerLoadAccountsData AccountsManagerLoadAccountsData;
typedef struct _AccountsManagerRemoveAccountData AccountsManagerRemoveAccountData;
typedef struct _AccountsManagerRestoreAccountData AccountsManagerRestoreAccountData;
typedef struct _AccountsManagerExpungeAccountsData AccountsManagerExpungeAccountsData;
typedef struct _AccountsManagerSaveAccountData AccountsManagerSaveAccountData;
typedef struct _AccountsManagerUpdateLocalCredentialsData AccountsManagerUpdateLocalCredentialsData;
typedef struct _AccountsManagerAddGoaAccountData AccountsManagerAddGoaAccountData;
typedef struct _AccountsManagerShowGoaAccountData AccountsManagerShowGoaAccountData;
typedef struct _AccountsManagerNextIdData AccountsManagerNextIdData;
#define _geary_config_file_unref0(var) ((var == NULL) ? NULL : (var = (geary_config_file_unref (var), NULL)))
#define _geary_config_file_group_unref0(var) ((var == NULL) ? NULL : (var = (geary_config_file_group_unref (var), NULL)))
typedef struct _AccountsManagerLoadAccountData AccountsManagerLoadAccountData;
typedef struct _AccountsManagerSaveAccountLockedData AccountsManagerSaveAccountLockedData;
typedef struct _AccountsManagerDeleteAccountData AccountsManagerDeleteAccountData;
typedef struct _AccountsManagerCreateAccountDirsData AccountsManagerCreateAccountDirsData;
typedef struct _AccountsManagerCreateGoaAccountData AccountsManagerCreateGoaAccountData;
typedef struct _AccountsManagerUpdateGoaAccountData AccountsManagerUpdateGoaAccountData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _AccountsManagerOpenGoaSettingsData AccountsManagerOpenGoaSettingsData;
typedef struct _Block49Data Block49Data;
typedef struct _AccountsManagerAccountStatePrivate AccountsManagerAccountStatePrivate;
typedef struct _AccountsManagerParamSpecAccountState AccountsManagerParamSpecAccountState;
enum  {
	ACCOUNTS_MANAGER_ACCOUNT_ADDED_SIGNAL,
	ACCOUNTS_MANAGER_ACCOUNT_STATUS_CHANGED_SIGNAL,
	ACCOUNTS_MANAGER_ACCOUNT_REMOVED_SIGNAL,
	ACCOUNTS_MANAGER_REPORT_PROBLEM_SIGNAL,
	ACCOUNTS_MANAGER_NUM_SIGNALS
};
static guint accounts_manager_signals[ACCOUNTS_MANAGER_NUM_SIGNALS] = {0};
enum  {
	ACCOUNTS_ACCOUNT_CONFIG_V1_0_PROPERTY,
	ACCOUNTS_ACCOUNT_CONFIG_V1_NUM_PROPERTIES
};
static GParamSpec* accounts_account_config_v1_properties[ACCOUNTS_ACCOUNT_CONFIG_V1_NUM_PROPERTIES];
enum  {
	ACCOUNTS_ACCOUNT_CONFIG_LEGACY_0_PROPERTY,
	ACCOUNTS_ACCOUNT_CONFIG_LEGACY_NUM_PROPERTIES
};
static GParamSpec* accounts_account_config_legacy_properties[ACCOUNTS_ACCOUNT_CONFIG_LEGACY_NUM_PROPERTIES];
enum  {
	ACCOUNTS_SERVICE_CONFIG_V1_0_PROPERTY,
	ACCOUNTS_SERVICE_CONFIG_V1_NUM_PROPERTIES
};
static GParamSpec* accounts_service_config_v1_properties[ACCOUNTS_SERVICE_CONFIG_V1_NUM_PROPERTIES];
enum  {
	ACCOUNTS_SERVICE_CONFIG_LEGACY_0_PROPERTY,
	ACCOUNTS_SERVICE_CONFIG_LEGACY_NUM_PROPERTIES
};
static GParamSpec* accounts_service_config_legacy_properties[ACCOUNTS_SERVICE_CONFIG_LEGACY_NUM_PROPERTIES];

struct _AccountsManagerPrivate {
	GFile* _config_dir;
	GFile* _data_dir;
	GeeMap* accounts;
	GeeLinkedList* removed;
	GearyCredentialsMediator* local_mediator;
	GoaClient* goa_service;
};

struct _AccountsManagerConnectGoaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountsManager* self;
	GCancellable* cancellable;
	GoaClient* _tmp0_;
	GoaClient* _tmp1_;
	GoaClient* _tmp2_;
	GoaClient* _tmp3_;
	GoaClient* _tmp4_;
	GoaClient* _tmp5_;
	GError* _inner_error0_;
};

struct _AccountsManagerNewOrphanAccountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountsManager* self;
	GearyServiceProvider provider;
	GearyRFC822MailboxAddress* primary_mailbox;
	GCancellable* cancellable;
	GearyAccountInformation* result;
	gchar* id;
	gchar* _tmp0_;
	GearyCredentialsMediator* _tmp1_;
	GearyAccountInformation* _tmp2_;
};

struct _AccountsManagerCreateAccountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountsManager* self;
	GearyAccountInformation* account;
	GCancellable* cancellable;
	SecretMediator* mediator;
	GearyCredentialsMediator* _tmp0_;
	GearyCredentialsMediator* _tmp1_;
	SecretMediator* _tmp2_;
	SecretMediator* _tmp3_;
	SecretMediator* _tmp4_;
	GearyServiceInformation* _tmp5_;
	GearyServiceInformation* _tmp6_;
	SecretMediator* _tmp7_;
	GearyServiceInformation* _tmp8_;
	GearyServiceInformation* _tmp9_;
	GError* _inner_error0_;
};

struct _AccountsManagerLoadAccountsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountsManager* self;
	GCancellable* cancellable;
	GFileEnumerator* enumerator;
	GFileEnumerator* _tmp0_;
	GFile* _tmp1_;
	GFileEnumerator* _tmp2_;
	GFileEnumerator* _tmp3_;
	gboolean _tmp4_;
	GFileEnumerator* _tmp5_;
	GList* info_list;
	GFileEnumerator* _tmp6_;
	GList* _tmp7_;
	guint len;
	GList* _tmp8_;
	guint i;
	gboolean _tmp9_;
	guint _tmp10_;
	gboolean _tmp11_;
	GFileInfo* file;
	GList* _tmp12_;
	gconstpointer _tmp13_;
	GFileInfo* _tmp14_;
	GFileInfo* _tmp15_;
	gchar* id;
	GFileInfo* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	GearyAccountInformation* info;
	const gchar* _tmp19_;
	GearyAccountInformation* _tmp20_;
	GearyAccountInformation* _tmp21_;
	GError* err;
	const gchar* _tmp22_;
	GError* _tmp23_;
	GearyProblemReport* _tmp24_;
	GearyProblemReport* _tmp25_;
	GoaClient* _tmp26_;
	GList* list;
	GoaClient* _tmp27_;
	GList* _tmp28_;
	gint _vala1_i;
	gboolean _tmp29_;
	gint _tmp30_;
	gboolean _tmp31_;
	GList* _tmp32_;
	GoaObject* account;
	GList* _tmp33_;
	gconstpointer _tmp34_;
	GoaObject* _tmp35_;
	gchar* _vala1_id;
	GoaObject* _tmp36_;
	gchar* _tmp37_;
	GeeMap* _tmp38_;
	const gchar* _tmp39_;
	GoaObject* _tmp40_;
	GError* _inner_error0_;
};

struct _AccountsManagerRemoveAccountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountsManager* self;
	GearyAccountInformation* account;
	GCancellable* cancellable;
	GeeMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GeeLinkedList* _tmp3_;
	guint _tmp4_;
	GError* _inner_error0_;
};

struct _AccountsManagerRestoreAccountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountsManager* self;
	GearyAccountInformation* account;
	GCancellable* cancellable;
	GeeLinkedList* _tmp0_;
	GError* _inner_error0_;
};

struct _AccountsManagerExpungeAccountsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountsManager* self;
	GCancellable* cancellable;
	gboolean _tmp0_;
	GeeLinkedList* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GeeLinkedList* _tmp4_;
	gpointer _tmp5_;
	GearyAccountInformation* _tmp6_;
	GError* _inner_error0_;
};

struct _AccountsManagerSaveAccountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountsManager* self;
	GearyAccountInformation* info;
	GCancellable* cancellable;
	gint token;
	GearyNonblockingMutex* _tmp0_;
	GearyNonblockingMutex* _tmp1_;
	GError* thrown;
	GError* err;
	GError* _tmp2_;
	GError* _tmp3_;
	GearyNonblockingMutex* _tmp4_;
	GearyNonblockingMutex* _tmp5_;
	GError* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError* _inner_error0_;
};

struct _AccountsManagerUpdateLocalCredentialsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountsManager* self;
	GearyAccountInformation* account;
	GearyServiceInformation* old_service;
	GearyServiceInformation* new_service;
	GCancellable* cancellable;
	SecretMediator* mediator;
	GearyCredentialsMediator* _tmp0_;
	GearyCredentialsMediator* _tmp1_;
	SecretMediator* _tmp2_;
	SecretMediator* _tmp3_;
	GearyCredentials* _tmp4_;
	GearyCredentials* _tmp5_;
	SecretMediator* _tmp6_;
	gboolean _tmp7_;
	GearyCredentials* _tmp8_;
	GearyCredentials* _tmp9_;
	gboolean _tmp10_;
	GearyCredentials* _tmp11_;
	GearyCredentials* _tmp12_;
	gboolean _tmp13_;
	GearyCredentials* _tmp14_;
	GearyCredentials* _tmp15_;
	GearyCredentials* _tmp16_;
	GearyCredentials* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GearyCredentials* _tmp20_;
	GearyCredentials* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	SecretMediator* _tmp24_;
	GError* _inner_error0_;
};

struct _AccountsManagerAddGoaAccountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountsManager* self;
	GearyServiceProvider type;
	GCancellable* cancellable;
	GError* _tmp0_;
	GError* _inner_error0_;
};

struct _AccountsManagerShowGoaAccountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountsManager* self;
	GearyAccountInformation* account;
	GCancellable* cancellable;
	GError* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _inner_error0_;
};

struct _AccountsManagerNextIdData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountsManager* self;
	GCancellable* cancellable;
	gchar* result;
	gchar* last_account;
	GeeMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	gpointer _tmp4_;
	gchar* _tmp5_;
	guint next_id;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* id;
	gchar* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	GFile* _tmp15_;
	const gchar* _tmp16_;
	GFile* _tmp17_;
	GFile* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	GFile* _tmp21_;
	const gchar* _tmp22_;
	GFile* _tmp23_;
	GFile* _tmp24_;
	gboolean _tmp25_;
	guint _tmp26_;
	gchar* _tmp27_;
	GError* err;
	GError* _tmp28_;
	const gchar* _tmp29_;
	GError* _inner_error0_;
};

struct _AccountsManagerLoadAccountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountsManager* self;
	gchar* id;
	GCancellable* cancellable;
	GearyAccountInformation* result;
	GFile* config_dir;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* data_dir;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GearyConfigFile* config;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GearyConfigFile* _tmp7_;
	GearyConfigFile* _tmp8_;
	GearyConfigFile* _tmp9_;
	GError* err;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GError* _tmp12_;
	GError* _vala1_err;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError* _tmp15_;
	GearyConfigFileGroup* metadata_config;
	GearyConfigFile* _tmp16_;
	GearyConfigFileGroup* _tmp17_;
	gint version;
	GearyConfigFileGroup* _tmp18_;
	AccountsManagerStatus status;
	AccountsManagerStatus _tmp19_;
	GearyConfigFileGroup* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	AccountsManagerStatus _tmp25_;
	GError* _tmp26_;
	gchar* goa_id;
	GearyConfigFileGroup* _tmp27_;
	gchar* _tmp28_;
	gboolean is_goa;
	const gchar* _tmp29_;
	gboolean _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	GoaObject* goa_handle;
	GoaMediator* goa_mediator;
	GearyServiceProvider* default_provider;
	GearyCredentialsMediator* mediator;
	GearyCredentialsMediator* _tmp33_;
	GearyCredentialsMediator* _tmp34_;
	GoaClient* _tmp35_;
	GError* _tmp36_;
	GoaClient* _tmp37_;
	const gchar* _tmp38_;
	GoaObject* _tmp39_;
	GoaObject* _tmp40_;
	GoaObject* _tmp41_;
	GoaMediator* _tmp42_;
	GoaMediator* _tmp43_;
	GearyCredentialsMediator* _tmp44_;
	GoaMediator* _tmp45_;
	GearyServiceProvider _tmp46_;
	GearyServiceProvider* _tmp47_;
	const gchar* _tmp48_;
	GearyServiceProvider _tmp49_;
	GearyServiceProvider* _tmp50_;
	AccountsAccountConfig* accounts;
	AccountsServiceConfig* services;
	AccountsAccountConfigLegacy* _tmp51_;
	AccountsServiceConfigLegacy* _tmp52_;
	AccountsAccountConfigV1* _tmp53_;
	AccountsServiceConfigV1* _tmp54_;
	GError* _tmp55_;
	GearyAccountInformation* account;
	GearyAccountInformation* _tmp56_;
	AccountsAccountConfig* _tmp57_;
	GearyConfigFile* _tmp58_;
	GearyCredentialsMediator* _tmp59_;
	GearyServiceProvider* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	GearyAccountInformation* _tmp63_;
	GearyAccountInformation* _tmp64_;
	GearyAccountInformation* _tmp65_;
	GearyAccountInformation* _tmp66_;
	GFile* _tmp67_;
	GFile* _tmp68_;
	GError* _vala2_err;
	GError* _tmp69_;
	const gchar* _tmp70_;
	GError* _tmp71_;
	GeeLinkedList* _tmp72_;
	GearyAccountInformation* _tmp73_;
	GError* _tmp74_;
	AccountsServiceConfig* _tmp75_;
	GearyConfigFile* _tmp76_;
	GearyAccountInformation* _tmp77_;
	GearyAccountInformation* _tmp78_;
	GearyServiceInformation* _tmp79_;
	GearyServiceInformation* _tmp80_;
	AccountsServiceConfig* _tmp81_;
	GearyConfigFile* _tmp82_;
	GearyAccountInformation* _tmp83_;
	GearyAccountInformation* _tmp84_;
	GearyServiceInformation* _tmp85_;
	GearyServiceInformation* _tmp86_;
	GError* _vala3_err;
	GError* _tmp87_;
	const gchar* _tmp88_;
	GError* _tmp89_;
	GearyAccountInformation* _tmp90_;
	GoaMediator* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	GoaMediator* _tmp94_;
	GearyAccountInformation* _tmp95_;
	GError* _vala4_err;
	GError* _tmp96_;
	const gchar* _tmp97_;
	GError* _tmp98_;
	GoaObject* _tmp99_;
	GearyAccountInformation* _tmp100_;
	GError* _tmp101_;
	GearyAccountInformation* _tmp102_;
	GError* _tmp103_;
	GError* _inner_error0_;
};

struct _AccountsManagerSaveAccountLockedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountsManager* self;
	GearyAccountInformation* account;
	GCancellable* cancellable;
	GFile* _tmp0_;
	GFile* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError* _tmp4_;
	GearyConfigFile* config;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GearyConfigFile* _tmp9_;
	GearyConfigFile* _tmp10_;
	GError* err;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GearyConfigFileGroup* metadata_config;
	GearyConfigFileGroup* _tmp13_;
	GearyConfigFileGroup* _tmp14_;
	GearyConfigFileGroup* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gboolean is_goa;
	GearyConfigFileGroup* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	AccountsAccountConfig* accounts;
	AccountsAccountConfigV1* _tmp23_;
	AccountsAccountConfig* _tmp24_;
	AccountsServiceConfig* services;
	AccountsServiceConfigV1* _tmp25_;
	AccountsServiceConfig* _tmp26_;
	GearyServiceInformation* _tmp27_;
	GearyServiceInformation* _tmp28_;
	AccountsServiceConfig* _tmp29_;
	GearyServiceInformation* _tmp30_;
	GearyServiceInformation* _tmp31_;
	GFile* _tmp32_;
	GFile* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GError* _inner_error0_;
};

struct _AccountsManagerDeleteAccountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountsManager* self;
	GearyAccountInformation* info;
	GCancellable* cancellable;
	SecretMediator* mediator;
	GearyCredentialsMediator* _tmp0_;
	GearyCredentialsMediator* _tmp1_;
	SecretMediator* _tmp2_;
	SecretMediator* _tmp3_;
	SecretMediator* _tmp4_;
	GearyServiceInformation* _tmp5_;
	GearyServiceInformation* _tmp6_;
	GError* e;
	GError* _tmp7_;
	const gchar* _tmp8_;
	SecretMediator* _tmp9_;
	GearyServiceInformation* _tmp10_;
	GearyServiceInformation* _tmp11_;
	GError* _vala1_e;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	GFile* _tmp18_;
	GFile* _tmp19_;
	GFile* _tmp20_;
	GFile* _tmp21_;
	GError* _inner_error0_;
};

struct _AccountsManagerCreateAccountDirsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountsManager* self;
	GearyAccountInformation* info;
	GCancellable* cancellable;
	GFile* config;
	GFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* data;
	GFile* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GError* _inner_error0_;
};

struct _AccountsManagerCreateGoaAccountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountsManager* self;
	GoaObject* account;
	GCancellable* cancellable;
	GoaMail* mail;
	GoaMail* _tmp0_;
	gchar* name;
	GoaMail* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GoaMediator* mediator;
	GoaMediator* _tmp6_;
	GearyAccountInformation* info;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GoaMediator* _tmp9_;
	GoaMediator* _tmp10_;
	const gchar* _tmp11_;
	GoaMail* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GearyRFC822MailboxAddress* _tmp16_;
	GearyRFC822MailboxAddress* _tmp17_;
	GearyAccountInformation* _tmp18_;
	GearyAccountInformation* _tmp19_;
	GearyAccountInformation* _tmp20_;
	gint _tmp21_;
	GearyAccountInformation* _tmp22_;
	GoaMediator* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GearyAccountInformation* _tmp26_;
	GoaAccount* _tmp27_;
	GoaAccount* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GearyAccountInformation* _tmp32_;
	GearyAccountInformation* _tmp33_;
	GoaMediator* _tmp34_;
	GearyAccountInformation* _tmp35_;
	GError* err;
	GError* _tmp36_;
	GearyProblemReport* _tmp37_;
	GearyProblemReport* _tmp38_;
	GearyAccountInformation* _tmp39_;
	GoaAccount* _tmp40_;
	GoaAccount* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	GoaAccount* _tmp45_;
	GoaAccount* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	GError* _inner_error0_;
};

struct _AccountsManagerUpdateGoaAccountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountsManager* self;
	GearyAccountInformation* account;
	gboolean is_available;
	GCancellable* cancellable;
	GoaMediator* mediator;
	GearyCredentialsMediator* _tmp0_;
	GearyCredentialsMediator* _tmp1_;
	GoaMediator* _tmp2_;
	GoaMediator* _tmp3_;
	GError* err;
	GError* _tmp4_;
	GearyAccountProblemReport* _tmp5_;
	GearyAccountProblemReport* _tmp6_;
	GError* _inner_error0_;
};

struct _AccountsManagerOpenGoaSettingsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountsManager* self;
	gchar* action;
	gchar* param;
	GCancellable* cancellable;
	GDBusProxy* settings;
	GDBusProxy* _tmp0_;
	GVariant** args;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant** _tmp4_;
	GVariant** _tmp5_;
	gint _tmp5__length1;
	gint args_length1;
	gint _args_size_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	GVariant* command;
	GVariant* _tmp9_;
	const GVariantType* _tmp10_;
	GVariant** _tmp11_;
	gint _tmp11__length1;
	GVariant* _tmp12_;
	GVariant** _tmp13_;
	GVariant** _tmp14_;
	gint _tmp14__length1;
	GVariant* _tmp15_;
	GVariant* _tmp16_;
	GVariant* params;
	GVariant* _tmp17_;
	const GVariantType* _tmp18_;
	GVariant* _tmp19_;
	GVariant* _tmp20_;
	GVariant** _tmp21_;
	GVariant** _tmp22_;
	gint _tmp22__length1;
	GVariant* _tmp23_;
	GVariant* _tmp24_;
	GVariant** _tmp25_;
	GVariant** _tmp26_;
	gint _tmp26__length1;
	GVariant* _tmp27_;
	GVariant* _tmp28_;
	GDBusProxy* _tmp29_;
	GVariant* _tmp30_;
	GVariant* _tmp31_;
	GVariant* _tmp32_;
	GError* _inner_error0_;
};

struct _Block49Data {
	int _ref_count_;
	AccountsManager* self;
	GearyAccountInformation* account;
};

struct _AccountsManagerAccountState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AccountsManagerAccountStatePrivate * priv;
};

struct _AccountsManagerAccountStateClass {
	GTypeClass parent_class;
	void (*finalize) (AccountsManagerAccountState *self);
};

struct _AccountsManagerAccountStatePrivate {
	GearyAccountInformation* _account;
	gboolean _enabled;
	gboolean _available;
};

struct _AccountsManagerParamSpecAccountState {
	GParamSpec parent_instance;
};

struct _AccountsAccountConfigV1Private {
	gboolean is_managed;
};

static gint AccountsManager_private_offset;
static gpointer accounts_manager_parent_class = NULL;
static gint AccountsManagerAccountState_private_offset;
static gpointer accounts_manager_account_state_parent_class = NULL;
static gint AccountsAccountConfigV1_private_offset;
static gpointer accounts_account_config_v1_parent_class = NULL;
static AccountsAccountConfigIface * accounts_account_config_v1_accounts_account_config_parent_iface = NULL;
static gpointer accounts_account_config_legacy_parent_class = NULL;
static AccountsAccountConfigIface * accounts_account_config_legacy_accounts_account_config_parent_iface = NULL;
static gpointer accounts_service_config_v1_parent_class = NULL;
static AccountsServiceConfigIface * accounts_service_config_v1_accounts_service_config_parent_iface = NULL;
static gpointer accounts_service_config_legacy_parent_class = NULL;
static AccountsServiceConfigIface * accounts_service_config_legacy_accounts_service_config_parent_iface = NULL;

static gpointer accounts_manager_account_state_ref (gpointer instance);
static void accounts_manager_account_state_unref (gpointer instance);
static GParamSpec* accounts_manager_param_spec_account_state (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags) G_GNUC_UNUSED ;
static void accounts_manager_value_set_account_state (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED ;
static void accounts_manager_value_take_account_state (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED ;
static gpointer accounts_manager_value_get_account_state (const GValue* value) G_GNUC_UNUSED ;
static GType accounts_manager_account_state_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void accounts_manager_set_config_dir (AccountsManager* self,
                                      GFile* value);
static void accounts_manager_set_data_dir (AccountsManager* self,
                                    GFile* value);
static void g_cclosure_user_marshal_VOID__OBJECT_ENUM (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void accounts_manager_connect_goa_data_free (gpointer _data);
static gboolean accounts_manager_connect_goa_co (AccountsManagerConnectGoaData* _data_);
static void accounts_manager_connect_goa_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static void accounts_manager_on_goa_account_added (AccountsManager* self,
                                            GoaObject* account);
static void _accounts_manager_on_goa_account_added_goa_client_account_added (GoaClient* _sender,
                                                                      GoaObject* object,
                                                                      gpointer self);
static void accounts_manager_on_goa_account_changed (AccountsManager* self,
                                              GoaObject* account);
static void _accounts_manager_on_goa_account_changed_goa_client_account_changed (GoaClient* _sender,
                                                                          GoaObject* object,
                                                                          gpointer self);
static void accounts_manager_on_goa_account_removed (AccountsManager* self,
                                              GoaObject* account);
static void _accounts_manager_on_goa_account_removed_goa_client_account_removed (GoaClient* _sender,
                                                                          GoaObject* object,
                                                                          gpointer self);
static GearyAccountInformation* accounts_manager_account_state_get_account (AccountsManagerAccountState* self);
static AccountsManagerStatus accounts_manager_account_state_get_status (AccountsManagerAccountState* self);
static GearyAccountInformation* __lambda52_ (AccountsManager* self,
                                      AccountsManagerAccountState* state);
static gpointer ___lambda52__gee_map_func (gpointer g,
                                    gpointer self);
static void accounts_manager_new_orphan_account_data_free (gpointer _data);
static gboolean accounts_manager_new_orphan_account_co (AccountsManagerNewOrphanAccountData* _data_);
static void accounts_manager_next_id (AccountsManager* self,
                               GCancellable* cancellable,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
static gchar* accounts_manager_next_id_finish (AccountsManager* self,
                                        GAsyncResult* _res_);
static void accounts_manager_new_orphan_account_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void accounts_manager_create_account_data_free (gpointer _data);
static gboolean accounts_manager_create_account_co (AccountsManagerCreateAccountData* _data_);
static void accounts_manager_create_account_dirs (AccountsManager* self,
                                           GearyAccountInformation* info,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void accounts_manager_create_account_dirs_finish (AccountsManager* self,
                                                  GAsyncResult* _res_,
                                                  GError** error);
static void accounts_manager_create_account_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static gboolean accounts_manager_set_enabled (AccountsManager* self,
                                       GearyAccountInformation* account,
                                       gboolean is_enabled);
static void accounts_manager_load_accounts_data_free (gpointer _data);
static gboolean accounts_manager_load_accounts_co (AccountsManagerLoadAccountsData* _data_);
static void accounts_manager_load_accounts_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void accounts_manager_load_account (AccountsManager* self,
                                    const gchar* id,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static GearyAccountInformation* accounts_manager_load_account_finish (AccountsManager* self,
                                                               GAsyncResult* _res_,
                                                               GError** error);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static inline gchar* accounts_manager_to_geary_id (AccountsManager* self,
                                     GoaObject* account);
static void accounts_manager_create_goa_account (AccountsManager* self,
                                          GoaObject* account,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void accounts_manager_create_goa_account_finish (AccountsManager* self,
                                                 GAsyncResult* _res_);
static gboolean accounts_manager_set_available (AccountsManager* self,
                                         GearyAccountInformation* account,
                                         gboolean is_available);
static void accounts_manager_remove_account_data_free (gpointer _data);
static gboolean accounts_manager_remove_account_co (AccountsManagerRemoveAccountData* _data_);
static void accounts_manager_on_account_changed (AccountsManager* self,
                                          GearyAccountInformation* account);
static void _accounts_manager_on_account_changed_geary_account_information_changed (GearyAccountInformation* _sender,
                                                                             gpointer self);
static void accounts_manager_remove_account_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void accounts_manager_restore_account_data_free (gpointer _data);
static gboolean accounts_manager_restore_account_co (AccountsManagerRestoreAccountData* _data_);
static void accounts_manager_restore_account_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static void accounts_manager_expunge_accounts_data_free (gpointer _data);
static gboolean accounts_manager_expunge_accounts_co (AccountsManagerExpungeAccountsData* _data_);
static void accounts_manager_delete_account (AccountsManager* self,
                                      GearyAccountInformation* info,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static void accounts_manager_delete_account_finish (AccountsManager* self,
                                             GAsyncResult* _res_,
                                             GError** error);
static void accounts_manager_expunge_accounts_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void accounts_manager_save_account_data_free (gpointer _data);
static gboolean accounts_manager_save_account_co (AccountsManagerSaveAccountData* _data_);
static void accounts_manager_save_account_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void accounts_manager_save_account_locked (AccountsManager* self,
                                           GearyAccountInformation* account,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void accounts_manager_save_account_locked_finish (AccountsManager* self,
                                                  GAsyncResult* _res_,
                                                  GError** error);
static void accounts_manager_update_local_credentials_data_free (gpointer _data);
static gboolean accounts_manager_update_local_credentials_co (AccountsManagerUpdateLocalCredentialsData* _data_);
static void accounts_manager_update_local_credentials_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void accounts_manager_add_goa_account_data_free (gpointer _data);
static gboolean accounts_manager_add_goa_account_co (AccountsManagerAddGoaAccountData* _data_);
static void accounts_manager_open_goa_settings (AccountsManager* self,
                                         const gchar* action,
                                         const gchar* param,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static void accounts_manager_open_goa_settings_finish (AccountsManager* self,
                                                GAsyncResult* _res_,
                                                GError** error);
static void accounts_manager_add_goa_account_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static void accounts_manager_show_goa_account_data_free (gpointer _data);
static gboolean accounts_manager_show_goa_account_co (AccountsManagerShowGoaAccountData* _data_);
static inline gchar* accounts_manager_to_goa_id (AccountsManager* self,
                                   const gchar* id);
static void accounts_manager_show_goa_account_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void accounts_manager_next_id_data_free (gpointer _data);
static gboolean accounts_manager_next_id_co (AccountsManagerNextIdData* _data_);
static gchar* __lambda53_ (AccountsManager* self,
                    gchar* next,
                    gchar* last);
static gpointer ___lambda53__gee_fold_func (gpointer g,
                                     gpointer a,
                                     gpointer self);
static void accounts_manager_next_id_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_);
static void accounts_manager_load_account_data_free (gpointer _data);
static gboolean accounts_manager_load_account_co (AccountsManagerLoadAccountData* _data_);
static void accounts_manager_load_account_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static GearyServiceProvider* _geary_service_provider_dup (GearyServiceProvider* self);
static gboolean accounts_manager_is_valid_goa_account (AccountsManager* self,
                                                GoaObject* handle);
static void accounts_manager_save_account_locked_data_free (gpointer _data);
static gboolean accounts_manager_save_account_locked_co (AccountsManagerSaveAccountLockedData* _data_);
static void accounts_manager_save_account_locked_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void accounts_manager_delete_account_data_free (gpointer _data);
static gboolean accounts_manager_delete_account_co (AccountsManagerDeleteAccountData* _data_);
static void accounts_manager_delete_account_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static inline AccountsManagerAccountState* accounts_manager_lookup_state (AccountsManager* self,
                                                            GearyAccountInformation* account);
static AccountsManagerAccountState* accounts_manager_account_state_new (GearyAccountInformation* account);
static AccountsManagerAccountState* accounts_manager_account_state_construct (GType object_type,
                                                                       GearyAccountInformation* account);
static void accounts_manager_account_state_set_enabled (AccountsManagerAccountState* self,
                                                 gboolean value);
static void accounts_manager_account_state_set_available (AccountsManagerAccountState* self,
                                                   gboolean value);
static void accounts_manager_create_account_dirs_data_free (gpointer _data);
static gboolean accounts_manager_create_account_dirs_co (AccountsManagerCreateAccountDirsData* _data_);
static void accounts_manager_create_account_dirs_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void accounts_manager_create_goa_account_data_free (gpointer _data);
static gboolean accounts_manager_create_goa_account_co (AccountsManagerCreateGoaAccountData* _data_);
static void accounts_manager_create_goa_account_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void accounts_manager_update_goa_account_data_free (gpointer _data);
static void accounts_manager_update_goa_account (AccountsManager* self,
                                          GearyAccountInformation* account,
                                          gboolean is_available,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void accounts_manager_update_goa_account_finish (AccountsManager* self,
                                                 GAsyncResult* _res_);
static gboolean accounts_manager_update_goa_account_co (AccountsManagerUpdateGoaAccountData* _data_);
static void accounts_manager_update_goa_account_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void accounts_manager_open_goa_settings_data_free (gpointer _data);
static gboolean accounts_manager_open_goa_settings_co (AccountsManagerOpenGoaSettingsData* _data_);
static void accounts_manager_open_goa_settings_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static void _vala_array_add13 (GVariant** * array,
                        gint* length,
                        gint* size,
                        GVariant* value);
static Block49Data* block49_data_ref (Block49Data* _data49_);
static void block49_data_unref (void * _userdata_);
static void __lambda51_ (Block49Data* _data49_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda51__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void accounts_manager_account_state_set_account (AccountsManagerAccountState* self,
                                                 GearyAccountInformation* value);
static gboolean accounts_manager_account_state_get_enabled (AccountsManagerAccountState* self);
static gboolean accounts_manager_account_state_get_available (AccountsManagerAccountState* self);
static void accounts_manager_account_state_finalize (AccountsManagerAccountState * obj);
static GType accounts_manager_account_state_get_type_once (void);
static void accounts_manager_finalize (GObject * obj);
static GType accounts_manager_get_type_once (void);
static void _vala_accounts_manager_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_accounts_manager_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static GType accounts_account_config_get_type_once (void);
static GType accounts_service_config_get_type_once (void);
static GearyAccountInformation* accounts_account_config_v1_real_load (AccountsAccountConfig* base,
                                                               GearyConfigFile* config,
                                                               const gchar* id,
                                                               GearyCredentialsMediator* mediator,
                                                               GearyServiceProvider* default_provider,
                                                               const gchar* default_name,
                                                               GError** error);
static GearyServiceProvider ___lambda47_ (AccountsAccountConfigV1* self,
                                   const gchar* value,
                                   GError** error);
static gpointer ____lambda47__geary_config_file_parser (const gchar* value,
                                                 gpointer self,
                                                 GError** error);
static void accounts_account_config_v1_real_save (AccountsAccountConfig* base,
                                           GearyAccountInformation* account,
                                           GearyConfigFile* config);
static gchar* __lambda48_ (AccountsAccountConfigV1* self,
                    GearyRFC822MailboxAddress* sender);
static gpointer ___lambda48__gee_map_func (gpointer g,
                                    gpointer self);
static inline void accounts_account_config_v1_save_folder (AccountsAccountConfigV1* self,
                                             GearyConfigFileGroup* config,
                                             const gchar* key,
                                             GeeList* steps);
static void accounts_account_config_v1_finalize (GObject * obj);
static GType accounts_account_config_v1_get_type_once (void);
static GearyAccountInformation* accounts_account_config_legacy_real_load (AccountsAccountConfig* base,
                                                                   GearyConfigFile* config_file,
                                                                   const gchar* id,
                                                                   GearyCredentialsMediator* mediator,
                                                                   GearyServiceProvider* default_provider,
                                                                   const gchar* default_name,
                                                                   GError** error);
static GearyServiceProvider ___lambda54_ (AccountsAccountConfigLegacy* self,
                                   const gchar* value,
                                   GError** error);
static gpointer ____lambda54__geary_config_file_parser (const gchar* value,
                                                 gpointer self,
                                                 GError** error);
static void accounts_account_config_legacy_real_save (AccountsAccountConfig* base,
                                               GearyAccountInformation* info,
                                               GearyConfigFile* config_file);
static gchar* ___lambda55_ (AccountsAccountConfigLegacy* self,
                     GearyRFC822MailboxAddress* alt);
static gpointer ____lambda55__gee_map_func (gpointer g,
                                     gpointer self);
static GType accounts_account_config_legacy_get_type_once (void);
static void accounts_service_config_v1_real_load (AccountsServiceConfig* base,
                                           GearyConfigFile* config,
                                           GearyAccountInformation* account,
                                           GearyServiceInformation* service,
                                           GError** error);
static GearyTlsNegotiationMethod ___lambda49_ (AccountsServiceConfigV1* self,
                                        const gchar* value,
                                        GError** error);
static gpointer ____lambda49__geary_config_file_parser (const gchar* value,
                                                 gpointer self,
                                                 GError** error);
static GearyCredentialsRequirement ___lambda50_ (AccountsServiceConfigV1* self,
                                          const gchar* value,
                                          GError** error);
static gpointer ____lambda50__geary_config_file_parser (const gchar* value,
                                                 gpointer self,
                                                 GError** error);
static void accounts_service_config_v1_real_save (AccountsServiceConfig* base,
                                           GearyAccountInformation* account,
                                           GearyServiceInformation* service,
                                           GearyConfigFile* config);
static GType accounts_service_config_v1_get_type_once (void);
static void accounts_service_config_legacy_real_load (AccountsServiceConfig* base,
                                               GearyConfigFile* config,
                                               GearyAccountInformation* account,
                                               GearyServiceInformation* service,
                                               GError** error);
static void accounts_service_config_legacy_real_save (AccountsServiceConfig* base,
                                               GearyAccountInformation* account,
                                               GearyServiceInformation* service,
                                               GearyConfigFile* config);
static GType accounts_service_config_legacy_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
accounts_manager_get_instance_private (AccountsManager* self)
{
	return G_STRUCT_MEMBER_P (self, AccountsManager_private_offset);
}

/**
     * Specifies the overall status of an account.
     */
AccountsManagerStatus
accounts_manager_status_for_value (const gchar* value,
                                   GError** error)
{
	AccountsManagerStatus _tmp0_ = 0;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gpointer _tmp3_;
	AccountsManagerStatus _tmp4_;
	GError* _inner_error0_ = NULL;
	AccountsManagerStatus result;
	g_return_val_if_fail (value != NULL, 0);
	_tmp1_ = g_ascii_strdown (value, (gssize) -1);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_object_utils_from_enum_nick (ACCOUNTS_MANAGER_TYPE_STATUS, NULL, NULL, ACCOUNTS_MANAGER_TYPE_STATUS, _tmp2_, &_inner_error0_);
	_tmp4_ = (AccountsManagerStatus) ((gintptr) _tmp3_);
	_g_free0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
	}
	result = _tmp0_;
	return result;
}

gchar*
accounts_manager_status_to_value (AccountsManagerStatus self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = geary_object_utils_to_enum_nick (ACCOUNTS_MANAGER_TYPE_STATUS, NULL, NULL, ACCOUNTS_MANAGER_TYPE_STATUS, (gpointer) ((gintptr) self));
	result = _tmp0_;
	return result;
}

static GType
accounts_manager_status_get_type_once (void)
{
	static const GEnumValue values[] = {{ACCOUNTS_MANAGER_STATUS_ENABLED, "ACCOUNTS_MANAGER_STATUS_ENABLED", "enabled"}, {ACCOUNTS_MANAGER_STATUS_DISABLED, "ACCOUNTS_MANAGER_STATUS_DISABLED", "disabled"}, {ACCOUNTS_MANAGER_STATUS_UNAVAILABLE, "ACCOUNTS_MANAGER_STATUS_UNAVAILABLE", "unavailable"}, {ACCOUNTS_MANAGER_STATUS_REMOVED, "ACCOUNTS_MANAGER_STATUS_REMOVED", "removed"}, {0, NULL, NULL}};
	GType accounts_manager_status_type_id;
	accounts_manager_status_type_id = g_enum_register_static ("AccountsManagerStatus", values);
	return accounts_manager_status_type_id;
}

GType
accounts_manager_status_get_type (void)
{
	static volatile gsize accounts_manager_status_type_id__once = 0;
	if (g_once_init_enter (&accounts_manager_status_type_id__once)) {
		GType accounts_manager_status_type_id;
		accounts_manager_status_type_id = accounts_manager_status_get_type_once ();
		g_once_init_leave (&accounts_manager_status_type_id__once, accounts_manager_status_type_id);
	}
	return accounts_manager_status_type_id__once;
}

gint
accounts_manager_get_size (AccountsManager* self)
{
	gint result;
	GeeMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (ACCOUNTS_IS_MANAGER (self), 0);
	_tmp0_ = self->priv->accounts;
	_tmp1_ = gee_map_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

GFile*
accounts_manager_get_config_dir (AccountsManager* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (ACCOUNTS_IS_MANAGER (self), NULL);
	_tmp0_ = self->priv->_config_dir;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
accounts_manager_set_config_dir (AccountsManager* self,
                                 GFile* value)
{
	GFile* old_value;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	old_value = accounts_manager_get_config_dir (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_config_dir);
		self->priv->_config_dir = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, accounts_manager_properties[ACCOUNTS_MANAGER_CONFIG_DIR_PROPERTY]);
	}
}

GFile*
accounts_manager_get_data_dir (AccountsManager* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (ACCOUNTS_IS_MANAGER (self), NULL);
	_tmp0_ = self->priv->_data_dir;
	result = _tmp0_;
	return result;
}

static void
accounts_manager_set_data_dir (AccountsManager* self,
                               GFile* value)
{
	GFile* old_value;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	old_value = accounts_manager_get_data_dir (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_data_dir);
		self->priv->_data_dir = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, accounts_manager_properties[ACCOUNTS_MANAGER_DATA_DIR_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_ENUM (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_ENUM) (gpointer data1, gpointer arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_enum (param_values + 2), data2);
}

AccountsManager*
accounts_manager_construct (GType object_type,
                            GearyCredentialsMediator* local_mediator,
                            GFile* config_dir,
                            GFile* data_dir)
{
	AccountsManager * self = NULL;
	GearyCredentialsMediator* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (local_mediator, GEARY_TYPE_CREDENTIALS_MEDIATOR), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (config_dir, g_file_get_type ()), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (data_dir, g_file_get_type ()), NULL);
	self = (AccountsManager*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (local_mediator);
	_g_object_unref0 (self->priv->local_mediator);
	self->priv->local_mediator = _tmp0_;
	accounts_manager_set_config_dir (self, config_dir);
	accounts_manager_set_data_dir (self, data_dir);
	return self;
}

AccountsManager*
accounts_manager_new (GearyCredentialsMediator* local_mediator,
                      GFile* config_dir,
                      GFile* data_dir)
{
	return accounts_manager_construct (ACCOUNTS_TYPE_MANAGER, local_mediator, config_dir, data_dir);
}

static void
accounts_manager_connect_goa_data_free (gpointer _data)
{
	AccountsManagerConnectGoaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountsManagerConnectGoaData, _data_);
}

void
accounts_manager_connect_goa (AccountsManager* self,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	AccountsManagerConnectGoaData* _data_;
	AccountsManager* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (AccountsManagerConnectGoaData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, accounts_manager_connect_goa_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	accounts_manager_connect_goa_co (_data_);
}

void
accounts_manager_connect_goa_finish (AccountsManager* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	AccountsManagerConnectGoaData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
accounts_manager_connect_goa_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	AccountsManagerConnectGoaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	accounts_manager_connect_goa_co (_data_);
}

static void
_accounts_manager_on_goa_account_added_goa_client_account_added (GoaClient* _sender,
                                                                 GoaObject* object,
                                                                 gpointer self)
{
	accounts_manager_on_goa_account_added ((AccountsManager*) self, object);
}

static void
_accounts_manager_on_goa_account_changed_goa_client_account_changed (GoaClient* _sender,
                                                                     GoaObject* object,
                                                                     gpointer self)
{
	accounts_manager_on_goa_account_changed ((AccountsManager*) self, object);
}

static void
_accounts_manager_on_goa_account_removed_goa_client_account_removed (GoaClient* _sender,
                                                                     GoaObject* object,
                                                                     gpointer self)
{
	accounts_manager_on_goa_account_removed ((AccountsManager*) self, object);
}

static gboolean
accounts_manager_connect_goa_co (AccountsManagerConnectGoaData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	goa_client_new (_data_->cancellable, accounts_manager_connect_goa_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = goa_client_new_finish (_data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_g_object_unref0 (_data_->self->priv->goa_service);
	_data_->self->priv->goa_service = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->goa_service;
	g_signal_connect_object (_data_->_tmp3_, "account-added", (GCallback) _accounts_manager_on_goa_account_added_goa_client_account_added, _data_->self, 0);
	_data_->_tmp4_ = _data_->self->priv->goa_service;
	g_signal_connect_object (_data_->_tmp4_, "account-changed", (GCallback) _accounts_manager_on_goa_account_changed_goa_client_account_changed, _data_->self, 0);
	_data_->_tmp5_ = _data_->self->priv->goa_service;
	g_signal_connect_object (_data_->_tmp5_, "account-removed", (GCallback) _accounts_manager_on_goa_account_removed_goa_client_account_removed, _data_->self, 0);
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/** Returns the account with the given id. */
GearyAccountInformation*
accounts_manager_get_account (AccountsManager* self,
                              const gchar* id)
{
	AccountsManagerAccountState* state = NULL;
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	GearyAccountInformation* _tmp2_ = NULL;
	AccountsManagerAccountState* _tmp3_;
	GearyAccountInformation* _tmp7_;
	GearyAccountInformation* result;
	g_return_val_if_fail (ACCOUNTS_IS_MANAGER (self), NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = self->priv->accounts;
	_tmp1_ = gee_map_get (_tmp0_, id);
	state = (AccountsManagerAccountState*) _tmp1_;
	_tmp3_ = state;
	if (_tmp3_ != NULL) {
		AccountsManagerAccountState* _tmp4_;
		GearyAccountInformation* _tmp5_;
		GearyAccountInformation* _tmp6_;
		_tmp4_ = state;
		_tmp5_ = accounts_manager_account_state_get_account (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = NULL;
	}
	_tmp7_ = _g_object_ref0 (_tmp2_);
	result = _tmp7_;
	_accounts_manager_account_state_unref0 (state);
	return result;
}

/** Returns the status for the given account. */
AccountsManagerStatus
accounts_manager_get_status (AccountsManager* self,
                             GearyAccountInformation* account)
{
	AccountsManagerAccountState* state = NULL;
	GeeMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gpointer _tmp3_;
	AccountsManagerStatus _tmp4_ = 0;
	AccountsManagerAccountState* _tmp5_;
	AccountsManagerStatus result;
	g_return_val_if_fail (ACCOUNTS_IS_MANAGER (self), 0);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION), 0);
	_tmp0_ = self->priv->accounts;
	_tmp1_ = geary_account_information_get_id (account);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_map_get (_tmp0_, _tmp2_);
	state = (AccountsManagerAccountState*) _tmp3_;
	_tmp5_ = state;
	if (_tmp5_ != NULL) {
		AccountsManagerAccountState* _tmp6_;
		AccountsManagerStatus _tmp7_;
		AccountsManagerStatus _tmp8_;
		_tmp6_ = state;
		_tmp7_ = accounts_manager_account_state_get_status (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_;
	} else {
		_tmp4_ = ACCOUNTS_MANAGER_STATUS_UNAVAILABLE;
	}
	result = _tmp4_;
	_accounts_manager_account_state_unref0 (state);
	return result;
}

/** Returns a read-only iterable of all currently known accounts. */
static GearyAccountInformation*
__lambda52_ (AccountsManager* self,
             AccountsManagerAccountState* state)
{
	GearyAccountInformation* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GearyAccountInformation* _tmp2_;
	GearyAccountInformation* result;
	g_return_val_if_fail (ACCOUNTS_MANAGER_IS_ACCOUNT_STATE (state), NULL);
	_tmp0_ = accounts_manager_account_state_get_account (state);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	_accounts_manager_account_state_unref0 (state);
	return result;
}

static gpointer
___lambda52__gee_map_func (gpointer g,
                           gpointer self)
{
	gpointer result;
	result = __lambda52_ ((AccountsManager*) self, (AccountsManagerAccountState*) g);
	return result;
}

GearyIterable*
accounts_manager_iterable (AccountsManager* self)
{
	GeeMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GearyIterable* _tmp4_;
	GearyIterable* _tmp5_;
	GearyIterable* _tmp6_;
	GearyIterable* _tmp7_;
	GearyIterable* result;
	g_return_val_if_fail (ACCOUNTS_IS_MANAGER (self), NULL);
	_tmp0_ = self->priv->accounts;
	_tmp1_ = gee_map_get_values (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_traverse (ACCOUNTS_MANAGER_TYPE_ACCOUNT_STATE, (GBoxedCopyFunc) accounts_manager_account_state_ref, (GDestroyNotify) accounts_manager_account_state_unref, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
	_tmp5_ = _tmp4_;
	_tmp6_ = geary_iterable_map (_tmp5_, GEARY_TYPE_ACCOUNT_INFORMATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, ___lambda52__gee_map_func, self);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	result = _tmp7_;
	return result;
}

/**
     * Returns the display name for the current desktop login session.
     */
gchar*
accounts_manager_get_account_name (AccountsManager* self)
{
	gchar* name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (ACCOUNTS_IS_MANAGER (self), NULL);
	_tmp0_ = g_get_real_name ();
	_tmp1_ = g_strdup (_tmp0_);
	name = _tmp1_;
	_tmp3_ = name;
	if (geary_string_is_empty (_tmp3_)) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = name;
		_tmp2_ = g_strcmp0 (_tmp4_, "Unknown") == 0;
	}
	if (_tmp2_) {
		_g_free0 (name);
		name = NULL;
	}
	result = name;
	return result;
}

static void
accounts_manager_new_orphan_account_data_free (gpointer _data)
{
	AccountsManagerNewOrphanAccountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->primary_mailbox);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountsManagerNewOrphanAccountData, _data_);
}

void
accounts_manager_new_orphan_account (AccountsManager* self,
                                     GearyServiceProvider provider,
                                     GearyRFC822MailboxAddress* primary_mailbox,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	AccountsManagerNewOrphanAccountData* _data_;
	AccountsManager* _tmp0_;
	GearyRFC822MailboxAddress* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (primary_mailbox, GEARY_RF_C822_TYPE_MAILBOX_ADDRESS));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (AccountsManagerNewOrphanAccountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, accounts_manager_new_orphan_account_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->provider = provider;
	_tmp1_ = _g_object_ref0 (primary_mailbox);
	_g_object_unref0 (_data_->primary_mailbox);
	_data_->primary_mailbox = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	accounts_manager_new_orphan_account_co (_data_);
}

GearyAccountInformation*
accounts_manager_new_orphan_account_finish (AccountsManager* self,
                                            GAsyncResult* _res_)
{
	GearyAccountInformation* result;
	AccountsManagerNewOrphanAccountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Returns a new account, not yet stored on disk.
     */
static void
accounts_manager_new_orphan_account_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	AccountsManagerNewOrphanAccountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	accounts_manager_new_orphan_account_co (_data_);
}

static gboolean
accounts_manager_new_orphan_account_co (AccountsManagerNewOrphanAccountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	accounts_manager_next_id (_data_->self, _data_->cancellable, accounts_manager_new_orphan_account_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = accounts_manager_next_id_finish (_data_->self, _data_->_res_);
	_data_->id = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->local_mediator;
	_data_->_tmp2_ = geary_account_information_new (_data_->id, _data_->provider, _data_->_tmp1_, _data_->primary_mailbox);
	_data_->result = _data_->_tmp2_;
	_g_free0 (_data_->id);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
accounts_manager_create_account_data_free (gpointer _data)
{
	AccountsManagerCreateAccountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountsManagerCreateAccountData, _data_);
}

void
accounts_manager_create_account (AccountsManager* self,
                                 GearyAccountInformation* account,
                                 GCancellable* cancellable,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	AccountsManagerCreateAccountData* _data_;
	AccountsManager* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (AccountsManagerCreateAccountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, accounts_manager_create_account_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (account);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	accounts_manager_create_account_co (_data_);
}

void
accounts_manager_create_account_finish (AccountsManager* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	AccountsManagerCreateAccountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Creates new account's disk and credential storage as needed.
     */
static void
accounts_manager_create_account_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	AccountsManagerCreateAccountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	accounts_manager_create_account_co (_data_);
}

static gboolean
accounts_manager_create_account_co (AccountsManagerCreateAccountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	accounts_manager_create_account_dirs (_data_->self, _data_->account, _data_->cancellable, accounts_manager_create_account_ready, _data_);
	return FALSE;
	_state_1:
	accounts_manager_create_account_dirs_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	accounts_manager_save_account (_data_->self, _data_->account, _data_->cancellable, accounts_manager_create_account_ready, _data_);
	return FALSE;
	_state_2:
	accounts_manager_save_account_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	accounts_manager_set_enabled (_data_->self, _data_->account, TRUE);
	_data_->_tmp0_ = geary_account_information_get_mediator (_data_->account);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _g_object_ref0 (IS_SECRET_MEDIATOR (_data_->_tmp1_) ? ((SecretMediator*) _data_->_tmp1_) : NULL);
	_data_->mediator = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->mediator;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp4_ = _data_->mediator;
		_data_->_tmp5_ = geary_account_information_get_incoming (_data_->account);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_state_ = 3;
		secret_mediator_update_token (_data_->_tmp4_, _data_->account, _data_->_tmp6_, _data_->cancellable, accounts_manager_create_account_ready, _data_);
		return FALSE;
		_state_3:
		secret_mediator_update_token_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->mediator);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp7_ = _data_->mediator;
		_data_->_tmp8_ = geary_account_information_get_outgoing (_data_->account);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_state_ = 4;
		secret_mediator_update_token (_data_->_tmp7_, _data_->account, _data_->_tmp9_, _data_->cancellable, accounts_manager_create_account_ready, _data_);
		return FALSE;
		_state_4:
		secret_mediator_update_token_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->mediator);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->mediator);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
accounts_manager_load_accounts_data_free (gpointer _data)
{
	AccountsManagerLoadAccountsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountsManagerLoadAccountsData, _data_);
}

void
accounts_manager_load_accounts (AccountsManager* self,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	AccountsManagerLoadAccountsData* _data_;
	AccountsManager* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (AccountsManagerLoadAccountsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, accounts_manager_load_accounts_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	accounts_manager_load_accounts_co (_data_);
}

void
accounts_manager_load_accounts_finish (AccountsManager* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	AccountsManagerLoadAccountsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
accounts_manager_load_accounts_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	AccountsManagerLoadAccountsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	accounts_manager_load_accounts_co (_data_);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
accounts_manager_load_accounts_co (AccountsManagerLoadAccountsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->enumerator = NULL;
	{
		_data_->_tmp1_ = _data_->self->priv->_config_dir;
		_data_->_state_ = 1;
		g_file_enumerate_children_async (_data_->_tmp1_, "standard::*", G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->cancellable, accounts_manager_load_accounts_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = g_file_enumerate_children_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				goto __catch0_g_io_error_not_found;
			}
			goto __finally0;
		}
		_data_->_tmp3_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->enumerator);
		_data_->enumerator = _data_->_tmp3_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error_not_found:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->enumerator);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	while (TRUE) {
		_data_->_tmp5_ = _data_->enumerator;
		if (_data_->_tmp5_ != NULL) {
			_data_->_tmp4_ = !g_cancellable_is_cancelled (_data_->cancellable);
		} else {
			_data_->_tmp4_ = FALSE;
		}
		if (!_data_->_tmp4_) {
			break;
		}
		_data_->_tmp6_ = _data_->enumerator;
		_data_->_state_ = 2;
		g_file_enumerator_next_files_async (_data_->_tmp6_, 10, G_PRIORITY_DEFAULT, _data_->cancellable, accounts_manager_load_accounts_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp7_ = g_file_enumerator_next_files_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
		_data_->info_list = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->enumerator);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp8_ = _data_->info_list;
		_data_->len = g_list_length (_data_->_tmp8_);
		{
			_data_->i = (guint) 0;
			{
				_data_->_tmp9_ = TRUE;
				while (TRUE) {
					if (!_data_->_tmp9_) {
						_data_->_tmp10_ = _data_->i;
						_data_->i = _data_->_tmp10_ + 1;
					}
					_data_->_tmp9_ = FALSE;
					if (_data_->i < _data_->len) {
						_data_->_tmp11_ = !g_cancellable_is_cancelled (_data_->cancellable);
					} else {
						_data_->_tmp11_ = FALSE;
					}
					if (!_data_->_tmp11_) {
						break;
					}
					_data_->_tmp12_ = _data_->info_list;
					_data_->_tmp13_ = g_list_nth_data (_data_->_tmp12_, _data_->i);
					_data_->_tmp14_ = _g_object_ref0 ((GFileInfo*) _data_->_tmp13_);
					_data_->file = _data_->_tmp14_;
					_data_->_tmp15_ = _data_->file;
					if (g_file_info_get_file_type (_data_->_tmp15_) == G_FILE_TYPE_DIRECTORY) {
						_data_->_tmp16_ = _data_->file;
						_data_->_tmp17_ = g_file_info_get_name (_data_->_tmp16_);
						_data_->_tmp18_ = g_strdup (_data_->_tmp17_);
						_data_->id = _data_->_tmp18_;
						{
							_data_->_tmp19_ = _data_->id;
							_data_->_state_ = 3;
							accounts_manager_load_account (_data_->self, _data_->_tmp19_, _data_->cancellable, accounts_manager_load_accounts_ready, _data_);
							return FALSE;
							_state_3:
							_data_->_tmp20_ = accounts_manager_load_account_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
							_data_->info = _data_->_tmp20_;
							if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
								if (g_error_matches (_data_->_inner_error0_, ACCOUNTS_CONFIG_ERROR, ACCOUNTS_CONFIG_ERROR_UNAVAILABLE)) {
									goto __catch1_accounts_config_error_unavailable;
								}
								if (g_error_matches (_data_->_inner_error0_, ACCOUNTS_CONFIG_ERROR, ACCOUNTS_CONFIG_ERROR_REMOVED)) {
									goto __catch1_accounts_config_error_removed;
								}
								goto __catch1_g_error;
							}
							_data_->_tmp21_ = _data_->info;
							accounts_manager_set_enabled (_data_->self, _data_->_tmp21_, TRUE);
							_g_object_unref0 (_data_->info);
						}
						goto __finally1;
						__catch1_accounts_config_error_unavailable:
						{
							g_clear_error (&_data_->_inner_error0_);
						}
						goto __finally1;
						__catch1_accounts_config_error_removed:
						{
							g_clear_error (&_data_->_inner_error0_);
						}
						goto __finally1;
						__catch1_g_error:
						{
							_data_->err = _data_->_inner_error0_;
							_data_->_inner_error0_ = NULL;
							_data_->_tmp22_ = _data_->id;
							g_debug ("accounts-manager.vala:262: Error loading account %s", _data_->_tmp22_);
							_data_->_tmp23_ = _data_->err;
							_data_->_tmp24_ = geary_problem_report_new (_data_->_tmp23_);
							_data_->_tmp25_ = _data_->_tmp24_;
							g_signal_emit (_data_->self, accounts_manager_signals[ACCOUNTS_MANAGER_REPORT_PROBLEM_SIGNAL], 0, _data_->_tmp25_);
							_g_object_unref0 (_data_->_tmp25_);
							_g_error_free0 (_data_->err);
						}
						__finally1:
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
							_g_free0 (_data_->id);
							_g_object_unref0 (_data_->file);
							(_data_->info_list == NULL) ? NULL : (_data_->info_list = (_g_list_free__g_object_unref0_ (_data_->info_list), NULL));
							_g_object_unref0 (_data_->enumerator);
							g_object_unref (_data_->_async_result);
							return FALSE;
						}
						_g_free0 (_data_->id);
					}
					_g_object_unref0 (_data_->file);
				}
			}
		}
		if (_data_->len == ((guint) 0)) {
			_g_object_unref0 (_data_->enumerator);
			_data_->enumerator = NULL;
		}
		(_data_->info_list == NULL) ? NULL : (_data_->info_list = (_g_list_free__g_object_unref0_ (_data_->info_list), NULL));
	}
	_data_->_tmp26_ = _data_->self->priv->goa_service;
	if (_data_->_tmp26_ != NULL) {
		_data_->_tmp27_ = _data_->self->priv->goa_service;
		_data_->_tmp28_ = goa_client_get_accounts (_data_->_tmp27_);
		_data_->list = _data_->_tmp28_;
		{
			_data_->_vala1_i = 0;
			{
				_data_->_tmp29_ = TRUE;
				while (TRUE) {
					if (!_data_->_tmp29_) {
						_data_->_tmp30_ = _data_->_vala1_i;
						_data_->_vala1_i = _data_->_tmp30_ + 1;
					}
					_data_->_tmp29_ = FALSE;
					_data_->_tmp32_ = _data_->list;
					if (((guint) _data_->_vala1_i) < g_list_length (_data_->_tmp32_)) {
						_data_->_tmp31_ = !g_cancellable_is_cancelled (_data_->cancellable);
					} else {
						_data_->_tmp31_ = FALSE;
					}
					if (!_data_->_tmp31_) {
						break;
					}
					_data_->_tmp33_ = _data_->list;
					_data_->_tmp34_ = g_list_nth_data (_data_->_tmp33_, (guint) _data_->_vala1_i);
					_data_->_tmp35_ = _g_object_ref0 ((GoaObject*) _data_->_tmp34_);
					_data_->account = _data_->_tmp35_;
					_data_->_tmp36_ = _data_->account;
					_data_->_tmp37_ = accounts_manager_to_geary_id (_data_->self, _data_->_tmp36_);
					_data_->_vala1_id = _data_->_tmp37_;
					_data_->_tmp38_ = _data_->self->priv->accounts;
					_data_->_tmp39_ = _data_->_vala1_id;
					if (!gee_map_has_key (_data_->_tmp38_, _data_->_tmp39_)) {
						_data_->_tmp40_ = _data_->account;
						_data_->_state_ = 4;
						accounts_manager_create_goa_account (_data_->self, _data_->_tmp40_, _data_->cancellable, accounts_manager_load_accounts_ready, _data_);
						return FALSE;
						_state_4:
						accounts_manager_create_goa_account_finish (_data_->self, _data_->_res_);
					}
					_g_free0 (_data_->_vala1_id);
					_g_object_unref0 (_data_->account);
				}
			}
		}
		(_data_->list == NULL) ? NULL : (_data_->list = (_g_list_free__g_object_unref0_ (_data_->list), NULL));
	}
	_g_object_unref0 (_data_->enumerator);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Marks an existing account as being unavailable.
     *
     * This keeps the account in the known set, but marks it as being
     * unavailable.
     */
void
accounts_manager_disable_account (AccountsManager* self,
                                  GearyAccountInformation* account)
{
	GeeMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION));
	_tmp0_ = self->priv->accounts;
	_tmp1_ = geary_account_information_get_id (account);
	_tmp2_ = _tmp1_;
	if (gee_map_has_key (_tmp0_, _tmp2_)) {
		accounts_manager_set_available (self, account, FALSE);
	}
}

static void
accounts_manager_remove_account_data_free (gpointer _data)
{
	AccountsManagerRemoveAccountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountsManagerRemoveAccountData, _data_);
}

void
accounts_manager_remove_account (AccountsManager* self,
                                 GearyAccountInformation* account,
                                 GCancellable* cancellable,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	AccountsManagerRemoveAccountData* _data_;
	AccountsManager* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (AccountsManagerRemoveAccountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, accounts_manager_remove_account_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (account);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	accounts_manager_remove_account_co (_data_);
}

void
accounts_manager_remove_account_finish (AccountsManager* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	AccountsManagerRemoveAccountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Removes an account from the manager's set of known accounts.
     *
     * This removes the account from the known set, marks the account
     * as deleted, and queues it for deletion. The account will not
     * actually be deleted until {@link expunge_accounts} is called,
     * and until then the account can be re-added using {@link
     * restore_account}.
     */
static void
_accounts_manager_on_account_changed_geary_account_information_changed (GearyAccountInformation* _sender,
                                                                        gpointer self)
{
	accounts_manager_on_account_changed ((AccountsManager*) self, _sender);
}

static void
accounts_manager_remove_account_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	AccountsManagerRemoveAccountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	accounts_manager_remove_account_co (_data_);
}

static gboolean
accounts_manager_remove_account_co (AccountsManagerRemoveAccountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->accounts;
	_data_->_tmp1_ = geary_account_information_get_id (_data_->account);
	_data_->_tmp2_ = _data_->_tmp1_;
	gee_map_unset (_data_->_tmp0_, _data_->_tmp2_, NULL);
	_data_->_tmp3_ = _data_->self->priv->removed;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->account);
	g_signal_parse_name ("changed", GEARY_TYPE_ACCOUNT_INFORMATION, &_data_->_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_data_->account, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp4_, 0, NULL, (GCallback) _accounts_manager_on_account_changed_geary_account_information_changed, _data_->self);
	_data_->_state_ = 1;
	accounts_manager_save_account (_data_->self, _data_->account, _data_->cancellable, accounts_manager_remove_account_ready, _data_);
	return FALSE;
	_state_1:
	accounts_manager_save_account_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_signal_emit (_data_->self, accounts_manager_signals[ACCOUNTS_MANAGER_ACCOUNT_REMOVED_SIGNAL], 0, _data_->account);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
accounts_manager_restore_account_data_free (gpointer _data)
{
	AccountsManagerRestoreAccountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountsManagerRestoreAccountData, _data_);
}

void
accounts_manager_restore_account (AccountsManager* self,
                                  GearyAccountInformation* account,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	AccountsManagerRestoreAccountData* _data_;
	AccountsManager* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (AccountsManagerRestoreAccountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, accounts_manager_restore_account_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (account);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	accounts_manager_restore_account_co (_data_);
}

void
accounts_manager_restore_account_finish (AccountsManager* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	AccountsManagerRestoreAccountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Restores an account that has previously been removed.
     *
     * This restores an account previously removed via a call to
     * {@link remove_account}, adding it back to the known set, as
     * long as {@link expunge_accounts} has not been called since
     * he account was removed.
     */
static void
accounts_manager_restore_account_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	AccountsManagerRestoreAccountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	accounts_manager_restore_account_co (_data_);
}

static gboolean
accounts_manager_restore_account_co (AccountsManagerRestoreAccountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->removed;
	if (gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->account)) {
		_data_->_state_ = 1;
		accounts_manager_save_account (_data_->self, _data_->account, _data_->cancellable, accounts_manager_restore_account_ready, _data_);
		return FALSE;
		_state_1:
		accounts_manager_save_account_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		accounts_manager_set_enabled (_data_->self, _data_->account, TRUE);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
accounts_manager_expunge_accounts_data_free (gpointer _data)
{
	AccountsManagerExpungeAccountsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountsManagerExpungeAccountsData, _data_);
}

void
accounts_manager_expunge_accounts (AccountsManager* self,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	AccountsManagerExpungeAccountsData* _data_;
	AccountsManager* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (AccountsManagerExpungeAccountsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, accounts_manager_expunge_accounts_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	accounts_manager_expunge_accounts_co (_data_);
}

void
accounts_manager_expunge_accounts_finish (AccountsManager* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	AccountsManagerExpungeAccountsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Deletes all local data for all accounts that have been removed.
     */
static void
accounts_manager_expunge_accounts_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	AccountsManagerExpungeAccountsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	accounts_manager_expunge_accounts_co (_data_);
}

static gboolean
accounts_manager_expunge_accounts_co (AccountsManagerExpungeAccountsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	while (TRUE) {
		_data_->_tmp1_ = _data_->self->priv->removed;
		_data_->_tmp2_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp3_ = _data_->_tmp2_;
		if (!_data_->_tmp3_) {
			_data_->_tmp0_ = !g_cancellable_is_cancelled (_data_->cancellable);
		} else {
			_data_->_tmp0_ = FALSE;
		}
		if (!_data_->_tmp0_) {
			break;
		}
		_data_->_tmp4_ = _data_->self->priv->removed;
		_data_->_tmp5_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
		_data_->_tmp6_ = (GearyAccountInformation*) _data_->_tmp5_;
		_data_->_state_ = 1;
		accounts_manager_delete_account (_data_->self, _data_->_tmp6_, _data_->cancellable, accounts_manager_expunge_accounts_ready, _data_);
		return FALSE;
		_state_1:
		accounts_manager_delete_account_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp6_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
accounts_manager_save_account_data_free (gpointer _data)
{
	AccountsManagerSaveAccountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->info);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountsManagerSaveAccountData, _data_);
}

void
accounts_manager_save_account (AccountsManager* self,
                               GearyAccountInformation* info,
                               GCancellable* cancellable,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	AccountsManagerSaveAccountData* _data_;
	AccountsManager* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (AccountsManagerSaveAccountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, accounts_manager_save_account_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (info);
	_g_object_unref0 (_data_->info);
	_data_->info = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	accounts_manager_save_account_co (_data_);
}

void
accounts_manager_save_account_finish (AccountsManager* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	AccountsManagerSaveAccountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Saves an account's configuration data to disk.
     */
static void
accounts_manager_save_account_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	AccountsManagerSaveAccountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	accounts_manager_save_account_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
accounts_manager_save_account_co (AccountsManagerSaveAccountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_account_information_get_write_lock (_data_->info);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_state_ = 1;
	geary_nonblocking_mutex_claim_async (_data_->_tmp1_, _data_->cancellable, accounts_manager_save_account_ready, _data_);
	return FALSE;
	_state_1:
	_data_->token = geary_nonblocking_mutex_claim_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->thrown = NULL;
	{
		_data_->_state_ = 2;
		accounts_manager_save_account_locked (_data_->self, _data_->info, _data_->cancellable, accounts_manager_save_account_ready, _data_);
		return FALSE;
		_state_2:
		accounts_manager_save_account_locked_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp2_ = _data_->err;
		_data_->_tmp3_ = _g_error_copy0 (_data_->_tmp2_);
		_g_error_free0 (_data_->thrown);
		_data_->thrown = _data_->_tmp3_;
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_error_free0 (_data_->thrown);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = geary_account_information_get_write_lock (_data_->info);
	_data_->_tmp5_ = _data_->_tmp4_;
	geary_nonblocking_mutex_release (_data_->_tmp5_, &_data_->token, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_error_free0 (_data_->thrown);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->thrown;
	if (_data_->_tmp6_ != NULL) {
		_data_->_tmp7_ = _data_->thrown;
		_data_->_tmp8_ = _g_error_copy0 (_data_->_tmp7_);
		_data_->_inner_error0_ = _data_->_tmp8_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_error_free0 (_data_->thrown);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_error_free0 (_data_->thrown);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
accounts_manager_update_local_credentials_data_free (gpointer _data)
{
	AccountsManagerUpdateLocalCredentialsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->old_service);
	_g_object_unref0 (_data_->new_service);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountsManagerUpdateLocalCredentialsData, _data_);
}

void
accounts_manager_update_local_credentials (AccountsManager* self,
                                           GearyAccountInformation* account,
                                           GearyServiceInformation* old_service,
                                           GearyServiceInformation* new_service,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	AccountsManagerUpdateLocalCredentialsData* _data_;
	AccountsManager* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GearyServiceInformation* _tmp2_;
	GearyServiceInformation* _tmp3_;
	GCancellable* _tmp4_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (old_service, GEARY_TYPE_SERVICE_INFORMATION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_service, GEARY_TYPE_SERVICE_INFORMATION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (AccountsManagerUpdateLocalCredentialsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, accounts_manager_update_local_credentials_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (account);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = _g_object_ref0 (old_service);
	_g_object_unref0 (_data_->old_service);
	_data_->old_service = _tmp2_;
	_tmp3_ = _g_object_ref0 (new_service);
	_g_object_unref0 (_data_->new_service);
	_data_->new_service = _tmp3_;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	accounts_manager_update_local_credentials_co (_data_);
}

void
accounts_manager_update_local_credentials_finish (AccountsManager* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	AccountsManagerUpdateLocalCredentialsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/** Updates a local account service's credentials. */
static void
accounts_manager_update_local_credentials_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	AccountsManagerUpdateLocalCredentialsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	accounts_manager_update_local_credentials_co (_data_);
}

static gboolean
accounts_manager_update_local_credentials_co (AccountsManagerUpdateLocalCredentialsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_account_information_get_mediator (_data_->account);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _g_object_ref0 (IS_SECRET_MEDIATOR (_data_->_tmp1_) ? ((SecretMediator*) _data_->_tmp1_) : NULL);
	_data_->mediator = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->mediator;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp4_ = geary_service_information_get_credentials (_data_->new_service);
		_data_->_tmp5_ = _data_->_tmp4_;
		if (_data_->_tmp5_ != NULL) {
			_data_->_tmp6_ = _data_->mediator;
			_data_->_state_ = 1;
			secret_mediator_update_token (_data_->_tmp6_, _data_->account, _data_->new_service, _data_->cancellable, accounts_manager_update_local_credentials_ready, _data_);
			return FALSE;
			_state_1:
			secret_mediator_update_token_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->mediator);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->_tmp8_ = geary_service_information_get_credentials (_data_->old_service);
		_data_->_tmp9_ = _data_->_tmp8_;
		if (_data_->_tmp9_ != NULL) {
			_data_->_tmp11_ = geary_service_information_get_credentials (_data_->new_service);
			_data_->_tmp12_ = _data_->_tmp11_;
			if (_data_->_tmp12_ == NULL) {
				_data_->_tmp10_ = TRUE;
			} else {
				_data_->_tmp14_ = geary_service_information_get_credentials (_data_->new_service);
				_data_->_tmp15_ = _data_->_tmp14_;
				if (_data_->_tmp15_ != NULL) {
					_data_->_tmp16_ = geary_service_information_get_credentials (_data_->old_service);
					_data_->_tmp17_ = _data_->_tmp16_;
					_data_->_tmp18_ = geary_credentials_get_user (_data_->_tmp17_);
					_data_->_tmp19_ = _data_->_tmp18_;
					_data_->_tmp20_ = geary_service_information_get_credentials (_data_->old_service);
					_data_->_tmp21_ = _data_->_tmp20_;
					_data_->_tmp22_ = geary_credentials_get_user (_data_->_tmp21_);
					_data_->_tmp23_ = _data_->_tmp22_;
					_data_->_tmp13_ = g_strcmp0 (_data_->_tmp19_, _data_->_tmp23_) != 0;
				} else {
					_data_->_tmp13_ = FALSE;
				}
				_data_->_tmp10_ = _data_->_tmp13_;
			}
			_data_->_tmp7_ = _data_->_tmp10_;
		} else {
			_data_->_tmp7_ = FALSE;
		}
		if (_data_->_tmp7_) {
			_data_->_tmp24_ = _data_->mediator;
			_data_->_state_ = 2;
			secret_mediator_clear_token (_data_->_tmp24_, _data_->account, _data_->old_service, _data_->cancellable, accounts_manager_update_local_credentials_ready, _data_);
			return FALSE;
			_state_2:
			secret_mediator_clear_token_finish (_data_->_tmp24_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->mediator);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	_g_object_unref0 (_data_->mediator);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Determines if an account is a GOA account or not.
     */
gboolean
accounts_manager_is_goa_account (AccountsManager* self,
                                 GearyAccountInformation* account)
{
	GearyCredentialsMediator* _tmp0_;
	GearyCredentialsMediator* _tmp1_;
	gboolean result;
	g_return_val_if_fail (ACCOUNTS_IS_MANAGER (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION), FALSE);
	_tmp0_ = geary_account_information_get_mediator (account);
	_tmp1_ = _tmp0_;
	result = IS_GOA_MEDIATOR (_tmp1_);
	return result;
}

static void
accounts_manager_add_goa_account_data_free (gpointer _data)
{
	AccountsManagerAddGoaAccountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountsManagerAddGoaAccountData, _data_);
}

void
accounts_manager_add_goa_account (AccountsManager* self,
                                  GearyServiceProvider type,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	AccountsManagerAddGoaAccountData* _data_;
	AccountsManager* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (AccountsManagerAddGoaAccountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, accounts_manager_add_goa_account_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->type = type;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	accounts_manager_add_goa_account_co (_data_);
}

void
accounts_manager_add_goa_account_finish (AccountsManager* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	AccountsManagerAddGoaAccountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Opens GNOME Settings to add an account of a particular type.
     *
     * Throws an error if it was not possible to open GNOME Settings,
     * or if the given type is not supported for by GOA.
     */
static void
accounts_manager_add_goa_account_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	AccountsManagerAddGoaAccountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	accounts_manager_add_goa_account_co (_data_);
}

static gboolean
accounts_manager_add_goa_account_co (AccountsManagerAddGoaAccountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	switch (_data_->type) {
		case GEARY_SERVICE_PROVIDER_GMAIL:
		{
			_data_->_state_ = 1;
			accounts_manager_open_goa_settings (_data_->self, "add", "google", _data_->cancellable, accounts_manager_add_goa_account_ready, _data_);
			return FALSE;
			_state_1:
			accounts_manager_open_goa_settings_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			break;
		}
		case GEARY_SERVICE_PROVIDER_OUTLOOK:
		{
			_data_->_state_ = 2;
			accounts_manager_open_goa_settings (_data_->self, "add", "windows_live", _data_->cancellable, accounts_manager_add_goa_account_ready, _data_);
			return FALSE;
			_state_2:
			accounts_manager_open_goa_settings_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			break;
		}
		default:
		{
			_data_->_tmp0_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "Not supported for GOA");
			_data_->_inner_error0_ = _data_->_tmp0_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
accounts_manager_show_goa_account_data_free (gpointer _data)
{
	AccountsManagerShowGoaAccountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountsManagerShowGoaAccountData, _data_);
}

void
accounts_manager_show_goa_account (AccountsManager* self,
                                   GearyAccountInformation* account,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	AccountsManagerShowGoaAccountData* _data_;
	AccountsManager* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (AccountsManagerShowGoaAccountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, accounts_manager_show_goa_account_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (account);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	accounts_manager_show_goa_account_co (_data_);
}

void
accounts_manager_show_goa_account_finish (AccountsManager* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	AccountsManagerShowGoaAccountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Opens GOA settings for the given account in GNOME Settings.
     *
     * Throws an error if it was not possible to open GNOME Settings,
     * or if the given account is not backed by GOA.
     */
static void
accounts_manager_show_goa_account_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	AccountsManagerShowGoaAccountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	accounts_manager_show_goa_account_co (_data_);
}

static gboolean
accounts_manager_show_goa_account_co (AccountsManagerShowGoaAccountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!accounts_manager_is_goa_account (_data_->self, _data_->account)) {
		_data_->_tmp0_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "Not a GOA Account");
		_data_->_inner_error0_ = _data_->_tmp0_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = geary_account_information_get_id (_data_->account);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = accounts_manager_to_goa_id (_data_->self, _data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_state_ = 1;
	accounts_manager_open_goa_settings (_data_->self, _data_->_tmp4_, NULL, _data_->cancellable, accounts_manager_show_goa_account_ready, _data_);
	return FALSE;
	_state_1:
	accounts_manager_open_goa_settings_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_g_free0 (_data_->_tmp4_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
accounts_manager_next_id_data_free (gpointer _data)
{
	AccountsManagerNextIdData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountsManagerNextIdData, _data_);
}

static void
accounts_manager_next_id (AccountsManager* self,
                          GCancellable* cancellable,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	AccountsManagerNextIdData* _data_;
	AccountsManager* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (AccountsManagerNextIdData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, accounts_manager_next_id_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	accounts_manager_next_id_co (_data_);
}

static gchar*
accounts_manager_next_id_finish (AccountsManager* self,
                                 GAsyncResult* _res_)
{
	gchar* result;
	AccountsManagerNextIdData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/** Returns the next id for a new local account. */
static gchar*
__lambda53_ (AccountsManager* self,
             gchar* next,
             gchar* last)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (next != NULL, NULL);
	_tmp0_ = g_strdup (last);
	_result_ = _tmp0_;
	if (g_str_has_prefix (next, ACCOUNTS_MANAGER_LOCAL_ID_PREFIX)) {
		const gchar* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		gchar* _tmp4_;
		if (last == NULL) {
			_tmp2_ = TRUE;
		} else {
			GCompareFunc _tmp3_;
			_tmp3_ = ((GCompareFunc) g_strcmp0);
			_tmp2_ = _tmp3_ (last, next) < 0;
		}
		if (_tmp2_) {
			_tmp1_ = next;
		} else {
			_tmp1_ = last;
		}
		_tmp4_ = g_strdup (_tmp1_);
		_g_free0 (_result_);
		_result_ = _tmp4_;
	}
	result = _result_;
	_g_free0 (next);
	_g_free0 (last);
	return result;
}

static gpointer
___lambda53__gee_fold_func (gpointer g,
                            gpointer a,
                            gpointer self)
{
	gpointer result;
	result = __lambda53_ ((AccountsManager*) self, (gchar*) g, (gchar*) a);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
accounts_manager_next_id_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_)
{
	AccountsManagerNextIdData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	accounts_manager_next_id_co (_data_);
}

static gboolean
accounts_manager_next_id_co (AccountsManagerNextIdData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->accounts;
	_data_->_tmp1_ = gee_map_get_keys (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = gee_traversable_fold (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, GEE_TYPE_TRAVERSABLE, GeeTraversable), G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, ___lambda53__gee_fold_func, _data_->self, NULL);
	_data_->_tmp5_ = (gchar*) _data_->_tmp4_;
	_g_object_unref0 (_data_->_tmp3_);
	_data_->last_account = _data_->_tmp5_;
	_data_->next_id = (guint) 1;
	_data_->_tmp6_ = _data_->last_account;
	if (_data_->_tmp6_ != NULL) {
		_data_->_tmp7_ = _data_->last_account;
		_data_->_tmp8_ = strlen (ACCOUNTS_MANAGER_LOCAL_ID_PREFIX);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = string_substring (_data_->_tmp7_, (glong) _data_->_tmp9_, (glong) -1);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->next_id = (guint) (atoi (_data_->_tmp11_) + 1);
		_g_free0 (_data_->_tmp11_);
	}
	_data_->_tmp12_ = g_strdup_printf (ACCOUNTS_MANAGER_LOCAL_ID_FORMAT, _data_->next_id);
	_data_->id = _data_->_tmp12_;
	{
		while (TRUE) {
			_data_->_tmp15_ = _data_->self->priv->_config_dir;
			_data_->_tmp16_ = _data_->id;
			_data_->_tmp17_ = g_file_get_child (_data_->_tmp15_, _data_->_tmp16_);
			_data_->_tmp18_ = _data_->_tmp17_;
			_data_->_state_ = 1;
			geary_files_query_exists_async (_data_->_tmp18_, _data_->cancellable, accounts_manager_next_id_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp19_ = geary_files_query_exists_finish (_data_->_res_, &_data_->_inner_error0_);
			_g_object_unref0 (_data_->_tmp18_);
			_data_->_tmp14_ = _data_->_tmp19_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			if (_data_->_tmp14_) {
				_data_->_tmp13_ = TRUE;
			} else {
				_data_->_tmp21_ = _data_->self->priv->_data_dir;
				_data_->_tmp22_ = _data_->id;
				_data_->_tmp23_ = g_file_get_child (_data_->_tmp21_, _data_->_tmp22_);
				_data_->_tmp24_ = _data_->_tmp23_;
				_data_->_state_ = 2;
				geary_files_query_exists_async (_data_->_tmp24_, _data_->cancellable, accounts_manager_next_id_ready, _data_);
				return FALSE;
				_state_2:
				_data_->_tmp25_ = geary_files_query_exists_finish (_data_->_res_, &_data_->_inner_error0_);
				_g_object_unref0 (_data_->_tmp24_);
				_data_->_tmp20_ = _data_->_tmp25_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_data_->_tmp13_ = _data_->_tmp20_;
			}
			if (!_data_->_tmp13_) {
				break;
			}
			_data_->_tmp26_ = _data_->next_id;
			_data_->next_id = _data_->_tmp26_ + 1;
			_data_->_tmp27_ = g_strdup_printf (ACCOUNTS_MANAGER_LOCAL_ID_FORMAT, _data_->next_id);
			_g_free0 (_data_->id);
			_data_->id = _data_->_tmp27_;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp28_ = _data_->err;
		_data_->_tmp29_ = _data_->_tmp28_->message;
		g_debug ("accounts-manager.vala:470: Error checking for a free id on disk: %s", _data_->_tmp29_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->id);
		_g_free0 (_data_->last_account);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->id;
	_g_free0 (_data_->last_account);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
accounts_manager_load_account_data_free (gpointer _data)
{
	AccountsManagerLoadAccountData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountsManagerLoadAccountData, _data_);
}

static void
accounts_manager_load_account (AccountsManager* self,
                               const gchar* id,
                               GCancellable* cancellable,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	AccountsManagerLoadAccountData* _data_;
	AccountsManager* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail (id != NULL);
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (AccountsManagerLoadAccountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, accounts_manager_load_account_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	accounts_manager_load_account_co (_data_);
}

static GearyAccountInformation*
accounts_manager_load_account_finish (AccountsManager* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	GearyAccountInformation* result;
	AccountsManagerLoadAccountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Loads an account info from a config directory.
     *
     * Throws an error if the config file was not found, could not be
     * parsed, or doesn't have all required fields.
     */
static void
accounts_manager_load_account_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	AccountsManagerLoadAccountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	accounts_manager_load_account_co (_data_);
}

static GearyServiceProvider*
_geary_service_provider_dup (GearyServiceProvider* self)
{
	GearyServiceProvider* dup;
	dup = g_new0 (GearyServiceProvider, 1);
	memcpy (dup, self, sizeof (GearyServiceProvider));
	return dup;
}

static gpointer
__geary_service_provider_dup0 (gpointer self)
{
	return self ? _geary_service_provider_dup (self) : NULL;
}

static gboolean
accounts_manager_load_account_co (AccountsManagerLoadAccountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_config_dir;
	_data_->_tmp1_ = g_file_get_child (_data_->_tmp0_, _data_->id);
	_data_->config_dir = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->_data_dir;
	_data_->_tmp3_ = g_file_get_child (_data_->_tmp2_, _data_->id);
	_data_->data_dir = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->config_dir;
	_data_->_tmp5_ = g_file_get_child (_data_->_tmp4_, ACCOUNTS_MANAGER_SETTINGS_FILENAME);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = geary_config_file_new (_data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_g_object_unref0 (_data_->_tmp6_);
	_data_->config = _data_->_tmp8_;
	{
		_data_->_tmp9_ = _data_->config;
		_data_->_state_ = 1;
		geary_config_file_load (_data_->_tmp9_, _data_->cancellable, accounts_manager_load_account_ready, _data_);
		return FALSE;
		_state_1:
		geary_config_file_load_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp10_ = _data_->err;
		_data_->_tmp11_ = _data_->_tmp10_->message;
		_data_->_tmp12_ = g_error_new_literal (ACCOUNTS_CONFIG_ERROR, ACCOUNTS_CONFIG_ERROR_SYNTAX, _data_->_tmp11_);
		_data_->_inner_error0_ = _data_->_tmp12_;
		_g_error_free0 (_data_->err);
		goto __finally0;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_vala1_err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp13_ = _data_->_vala1_err;
		_data_->_tmp14_ = _data_->_tmp13_->message;
		_data_->_tmp15_ = g_error_new_literal (ACCOUNTS_CONFIG_ERROR, ACCOUNTS_CONFIG_ERROR_IO, _data_->_tmp14_);
		_data_->_inner_error0_ = _data_->_tmp15_;
		_g_error_free0 (_data_->_vala1_err);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == ACCOUNTS_CONFIG_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_geary_config_file_unref0 (_data_->config);
			_g_object_unref0 (_data_->data_dir);
			_g_object_unref0 (_data_->config_dir);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_geary_config_file_unref0 (_data_->config);
			_g_object_unref0 (_data_->data_dir);
			_g_object_unref0 (_data_->config_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp16_ = _data_->config;
	_data_->_tmp17_ = geary_config_file_get_group (_data_->_tmp16_, ACCOUNTS_MANAGER_GROUP_METADATA);
	_data_->metadata_config = _data_->_tmp17_;
	_data_->_tmp18_ = _data_->metadata_config;
	_data_->version = geary_config_file_group_get_int (_data_->_tmp18_, ACCOUNTS_MANAGER_METADATA_VERSION, 0);
	_data_->status = ACCOUNTS_MANAGER_STATUS_ENABLED;
	{
		_data_->_tmp20_ = _data_->metadata_config;
		_data_->_tmp21_ = accounts_manager_status_to_value (_data_->status);
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp23_ = geary_config_file_group_get_string (_data_->_tmp20_, ACCOUNTS_MANAGER_METADATA_STATUS, _data_->_tmp22_);
		_data_->_tmp24_ = _data_->_tmp23_;
		_data_->_tmp25_ = accounts_manager_status_for_value (_data_->_tmp24_, &_data_->_inner_error0_);
		_g_free0 (_data_->_tmp24_);
		_g_free0 (_data_->_tmp22_);
		_data_->_tmp19_ = _data_->_tmp25_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == GEARY_ENGINE_ERROR) {
				goto __catch1_geary_engine_error;
			}
			_geary_config_file_group_unref0 (_data_->metadata_config);
			_geary_config_file_unref0 (_data_->config);
			_g_object_unref0 (_data_->data_dir);
			_g_object_unref0 (_data_->config_dir);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->status = _data_->_tmp19_;
	}
	goto __finally1;
	__catch1_geary_engine_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->_tmp26_ = g_error_new (ACCOUNTS_CONFIG_ERROR, ACCOUNTS_CONFIG_ERROR_SYNTAX, "%s: Invalid status value", _data_->id);
		_data_->_inner_error0_ = _data_->_tmp26_;
		goto __finally1;
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == ACCOUNTS_CONFIG_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_geary_config_file_group_unref0 (_data_->metadata_config);
			_geary_config_file_unref0 (_data_->config);
			_g_object_unref0 (_data_->data_dir);
			_g_object_unref0 (_data_->config_dir);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_geary_config_file_group_unref0 (_data_->metadata_config);
			_geary_config_file_unref0 (_data_->config);
			_g_object_unref0 (_data_->data_dir);
			_g_object_unref0 (_data_->config_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp27_ = _data_->metadata_config;
	_data_->_tmp28_ = geary_config_file_group_get_string (_data_->_tmp27_, ACCOUNTS_MANAGER_METADATA_GOA, NULL);
	_data_->goa_id = _data_->_tmp28_;
	_data_->_tmp29_ = _data_->goa_id;
	_data_->is_goa = _data_->_tmp29_ != NULL;
	_data_->_tmp31_ = _data_->goa_id;
	if (_data_->_tmp31_ == NULL) {
		_data_->_tmp30_ = g_str_has_prefix (_data_->id, ACCOUNTS_MANAGER_GOA_ID_PREFIX);
	} else {
		_data_->_tmp30_ = FALSE;
	}
	if (_data_->_tmp30_) {
		_data_->_tmp32_ = accounts_manager_to_goa_id (_data_->self, _data_->id);
		_g_free0 (_data_->goa_id);
		_data_->goa_id = _data_->_tmp32_;
		_data_->is_goa = TRUE;
	}
	_data_->goa_handle = NULL;
	_data_->goa_mediator = NULL;
	_data_->default_provider = NULL;
	_data_->_tmp33_ = _data_->self->priv->local_mediator;
	_data_->_tmp34_ = _g_object_ref0 (_data_->_tmp33_);
	_data_->mediator = _data_->_tmp34_;
	if (_data_->is_goa) {
		_data_->_tmp35_ = _data_->self->priv->goa_service;
		if (_data_->_tmp35_ == NULL) {
			_data_->_tmp36_ = g_error_new_literal (ACCOUNTS_CONFIG_ERROR, ACCOUNTS_CONFIG_ERROR_MANAGEMENT, "GOA service not available");
			_data_->_inner_error0_ = _data_->_tmp36_;
			if (_data_->_inner_error0_->domain == ACCOUNTS_CONFIG_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->mediator);
				_g_free0 (_data_->default_provider);
				_g_object_unref0 (_data_->goa_mediator);
				_g_object_unref0 (_data_->goa_handle);
				_g_free0 (_data_->goa_id);
				_geary_config_file_group_unref0 (_data_->metadata_config);
				_geary_config_file_unref0 (_data_->config);
				_g_object_unref0 (_data_->data_dir);
				_g_object_unref0 (_data_->config_dir);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->mediator);
				_g_free0 (_data_->default_provider);
				_g_object_unref0 (_data_->goa_mediator);
				_g_object_unref0 (_data_->goa_handle);
				_g_free0 (_data_->goa_id);
				_geary_config_file_group_unref0 (_data_->metadata_config);
				_geary_config_file_unref0 (_data_->config);
				_g_object_unref0 (_data_->data_dir);
				_g_object_unref0 (_data_->config_dir);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->_tmp37_ = _data_->self->priv->goa_service;
		_data_->_tmp38_ = _data_->goa_id;
		_data_->_tmp39_ = goa_client_lookup_by_id (_data_->_tmp37_, _data_->_tmp38_);
		_g_object_unref0 (_data_->goa_handle);
		_data_->goa_handle = _data_->_tmp39_;
		_data_->_tmp40_ = _data_->goa_handle;
		if (_data_->_tmp40_ != NULL) {
			_data_->_tmp41_ = _data_->goa_handle;
			_data_->_tmp42_ = goa_mediator_new (_data_->_tmp41_);
			_g_object_unref0 (_data_->goa_mediator);
			_data_->goa_mediator = _data_->_tmp42_;
			_data_->_tmp43_ = _data_->goa_mediator;
			_data_->_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp43_, GEARY_TYPE_CREDENTIALS_MEDIATOR, GearyCredentialsMediator));
			_g_object_unref0 (_data_->mediator);
			_data_->mediator = _data_->_tmp44_;
			_data_->_tmp45_ = _data_->goa_mediator;
			_data_->_tmp46_ = goa_mediator_get_service_provider (_data_->_tmp45_);
			_data_->_tmp47_ = __geary_service_provider_dup0 (&_data_->_tmp46_);
			_g_free0 (_data_->default_provider);
			_data_->default_provider = _data_->_tmp47_;
		} else {
			_data_->_tmp48_ = _data_->goa_id;
			g_info ("accounts-manager.vala:541: %s: GOA account %s has been removed, removi" \
"ng local data", _data_->id, _data_->_tmp48_);
			_data_->status = ACCOUNTS_MANAGER_STATUS_REMOVED;
			_data_->_tmp49_ = GEARY_SERVICE_PROVIDER_OTHER;
			_data_->_tmp50_ = __geary_service_provider_dup0 (&_data_->_tmp49_);
			_g_free0 (_data_->default_provider);
			_data_->default_provider = _data_->_tmp50_;
		}
	}
	_data_->accounts = NULL;
	_data_->services = NULL;
	switch (_data_->version) {
		case 0:
		{
			_data_->_tmp51_ = accounts_account_config_legacy_new ();
			_g_object_unref0 (_data_->accounts);
			_data_->accounts = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp51_, ACCOUNTS_TYPE_ACCOUNT_CONFIG, AccountsAccountConfig);
			_data_->_tmp52_ = accounts_service_config_legacy_new ();
			_g_object_unref0 (_data_->services);
			_data_->services = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp52_, ACCOUNTS_TYPE_SERVICE_CONFIG, AccountsServiceConfig);
			break;
		}
		case 1:
		{
			_data_->_tmp53_ = accounts_account_config_v1_new (_data_->is_goa);
			_g_object_unref0 (_data_->accounts);
			_data_->accounts = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp53_, ACCOUNTS_TYPE_ACCOUNT_CONFIG, AccountsAccountConfig);
			_data_->_tmp54_ = accounts_service_config_v1_new ();
			_g_object_unref0 (_data_->services);
			_data_->services = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp54_, ACCOUNTS_TYPE_SERVICE_CONFIG, AccountsServiceConfig);
			break;
		}
		default:
		{
			_data_->_tmp55_ = g_error_new (ACCOUNTS_CONFIG_ERROR, ACCOUNTS_CONFIG_ERROR_VERSION, "Unsupported config version: %d", _data_->version);
			_data_->_inner_error0_ = _data_->_tmp55_;
			if (_data_->_inner_error0_->domain == ACCOUNTS_CONFIG_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->services);
				_g_object_unref0 (_data_->accounts);
				_g_object_unref0 (_data_->mediator);
				_g_free0 (_data_->default_provider);
				_g_object_unref0 (_data_->goa_mediator);
				_g_object_unref0 (_data_->goa_handle);
				_g_free0 (_data_->goa_id);
				_geary_config_file_group_unref0 (_data_->metadata_config);
				_geary_config_file_unref0 (_data_->config);
				_g_object_unref0 (_data_->data_dir);
				_g_object_unref0 (_data_->config_dir);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->services);
				_g_object_unref0 (_data_->accounts);
				_g_object_unref0 (_data_->mediator);
				_g_free0 (_data_->default_provider);
				_g_object_unref0 (_data_->goa_mediator);
				_g_object_unref0 (_data_->goa_handle);
				_g_free0 (_data_->goa_id);
				_geary_config_file_group_unref0 (_data_->metadata_config);
				_geary_config_file_unref0 (_data_->config);
				_g_object_unref0 (_data_->data_dir);
				_g_object_unref0 (_data_->config_dir);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	_data_->account = NULL;
	{
		_data_->_tmp57_ = _data_->accounts;
		_data_->_tmp58_ = _data_->config;
		_data_->_tmp59_ = _data_->mediator;
		_data_->_tmp60_ = _data_->default_provider;
		_data_->_tmp61_ = accounts_manager_get_account_name (_data_->self);
		_data_->_tmp62_ = _data_->_tmp61_;
		_data_->_tmp63_ = accounts_account_config_load (_data_->_tmp57_, _data_->_tmp58_, _data_->id, _data_->_tmp59_, _data_->_tmp60_, _data_->_tmp62_, &_data_->_inner_error0_);
		_data_->_tmp64_ = _data_->_tmp63_;
		_g_free0 (_data_->_tmp62_);
		_data_->_tmp56_ = _data_->_tmp64_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch2_g_key_file_error;
			}
			goto __finally2;
		}
		_data_->_tmp65_ = _data_->_tmp56_;
		_data_->_tmp56_ = NULL;
		_g_object_unref0 (_data_->account);
		_data_->account = _data_->_tmp65_;
		_data_->_tmp66_ = _data_->account;
		_data_->_tmp67_ = _data_->config_dir;
		_data_->_tmp68_ = _data_->data_dir;
		geary_account_information_set_account_directories (_data_->_tmp66_, _data_->_tmp67_, _data_->_tmp68_);
		_g_object_unref0 (_data_->_tmp56_);
	}
	goto __finally2;
	__catch2_g_key_file_error:
	{
		_data_->_vala2_err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp69_ = _data_->_vala2_err;
		_data_->_tmp70_ = _data_->_tmp69_->message;
		_data_->_tmp71_ = g_error_new_literal (ACCOUNTS_CONFIG_ERROR, ACCOUNTS_CONFIG_ERROR_SYNTAX, _data_->_tmp70_);
		_data_->_inner_error0_ = _data_->_tmp71_;
		_g_error_free0 (_data_->_vala2_err);
		goto __finally2;
	}
	__finally2:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == ACCOUNTS_CONFIG_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->account);
			_g_object_unref0 (_data_->services);
			_g_object_unref0 (_data_->accounts);
			_g_object_unref0 (_data_->mediator);
			_g_free0 (_data_->default_provider);
			_g_object_unref0 (_data_->goa_mediator);
			_g_object_unref0 (_data_->goa_handle);
			_g_free0 (_data_->goa_id);
			_geary_config_file_group_unref0 (_data_->metadata_config);
			_geary_config_file_unref0 (_data_->config);
			_g_object_unref0 (_data_->data_dir);
			_g_object_unref0 (_data_->config_dir);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->account);
			_g_object_unref0 (_data_->services);
			_g_object_unref0 (_data_->accounts);
			_g_object_unref0 (_data_->mediator);
			_g_free0 (_data_->default_provider);
			_g_object_unref0 (_data_->goa_mediator);
			_g_object_unref0 (_data_->goa_handle);
			_g_free0 (_data_->goa_id);
			_geary_config_file_group_unref0 (_data_->metadata_config);
			_geary_config_file_unref0 (_data_->config);
			_g_object_unref0 (_data_->data_dir);
			_g_object_unref0 (_data_->config_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	if (_data_->status == ACCOUNTS_MANAGER_STATUS_REMOVED) {
		_data_->_tmp72_ = _data_->self->priv->removed;
		_data_->_tmp73_ = _data_->account;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp72_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->_tmp73_);
		_data_->_tmp74_ = g_error_new_literal (ACCOUNTS_CONFIG_ERROR, ACCOUNTS_CONFIG_ERROR_REMOVED, "Account marked for removal");
		_data_->_inner_error0_ = _data_->_tmp74_;
		if (_data_->_inner_error0_->domain == ACCOUNTS_CONFIG_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->account);
			_g_object_unref0 (_data_->services);
			_g_object_unref0 (_data_->accounts);
			_g_object_unref0 (_data_->mediator);
			_g_free0 (_data_->default_provider);
			_g_object_unref0 (_data_->goa_mediator);
			_g_object_unref0 (_data_->goa_handle);
			_g_free0 (_data_->goa_id);
			_geary_config_file_group_unref0 (_data_->metadata_config);
			_geary_config_file_unref0 (_data_->config);
			_g_object_unref0 (_data_->data_dir);
			_g_object_unref0 (_data_->config_dir);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->account);
			_g_object_unref0 (_data_->services);
			_g_object_unref0 (_data_->accounts);
			_g_object_unref0 (_data_->mediator);
			_g_free0 (_data_->default_provider);
			_g_object_unref0 (_data_->goa_mediator);
			_g_object_unref0 (_data_->goa_handle);
			_g_free0 (_data_->goa_id);
			_geary_config_file_group_unref0 (_data_->metadata_config);
			_geary_config_file_unref0 (_data_->config);
			_g_object_unref0 (_data_->data_dir);
			_g_object_unref0 (_data_->config_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	if (!_data_->is_goa) {
		{
			_data_->_tmp75_ = _data_->services;
			_data_->_tmp76_ = _data_->config;
			_data_->_tmp77_ = _data_->account;
			_data_->_tmp78_ = _data_->account;
			_data_->_tmp79_ = geary_account_information_get_incoming (_data_->_tmp78_);
			_data_->_tmp80_ = _data_->_tmp79_;
			accounts_service_config_load (_data_->_tmp75_, _data_->_tmp76_, _data_->_tmp77_, _data_->_tmp80_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch3_g_key_file_error;
				}
				goto __finally3;
			}
			_data_->_tmp81_ = _data_->services;
			_data_->_tmp82_ = _data_->config;
			_data_->_tmp83_ = _data_->account;
			_data_->_tmp84_ = _data_->account;
			_data_->_tmp85_ = geary_account_information_get_outgoing (_data_->_tmp84_);
			_data_->_tmp86_ = _data_->_tmp85_;
			accounts_service_config_load (_data_->_tmp81_, _data_->_tmp82_, _data_->_tmp83_, _data_->_tmp86_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch3_g_key_file_error;
				}
				goto __finally3;
			}
		}
		goto __finally3;
		__catch3_g_key_file_error:
		{
			_data_->_vala3_err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp87_ = _data_->_vala3_err;
			_data_->_tmp88_ = _data_->_tmp87_->message;
			_data_->_tmp89_ = g_error_new_literal (ACCOUNTS_CONFIG_ERROR, ACCOUNTS_CONFIG_ERROR_SYNTAX, _data_->_tmp88_);
			_data_->_inner_error0_ = _data_->_tmp89_;
			_g_error_free0 (_data_->_vala3_err);
			goto __finally3;
		}
		__finally3:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == ACCOUNTS_CONFIG_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->account);
				_g_object_unref0 (_data_->services);
				_g_object_unref0 (_data_->accounts);
				_g_object_unref0 (_data_->mediator);
				_g_free0 (_data_->default_provider);
				_g_object_unref0 (_data_->goa_mediator);
				_g_object_unref0 (_data_->goa_handle);
				_g_free0 (_data_->goa_id);
				_geary_config_file_group_unref0 (_data_->metadata_config);
				_geary_config_file_unref0 (_data_->config);
				_g_object_unref0 (_data_->data_dir);
				_g_object_unref0 (_data_->config_dir);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->account);
				_g_object_unref0 (_data_->services);
				_g_object_unref0 (_data_->accounts);
				_g_object_unref0 (_data_->mediator);
				_g_free0 (_data_->default_provider);
				_g_object_unref0 (_data_->goa_mediator);
				_g_object_unref0 (_data_->goa_handle);
				_g_free0 (_data_->goa_id);
				_geary_config_file_group_unref0 (_data_->metadata_config);
				_geary_config_file_unref0 (_data_->config);
				_g_object_unref0 (_data_->data_dir);
				_g_object_unref0 (_data_->config_dir);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	} else {
		_data_->_tmp90_ = _data_->account;
		_data_->_tmp91_ = _data_->goa_mediator;
		_data_->_tmp92_ = goa_mediator_get_service_label (_data_->_tmp91_);
		_data_->_tmp93_ = _data_->_tmp92_;
		geary_account_information_set_service_label (_data_->_tmp90_, _data_->_tmp93_);
		_g_free0 (_data_->_tmp93_);
		{
			_data_->_tmp94_ = _data_->goa_mediator;
			_data_->_tmp95_ = _data_->account;
			_data_->_state_ = 2;
			goa_mediator_update (_data_->_tmp94_, _data_->_tmp95_, _data_->cancellable, accounts_manager_load_account_ready, _data_);
			return FALSE;
			_state_2:
			goa_mediator_update_finish (_data_->_tmp94_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch4_g_error;
			}
		}
		goto __finally4;
		__catch4_g_error:
		{
			_data_->_vala4_err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp96_ = _data_->_vala4_err;
			_data_->_tmp97_ = _data_->_tmp96_->message;
			_data_->_tmp98_ = g_error_new_literal (ACCOUNTS_CONFIG_ERROR, ACCOUNTS_CONFIG_ERROR_MANAGEMENT, _data_->_tmp97_);
			_data_->_inner_error0_ = _data_->_tmp98_;
			_g_error_free0 (_data_->_vala4_err);
			goto __finally4;
		}
		__finally4:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == ACCOUNTS_CONFIG_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->account);
				_g_object_unref0 (_data_->services);
				_g_object_unref0 (_data_->accounts);
				_g_object_unref0 (_data_->mediator);
				_g_free0 (_data_->default_provider);
				_g_object_unref0 (_data_->goa_mediator);
				_g_object_unref0 (_data_->goa_handle);
				_g_free0 (_data_->goa_id);
				_geary_config_file_group_unref0 (_data_->metadata_config);
				_geary_config_file_unref0 (_data_->config);
				_g_object_unref0 (_data_->data_dir);
				_g_object_unref0 (_data_->config_dir);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->account);
				_g_object_unref0 (_data_->services);
				_g_object_unref0 (_data_->accounts);
				_g_object_unref0 (_data_->mediator);
				_g_free0 (_data_->default_provider);
				_g_object_unref0 (_data_->goa_mediator);
				_g_object_unref0 (_data_->goa_handle);
				_g_free0 (_data_->goa_id);
				_geary_config_file_group_unref0 (_data_->metadata_config);
				_geary_config_file_unref0 (_data_->config);
				_g_object_unref0 (_data_->data_dir);
				_g_object_unref0 (_data_->config_dir);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->_tmp99_ = _data_->goa_handle;
		if (!accounts_manager_is_valid_goa_account (_data_->self, _data_->_tmp99_)) {
			_data_->_tmp100_ = _data_->account;
			accounts_manager_set_available (_data_->self, _data_->_tmp100_, FALSE);
			_data_->_tmp101_ = g_error_new_literal (ACCOUNTS_CONFIG_ERROR, ACCOUNTS_CONFIG_ERROR_UNAVAILABLE, "GOA Mail service not available");
			_data_->_inner_error0_ = _data_->_tmp101_;
			if (_data_->_inner_error0_->domain == ACCOUNTS_CONFIG_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->account);
				_g_object_unref0 (_data_->services);
				_g_object_unref0 (_data_->accounts);
				_g_object_unref0 (_data_->mediator);
				_g_free0 (_data_->default_provider);
				_g_object_unref0 (_data_->goa_mediator);
				_g_object_unref0 (_data_->goa_handle);
				_g_free0 (_data_->goa_id);
				_geary_config_file_group_unref0 (_data_->metadata_config);
				_geary_config_file_unref0 (_data_->config);
				_g_object_unref0 (_data_->data_dir);
				_g_object_unref0 (_data_->config_dir);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->account);
				_g_object_unref0 (_data_->services);
				_g_object_unref0 (_data_->accounts);
				_g_object_unref0 (_data_->mediator);
				_g_free0 (_data_->default_provider);
				_g_object_unref0 (_data_->goa_mediator);
				_g_object_unref0 (_data_->goa_handle);
				_g_free0 (_data_->goa_id);
				_geary_config_file_group_unref0 (_data_->metadata_config);
				_geary_config_file_unref0 (_data_->config);
				_g_object_unref0 (_data_->data_dir);
				_g_object_unref0 (_data_->config_dir);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	if (_data_->status == ACCOUNTS_MANAGER_STATUS_DISABLED) {
		_data_->_tmp102_ = _data_->account;
		accounts_manager_set_enabled (_data_->self, _data_->_tmp102_, FALSE);
		_data_->_tmp103_ = g_error_new_literal (ACCOUNTS_CONFIG_ERROR, ACCOUNTS_CONFIG_ERROR_UNAVAILABLE, "Account disabled");
		_data_->_inner_error0_ = _data_->_tmp103_;
		if (_data_->_inner_error0_->domain == ACCOUNTS_CONFIG_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->account);
			_g_object_unref0 (_data_->services);
			_g_object_unref0 (_data_->accounts);
			_g_object_unref0 (_data_->mediator);
			_g_free0 (_data_->default_provider);
			_g_object_unref0 (_data_->goa_mediator);
			_g_object_unref0 (_data_->goa_handle);
			_g_free0 (_data_->goa_id);
			_geary_config_file_group_unref0 (_data_->metadata_config);
			_geary_config_file_unref0 (_data_->config);
			_g_object_unref0 (_data_->data_dir);
			_g_object_unref0 (_data_->config_dir);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->account);
			_g_object_unref0 (_data_->services);
			_g_object_unref0 (_data_->accounts);
			_g_object_unref0 (_data_->mediator);
			_g_free0 (_data_->default_provider);
			_g_object_unref0 (_data_->goa_mediator);
			_g_object_unref0 (_data_->goa_handle);
			_g_free0 (_data_->goa_id);
			_geary_config_file_group_unref0 (_data_->metadata_config);
			_geary_config_file_unref0 (_data_->config);
			_g_object_unref0 (_data_->data_dir);
			_g_object_unref0 (_data_->config_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = _data_->account;
	_g_object_unref0 (_data_->services);
	_g_object_unref0 (_data_->accounts);
	_g_object_unref0 (_data_->mediator);
	_g_free0 (_data_->default_provider);
	_g_object_unref0 (_data_->goa_mediator);
	_g_object_unref0 (_data_->goa_handle);
	_g_free0 (_data_->goa_id);
	_geary_config_file_group_unref0 (_data_->metadata_config);
	_geary_config_file_unref0 (_data_->config);
	_g_object_unref0 (_data_->data_dir);
	_g_object_unref0 (_data_->config_dir);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
accounts_manager_save_account_locked_data_free (gpointer _data)
{
	AccountsManagerSaveAccountLockedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountsManagerSaveAccountLockedData, _data_);
}

static void
accounts_manager_save_account_locked (AccountsManager* self,
                                      GearyAccountInformation* account,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	AccountsManagerSaveAccountLockedData* _data_;
	AccountsManager* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (AccountsManagerSaveAccountLockedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, accounts_manager_save_account_locked_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (account);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	accounts_manager_save_account_locked_co (_data_);
}

static void
accounts_manager_save_account_locked_finish (AccountsManager* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	AccountsManagerSaveAccountLockedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
accounts_manager_save_account_locked_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	AccountsManagerSaveAccountLockedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	accounts_manager_save_account_locked_co (_data_);
}

static gboolean
accounts_manager_save_account_locked_co (AccountsManagerSaveAccountLockedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_account_information_get_config_dir (_data_->account);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp2_ = geary_account_information_get_id (_data_->account);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = g_error_new (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "Account %s does not have a config directory", _data_->_tmp3_);
		_data_->_inner_error0_ = _data_->_tmp4_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = geary_account_information_get_config_dir (_data_->account);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = g_file_get_child (_data_->_tmp6_, ACCOUNTS_MANAGER_SETTINGS_FILENAME);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = geary_config_file_new (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_g_object_unref0 (_data_->_tmp8_);
	_data_->config = _data_->_tmp10_;
	{
		_data_->_state_ = 1;
		geary_config_file_load (_data_->config, _data_->cancellable, accounts_manager_save_account_locked_ready, _data_);
		return FALSE;
		_state_1:
		geary_config_file_load_finish (_data_->config, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp11_ = _data_->err;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		g_debug ("accounts-manager.vala:649: Could not load existing config file: %s", _data_->_tmp12_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_geary_config_file_unref0 (_data_->config);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = geary_config_file_get_group (_data_->config, ACCOUNTS_MANAGER_GROUP_METADATA);
	_data_->metadata_config = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->metadata_config;
	geary_config_file_group_set_int (_data_->_tmp14_, ACCOUNTS_MANAGER_METADATA_VERSION, ACCOUNTS_MANAGER_CONFIG_VERSION);
	_data_->_tmp15_ = _data_->metadata_config;
	_data_->_tmp16_ = accounts_manager_status_to_value (accounts_manager_get_status (_data_->self, _data_->account));
	_data_->_tmp17_ = _data_->_tmp16_;
	geary_config_file_group_set_string (_data_->_tmp15_, ACCOUNTS_MANAGER_METADATA_STATUS, _data_->_tmp17_);
	_g_free0 (_data_->_tmp17_);
	_data_->is_goa = accounts_manager_is_goa_account (_data_->self, _data_->account);
	if (_data_->is_goa) {
		_data_->_tmp18_ = _data_->metadata_config;
		_data_->_tmp19_ = geary_account_information_get_id (_data_->account);
		_data_->_tmp20_ = _data_->_tmp19_;
		_data_->_tmp21_ = accounts_manager_to_goa_id (_data_->self, _data_->_tmp20_);
		_data_->_tmp22_ = _data_->_tmp21_;
		geary_config_file_group_set_string (_data_->_tmp18_, ACCOUNTS_MANAGER_METADATA_GOA, _data_->_tmp22_);
		_g_free0 (_data_->_tmp22_);
	}
	_data_->_tmp23_ = accounts_account_config_v1_new (_data_->is_goa);
	_data_->accounts = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp23_, ACCOUNTS_TYPE_ACCOUNT_CONFIG, AccountsAccountConfig);
	_data_->_tmp24_ = _data_->accounts;
	accounts_account_config_save (_data_->_tmp24_, _data_->account, _data_->config);
	if (!_data_->is_goa) {
		_data_->_tmp25_ = accounts_service_config_v1_new ();
		_data_->services = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp25_, ACCOUNTS_TYPE_SERVICE_CONFIG, AccountsServiceConfig);
		_data_->_tmp26_ = _data_->services;
		_data_->_tmp27_ = geary_account_information_get_incoming (_data_->account);
		_data_->_tmp28_ = _data_->_tmp27_;
		accounts_service_config_save (_data_->_tmp26_, _data_->account, _data_->_tmp28_, _data_->config);
		_data_->_tmp29_ = _data_->services;
		_data_->_tmp30_ = geary_account_information_get_outgoing (_data_->account);
		_data_->_tmp31_ = _data_->_tmp30_;
		accounts_service_config_save (_data_->_tmp29_, _data_->account, _data_->_tmp31_, _data_->config);
		_g_object_unref0 (_data_->services);
	}
	_data_->_tmp32_ = geary_config_file_get_file (_data_->config);
	_data_->_tmp33_ = _data_->_tmp32_;
	_data_->_tmp34_ = g_file_get_path (_data_->_tmp33_);
	_data_->_tmp35_ = _data_->_tmp34_;
	g_debug ("accounts-manager.vala:675: Writing config to: %s", _data_->_tmp35_);
	_g_free0 (_data_->_tmp35_);
	_data_->_state_ = 2;
	geary_config_file_save (_data_->config, _data_->cancellable, accounts_manager_save_account_locked_ready, _data_);
	return FALSE;
	_state_2:
	geary_config_file_save_finish (_data_->config, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->accounts);
		_geary_config_file_group_unref0 (_data_->metadata_config);
		_geary_config_file_unref0 (_data_->config);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->accounts);
	_geary_config_file_group_unref0 (_data_->metadata_config);
	_geary_config_file_unref0 (_data_->config);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
accounts_manager_delete_account_data_free (gpointer _data)
{
	AccountsManagerDeleteAccountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->info);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountsManagerDeleteAccountData, _data_);
}

static void
accounts_manager_delete_account (AccountsManager* self,
                                 GearyAccountInformation* info,
                                 GCancellable* cancellable,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	AccountsManagerDeleteAccountData* _data_;
	AccountsManager* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (AccountsManagerDeleteAccountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, accounts_manager_delete_account_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (info);
	_g_object_unref0 (_data_->info);
	_data_->info = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	accounts_manager_delete_account_co (_data_);
}

static void
accounts_manager_delete_account_finish (AccountsManager* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	AccountsManagerDeleteAccountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
accounts_manager_delete_account_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	AccountsManagerDeleteAccountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	accounts_manager_delete_account_co (_data_);
}

static gboolean
accounts_manager_delete_account_co (AccountsManagerDeleteAccountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_account_information_get_mediator (_data_->info);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _g_object_ref0 (IS_SECRET_MEDIATOR (_data_->_tmp1_) ? ((SecretMediator*) _data_->_tmp1_) : NULL);
	_data_->mediator = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->mediator;
	if (_data_->_tmp3_ != NULL) {
		{
			_data_->_tmp4_ = _data_->mediator;
			_data_->_tmp5_ = geary_account_information_get_incoming (_data_->info);
			_data_->_tmp6_ = _data_->_tmp5_;
			_data_->_state_ = 1;
			secret_mediator_clear_token (_data_->_tmp4_, _data_->info, _data_->_tmp6_, _data_->cancellable, accounts_manager_delete_account_ready, _data_);
			return FALSE;
			_state_1:
			secret_mediator_clear_token_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp7_ = _data_->e;
			_data_->_tmp8_ = _data_->_tmp7_->message;
			g_debug ("accounts-manager.vala:690: Error clearing IMAP password: %s", _data_->_tmp8_);
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->mediator);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		{
			_data_->_tmp9_ = _data_->mediator;
			_data_->_tmp10_ = geary_account_information_get_outgoing (_data_->info);
			_data_->_tmp11_ = _data_->_tmp10_;
			_data_->_state_ = 2;
			secret_mediator_clear_token (_data_->_tmp9_, _data_->info, _data_->_tmp11_, _data_->cancellable, accounts_manager_delete_account_ready, _data_);
			return FALSE;
			_state_2:
			secret_mediator_clear_token_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->_vala1_e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp12_ = _data_->_vala1_e;
			_data_->_tmp13_ = _data_->_tmp12_->message;
			g_debug ("accounts-manager.vala:696: Error clearing IMAP password: %s", _data_->_tmp13_);
			_g_error_free0 (_data_->_vala1_e);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->mediator);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp14_ = geary_account_information_get_data_dir (_data_->info);
	_data_->_tmp15_ = _data_->_tmp14_;
	if (_data_->_tmp15_ != NULL) {
		_data_->_tmp16_ = geary_account_information_get_data_dir (_data_->info);
		_data_->_tmp17_ = _data_->_tmp16_;
		_data_->_state_ = 3;
		geary_files_recursive_delete_async (_data_->_tmp17_, G_PRIORITY_LOW, _data_->cancellable, accounts_manager_delete_account_ready, _data_);
		return FALSE;
		_state_3:
		geary_files_recursive_delete_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->mediator);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp18_ = geary_account_information_get_config_dir (_data_->info);
	_data_->_tmp19_ = _data_->_tmp18_;
	if (_data_->_tmp19_ != NULL) {
		_data_->_tmp20_ = geary_account_information_get_config_dir (_data_->info);
		_data_->_tmp21_ = _data_->_tmp20_;
		_data_->_state_ = 4;
		geary_files_recursive_delete_async (_data_->_tmp21_, G_PRIORITY_LOW, _data_->cancellable, accounts_manager_delete_account_ready, _data_);
		return FALSE;
		_state_4:
		geary_files_recursive_delete_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->mediator);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->mediator);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static inline AccountsManagerAccountState*
accounts_manager_lookup_state (AccountsManager* self,
                               GearyAccountInformation* account)
{
	AccountsManagerAccountState* state = NULL;
	GeeMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gpointer _tmp3_;
	AccountsManagerAccountState* _tmp4_;
	AccountsManagerAccountState* result;
	g_return_val_if_fail (ACCOUNTS_IS_MANAGER (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION), NULL);
	_tmp0_ = self->priv->accounts;
	_tmp1_ = geary_account_information_get_id (account);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_map_get (_tmp0_, _tmp2_);
	state = (AccountsManagerAccountState*) _tmp3_;
	_tmp4_ = state;
	if (_tmp4_ == NULL) {
		AccountsManagerAccountState* _tmp5_;
		GeeMap* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		AccountsManagerAccountState* _tmp9_;
		_tmp5_ = accounts_manager_account_state_new (account);
		_accounts_manager_account_state_unref0 (state);
		state = _tmp5_;
		_tmp6_ = self->priv->accounts;
		_tmp7_ = geary_account_information_get_id (account);
		_tmp8_ = _tmp7_;
		_tmp9_ = state;
		gee_map_set (_tmp6_, _tmp8_, _tmp9_);
	}
	result = state;
	return result;
}

static gboolean
accounts_manager_set_enabled (AccountsManager* self,
                              GearyAccountInformation* account,
                              gboolean is_enabled)
{
	gboolean was_added = FALSE;
	GeeMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	AccountsManagerAccountState* state = NULL;
	AccountsManagerAccountState* _tmp3_;
	AccountsManagerStatus existing_status = 0;
	AccountsManagerAccountState* _tmp4_;
	AccountsManagerStatus _tmp5_;
	AccountsManagerStatus _tmp6_;
	AccountsManagerAccountState* _tmp7_;
	gboolean ret = FALSE;
	gboolean result;
	g_return_val_if_fail (ACCOUNTS_IS_MANAGER (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION), FALSE);
	_tmp0_ = self->priv->accounts;
	_tmp1_ = geary_account_information_get_id (account);
	_tmp2_ = _tmp1_;
	was_added = !gee_map_has_key (_tmp0_, _tmp2_);
	_tmp3_ = accounts_manager_lookup_state (self, account);
	state = _tmp3_;
	_tmp4_ = state;
	_tmp5_ = accounts_manager_account_state_get_status (_tmp4_);
	_tmp6_ = _tmp5_;
	existing_status = _tmp6_;
	_tmp7_ = state;
	accounts_manager_account_state_set_enabled (_tmp7_, is_enabled);
	ret = FALSE;
	if (was_added) {
		AccountsManagerAccountState* _tmp8_;
		GearyAccountInformation* _tmp9_;
		GearyAccountInformation* _tmp10_;
		AccountsManagerAccountState* _tmp11_;
		AccountsManagerStatus _tmp12_;
		AccountsManagerStatus _tmp13_;
		_tmp8_ = state;
		_tmp9_ = accounts_manager_account_state_get_account (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = state;
		_tmp12_ = accounts_manager_account_state_get_status (_tmp11_);
		_tmp13_ = _tmp12_;
		g_signal_emit (self, accounts_manager_signals[ACCOUNTS_MANAGER_ACCOUNT_ADDED_SIGNAL], 0, _tmp10_, _tmp13_);
		g_signal_connect_object (account, "changed", (GCallback) _accounts_manager_on_account_changed_geary_account_information_changed, self, 0);
		ret = TRUE;
	} else {
		AccountsManagerAccountState* _tmp14_;
		AccountsManagerStatus _tmp15_;
		AccountsManagerStatus _tmp16_;
		_tmp14_ = state;
		_tmp15_ = accounts_manager_account_state_get_status (_tmp14_);
		_tmp16_ = _tmp15_;
		if (_tmp16_ != existing_status) {
			AccountsManagerAccountState* _tmp17_;
			GearyAccountInformation* _tmp18_;
			GearyAccountInformation* _tmp19_;
			AccountsManagerAccountState* _tmp20_;
			AccountsManagerStatus _tmp21_;
			AccountsManagerStatus _tmp22_;
			_tmp17_ = state;
			_tmp18_ = accounts_manager_account_state_get_account (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = state;
			_tmp21_ = accounts_manager_account_state_get_status (_tmp20_);
			_tmp22_ = _tmp21_;
			g_signal_emit (self, accounts_manager_signals[ACCOUNTS_MANAGER_ACCOUNT_STATUS_CHANGED_SIGNAL], 0, _tmp19_, _tmp22_);
			ret = TRUE;
		}
	}
	result = ret;
	_accounts_manager_account_state_unref0 (state);
	return result;
}

static gboolean
accounts_manager_set_available (AccountsManager* self,
                                GearyAccountInformation* account,
                                gboolean is_available)
{
	gboolean was_added = FALSE;
	GeeMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	AccountsManagerAccountState* state = NULL;
	AccountsManagerAccountState* _tmp3_;
	AccountsManagerStatus existing_status = 0;
	AccountsManagerAccountState* _tmp4_;
	AccountsManagerStatus _tmp5_;
	AccountsManagerStatus _tmp6_;
	AccountsManagerAccountState* _tmp7_;
	gboolean ret = FALSE;
	gboolean result;
	g_return_val_if_fail (ACCOUNTS_IS_MANAGER (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION), FALSE);
	_tmp0_ = self->priv->accounts;
	_tmp1_ = geary_account_information_get_id (account);
	_tmp2_ = _tmp1_;
	was_added = !gee_map_has_key (_tmp0_, _tmp2_);
	_tmp3_ = accounts_manager_lookup_state (self, account);
	state = _tmp3_;
	_tmp4_ = state;
	_tmp5_ = accounts_manager_account_state_get_status (_tmp4_);
	_tmp6_ = _tmp5_;
	existing_status = _tmp6_;
	_tmp7_ = state;
	accounts_manager_account_state_set_available (_tmp7_, is_available);
	ret = FALSE;
	if (was_added) {
		AccountsManagerAccountState* _tmp8_;
		GearyAccountInformation* _tmp9_;
		GearyAccountInformation* _tmp10_;
		AccountsManagerAccountState* _tmp11_;
		AccountsManagerStatus _tmp12_;
		AccountsManagerStatus _tmp13_;
		_tmp8_ = state;
		_tmp9_ = accounts_manager_account_state_get_account (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = state;
		_tmp12_ = accounts_manager_account_state_get_status (_tmp11_);
		_tmp13_ = _tmp12_;
		g_signal_emit (self, accounts_manager_signals[ACCOUNTS_MANAGER_ACCOUNT_ADDED_SIGNAL], 0, _tmp10_, _tmp13_);
		g_signal_connect_object (account, "changed", (GCallback) _accounts_manager_on_account_changed_geary_account_information_changed, self, 0);
		ret = TRUE;
	} else {
		AccountsManagerAccountState* _tmp14_;
		AccountsManagerStatus _tmp15_;
		AccountsManagerStatus _tmp16_;
		_tmp14_ = state;
		_tmp15_ = accounts_manager_account_state_get_status (_tmp14_);
		_tmp16_ = _tmp15_;
		if (_tmp16_ != existing_status) {
			AccountsManagerAccountState* _tmp17_;
			GearyAccountInformation* _tmp18_;
			GearyAccountInformation* _tmp19_;
			AccountsManagerAccountState* _tmp20_;
			AccountsManagerStatus _tmp21_;
			AccountsManagerStatus _tmp22_;
			_tmp17_ = state;
			_tmp18_ = accounts_manager_account_state_get_account (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = state;
			_tmp21_ = accounts_manager_account_state_get_status (_tmp20_);
			_tmp22_ = _tmp21_;
			g_signal_emit (self, accounts_manager_signals[ACCOUNTS_MANAGER_ACCOUNT_STATUS_CHANGED_SIGNAL], 0, _tmp19_, _tmp22_);
			ret = TRUE;
		}
	}
	result = ret;
	_accounts_manager_account_state_unref0 (state);
	return result;
}

static void
accounts_manager_create_account_dirs_data_free (gpointer _data)
{
	AccountsManagerCreateAccountDirsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->info);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountsManagerCreateAccountDirsData, _data_);
}

static void
accounts_manager_create_account_dirs (AccountsManager* self,
                                      GearyAccountInformation* info,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	AccountsManagerCreateAccountDirsData* _data_;
	AccountsManager* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (AccountsManagerCreateAccountDirsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, accounts_manager_create_account_dirs_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (info);
	_g_object_unref0 (_data_->info);
	_data_->info = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	accounts_manager_create_account_dirs_co (_data_);
}

static void
accounts_manager_create_account_dirs_finish (AccountsManager* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	AccountsManagerCreateAccountDirsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
accounts_manager_create_account_dirs_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	AccountsManagerCreateAccountDirsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	accounts_manager_create_account_dirs_co (_data_);
}

static gboolean
accounts_manager_create_account_dirs_co (AccountsManagerCreateAccountDirsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_config_dir;
	_data_->_tmp1_ = geary_account_information_get_id (_data_->info);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = g_file_get_child (_data_->_tmp0_, _data_->_tmp2_);
	_data_->config = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->self->priv->_data_dir;
	_data_->_tmp5_ = geary_account_information_get_id (_data_->info);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = g_file_get_child (_data_->_tmp4_, _data_->_tmp6_);
	_data_->data = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->config;
	_data_->_state_ = 1;
	geary_files_make_directory_with_parents (_data_->_tmp8_, _data_->cancellable, accounts_manager_create_account_dirs_ready, _data_);
	return FALSE;
	_state_1:
	geary_files_make_directory_with_parents_finish (_data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->data);
		_g_object_unref0 (_data_->config);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = _data_->data;
	_data_->_state_ = 2;
	geary_files_make_directory_with_parents (_data_->_tmp9_, _data_->cancellable, accounts_manager_create_account_dirs_ready, _data_);
	return FALSE;
	_state_2:
	geary_files_make_directory_with_parents_finish (_data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->data);
		_g_object_unref0 (_data_->config);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->config;
	_data_->_tmp11_ = _data_->data;
	geary_account_information_set_account_directories (_data_->info, _data_->_tmp10_, _data_->_tmp11_);
	_g_object_unref0 (_data_->data);
	_g_object_unref0 (_data_->config);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static inline gchar*
accounts_manager_to_geary_id (AccountsManager* self,
                              GoaObject* account)
{
	GoaAccount* _tmp0_;
	GoaAccount* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (ACCOUNTS_IS_MANAGER (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, goa_object_get_type ()), NULL);
	_tmp0_ = goa_object_get_account (account);
	_tmp1_ = _tmp0_;
	g_object_get (_tmp1_, "id", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (ACCOUNTS_MANAGER_GOA_ID_PREFIX, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp1_);
	result = _tmp6_;
	return result;
}

static inline gchar*
accounts_manager_to_goa_id (AccountsManager* self,
                            const gchar* id)
{
	gchar* _tmp0_ = NULL;
	gchar* result;
	g_return_val_if_fail (ACCOUNTS_IS_MANAGER (self), NULL);
	g_return_val_if_fail (id != NULL, NULL);
	if (g_str_has_prefix (id, ACCOUNTS_MANAGER_GOA_ID_PREFIX)) {
		gint _tmp1_;
		gint _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = strlen (ACCOUNTS_MANAGER_GOA_ID_PREFIX);
		_tmp2_ = _tmp1_;
		_tmp3_ = string_substring (id, (glong) _tmp2_, (glong) -1);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (id);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

static gboolean
accounts_manager_is_valid_goa_account (AccountsManager* self,
                                       GoaObject* handle)
{
	GoaMail* mail = NULL;
	GoaMail* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GoaMail* _tmp4_;
	gboolean result;
	g_return_val_if_fail (ACCOUNTS_IS_MANAGER (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (handle, goa_object_get_type ()), FALSE);
	_tmp0_ = goa_object_get_mail (handle);
	mail = _tmp0_;
	_tmp4_ = mail;
	if (_tmp4_ != NULL) {
		GoaAccount* _tmp5_;
		GoaAccount* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = goa_object_get_account (handle);
		_tmp6_ = _tmp5_;
		g_object_get (_tmp6_, "mail-disabled", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		_tmp3_ = !_tmp8_;
		_g_object_unref0 (_tmp6_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GoaMail* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp9_ = mail;
		g_object_get (_tmp9_, "imap-host", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp2_ = !geary_string_is_empty (_tmp12_);
		_g_free0 (_tmp12_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GoaMail* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp13_ = mail;
		g_object_get (_tmp13_, "smtp-host", &_tmp14_, NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp1_ = !geary_string_is_empty (_tmp16_);
		_g_free0 (_tmp16_);
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_g_object_unref0 (mail);
	return result;
}

static void
accounts_manager_create_goa_account_data_free (gpointer _data)
{
	AccountsManagerCreateGoaAccountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountsManagerCreateGoaAccountData, _data_);
}

static void
accounts_manager_create_goa_account (AccountsManager* self,
                                     GoaObject* account,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	AccountsManagerCreateGoaAccountData* _data_;
	AccountsManager* _tmp0_;
	GoaObject* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, goa_object_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (AccountsManagerCreateGoaAccountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, accounts_manager_create_goa_account_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (account);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	accounts_manager_create_goa_account_co (_data_);
}

static void
accounts_manager_create_goa_account_finish (AccountsManager* self,
                                            GAsyncResult* _res_)
{
	AccountsManagerCreateGoaAccountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

static void
accounts_manager_create_goa_account_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	AccountsManagerCreateGoaAccountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	accounts_manager_create_goa_account_co (_data_);
}

static gboolean
accounts_manager_create_goa_account_co (AccountsManagerCreateGoaAccountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (accounts_manager_is_valid_goa_account (_data_->self, _data_->account)) {
		_data_->_tmp0_ = goa_object_get_mail (_data_->account);
		_data_->mail = _data_->_tmp0_;
		_data_->_tmp1_ = _data_->mail;
		g_object_get (_data_->_tmp1_, "name", &_data_->_tmp2_, NULL);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->name = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->name;
		if (geary_string_is_empty_or_whitespace (_data_->_tmp4_)) {
			_data_->_tmp5_ = accounts_manager_get_account_name (_data_->self);
			_g_free0 (_data_->name);
			_data_->name = _data_->_tmp5_;
		}
		_data_->_tmp6_ = goa_mediator_new (_data_->account);
		_data_->mediator = _data_->_tmp6_;
		_data_->_tmp7_ = accounts_manager_to_geary_id (_data_->self, _data_->account);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = _data_->mediator;
		_data_->_tmp10_ = _data_->mediator;
		_data_->_tmp11_ = _data_->name;
		_data_->_tmp12_ = _data_->mail;
		g_object_get (_data_->_tmp12_, "email-address", &_data_->_tmp13_, NULL);
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp16_ = geary_rf_c822_mailbox_address_new (_data_->_tmp11_, _data_->_tmp15_);
		_data_->_tmp17_ = _data_->_tmp16_;
		_data_->_tmp18_ = geary_account_information_new (_data_->_tmp8_, goa_mediator_get_service_provider (_data_->_tmp9_), G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp10_, GEARY_TYPE_CREDENTIALS_MEDIATOR, GearyCredentialsMediator), _data_->_tmp17_);
		_data_->_tmp19_ = _data_->_tmp18_;
		_g_object_unref0 (_data_->_tmp17_);
		_g_free0 (_data_->_tmp15_);
		_g_free0 (_data_->_tmp8_);
		_data_->info = _data_->_tmp19_;
		_data_->_tmp20_ = _data_->info;
		_data_->_tmp21_ = geary_account_information_next_ordinal;
		geary_account_information_next_ordinal = _data_->_tmp21_ + 1;
		geary_account_information_set_ordinal (_data_->_tmp20_, _data_->_tmp21_);
		_data_->_tmp22_ = _data_->info;
		_data_->_tmp23_ = _data_->mediator;
		_data_->_tmp24_ = goa_mediator_get_service_label (_data_->_tmp23_);
		_data_->_tmp25_ = _data_->_tmp24_;
		geary_account_information_set_service_label (_data_->_tmp22_, _data_->_tmp25_);
		_g_free0 (_data_->_tmp25_);
		_data_->_tmp26_ = _data_->info;
		_data_->_tmp27_ = goa_object_get_account (_data_->account);
		_data_->_tmp28_ = _data_->_tmp27_;
		g_object_get (_data_->_tmp28_, "presentation-identity", &_data_->_tmp29_, NULL);
		_data_->_tmp30_ = _data_->_tmp29_;
		_data_->_tmp31_ = _data_->_tmp30_;
		geary_account_information_set_label (_data_->_tmp26_, _data_->_tmp31_);
		_g_free0 (_data_->_tmp31_);
		_g_object_unref0 (_data_->_tmp28_);
		{
			_data_->_tmp32_ = _data_->info;
			_data_->_state_ = 1;
			accounts_manager_create_account_dirs (_data_->self, _data_->_tmp32_, _data_->cancellable, accounts_manager_create_goa_account_ready, _data_);
			return FALSE;
			_state_1:
			accounts_manager_create_account_dirs_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp33_ = _data_->info;
			_data_->_state_ = 2;
			accounts_manager_save_account (_data_->self, _data_->_tmp33_, _data_->cancellable, accounts_manager_create_goa_account_ready, _data_);
			return FALSE;
			_state_2:
			accounts_manager_save_account_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp34_ = _data_->mediator;
			_data_->_tmp35_ = _data_->info;
			_data_->_state_ = 3;
			goa_mediator_update (_data_->_tmp34_, _data_->_tmp35_, _data_->cancellable, accounts_manager_create_goa_account_ready, _data_);
			return FALSE;
			_state_3:
			goa_mediator_update_finish (_data_->_tmp34_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp36_ = _data_->err;
			_data_->_tmp37_ = geary_problem_report_new (_data_->_tmp36_);
			_data_->_tmp38_ = _data_->_tmp37_;
			g_signal_emit (_data_->self, accounts_manager_signals[ACCOUNTS_MANAGER_REPORT_PROBLEM_SIGNAL], 0, _data_->_tmp38_);
			_g_object_unref0 (_data_->_tmp38_);
			_g_error_free0 (_data_->err);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->info);
			_g_object_unref0 (_data_->mediator);
			_g_free0 (_data_->name);
			_g_object_unref0 (_data_->mail);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp39_ = _data_->info;
		accounts_manager_set_enabled (_data_->self, _data_->_tmp39_, TRUE);
		_g_object_unref0 (_data_->info);
		_g_object_unref0 (_data_->mediator);
		_g_free0 (_data_->name);
		_g_object_unref0 (_data_->mail);
	} else {
		_data_->_tmp40_ = goa_object_get_account (_data_->account);
		_data_->_tmp41_ = _data_->_tmp40_;
		g_object_get (_data_->_tmp41_, "provider-type", &_data_->_tmp42_, NULL);
		_data_->_tmp43_ = _data_->_tmp42_;
		_data_->_tmp44_ = _data_->_tmp43_;
		_data_->_tmp45_ = goa_object_get_account (_data_->account);
		_data_->_tmp46_ = _data_->_tmp45_;
		g_object_get (_data_->_tmp46_, "id", &_data_->_tmp47_, NULL);
		_data_->_tmp48_ = _data_->_tmp47_;
		_data_->_tmp49_ = _data_->_tmp48_;
		g_debug ("accounts-manager.vala:823: Ignoring GOA %s account %s, mail service no" \
"t enabled", _data_->_tmp44_, _data_->_tmp49_);
		_g_free0 (_data_->_tmp49_);
		_g_object_unref0 (_data_->_tmp46_);
		_g_free0 (_data_->_tmp44_);
		_g_object_unref0 (_data_->_tmp41_);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
accounts_manager_update_goa_account_data_free (gpointer _data)
{
	AccountsManagerUpdateGoaAccountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountsManagerUpdateGoaAccountData, _data_);
}

static void
accounts_manager_update_goa_account (AccountsManager* self,
                                     GearyAccountInformation* account,
                                     gboolean is_available,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	AccountsManagerUpdateGoaAccountData* _data_;
	AccountsManager* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (AccountsManagerUpdateGoaAccountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, accounts_manager_update_goa_account_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (account);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_data_->is_available = is_available;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	accounts_manager_update_goa_account_co (_data_);
}

static void
accounts_manager_update_goa_account_finish (AccountsManager* self,
                                            GAsyncResult* _res_)
{
	AccountsManagerUpdateGoaAccountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

static void
accounts_manager_update_goa_account_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	AccountsManagerUpdateGoaAccountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	accounts_manager_update_goa_account_co (_data_);
}

static gboolean
accounts_manager_update_goa_account_co (AccountsManagerUpdateGoaAccountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_account_information_get_mediator (_data_->account);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TYPE_GOA_MEDIATOR, GoaMediator));
	_data_->mediator = _data_->_tmp2_;
	{
		_data_->_tmp3_ = _data_->mediator;
		_data_->_state_ = 1;
		goa_mediator_update (_data_->_tmp3_, _data_->account, _data_->cancellable, accounts_manager_update_goa_account_ready, _data_);
		return FALSE;
		_state_1:
		goa_mediator_update_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_data_->is_available) {
			_data_->_state_ = 2;
			geary_account_information_load_outgoing_credentials (_data_->account, _data_->cancellable, accounts_manager_update_goa_account_ready, _data_);
			return FALSE;
			_state_2:
			geary_account_information_load_outgoing_credentials_finish (_data_->account, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_state_ = 3;
			geary_account_information_load_incoming_credentials (_data_->account, _data_->cancellable, accounts_manager_update_goa_account_ready, _data_);
			return FALSE;
			_state_3:
			geary_account_information_load_incoming_credentials_finish (_data_->account, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp4_ = _data_->err;
		_data_->_tmp5_ = geary_account_problem_report_new (_data_->account, _data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		g_signal_emit (_data_->self, accounts_manager_signals[ACCOUNTS_MANAGER_REPORT_PROBLEM_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, GEARY_TYPE_PROBLEM_REPORT, GearyProblemReport));
		_g_object_unref0 (_data_->_tmp6_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->mediator);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	accounts_manager_set_available (_data_->self, _data_->account, _data_->is_available);
	_g_object_unref0 (_data_->mediator);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
accounts_manager_open_goa_settings_data_free (gpointer _data)
{
	AccountsManagerOpenGoaSettingsData* _data_;
	_data_ = _data;
	_g_free0 (_data_->action);
	_g_free0 (_data_->param);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountsManagerOpenGoaSettingsData, _data_);
}

static void
accounts_manager_open_goa_settings (AccountsManager* self,
                                    const gchar* action,
                                    const gchar* param,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	AccountsManagerOpenGoaSettingsData* _data_;
	AccountsManager* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail (action != NULL);
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (AccountsManagerOpenGoaSettingsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, accounts_manager_open_goa_settings_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (action);
	_g_free0 (_data_->action);
	_data_->action = _tmp1_;
	_tmp2_ = g_strdup (param);
	_g_free0 (_data_->param);
	_data_->param = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	accounts_manager_open_goa_settings_co (_data_);
}

static void
accounts_manager_open_goa_settings_finish (AccountsManager* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	AccountsManagerOpenGoaSettingsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
accounts_manager_open_goa_settings_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	AccountsManagerOpenGoaSettingsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	accounts_manager_open_goa_settings_co (_data_);
}

static void
_vala_array_add13 (GVariant** * array,
                   gint* length,
                   gint* size,
                   GVariant* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GVariant*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
accounts_manager_open_goa_settings_co (AccountsManagerOpenGoaSettingsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	g_dbus_proxy_new_for_bus (G_BUS_TYPE_SESSION, G_DBUS_PROXY_FLAGS_NONE, NULL, "org.gnome.Settings", "/org/gnome/Settings", "org.gtk.Actions", _data_->cancellable, accounts_manager_open_goa_settings_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = g_dbus_proxy_new_for_bus_finish (_data_->_res_, &_data_->_inner_error0_);
	_data_->settings = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = g_variant_new_string (_data_->action);
	g_variant_ref_sink (_data_->_tmp1_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = g_variant_new_variant (_data_->_tmp2_);
	g_variant_ref_sink (_data_->_tmp3_);
	_data_->_tmp4_ = g_new0 (GVariant*, 1 + 1);
	_data_->_tmp4_[0] = _data_->_tmp3_;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp5__length1 = 1;
	_g_variant_unref0 (_data_->_tmp2_);
	_data_->args = _data_->_tmp5_;
	_data_->args_length1 = _data_->_tmp5__length1;
	_data_->_args_size_ = _data_->args_length1;
	if (_data_->param != NULL) {
		_data_->_tmp6_ = g_variant_new_string (_data_->param);
		g_variant_ref_sink (_data_->_tmp6_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = g_variant_new_variant (_data_->_tmp7_);
		g_variant_ref_sink (_data_->_tmp8_);
		_vala_array_add13 (&_data_->args, &_data_->args_length1, &_data_->_args_size_, _data_->_tmp8_);
		_g_variant_unref0 (_data_->_tmp7_);
	}
	_data_->_tmp9_ = g_variant_new_string ("online-accounts");
	g_variant_ref_sink (_data_->_tmp9_);
	_data_->_tmp10_ = G_VARIANT_TYPE_VARIANT;
	_data_->_tmp11_ = _data_->args;
	_data_->_tmp11__length1 = _data_->args_length1;
	_data_->_tmp12_ = g_variant_new_array (_data_->_tmp10_, _data_->_tmp11_, _data_->_tmp11__length1);
	g_variant_ref_sink (_data_->_tmp12_);
	_data_->_tmp13_ = g_new0 (GVariant*, 2 + 1);
	_data_->_tmp13_[0] = _data_->_tmp9_;
	_data_->_tmp13_[1] = _data_->_tmp12_;
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->_tmp14__length1 = 2;
	_data_->_tmp15_ = g_variant_new_tuple (_data_->_tmp14_, 2);
	g_variant_ref_sink (_data_->_tmp15_);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp14_ = (_vala_array_free (_data_->_tmp14_, _data_->_tmp14__length1, (GDestroyNotify) g_variant_unref), NULL);
	_data_->command = _data_->_tmp16_;
	_data_->_tmp17_ = g_variant_new_string ("launch-panel");
	g_variant_ref_sink (_data_->_tmp17_);
	_data_->_tmp18_ = G_VARIANT_TYPE_VARIANT;
	_data_->_tmp19_ = _data_->command;
	_data_->_tmp20_ = g_variant_new_variant (_data_->_tmp19_);
	g_variant_ref_sink (_data_->_tmp20_);
	_data_->_tmp21_ = g_new0 (GVariant*, 1 + 1);
	_data_->_tmp21_[0] = _data_->_tmp20_;
	_data_->_tmp22_ = _data_->_tmp21_;
	_data_->_tmp22__length1 = 1;
	_data_->_tmp23_ = g_variant_new_array (_data_->_tmp18_, _data_->_tmp22_, 1);
	g_variant_ref_sink (_data_->_tmp23_);
	_data_->_tmp24_ = g_variant_new ("a{sv}", NULL);
	g_variant_ref_sink (_data_->_tmp24_);
	_data_->_tmp25_ = g_new0 (GVariant*, 3 + 1);
	_data_->_tmp25_[0] = _data_->_tmp17_;
	_data_->_tmp25_[1] = _data_->_tmp23_;
	_data_->_tmp25_[2] = _data_->_tmp24_;
	_data_->_tmp26_ = _data_->_tmp25_;
	_data_->_tmp26__length1 = 3;
	_data_->_tmp27_ = g_variant_new_tuple (_data_->_tmp26_, 3);
	g_variant_ref_sink (_data_->_tmp27_);
	_data_->_tmp28_ = _data_->_tmp27_;
	_data_->_tmp26_ = (_vala_array_free (_data_->_tmp26_, _data_->_tmp26__length1, (GDestroyNotify) g_variant_unref), NULL);
	_data_->_tmp22_ = (_vala_array_free (_data_->_tmp22_, _data_->_tmp22__length1, (GDestroyNotify) g_variant_unref), NULL);
	_data_->params = _data_->_tmp28_;
	_data_->_tmp29_ = _data_->settings;
	_data_->_tmp30_ = _data_->params;
	_data_->_state_ = 2;
	g_dbus_proxy_call (_data_->_tmp29_, "Activate", _data_->_tmp30_, G_DBUS_CALL_FLAGS_NONE, -1, _data_->cancellable, accounts_manager_open_goa_settings_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp31_ = g_dbus_proxy_call_finish (_data_->_tmp29_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp32_ = _data_->_tmp31_;
	_g_variant_unref0 (_data_->_tmp32_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_variant_unref0 (_data_->params);
		_g_variant_unref0 (_data_->command);
		_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_variant_unref), NULL);
		_g_object_unref0 (_data_->settings);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_variant_unref0 (_data_->params);
	_g_variant_unref0 (_data_->command);
	_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_variant_unref), NULL);
	_g_object_unref0 (_data_->settings);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
accounts_manager_on_goa_account_added (AccountsManager* self,
                                       GoaObject* account)
{
	GoaAccount* _tmp0_;
	GoaAccount* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, goa_object_get_type ()));
	_tmp0_ = goa_object_get_account (account);
	_tmp1_ = _tmp0_;
	g_object_get (_tmp1_, "id", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	g_debug ("accounts-manager.vala:906: GOA account added: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp1_);
	accounts_manager_create_goa_account (self, account, NULL, NULL, NULL);
}

static void
accounts_manager_on_goa_account_changed (AccountsManager* self,
                                         GoaObject* account)
{
	GoaAccount* _tmp0_;
	GoaAccount* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	AccountsManagerAccountState* state = NULL;
	GeeMap* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gpointer _tmp8_;
	AccountsManagerAccountState* _tmp9_;
	AccountsManagerAccountState* _tmp10_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, goa_object_get_type ()));
	_tmp0_ = goa_object_get_account (account);
	_tmp1_ = _tmp0_;
	g_object_get (_tmp1_, "id", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	g_debug ("accounts-manager.vala:912: GOA account changed: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp1_);
	_tmp5_ = self->priv->accounts;
	_tmp6_ = accounts_manager_to_geary_id (self, account);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_map_get (_tmp5_, _tmp7_);
	_tmp9_ = (AccountsManagerAccountState*) _tmp8_;
	_g_free0 (_tmp7_);
	state = _tmp9_;
	_tmp10_ = state;
	if (_tmp10_ != NULL) {
		AccountsManagerAccountState* _tmp11_;
		GearyAccountInformation* _tmp12_;
		GearyAccountInformation* _tmp13_;
		_tmp11_ = state;
		_tmp12_ = accounts_manager_account_state_get_account (_tmp11_);
		_tmp13_ = _tmp12_;
		accounts_manager_update_goa_account (self, _tmp13_, accounts_manager_is_valid_goa_account (self, account), NULL, NULL, NULL);
	} else {
		accounts_manager_create_goa_account (self, account, NULL, NULL, NULL);
	}
	_accounts_manager_account_state_unref0 (state);
}

static void
accounts_manager_on_goa_account_removed (AccountsManager* self,
                                         GoaObject* account)
{
	GoaAccount* _tmp0_;
	GoaAccount* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	AccountsManagerAccountState* state = NULL;
	GeeMap* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gpointer _tmp8_;
	AccountsManagerAccountState* _tmp9_;
	AccountsManagerAccountState* _tmp10_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, goa_object_get_type ()));
	_tmp0_ = goa_object_get_account (account);
	_tmp1_ = _tmp0_;
	g_object_get (_tmp1_, "id", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	g_debug ("accounts-manager.vala:934: GOA account removed: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp1_);
	_tmp5_ = self->priv->accounts;
	_tmp6_ = accounts_manager_to_geary_id (self, account);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_map_get (_tmp5_, _tmp7_);
	_tmp9_ = (AccountsManagerAccountState*) _tmp8_;
	_g_free0 (_tmp7_);
	state = _tmp9_;
	_tmp10_ = state;
	if (_tmp10_ != NULL) {
		AccountsManagerAccountState* _tmp11_;
		GearyAccountInformation* _tmp12_;
		GearyAccountInformation* _tmp13_;
		_tmp11_ = state;
		_tmp12_ = accounts_manager_account_state_get_account (_tmp11_);
		_tmp13_ = _tmp12_;
		accounts_manager_set_available (self, _tmp13_, FALSE);
	}
	_accounts_manager_account_state_unref0 (state);
}

static Block49Data*
block49_data_ref (Block49Data* _data49_)
{
	g_atomic_int_inc (&_data49_->_ref_count_);
	return _data49_;
}

static void
block49_data_unref (void * _userdata_)
{
	Block49Data* _data49_;
	_data49_ = (Block49Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data49_->_ref_count_)) {
		AccountsManager* self;
		self = _data49_->self;
		_g_object_unref0 (_data49_->account);
		_g_object_unref0 (self);
		g_slice_free (Block49Data, _data49_);
	}
}

static void
__lambda51_ (Block49Data* _data49_,
             GObject* obj,
             GAsyncResult* res)
{
	AccountsManager* self;
	GError* _inner_error0_ = NULL;
	self = _data49_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	{
		accounts_manager_save_account_finish (self, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp0_;
		GearyAccountProblemReport* _tmp1_;
		GearyAccountProblemReport* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = err;
		_tmp1_ = geary_account_problem_report_new (_data49_->account, _tmp0_);
		_tmp2_ = _tmp1_;
		g_signal_emit (self, accounts_manager_signals[ACCOUNTS_MANAGER_REPORT_PROBLEM_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_TYPE_PROBLEM_REPORT, GearyProblemReport));
		_g_object_unref0 (_tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda51__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda51_ (self, source_object, res);
	block49_data_unref (self);
}

static void
accounts_manager_on_account_changed (AccountsManager* self,
                                     GearyAccountInformation* account)
{
	Block49Data* _data49_;
	GearyAccountInformation* _tmp0_;
	g_return_if_fail (ACCOUNTS_IS_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION));
	_data49_ = g_slice_new0 (Block49Data);
	_data49_->_ref_count_ = 1;
	_data49_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (account);
	_g_object_unref0 (_data49_->account);
	_data49_->account = _tmp0_;
	accounts_manager_save_account (self, _data49_->account, NULL, ___lambda51__gasync_ready_callback, block49_data_ref (_data49_));
	block49_data_unref (_data49_);
	_data49_ = NULL;
}

static inline gpointer
accounts_manager_account_state_get_instance_private (AccountsManagerAccountState* self)
{
	return G_STRUCT_MEMBER_P (self, AccountsManagerAccountState_private_offset);
}

static GearyAccountInformation*
accounts_manager_account_state_get_account (AccountsManagerAccountState* self)
{
	GearyAccountInformation* result;
	GearyAccountInformation* _tmp0_;
	g_return_val_if_fail (ACCOUNTS_MANAGER_IS_ACCOUNT_STATE (self), NULL);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}

static void
accounts_manager_account_state_set_account (AccountsManagerAccountState* self,
                                            GearyAccountInformation* value)
{
	GearyAccountInformation* _tmp0_;
	g_return_if_fail (ACCOUNTS_MANAGER_IS_ACCOUNT_STATE (self));
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_account);
	self->priv->_account = _tmp0_;
}

static AccountsManagerStatus
accounts_manager_account_state_get_status (AccountsManagerAccountState* self)
{
	AccountsManagerStatus result;
	AccountsManagerStatus status = 0;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (ACCOUNTS_MANAGER_IS_ACCOUNT_STATE (self), 0);
	status = ACCOUNTS_MANAGER_STATUS_ENABLED;
	_tmp0_ = self->priv->_enabled;
	if (!_tmp0_) {
		status = ACCOUNTS_MANAGER_STATUS_DISABLED;
	}
	_tmp1_ = self->priv->_available;
	if (!_tmp1_) {
		status = ACCOUNTS_MANAGER_STATUS_UNAVAILABLE;
	}
	result = status;
	return result;
}

static gboolean
accounts_manager_account_state_get_enabled (AccountsManagerAccountState* self)
{
	gboolean result;
	g_return_val_if_fail (ACCOUNTS_MANAGER_IS_ACCOUNT_STATE (self), FALSE);
	result = self->priv->_enabled;
	return result;
}

static void
accounts_manager_account_state_set_enabled (AccountsManagerAccountState* self,
                                            gboolean value)
{
	g_return_if_fail (ACCOUNTS_MANAGER_IS_ACCOUNT_STATE (self));
	self->priv->_enabled = value;
}

static gboolean
accounts_manager_account_state_get_available (AccountsManagerAccountState* self)
{
	gboolean result;
	g_return_val_if_fail (ACCOUNTS_MANAGER_IS_ACCOUNT_STATE (self), FALSE);
	result = self->priv->_available;
	return result;
}

static void
accounts_manager_account_state_set_available (AccountsManagerAccountState* self,
                                              gboolean value)
{
	g_return_if_fail (ACCOUNTS_MANAGER_IS_ACCOUNT_STATE (self));
	self->priv->_available = value;
}

static AccountsManagerAccountState*
accounts_manager_account_state_construct (GType object_type,
                                          GearyAccountInformation* account)
{
	AccountsManagerAccountState* self = NULL;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION), NULL);
	self = (AccountsManagerAccountState*) g_type_create_instance (object_type);
	accounts_manager_account_state_set_account (self, account);
	return self;
}

static AccountsManagerAccountState*
accounts_manager_account_state_new (GearyAccountInformation* account)
{
	return accounts_manager_account_state_construct (ACCOUNTS_MANAGER_TYPE_ACCOUNT_STATE, account);
}

static void
accounts_manager_value_account_state_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
accounts_manager_value_account_state_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		accounts_manager_account_state_unref (value->data[0].v_pointer);
	}
}

static void
accounts_manager_value_account_state_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = accounts_manager_account_state_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
accounts_manager_value_account_state_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
accounts_manager_value_account_state_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		AccountsManagerAccountState * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = accounts_manager_account_state_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
accounts_manager_value_account_state_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	AccountsManagerAccountState ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = accounts_manager_account_state_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
accounts_manager_param_spec_account_state (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	AccountsManagerParamSpecAccountState* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ACCOUNTS_MANAGER_TYPE_ACCOUNT_STATE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
accounts_manager_value_get_account_state (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ACCOUNTS_MANAGER_TYPE_ACCOUNT_STATE), NULL);
	return value->data[0].v_pointer;
}

static void
accounts_manager_value_set_account_state (GValue* value,
                                          gpointer v_object)
{
	AccountsManagerAccountState * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ACCOUNTS_MANAGER_TYPE_ACCOUNT_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ACCOUNTS_MANAGER_TYPE_ACCOUNT_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		accounts_manager_account_state_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		accounts_manager_account_state_unref (old);
	}
}

static void
accounts_manager_value_take_account_state (GValue* value,
                                           gpointer v_object)
{
	AccountsManagerAccountState * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ACCOUNTS_MANAGER_TYPE_ACCOUNT_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ACCOUNTS_MANAGER_TYPE_ACCOUNT_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		accounts_manager_account_state_unref (old);
	}
}

static void
accounts_manager_account_state_class_init (AccountsManagerAccountStateClass * klass,
                                           gpointer klass_data)
{
	accounts_manager_account_state_parent_class = g_type_class_peek_parent (klass);
	((AccountsManagerAccountStateClass *) klass)->finalize = accounts_manager_account_state_finalize;
	g_type_class_adjust_private_offset (klass, &AccountsManagerAccountState_private_offset);
}

static void
accounts_manager_account_state_instance_init (AccountsManagerAccountState * self,
                                              gpointer klass)
{
	self->priv = accounts_manager_account_state_get_instance_private (self);
	self->priv->_enabled = TRUE;
	self->priv->_available = TRUE;
	self->ref_count = 1;
}

static void
accounts_manager_account_state_finalize (AccountsManagerAccountState * obj)
{
	AccountsManagerAccountState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ACCOUNTS_MANAGER_TYPE_ACCOUNT_STATE, AccountsManagerAccountState);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->_account);
}

/** Specifies an account's current state. */
static GType
accounts_manager_account_state_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { accounts_manager_value_account_state_init, accounts_manager_value_account_state_free_value, accounts_manager_value_account_state_copy_value, accounts_manager_value_account_state_peek_pointer, "p", accounts_manager_value_account_state_collect_value, "p", accounts_manager_value_account_state_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (AccountsManagerAccountStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) accounts_manager_account_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AccountsManagerAccountState), 0, (GInstanceInitFunc) accounts_manager_account_state_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType accounts_manager_account_state_type_id;
	accounts_manager_account_state_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AccountsManagerAccountState", &g_define_type_info, &g_define_type_fundamental_info, 0);
	AccountsManagerAccountState_private_offset = g_type_add_instance_private (accounts_manager_account_state_type_id, sizeof (AccountsManagerAccountStatePrivate));
	return accounts_manager_account_state_type_id;
}

static GType
accounts_manager_account_state_get_type (void)
{
	static volatile gsize accounts_manager_account_state_type_id__once = 0;
	if (g_once_init_enter (&accounts_manager_account_state_type_id__once)) {
		GType accounts_manager_account_state_type_id;
		accounts_manager_account_state_type_id = accounts_manager_account_state_get_type_once ();
		g_once_init_leave (&accounts_manager_account_state_type_id__once, accounts_manager_account_state_type_id);
	}
	return accounts_manager_account_state_type_id__once;
}

static gpointer
accounts_manager_account_state_ref (gpointer instance)
{
	AccountsManagerAccountState * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
accounts_manager_account_state_unref (gpointer instance)
{
	AccountsManagerAccountState * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ACCOUNTS_MANAGER_ACCOUNT_STATE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
accounts_manager_class_init (AccountsManagerClass * klass,
                             gpointer klass_data)
{
	accounts_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AccountsManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_accounts_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_accounts_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = accounts_manager_finalize;
	/** Returns the number of currently known accounts. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNTS_MANAGER_SIZE_PROPERTY, accounts_manager_properties[ACCOUNTS_MANAGER_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Returns the base directory for account configuration. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNTS_MANAGER_CONFIG_DIR_PROPERTY, accounts_manager_properties[ACCOUNTS_MANAGER_CONFIG_DIR_PROPERTY] = g_param_spec_object ("config-dir", "config-dir", "config-dir", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Returns the base directory for account data. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNTS_MANAGER_DATA_DIR_PROPERTY, accounts_manager_properties[ACCOUNTS_MANAGER_DATA_DIR_PROPERTY] = g_param_spec_object ("data-dir", "data-dir", "data-dir", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Fired when a new account is created. */
	accounts_manager_signals[ACCOUNTS_MANAGER_ACCOUNT_ADDED_SIGNAL] = g_signal_new ("account-added", ACCOUNTS_TYPE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_ENUM, G_TYPE_NONE, 2, GEARY_TYPE_ACCOUNT_INFORMATION, ACCOUNTS_MANAGER_TYPE_STATUS);
	/** Fired when an existing account's state has changed. */
	accounts_manager_signals[ACCOUNTS_MANAGER_ACCOUNT_STATUS_CHANGED_SIGNAL] = g_signal_new ("account-status-changed", ACCOUNTS_TYPE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_ENUM, G_TYPE_NONE, 2, GEARY_TYPE_ACCOUNT_INFORMATION, ACCOUNTS_MANAGER_TYPE_STATUS);
	/** Fired when an account is deleted. */
	accounts_manager_signals[ACCOUNTS_MANAGER_ACCOUNT_REMOVED_SIGNAL] = g_signal_new ("account-removed", ACCOUNTS_TYPE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_TYPE_ACCOUNT_INFORMATION);
	/** Emitted to notify an account problem has occurred. */
	accounts_manager_signals[ACCOUNTS_MANAGER_REPORT_PROBLEM_SIGNAL] = g_signal_new ("report-problem", ACCOUNTS_TYPE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_TYPE_PROBLEM_REPORT);
}

static void
accounts_manager_instance_init (AccountsManager * self,
                                gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeLinkedList* _tmp1_;
	self->priv = accounts_manager_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, ACCOUNTS_MANAGER_TYPE_ACCOUNT_STATE, (GBoxedCopyFunc) accounts_manager_account_state_ref, (GDestroyNotify) accounts_manager_account_state_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->accounts = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap);
	_tmp1_ = gee_linked_list_new (GEARY_TYPE_ACCOUNT_INFORMATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->removed = _tmp1_;
	self->priv->goa_service = NULL;
}

static void
accounts_manager_finalize (GObject * obj)
{
	AccountsManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ACCOUNTS_TYPE_MANAGER, AccountsManager);
	_g_object_unref0 (self->priv->_config_dir);
	_g_object_unref0 (self->priv->_data_dir);
	_g_object_unref0 (self->priv->accounts);
	_g_object_unref0 (self->priv->removed);
	_g_object_unref0 (self->priv->local_mediator);
	_g_object_unref0 (self->priv->goa_service);
	G_OBJECT_CLASS (accounts_manager_parent_class)->finalize (obj);
}

/**
 * Manages email account lifecycle for Geary.
 *
 * This class is responsible for creating, loading, saving and
 * removing accounts and their persisted data (configuration,
 * databases, caches, authentication tokens). The manager supports
 * both locally-specified accounts (i.e. those created by the user in
 * the app) and from SSO systems such as GOA via the Accounts.Provider
 * interface.
 *
 * Newly loaded and newly created accounts are first added to the
 * manager with a particular status (enabled, disabled, etc). Accounts
 * can have their enabled or disabled status updated manually,
 */
static GType
accounts_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AccountsManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) accounts_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AccountsManager), 0, (GInstanceInitFunc) accounts_manager_instance_init, NULL };
	GType accounts_manager_type_id;
	accounts_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "AccountsManager", &g_define_type_info, 0);
	AccountsManager_private_offset = g_type_add_instance_private (accounts_manager_type_id, sizeof (AccountsManagerPrivate));
	return accounts_manager_type_id;
}

GType
accounts_manager_get_type (void)
{
	static volatile gsize accounts_manager_type_id__once = 0;
	if (g_once_init_enter (&accounts_manager_type_id__once)) {
		GType accounts_manager_type_id;
		accounts_manager_type_id = accounts_manager_get_type_once ();
		g_once_init_leave (&accounts_manager_type_id__once, accounts_manager_type_id);
	}
	return accounts_manager_type_id__once;
}

static void
_vala_accounts_manager_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	AccountsManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ACCOUNTS_TYPE_MANAGER, AccountsManager);
	switch (property_id) {
		case ACCOUNTS_MANAGER_SIZE_PROPERTY:
		g_value_set_int (value, accounts_manager_get_size (self));
		break;
		case ACCOUNTS_MANAGER_CONFIG_DIR_PROPERTY:
		g_value_set_object (value, accounts_manager_get_config_dir (self));
		break;
		case ACCOUNTS_MANAGER_DATA_DIR_PROPERTY:
		g_value_set_object (value, accounts_manager_get_data_dir (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_accounts_manager_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	AccountsManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ACCOUNTS_TYPE_MANAGER, AccountsManager);
	switch (property_id) {
		case ACCOUNTS_MANAGER_CONFIG_DIR_PROPERTY:
		accounts_manager_set_config_dir (self, g_value_get_object (value));
		break;
		case ACCOUNTS_MANAGER_DATA_DIR_PROPERTY:
		accounts_manager_set_data_dir (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

/** Loads a supported account from a config file. */
GearyAccountInformation*
accounts_account_config_load (AccountsAccountConfig* self,
                              GearyConfigFile* config,
                              const gchar* id,
                              GearyCredentialsMediator* mediator,
                              GearyServiceProvider* default_provider,
                              const gchar* default_name,
                              GError** error)
{
	AccountsAccountConfigIface* _iface_;
	g_return_val_if_fail (ACCOUNTS_IS_ACCOUNT_CONFIG (self), NULL);
	_iface_ = ACCOUNTS_ACCOUNT_CONFIG_GET_INTERFACE (self);
	if (_iface_->load) {
		return _iface_->load (self, config, id, mediator, default_provider, default_name, error);
	}
	return NULL;
}

/** Saves an account to a config file. */
void
accounts_account_config_save (AccountsAccountConfig* self,
                              GearyAccountInformation* account,
                              GearyConfigFile* config)
{
	AccountsAccountConfigIface* _iface_;
	g_return_if_fail (ACCOUNTS_IS_ACCOUNT_CONFIG (self));
	_iface_ = ACCOUNTS_ACCOUNT_CONFIG_GET_INTERFACE (self);
	if (_iface_->save) {
		_iface_->save (self, account, config);
	}
}

static void
accounts_account_config_default_init (AccountsAccountConfigIface * iface,
                                      gpointer iface_data)
{
}

/** Objects that can be used to load/save account configuration. */
static GType
accounts_account_config_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AccountsAccountConfigIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) accounts_account_config_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType accounts_account_config_type_id;
	accounts_account_config_type_id = g_type_register_static (G_TYPE_INTERFACE, "AccountsAccountConfig", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (accounts_account_config_type_id, G_TYPE_OBJECT);
	return accounts_account_config_type_id;
}

GType
accounts_account_config_get_type (void)
{
	static volatile gsize accounts_account_config_type_id__once = 0;
	if (g_once_init_enter (&accounts_account_config_type_id__once)) {
		GType accounts_account_config_type_id;
		accounts_account_config_type_id = accounts_account_config_get_type_once ();
		g_once_init_leave (&accounts_account_config_type_id__once, accounts_account_config_type_id);
	}
	return accounts_account_config_type_id__once;
}

/** Loads a service from a config file. */
void
accounts_service_config_load (AccountsServiceConfig* self,
                              GearyConfigFile* config,
                              GearyAccountInformation* account,
                              GearyServiceInformation* service,
                              GError** error)
{
	AccountsServiceConfigIface* _iface_;
	g_return_if_fail (ACCOUNTS_IS_SERVICE_CONFIG (self));
	_iface_ = ACCOUNTS_SERVICE_CONFIG_GET_INTERFACE (self);
	if (_iface_->load) {
		_iface_->load (self, config, account, service, error);
	}
}

/** Saves a service to a config file. */
void
accounts_service_config_save (AccountsServiceConfig* self,
                              GearyAccountInformation* account,
                              GearyServiceInformation* service,
                              GearyConfigFile* config)
{
	AccountsServiceConfigIface* _iface_;
	g_return_if_fail (ACCOUNTS_IS_SERVICE_CONFIG (self));
	_iface_ = ACCOUNTS_SERVICE_CONFIG_GET_INTERFACE (self);
	if (_iface_->save) {
		_iface_->save (self, account, service, config);
	}
}

static void
accounts_service_config_default_init (AccountsServiceConfigIface * iface,
                                      gpointer iface_data)
{
}

/** Objects that can be used to load/save service configuration. */
static GType
accounts_service_config_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AccountsServiceConfigIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) accounts_service_config_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType accounts_service_config_type_id;
	accounts_service_config_type_id = g_type_register_static (G_TYPE_INTERFACE, "AccountsServiceConfig", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (accounts_service_config_type_id, G_TYPE_OBJECT);
	return accounts_service_config_type_id;
}

GType
accounts_service_config_get_type (void)
{
	static volatile gsize accounts_service_config_type_id__once = 0;
	if (g_once_init_enter (&accounts_service_config_type_id__once)) {
		GType accounts_service_config_type_id;
		accounts_service_config_type_id = accounts_service_config_get_type_once ();
		g_once_init_leave (&accounts_service_config_type_id__once, accounts_service_config_type_id);
	}
	return accounts_service_config_type_id__once;
}

GQuark
accounts_config_error_quark (void)
{
	return g_quark_from_static_string ("accounts-config-error-quark");
}

static GType
accounts_config_error_get_type_once (void)
{
	static const GEnumValue values[] = {{ACCOUNTS_CONFIG_ERROR_IO, "ACCOUNTS_CONFIG_ERROR_IO", "io"}, {ACCOUNTS_CONFIG_ERROR_MANAGEMENT, "ACCOUNTS_CONFIG_ERROR_MANAGEMENT", "management"}, {ACCOUNTS_CONFIG_ERROR_SYNTAX, "ACCOUNTS_CONFIG_ERROR_SYNTAX", "syntax"}, {ACCOUNTS_CONFIG_ERROR_VERSION, "ACCOUNTS_CONFIG_ERROR_VERSION", "version"}, {ACCOUNTS_CONFIG_ERROR_UNAVAILABLE, "ACCOUNTS_CONFIG_ERROR_UNAVAILABLE", "unavailable"}, {ACCOUNTS_CONFIG_ERROR_REMOVED, "ACCOUNTS_CONFIG_ERROR_REMOVED", "removed"}, {0, NULL, NULL}};
	GType accounts_config_error_type_id;
	accounts_config_error_type_id = g_enum_register_static ("AccountsConfigError", values);
	return accounts_config_error_type_id;
}

GType
accounts_config_error_get_type (void)
{
	static volatile gsize accounts_config_error_type_id__once = 0;
	if (g_once_init_enter (&accounts_config_error_type_id__once)) {
		GType accounts_config_error_type_id;
		accounts_config_error_type_id = accounts_config_error_get_type_once ();
		g_once_init_leave (&accounts_config_error_type_id__once, accounts_config_error_type_id);
	}
	return accounts_config_error_type_id__once;
}

static inline gpointer
accounts_account_config_v1_get_instance_private (AccountsAccountConfigV1* self)
{
	return G_STRUCT_MEMBER_P (self, AccountsAccountConfigV1_private_offset);
}

AccountsAccountConfigV1*
accounts_account_config_v1_construct (GType object_type,
                                      gboolean is_managed)
{
	AccountsAccountConfigV1 * self = NULL;
	self = (AccountsAccountConfigV1*) g_object_new (object_type, NULL);
	self->priv->is_managed = is_managed;
	return self;
}

AccountsAccountConfigV1*
accounts_account_config_v1_new (gboolean is_managed)
{
	return accounts_account_config_v1_construct (ACCOUNTS_TYPE_ACCOUNT_CONFIG_V1, is_managed);
}

static GearyServiceProvider
___lambda47_ (AccountsAccountConfigV1* self,
              const gchar* value,
              GError** error)
{
	GError* _inner_error0_ = NULL;
	GearyServiceProvider result;
	g_return_val_if_fail (value != NULL, 0);
	{
		GearyServiceProvider _tmp0_ = 0;
		_tmp0_ = geary_service_provider_for_value (value, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_ENGINE_ERROR) {
				goto __catch0_geary_engine_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_geary_engine_error:
	{
		GError* err = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		GError* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = err;
		_tmp2_ = _tmp1_->message;
		_tmp3_ = g_error_new_literal (G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_INVALID_VALUE, _tmp2_);
		_inner_error0_ = _tmp3_;
		_g_error_free0 (err);
		goto __finally0;
	}
	__finally0:
	if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
		g_propagate_error (error, _inner_error0_);
		return 0;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
}

static gpointer
____lambda47__geary_config_file_parser (const gchar* value,
                                        gpointer self,
                                        GError** error)
{
	gpointer result;
	result = (gpointer) ((gintptr) ___lambda47_ ((AccountsAccountConfigV1*) self, value, error));
	return result;
}

static GearyAccountInformation*
accounts_account_config_v1_real_load (AccountsAccountConfig* base,
                                      GearyConfigFile* config,
                                      const gchar* id,
                                      GearyCredentialsMediator* mediator,
                                      GearyServiceProvider* default_provider,
                                      const gchar* default_name,
                                      GError** error)
{
	AccountsAccountConfigV1 * self;
	GearyConfigFileGroup* account_config = NULL;
	GearyConfigFileGroup* _tmp0_;
	GeeList* senders = NULL;
	GeeLinkedList* _tmp1_;
	GeeList* _tmp2_ = NULL;
	GearyConfigFileGroup* _tmp3_;
	GeeList* _tmp4_;
	GeeList* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	GearyServiceProvider* _tmp22_ = NULL;
	GearyServiceProvider provider = 0;
	GearyAccountInformation* account = NULL;
	GeeList* _tmp28_;
	gpointer _tmp29_;
	GearyRFC822MailboxAddress* _tmp30_;
	GearyAccountInformation* _tmp31_;
	GearyAccountInformation* _tmp32_;
	GearyAccountInformation* _tmp33_;
	GearyConfigFileGroup* _tmp34_;
	gint _tmp35_;
	GearyAccountInformation* _tmp36_;
	GearyConfigFileGroup* _tmp37_;
	GearyAccountInformation* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	GearyAccountInformation* _tmp43_;
	GearyConfigFileGroup* _tmp44_;
	GearyAccountInformation* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	GearyAccountInformation* _tmp48_;
	GearyConfigFileGroup* _tmp49_;
	GearyAccountInformation* _tmp50_;
	gboolean _tmp51_;
	gboolean _tmp52_;
	GearyAccountInformation* _tmp53_;
	GearyConfigFileGroup* _tmp54_;
	GearyAccountInformation* _tmp55_;
	gboolean _tmp56_;
	gboolean _tmp57_;
	GearyAccountInformation* _tmp58_;
	GearyConfigFileGroup* _tmp59_;
	GearyAccountInformation* _tmp60_;
	gboolean _tmp61_;
	gboolean _tmp62_;
	GearyAccountInformation* _tmp63_;
	GearyConfigFileGroup* _tmp64_;
	GearyAccountInformation* _tmp65_;
	const gchar* _tmp66_;
	const gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	GearyConfigFileGroup* folder_config = NULL;
	GearyConfigFileGroup* _tmp80_;
	GearyAccountInformation* _tmp81_;
	GearyConfigFileGroup* _tmp82_;
	GeeList* _tmp83_;
	GeeList* _tmp84_;
	GearyAccountInformation* _tmp85_;
	GearyConfigFileGroup* _tmp86_;
	GeeList* _tmp87_;
	GeeList* _tmp88_;
	GearyAccountInformation* _tmp89_;
	GearyConfigFileGroup* _tmp90_;
	GeeList* _tmp91_;
	GeeList* _tmp92_;
	GearyConfigFileGroup* _tmp93_;
	GearyConfigFileGroup* _tmp98_;
	GearyAccountInformation* _tmp103_;
	GearyConfigFileGroup* _tmp104_;
	GeeList* _tmp105_;
	GeeList* _tmp106_;
	GError* _inner_error0_ = NULL;
	GearyAccountInformation* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, ACCOUNTS_TYPE_ACCOUNT_CONFIG_V1, AccountsAccountConfigV1);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (config, GEARY_TYPE_CONFIG_FILE), NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (mediator, GEARY_TYPE_CREDENTIALS_MEDIATOR), NULL);
	_tmp0_ = geary_config_file_get_group (config, ACCOUNTS_ACCOUNT_CONFIG_V1_GROUP_ACCOUNT);
	account_config = _tmp0_;
	_tmp1_ = gee_linked_list_new (GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	senders = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_LIST, GeeList);
	_tmp3_ = account_config;
	_tmp4_ = geary_config_file_group_get_required_string_list (_tmp3_, ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_SENDERS, &_inner_error0_);
	_tmp2_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == ACCOUNTS_CONFIG_ERROR) || (_inner_error0_->domain == G_KEY_FILE_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (senders);
			_geary_config_file_group_unref0 (account_config);
			return NULL;
		} else {
			_g_object_unref0 (senders);
			_geary_config_file_group_unref0 (account_config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	{
		GeeList* _sender_list = NULL;
		gint _sender_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _sender_index = 0;
		_sender_list = _tmp2_;
		_tmp5_ = _sender_list;
		_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp7_ = _tmp6_;
		_sender_size = _tmp7_;
		_sender_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gchar* sender = NULL;
			GeeList* _tmp10_;
			gpointer _tmp11_;
			_sender_index = _sender_index + 1;
			_tmp8_ = _sender_index;
			_tmp9_ = _sender_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _sender_list;
			_tmp11_ = gee_list_get (_tmp10_, _sender_index);
			sender = (gchar*) _tmp11_;
			{
				GearyRFC822MailboxAddress* _tmp12_ = NULL;
				const gchar* _tmp13_;
				GearyRFC822MailboxAddress* _tmp14_;
				GeeList* _tmp15_;
				_tmp13_ = sender;
				_tmp14_ = geary_rf_c822_mailbox_address_new_from_rfc822_string (_tmp13_, &_inner_error0_);
				_tmp12_ = _tmp14_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
						goto __catch0_geary_rf_c822_error;
					}
					_g_free0 (sender);
					_g_object_unref0 (_tmp2_);
					_g_object_unref0 (senders);
					_geary_config_file_group_unref0 (account_config);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp15_ = senders;
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection), _tmp12_);
				_g_object_unref0 (_tmp12_);
			}
			goto __finally0;
			__catch0_geary_rf_c822_error:
			{
				const gchar* _tmp16_;
				GError* _tmp17_;
				g_clear_error (&_inner_error0_);
				_tmp16_ = sender;
				_tmp17_ = g_error_new (ACCOUNTS_CONFIG_ERROR, ACCOUNTS_CONFIG_ERROR_SYNTAX, "%s: Invalid sender address: %s", id, _tmp16_);
				_inner_error0_ = _tmp17_;
				goto __finally0;
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if ((_inner_error0_->domain == ACCOUNTS_CONFIG_ERROR) || (_inner_error0_->domain == G_KEY_FILE_ERROR)) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (sender);
					_g_object_unref0 (_tmp2_);
					_g_object_unref0 (senders);
					_geary_config_file_group_unref0 (account_config);
					return NULL;
				} else {
					_g_free0 (sender);
					_g_object_unref0 (_tmp2_);
					_g_object_unref0 (senders);
					_geary_config_file_group_unref0 (account_config);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_g_free0 (sender);
		}
	}
	_tmp18_ = senders;
	_tmp19_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp20_ = _tmp19_;
	if (_tmp20_) {
		GError* _tmp21_;
		_tmp21_ = g_error_new (ACCOUNTS_CONFIG_ERROR, ACCOUNTS_CONFIG_ERROR_SYNTAX, "%s: No sender addresses found", id);
		_inner_error0_ = _tmp21_;
		if ((_inner_error0_->domain == ACCOUNTS_CONFIG_ERROR) || (_inner_error0_->domain == G_KEY_FILE_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp2_);
			_g_object_unref0 (senders);
			_geary_config_file_group_unref0 (account_config);
			return NULL;
		} else {
			_g_object_unref0 (_tmp2_);
			_g_object_unref0 (senders);
			_geary_config_file_group_unref0 (account_config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (default_provider != NULL) {
		GearyServiceProvider* _tmp23_;
		_tmp23_ = __geary_service_provider_dup0 (default_provider);
		_g_free0 (_tmp22_);
		_tmp22_ = _tmp23_;
	} else {
		GearyConfigFileGroup* _tmp24_;
		gpointer _tmp25_;
		GearyServiceProvider _tmp26_;
		GearyServiceProvider* _tmp27_;
		_tmp24_ = account_config;
		_tmp25_ = geary_config_file_group_parse_required_value (_tmp24_, GEARY_TYPE_SERVICE_PROVIDER, NULL, NULL, ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_PROVIDER, ____lambda47__geary_config_file_parser, self, &_inner_error0_);
		_tmp26_ = (GearyServiceProvider) ((gintptr) _tmp25_);
		_tmp27_ = __geary_service_provider_dup0 (&_tmp26_);
		_g_free0 (_tmp22_);
		_tmp22_ = _tmp27_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if ((_inner_error0_->domain == ACCOUNTS_CONFIG_ERROR) || (_inner_error0_->domain == G_KEY_FILE_ERROR)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (_tmp22_);
				_g_object_unref0 (_tmp2_);
				_g_object_unref0 (senders);
				_geary_config_file_group_unref0 (account_config);
				return NULL;
			} else {
				_g_free0 (_tmp22_);
				_g_object_unref0 (_tmp2_);
				_g_object_unref0 (senders);
				_geary_config_file_group_unref0 (account_config);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	provider = *_tmp22_;
	_tmp28_ = senders;
	_tmp29_ = gee_list_remove_at (_tmp28_, 0);
	_tmp30_ = (GearyRFC822MailboxAddress*) _tmp29_;
	_tmp31_ = geary_account_information_new (id, provider, mediator, _tmp30_);
	_tmp32_ = _tmp31_;
	_g_object_unref0 (_tmp30_);
	account = _tmp32_;
	_tmp33_ = account;
	_tmp34_ = account_config;
	_tmp35_ = geary_account_information_next_ordinal;
	geary_account_information_next_ordinal = _tmp35_ + 1;
	geary_account_information_set_ordinal (_tmp33_, geary_config_file_group_get_int (_tmp34_, ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_ORDINAL, _tmp35_));
	_tmp36_ = account;
	_tmp37_ = account_config;
	_tmp38_ = account;
	_tmp39_ = geary_account_information_get_label (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = geary_config_file_group_get_string (_tmp37_, ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_LABEL, _tmp40_);
	_tmp42_ = _tmp41_;
	geary_account_information_set_label (_tmp36_, _tmp42_);
	_g_free0 (_tmp42_);
	_tmp43_ = account;
	_tmp44_ = account_config;
	_tmp45_ = account;
	_tmp46_ = geary_account_information_get_prefetch_period_days (_tmp45_);
	_tmp47_ = _tmp46_;
	geary_account_information_set_prefetch_period_days (_tmp43_, geary_config_file_group_get_int (_tmp44_, ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_PREFETCH, _tmp47_));
	_tmp48_ = account;
	_tmp49_ = account_config;
	_tmp50_ = account;
	_tmp51_ = geary_account_information_get_save_drafts (_tmp50_);
	_tmp52_ = _tmp51_;
	geary_account_information_set_save_drafts (_tmp48_, geary_config_file_group_get_bool (_tmp49_, ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_SAVE_DRAFTS, _tmp52_));
	_tmp53_ = account;
	_tmp54_ = account_config;
	_tmp55_ = account;
	_tmp56_ = geary_account_information_get_save_sent (_tmp55_);
	_tmp57_ = _tmp56_;
	geary_account_information_set_save_sent (_tmp53_, geary_config_file_group_get_bool (_tmp54_, ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_SAVE_SENT, _tmp57_));
	_tmp58_ = account;
	_tmp59_ = account_config;
	_tmp60_ = account;
	_tmp61_ = geary_account_information_get_use_signature (_tmp60_);
	_tmp62_ = _tmp61_;
	geary_account_information_set_use_signature (_tmp58_, geary_config_file_group_get_bool (_tmp59_, ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_USE_SIG, _tmp62_));
	_tmp63_ = account;
	_tmp64_ = account_config;
	_tmp65_ = account;
	_tmp66_ = geary_account_information_get_signature (_tmp65_);
	_tmp67_ = _tmp66_;
	_tmp68_ = geary_config_file_group_get_string (_tmp64_, ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_SIG, _tmp67_);
	_tmp69_ = _tmp68_;
	geary_account_information_set_signature (_tmp63_, _tmp69_);
	_g_free0 (_tmp69_);
	{
		GeeList* _sender_list = NULL;
		GeeList* _tmp70_;
		gint _sender_size = 0;
		GeeList* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		gint _sender_index = 0;
		_tmp70_ = senders;
		_sender_list = _tmp70_;
		_tmp71_ = _sender_list;
		_tmp72_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp73_ = _tmp72_;
		_sender_size = _tmp73_;
		_sender_index = -1;
		while (TRUE) {
			gint _tmp74_;
			gint _tmp75_;
			GearyRFC822MailboxAddress* sender = NULL;
			GeeList* _tmp76_;
			gpointer _tmp77_;
			GearyAccountInformation* _tmp78_;
			GearyRFC822MailboxAddress* _tmp79_;
			_sender_index = _sender_index + 1;
			_tmp74_ = _sender_index;
			_tmp75_ = _sender_size;
			if (!(_tmp74_ < _tmp75_)) {
				break;
			}
			_tmp76_ = _sender_list;
			_tmp77_ = gee_list_get (_tmp76_, _sender_index);
			sender = (GearyRFC822MailboxAddress*) _tmp77_;
			_tmp78_ = account;
			_tmp79_ = sender;
			geary_account_information_append_sender (_tmp78_, _tmp79_);
			_g_object_unref0 (sender);
		}
	}
	_tmp80_ = geary_config_file_get_group (config, ACCOUNTS_ACCOUNT_CONFIG_V1_GROUP_FOLDERS);
	folder_config = _tmp80_;
	_tmp81_ = account;
	_tmp82_ = folder_config;
	_tmp83_ = geary_config_file_group_get_string_list (_tmp82_, ACCOUNTS_ACCOUNT_CONFIG_V1_FOLDER_ARCHIVE);
	_tmp84_ = _tmp83_;
	geary_account_information_set_folder_steps_for_use (_tmp81_, GEARY_FOLDER_SPECIAL_USE_ARCHIVE, _tmp84_);
	_g_object_unref0 (_tmp84_);
	_tmp85_ = account;
	_tmp86_ = folder_config;
	_tmp87_ = geary_config_file_group_get_string_list (_tmp86_, ACCOUNTS_ACCOUNT_CONFIG_V1_FOLDER_DRAFTS);
	_tmp88_ = _tmp87_;
	geary_account_information_set_folder_steps_for_use (_tmp85_, GEARY_FOLDER_SPECIAL_USE_DRAFTS, _tmp88_);
	_g_object_unref0 (_tmp88_);
	_tmp89_ = account;
	_tmp90_ = folder_config;
	_tmp91_ = geary_config_file_group_get_string_list (_tmp90_, ACCOUNTS_ACCOUNT_CONFIG_V1_FOLDER_SENT);
	_tmp92_ = _tmp91_;
	geary_account_information_set_folder_steps_for_use (_tmp89_, GEARY_FOLDER_SPECIAL_USE_SENT, _tmp92_);
	_g_object_unref0 (_tmp92_);
	_tmp93_ = folder_config;
	if (geary_config_file_group_has_key (_tmp93_, ACCOUNTS_ACCOUNT_CONFIG_V1_FOLDER_SPAM)) {
		GearyAccountInformation* _tmp94_;
		GearyConfigFileGroup* _tmp95_;
		GeeList* _tmp96_;
		GeeList* _tmp97_;
		_tmp94_ = account;
		_tmp95_ = folder_config;
		_tmp96_ = geary_config_file_group_get_string_list (_tmp95_, ACCOUNTS_ACCOUNT_CONFIG_V1_FOLDER_SPAM);
		_tmp97_ = _tmp96_;
		geary_account_information_set_folder_steps_for_use (_tmp94_, GEARY_FOLDER_SPECIAL_USE_JUNK, _tmp97_);
		_g_object_unref0 (_tmp97_);
	}
	_tmp98_ = folder_config;
	if (geary_config_file_group_has_key (_tmp98_, ACCOUNTS_ACCOUNT_CONFIG_V1_FOLDER_JUNK)) {
		GearyAccountInformation* _tmp99_;
		GearyConfigFileGroup* _tmp100_;
		GeeList* _tmp101_;
		GeeList* _tmp102_;
		_tmp99_ = account;
		_tmp100_ = folder_config;
		_tmp101_ = geary_config_file_group_get_string_list (_tmp100_, ACCOUNTS_ACCOUNT_CONFIG_V1_FOLDER_JUNK);
		_tmp102_ = _tmp101_;
		geary_account_information_set_folder_steps_for_use (_tmp99_, GEARY_FOLDER_SPECIAL_USE_JUNK, _tmp102_);
		_g_object_unref0 (_tmp102_);
	}
	_tmp103_ = account;
	_tmp104_ = folder_config;
	_tmp105_ = geary_config_file_group_get_string_list (_tmp104_, ACCOUNTS_ACCOUNT_CONFIG_V1_FOLDER_TRASH);
	_tmp106_ = _tmp105_;
	geary_account_information_set_folder_steps_for_use (_tmp103_, GEARY_FOLDER_SPECIAL_USE_TRASH, _tmp106_);
	_g_object_unref0 (_tmp106_);
	result = account;
	_geary_config_file_group_unref0 (folder_config);
	_g_free0 (_tmp22_);
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (senders);
	_geary_config_file_group_unref0 (account_config);
	return result;
}

/** Saves an account to a config file. */
static gchar*
__lambda48_ (AccountsAccountConfigV1* self,
             GearyRFC822MailboxAddress* sender)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (sender, GEARY_RF_C822_TYPE_MAILBOX_ADDRESS), NULL);
	_tmp0_ = geary_rf_c822_decoded_message_data_to_rfc822_string (G_TYPE_CHECK_INSTANCE_CAST (sender, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, GearyRFC822DecodedMessageData));
	result = _tmp0_;
	_g_object_unref0 (sender);
	return result;
}

static gpointer
___lambda48__gee_map_func (gpointer g,
                           gpointer self)
{
	gpointer result;
	result = __lambda48_ ((AccountsAccountConfigV1*) self, (GearyRFC822MailboxAddress*) g);
	return result;
}

static void
accounts_account_config_v1_real_save (AccountsAccountConfig* base,
                                      GearyAccountInformation* account,
                                      GearyConfigFile* config)
{
	AccountsAccountConfigV1 * self;
	GearyConfigFileGroup* account_config = NULL;
	GearyConfigFileGroup* _tmp0_;
	GearyConfigFileGroup* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GearyConfigFileGroup* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GearyConfigFileGroup* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GearyConfigFileGroup* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GearyConfigFileGroup* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	GearyConfigFileGroup* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	GearyConfigFileGroup* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GearyConfigFileGroup* _tmp22_;
	GeeList* _tmp23_;
	GeeList* _tmp24_;
	GeeList* _tmp25_;
	GearyIterable* _tmp26_;
	GearyIterable* _tmp27_;
	GearyIterable* _tmp28_;
	GearyIterable* _tmp29_;
	GeeArrayList* _tmp30_;
	GeeArrayList* _tmp31_;
	GearyConfigFileGroup* folder_config = NULL;
	GearyConfigFileGroup* _tmp37_;
	GeeList* _tmp38_;
	GeeList* _tmp39_;
	GeeList* _tmp40_;
	GeeList* _tmp41_;
	GeeList* _tmp42_;
	GeeList* _tmp43_;
	GeeList* _tmp44_;
	GeeList* _tmp45_;
	GeeList* _tmp46_;
	GeeList* _tmp47_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, ACCOUNTS_TYPE_ACCOUNT_CONFIG_V1, AccountsAccountConfigV1);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (config, GEARY_TYPE_CONFIG_FILE));
	_tmp0_ = geary_config_file_get_group (config, ACCOUNTS_ACCOUNT_CONFIG_V1_GROUP_ACCOUNT);
	account_config = _tmp0_;
	_tmp1_ = account_config;
	_tmp2_ = geary_account_information_get_ordinal (account);
	_tmp3_ = _tmp2_;
	geary_config_file_group_set_int (_tmp1_, ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_ORDINAL, _tmp3_);
	_tmp4_ = account_config;
	_tmp5_ = geary_account_information_get_label (account);
	_tmp6_ = _tmp5_;
	geary_config_file_group_set_string (_tmp4_, ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_LABEL, _tmp6_);
	_tmp7_ = account_config;
	_tmp8_ = geary_account_information_get_prefetch_period_days (account);
	_tmp9_ = _tmp8_;
	geary_config_file_group_set_int (_tmp7_, ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_PREFETCH, _tmp9_);
	_tmp10_ = account_config;
	_tmp11_ = geary_account_information_get_save_drafts (account);
	_tmp12_ = _tmp11_;
	geary_config_file_group_set_bool (_tmp10_, ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_SAVE_DRAFTS, _tmp12_);
	_tmp13_ = account_config;
	_tmp14_ = geary_account_information_get_save_sent (account);
	_tmp15_ = _tmp14_;
	geary_config_file_group_set_bool (_tmp13_, ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_SAVE_SENT, _tmp15_);
	_tmp16_ = account_config;
	_tmp17_ = geary_account_information_get_use_signature (account);
	_tmp18_ = _tmp17_;
	geary_config_file_group_set_bool (_tmp16_, ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_USE_SIG, _tmp18_);
	_tmp19_ = account_config;
	_tmp20_ = geary_account_information_get_signature (account);
	_tmp21_ = _tmp20_;
	geary_config_file_group_set_string (_tmp19_, ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_SIG, _tmp21_);
	_tmp22_ = account_config;
	_tmp23_ = geary_account_information_get_sender_mailboxes (account);
	_tmp24_ = _tmp23_;
	_tmp25_ = _tmp24_;
	_tmp26_ = geary_traverse (GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_ITERABLE, GeeIterable));
	_tmp27_ = _tmp26_;
	_tmp28_ = geary_iterable_map (_tmp27_, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, ___lambda48__gee_map_func, self);
	_tmp29_ = _tmp28_;
	_tmp30_ = geary_iterable_to_array_list (_tmp29_, NULL, NULL, NULL);
	_tmp31_ = _tmp30_;
	geary_config_file_group_set_string_list (_tmp22_, ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_SENDERS, G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_LIST, GeeList));
	_g_object_unref0 (_tmp31_);
	_g_object_unref0 (_tmp29_);
	_g_object_unref0 (_tmp27_);
	_g_object_unref0 (_tmp25_);
	if (!self->priv->is_managed) {
		GearyConfigFileGroup* _tmp32_;
		GearyServiceProvider _tmp33_;
		GearyServiceProvider _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp32_ = account_config;
		_tmp33_ = geary_account_information_get_service_provider (account);
		_tmp34_ = _tmp33_;
		_tmp35_ = geary_service_provider_to_value (_tmp34_);
		_tmp36_ = _tmp35_;
		geary_config_file_group_set_string (_tmp32_, ACCOUNTS_ACCOUNT_CONFIG_V1_ACCOUNT_PROVIDER, _tmp36_);
		_g_free0 (_tmp36_);
	}
	_tmp37_ = geary_config_file_get_group (config, ACCOUNTS_ACCOUNT_CONFIG_V1_GROUP_FOLDERS);
	folder_config = _tmp37_;
	_tmp38_ = geary_account_information_get_folder_steps_for_use (account, GEARY_FOLDER_SPECIAL_USE_ARCHIVE);
	_tmp39_ = _tmp38_;
	accounts_account_config_v1_save_folder (self, folder_config, ACCOUNTS_ACCOUNT_CONFIG_V1_FOLDER_ARCHIVE, _tmp39_);
	_g_object_unref0 (_tmp39_);
	_tmp40_ = geary_account_information_get_folder_steps_for_use (account, GEARY_FOLDER_SPECIAL_USE_DRAFTS);
	_tmp41_ = _tmp40_;
	accounts_account_config_v1_save_folder (self, folder_config, ACCOUNTS_ACCOUNT_CONFIG_V1_FOLDER_DRAFTS, _tmp41_);
	_g_object_unref0 (_tmp41_);
	_tmp42_ = geary_account_information_get_folder_steps_for_use (account, GEARY_FOLDER_SPECIAL_USE_SENT);
	_tmp43_ = _tmp42_;
	accounts_account_config_v1_save_folder (self, folder_config, ACCOUNTS_ACCOUNT_CONFIG_V1_FOLDER_SENT, _tmp43_);
	_g_object_unref0 (_tmp43_);
	_tmp44_ = geary_account_information_get_folder_steps_for_use (account, GEARY_FOLDER_SPECIAL_USE_JUNK);
	_tmp45_ = _tmp44_;
	accounts_account_config_v1_save_folder (self, folder_config, ACCOUNTS_ACCOUNT_CONFIG_V1_FOLDER_JUNK, _tmp45_);
	_g_object_unref0 (_tmp45_);
	_tmp46_ = geary_account_information_get_folder_steps_for_use (account, GEARY_FOLDER_SPECIAL_USE_TRASH);
	_tmp47_ = _tmp46_;
	accounts_account_config_v1_save_folder (self, folder_config, ACCOUNTS_ACCOUNT_CONFIG_V1_FOLDER_TRASH, _tmp47_);
	_g_object_unref0 (_tmp47_);
	_geary_config_file_group_unref0 (folder_config);
	_geary_config_file_group_unref0 (account_config);
}

static inline void
accounts_account_config_v1_save_folder (AccountsAccountConfigV1* self,
                                        GearyConfigFileGroup* config,
                                        const gchar* key,
                                        GeeList* steps)
{
	g_return_if_fail (ACCOUNTS_IS_ACCOUNT_CONFIG_V1 (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (config, GEARY_CONFIG_FILE_TYPE_GROUP));
	g_return_if_fail (key != NULL);
	g_return_if_fail ((steps == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (steps, GEE_TYPE_LIST));
	if (steps != NULL) {
		geary_config_file_group_set_string_list (config, key, steps);
	}
}

static void
accounts_account_config_v1_class_init (AccountsAccountConfigV1Class * klass,
                                       gpointer klass_data)
{
	accounts_account_config_v1_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AccountsAccountConfigV1_private_offset);
	G_OBJECT_CLASS (klass)->finalize = accounts_account_config_v1_finalize;
}

static void
accounts_account_config_v1_accounts_account_config_interface_init (AccountsAccountConfigIface * iface,
                                                                   gpointer iface_data)
{
	accounts_account_config_v1_accounts_account_config_parent_iface = g_type_interface_peek_parent (iface);
	iface->load = (GearyAccountInformation* (*) (AccountsAccountConfig*, GearyConfigFile*, const gchar*, GearyCredentialsMediator*, GearyServiceProvider*, const gchar*, GError**)) accounts_account_config_v1_real_load;
	iface->save = (void (*) (AccountsAccountConfig*, GearyAccountInformation*, GearyConfigFile*)) accounts_account_config_v1_real_save;
}

static void
accounts_account_config_v1_instance_init (AccountsAccountConfigV1 * self,
                                          gpointer klass)
{
	self->priv = accounts_account_config_v1_get_instance_private (self);
}

static void
accounts_account_config_v1_finalize (GObject * obj)
{
	AccountsAccountConfigV1 * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ACCOUNTS_TYPE_ACCOUNT_CONFIG_V1, AccountsAccountConfigV1);
	G_OBJECT_CLASS (accounts_account_config_v1_parent_class)->finalize (obj);
}

/**
 * Manages persistence for version 1 config files.
 */
static GType
accounts_account_config_v1_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AccountsAccountConfigV1Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) accounts_account_config_v1_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AccountsAccountConfigV1), 0, (GInstanceInitFunc) accounts_account_config_v1_instance_init, NULL };
	static const GInterfaceInfo accounts_account_config_info = { (GInterfaceInitFunc) accounts_account_config_v1_accounts_account_config_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType accounts_account_config_v1_type_id;
	accounts_account_config_v1_type_id = g_type_register_static (G_TYPE_OBJECT, "AccountsAccountConfigV1", &g_define_type_info, 0);
	g_type_add_interface_static (accounts_account_config_v1_type_id, ACCOUNTS_TYPE_ACCOUNT_CONFIG, &accounts_account_config_info);
	AccountsAccountConfigV1_private_offset = g_type_add_instance_private (accounts_account_config_v1_type_id, sizeof (AccountsAccountConfigV1Private));
	return accounts_account_config_v1_type_id;
}

GType
accounts_account_config_v1_get_type (void)
{
	static volatile gsize accounts_account_config_v1_type_id__once = 0;
	if (g_once_init_enter (&accounts_account_config_v1_type_id__once)) {
		GType accounts_account_config_v1_type_id;
		accounts_account_config_v1_type_id = accounts_account_config_v1_get_type_once ();
		g_once_init_leave (&accounts_account_config_v1_type_id__once, accounts_account_config_v1_type_id);
	}
	return accounts_account_config_v1_type_id__once;
}

static GearyServiceProvider
___lambda54_ (AccountsAccountConfigLegacy* self,
              const gchar* value,
              GError** error)
{
	GError* _inner_error0_ = NULL;
	GearyServiceProvider result;
	g_return_val_if_fail (value != NULL, 0);
	{
		GearyServiceProvider _tmp0_ = 0;
		_tmp0_ = geary_service_provider_for_value (value, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_ENGINE_ERROR) {
				goto __catch0_geary_engine_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_geary_engine_error:
	{
		GError* err = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		GError* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = err;
		_tmp2_ = _tmp1_->message;
		_tmp3_ = g_error_new_literal (G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_INVALID_VALUE, _tmp2_);
		_inner_error0_ = _tmp3_;
		_g_error_free0 (err);
		goto __finally0;
	}
	__finally0:
	if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
		g_propagate_error (error, _inner_error0_);
		return 0;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
}

static gpointer
____lambda54__geary_config_file_parser (const gchar* value,
                                        gpointer self,
                                        GError** error)
{
	gpointer result;
	result = (gpointer) ((gintptr) ___lambda54_ ((AccountsAccountConfigLegacy*) self, value, error));
	return result;
}

static GearyAccountInformation*
accounts_account_config_legacy_real_load (AccountsAccountConfig* base,
                                          GearyConfigFile* config_file,
                                          const gchar* id,
                                          GearyCredentialsMediator* mediator,
                                          GearyServiceProvider* default_provider,
                                          const gchar* default_name,
                                          GError** error)
{
	AccountsAccountConfigLegacy * self;
	GearyConfigFileGroup* config = NULL;
	GearyConfigFileGroup* _tmp0_;
	gchar* primary_email = NULL;
	GearyConfigFileGroup* _tmp1_;
	gchar* _tmp2_;
	gchar* real_name = NULL;
	GearyConfigFileGroup* _tmp3_;
	gchar* _tmp4_;
	GearyServiceProvider* _tmp5_ = NULL;
	GearyServiceProvider provider = 0;
	GearyAccountInformation* info = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GearyRFC822MailboxAddress* _tmp13_;
	GearyRFC822MailboxAddress* _tmp14_;
	GearyAccountInformation* _tmp15_;
	GearyAccountInformation* _tmp16_;
	GearyAccountInformation* _tmp17_;
	GearyConfigFileGroup* _tmp18_;
	GearyAccountInformation* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	GearyAccountInformation* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	GearyAccountInformation* _tmp28_;
	GearyConfigFileGroup* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	GearyRFC822MailboxAddress* _tmp33_;
	GearyRFC822MailboxAddress* _tmp34_;
	GearyAccountInformation* _tmp35_;
	GearyConfigFileGroup* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GeeList* alt_email_list = NULL;
	GearyConfigFileGroup* _tmp39_;
	GeeList* _tmp40_;
	GearyAccountInformation* _tmp65_;
	GearyConfigFileGroup* _tmp66_;
	GearyAccountInformation* _tmp67_;
	gint _tmp68_;
	gint _tmp69_;
	GearyAccountInformation* _tmp70_;
	GearyConfigFileGroup* _tmp71_;
	GearyAccountInformation* _tmp72_;
	gboolean _tmp73_;
	gboolean _tmp74_;
	GearyAccountInformation* _tmp75_;
	GearyConfigFileGroup* _tmp76_;
	GearyAccountInformation* _tmp77_;
	gboolean _tmp78_;
	gboolean _tmp79_;
	GearyAccountInformation* _tmp80_;
	GearyConfigFileGroup* _tmp81_;
	GearyAccountInformation* _tmp82_;
	const gchar* _tmp83_;
	const gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	GearyAccountInformation* _tmp87_;
	GearyConfigFileGroup* _tmp88_;
	GeeList* _tmp89_;
	GeeList* _tmp90_;
	GearyAccountInformation* _tmp91_;
	GearyConfigFileGroup* _tmp92_;
	GeeList* _tmp93_;
	GeeList* _tmp94_;
	GearyAccountInformation* _tmp95_;
	GearyConfigFileGroup* _tmp96_;
	GeeList* _tmp97_;
	GeeList* _tmp98_;
	GearyAccountInformation* _tmp99_;
	GearyConfigFileGroup* _tmp100_;
	GeeList* _tmp101_;
	GeeList* _tmp102_;
	GearyAccountInformation* _tmp103_;
	GearyConfigFileGroup* _tmp104_;
	GeeList* _tmp105_;
	GeeList* _tmp106_;
	GearyAccountInformation* _tmp107_;
	GearyConfigFileGroup* _tmp108_;
	GError* _inner_error0_ = NULL;
	GearyAccountInformation* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, ACCOUNTS_TYPE_ACCOUNT_CONFIG_LEGACY, AccountsAccountConfigLegacy);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (config_file, GEARY_TYPE_CONFIG_FILE), NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (mediator, GEARY_TYPE_CREDENTIALS_MEDIATOR), NULL);
	_tmp0_ = geary_config_file_get_group (config_file, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_GROUP);
	config = _tmp0_;
	_tmp1_ = config;
	_tmp2_ = geary_config_file_group_get_required_string (_tmp1_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_PRIMARY_EMAIL_KEY, &_inner_error0_);
	primary_email = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == ACCOUNTS_CONFIG_ERROR) || (_inner_error0_->domain == G_KEY_FILE_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_geary_config_file_group_unref0 (config);
			return NULL;
		} else {
			_geary_config_file_group_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = config;
	_tmp4_ = geary_config_file_group_get_string (_tmp3_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_REAL_NAME_KEY, default_name);
	real_name = _tmp4_;
	if (default_provider != NULL) {
		GearyServiceProvider* _tmp6_;
		_tmp6_ = __geary_service_provider_dup0 (default_provider);
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp6_;
	} else {
		GearyConfigFileGroup* _tmp7_;
		gpointer _tmp8_;
		GearyServiceProvider _tmp9_;
		GearyServiceProvider* _tmp10_;
		_tmp7_ = config;
		_tmp8_ = geary_config_file_group_parse_required_value (_tmp7_, GEARY_TYPE_SERVICE_PROVIDER, NULL, NULL, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_SERVICE_PROVIDER_KEY, ____lambda54__geary_config_file_parser, self, &_inner_error0_);
		_tmp9_ = (GearyServiceProvider) ((gintptr) _tmp8_);
		_tmp10_ = __geary_service_provider_dup0 (&_tmp9_);
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if ((_inner_error0_->domain == ACCOUNTS_CONFIG_ERROR) || (_inner_error0_->domain == G_KEY_FILE_ERROR)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (_tmp5_);
				_g_free0 (real_name);
				_g_free0 (primary_email);
				_geary_config_file_group_unref0 (config);
				return NULL;
			} else {
				_g_free0 (_tmp5_);
				_g_free0 (real_name);
				_g_free0 (primary_email);
				_geary_config_file_group_unref0 (config);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	provider = *_tmp5_;
	_tmp11_ = real_name;
	_tmp12_ = primary_email;
	_tmp13_ = geary_rf_c822_mailbox_address_new (_tmp11_, _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = geary_account_information_new (id, provider, mediator, _tmp14_);
	_tmp16_ = _tmp15_;
	_g_object_unref0 (_tmp14_);
	info = _tmp16_;
	_tmp17_ = info;
	_tmp18_ = config;
	_tmp19_ = info;
	_tmp20_ = geary_account_information_get_ordinal (_tmp19_);
	_tmp21_ = _tmp20_;
	geary_account_information_set_ordinal (_tmp17_, geary_config_file_group_get_int (_tmp18_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_ORDINAL_KEY, _tmp21_));
	_tmp22_ = info;
	_tmp23_ = geary_account_information_get_ordinal (_tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_ >= geary_account_information_next_ordinal) {
		GearyAccountInformation* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		_tmp25_ = info;
		_tmp26_ = geary_account_information_get_ordinal (_tmp25_);
		_tmp27_ = _tmp26_;
		geary_account_information_next_ordinal = _tmp27_ + 1;
	}
	_tmp28_ = info;
	_tmp29_ = config;
	_tmp30_ = geary_config_file_group_get_string (_tmp29_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_REAL_NAME_KEY, NULL);
	_tmp31_ = _tmp30_;
	_tmp32_ = primary_email;
	_tmp33_ = geary_rf_c822_mailbox_address_new (_tmp31_, _tmp32_);
	_tmp34_ = _tmp33_;
	geary_account_information_append_sender (_tmp28_, _tmp34_);
	_g_object_unref0 (_tmp34_);
	_g_free0 (_tmp31_);
	_tmp35_ = info;
	_tmp36_ = config;
	_tmp37_ = geary_config_file_group_get_string (_tmp36_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_NICKNAME_KEY, NULL);
	_tmp38_ = _tmp37_;
	geary_account_information_set_label (_tmp35_, _tmp38_);
	_g_free0 (_tmp38_);
	_tmp39_ = config;
	_tmp40_ = geary_config_file_group_get_string_list (_tmp39_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_ALTERNATE_EMAILS_KEY);
	alt_email_list = _tmp40_;
	{
		GeeList* _alt_email_list = NULL;
		GeeList* _tmp41_;
		gint _alt_email_size = 0;
		GeeList* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		gint _alt_email_index = 0;
		_tmp41_ = alt_email_list;
		_alt_email_list = _tmp41_;
		_tmp42_ = _alt_email_list;
		_tmp43_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp44_ = _tmp43_;
		_alt_email_size = _tmp44_;
		_alt_email_index = -1;
		while (TRUE) {
			gint _tmp45_;
			gint _tmp46_;
			gchar* alt_email = NULL;
			GeeList* _tmp47_;
			gpointer _tmp48_;
			_alt_email_index = _alt_email_index + 1;
			_tmp45_ = _alt_email_index;
			_tmp46_ = _alt_email_size;
			if (!(_tmp45_ < _tmp46_)) {
				break;
			}
			_tmp47_ = _alt_email_list;
			_tmp48_ = gee_list_get (_tmp47_, _alt_email_index);
			alt_email = (gchar*) _tmp48_;
			{
				GearyRFC822MailboxAddresses* mailboxes = NULL;
				const gchar* _tmp49_;
				GearyRFC822MailboxAddresses* _tmp50_;
				_tmp49_ = alt_email;
				_tmp50_ = geary_rf_c822_mailbox_addresses_new_from_rfc822_string (_tmp49_, &_inner_error0_);
				mailboxes = _tmp50_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
						goto __catch0_geary_rf_c822_error;
					}
					_g_free0 (alt_email);
					_g_object_unref0 (alt_email_list);
					_g_object_unref0 (info);
					_g_free0 (_tmp5_);
					_g_free0 (real_name);
					_g_free0 (primary_email);
					_geary_config_file_group_unref0 (config);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				{
					GeeList* _mailbox_list = NULL;
					GearyRFC822MailboxAddresses* _tmp51_;
					GeeList* _tmp52_;
					gint _mailbox_size = 0;
					GeeList* _tmp53_;
					gint _tmp54_;
					gint _tmp55_;
					gint _mailbox_index = 0;
					_tmp51_ = mailboxes;
					_tmp52_ = geary_rf_c822_mailbox_addresses_get_all (_tmp51_);
					_mailbox_list = _tmp52_;
					_tmp53_ = _mailbox_list;
					_tmp54_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, GEE_TYPE_COLLECTION, GeeCollection));
					_tmp55_ = _tmp54_;
					_mailbox_size = _tmp55_;
					_mailbox_index = -1;
					while (TRUE) {
						gint _tmp56_;
						gint _tmp57_;
						GearyRFC822MailboxAddress* mailbox = NULL;
						GeeList* _tmp58_;
						gpointer _tmp59_;
						GearyAccountInformation* _tmp60_;
						GearyRFC822MailboxAddress* _tmp61_;
						_mailbox_index = _mailbox_index + 1;
						_tmp56_ = _mailbox_index;
						_tmp57_ = _mailbox_size;
						if (!(_tmp56_ < _tmp57_)) {
							break;
						}
						_tmp58_ = _mailbox_list;
						_tmp59_ = gee_list_get (_tmp58_, _mailbox_index);
						mailbox = (GearyRFC822MailboxAddress*) _tmp59_;
						_tmp60_ = info;
						_tmp61_ = mailbox;
						geary_account_information_append_sender (_tmp60_, _tmp61_);
						_g_object_unref0 (mailbox);
					}
					_g_object_unref0 (_mailbox_list);
				}
				_g_object_unref0 (mailboxes);
			}
			goto __finally0;
			__catch0_geary_rf_c822_error:
			{
				GError* _error_ = NULL;
				GError* _tmp62_;
				const gchar* _tmp63_;
				GError* _tmp64_;
				_error_ = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp62_ = _error_;
				_tmp63_ = _tmp62_->message;
				_tmp64_ = g_error_new (ACCOUNTS_CONFIG_ERROR, ACCOUNTS_CONFIG_ERROR_SYNTAX, "Invalid alternate email: %s", _tmp63_);
				_inner_error0_ = _tmp64_;
				_g_error_free0 (_error_);
				goto __finally0;
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if ((_inner_error0_->domain == ACCOUNTS_CONFIG_ERROR) || (_inner_error0_->domain == G_KEY_FILE_ERROR)) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (alt_email);
					_g_object_unref0 (alt_email_list);
					_g_object_unref0 (info);
					_g_free0 (_tmp5_);
					_g_free0 (real_name);
					_g_free0 (primary_email);
					_geary_config_file_group_unref0 (config);
					return NULL;
				} else {
					_g_free0 (alt_email);
					_g_object_unref0 (alt_email_list);
					_g_object_unref0 (info);
					_g_free0 (_tmp5_);
					_g_free0 (real_name);
					_g_free0 (primary_email);
					_geary_config_file_group_unref0 (config);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_g_free0 (alt_email);
		}
	}
	_tmp65_ = info;
	_tmp66_ = config;
	_tmp67_ = info;
	_tmp68_ = geary_account_information_get_prefetch_period_days (_tmp67_);
	_tmp69_ = _tmp68_;
	geary_account_information_set_prefetch_period_days (_tmp65_, geary_config_file_group_get_int (_tmp66_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_PREFETCH_PERIOD_DAYS_KEY, _tmp69_));
	_tmp70_ = info;
	_tmp71_ = config;
	_tmp72_ = info;
	_tmp73_ = geary_account_information_get_save_sent (_tmp72_);
	_tmp74_ = _tmp73_;
	geary_account_information_set_save_sent (_tmp70_, geary_config_file_group_get_bool (_tmp71_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_SAVE_SENT_MAIL_KEY, _tmp74_));
	_tmp75_ = info;
	_tmp76_ = config;
	_tmp77_ = info;
	_tmp78_ = geary_account_information_get_use_signature (_tmp77_);
	_tmp79_ = _tmp78_;
	geary_account_information_set_use_signature (_tmp75_, geary_config_file_group_get_bool (_tmp76_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_USE_EMAIL_SIGNATURE_KEY, _tmp79_));
	_tmp80_ = info;
	_tmp81_ = config;
	_tmp82_ = info;
	_tmp83_ = geary_account_information_get_signature (_tmp82_);
	_tmp84_ = _tmp83_;
	_tmp85_ = geary_config_file_group_get_string (_tmp81_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_EMAIL_SIGNATURE_KEY, _tmp84_);
	_tmp86_ = _tmp85_;
	geary_account_information_set_signature (_tmp80_, _tmp86_);
	_g_free0 (_tmp86_);
	_tmp87_ = info;
	_tmp88_ = config;
	_tmp89_ = geary_config_file_group_get_string_list (_tmp88_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_DRAFTS_FOLDER_KEY);
	_tmp90_ = _tmp89_;
	geary_account_information_set_folder_steps_for_use (_tmp87_, GEARY_FOLDER_SPECIAL_USE_DRAFTS, _tmp90_);
	_g_object_unref0 (_tmp90_);
	_tmp91_ = info;
	_tmp92_ = config;
	_tmp93_ = geary_config_file_group_get_string_list (_tmp92_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_SENT_MAIL_FOLDER_KEY);
	_tmp94_ = _tmp93_;
	geary_account_information_set_folder_steps_for_use (_tmp91_, GEARY_FOLDER_SPECIAL_USE_SENT, _tmp94_);
	_g_object_unref0 (_tmp94_);
	_tmp95_ = info;
	_tmp96_ = config;
	_tmp97_ = geary_config_file_group_get_string_list (_tmp96_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_SPAM_FOLDER_KEY);
	_tmp98_ = _tmp97_;
	geary_account_information_set_folder_steps_for_use (_tmp95_, GEARY_FOLDER_SPECIAL_USE_JUNK, _tmp98_);
	_g_object_unref0 (_tmp98_);
	_tmp99_ = info;
	_tmp100_ = config;
	_tmp101_ = geary_config_file_group_get_string_list (_tmp100_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_TRASH_FOLDER_KEY);
	_tmp102_ = _tmp101_;
	geary_account_information_set_folder_steps_for_use (_tmp99_, GEARY_FOLDER_SPECIAL_USE_TRASH, _tmp102_);
	_g_object_unref0 (_tmp102_);
	_tmp103_ = info;
	_tmp104_ = config;
	_tmp105_ = geary_config_file_group_get_string_list (_tmp104_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_ARCHIVE_FOLDER_KEY);
	_tmp106_ = _tmp105_;
	geary_account_information_set_folder_steps_for_use (_tmp103_, GEARY_FOLDER_SPECIAL_USE_ARCHIVE, _tmp106_);
	_g_object_unref0 (_tmp106_);
	_tmp107_ = info;
	_tmp108_ = config;
	geary_account_information_set_save_drafts (_tmp107_, geary_config_file_group_get_bool (_tmp108_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_SAVE_DRAFTS_KEY, TRUE));
	result = info;
	_g_object_unref0 (alt_email_list);
	_g_free0 (_tmp5_);
	_g_free0 (real_name);
	_g_free0 (primary_email);
	_geary_config_file_group_unref0 (config);
	return result;
}

static gchar*
___lambda55_ (AccountsAccountConfigLegacy* self,
              GearyRFC822MailboxAddress* alt)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (alt, GEARY_RF_C822_TYPE_MAILBOX_ADDRESS), NULL);
	_tmp0_ = geary_rf_c822_decoded_message_data_to_rfc822_string (G_TYPE_CHECK_INSTANCE_CAST (alt, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, GearyRFC822DecodedMessageData));
	result = _tmp0_;
	_g_object_unref0 (alt);
	return result;
}

static gpointer
____lambda55__gee_map_func (gpointer g,
                            gpointer self)
{
	gpointer result;
	result = ___lambda55_ ((AccountsAccountConfigLegacy*) self, (GearyRFC822MailboxAddress*) g);
	return result;
}

static void
accounts_account_config_legacy_real_save (AccountsAccountConfig* base,
                                          GearyAccountInformation* info,
                                          GearyConfigFile* config_file)
{
	AccountsAccountConfigLegacy * self;
	GearyConfigFileGroup* config = NULL;
	GearyConfigFileGroup* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GearyRFC822MailboxAddress* _tmp2_;
	GearyRFC822MailboxAddress* _tmp3_;
	GearyRFC822MailboxAddress* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GearyConfigFileGroup* _tmp8_;
	GearyConfigFileGroup* _tmp9_;
	GearyRFC822MailboxAddress* _tmp10_;
	GearyRFC822MailboxAddress* _tmp11_;
	GearyRFC822MailboxAddress* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GearyConfigFileGroup* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	GearyConfigFileGroup* _tmp18_;
	GearyServiceProvider _tmp19_;
	GearyServiceProvider _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GearyConfigFileGroup* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GearyConfigFileGroup* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	GearyConfigFileGroup* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	GearyConfigFileGroup* _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	GearyConfigFileGroup* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	gboolean _tmp38_;
	gboolean _tmp39_;
	GeeList* empty = NULL;
	GeeArrayList* _tmp53_;
	GeeList* steps = NULL;
	GeeList* _tmp54_;
	GeeList* _tmp55_ = NULL;
	GeeList* _tmp56_;
	GearyConfigFileGroup* _tmp59_;
	GeeList* _tmp60_;
	GeeList* _tmp61_ = NULL;
	GeeList* _tmp62_;
	GearyConfigFileGroup* _tmp65_;
	GeeList* _tmp66_;
	GeeList* _tmp67_ = NULL;
	GeeList* _tmp68_;
	GearyConfigFileGroup* _tmp71_;
	GeeList* _tmp72_;
	GeeList* _tmp73_ = NULL;
	GeeList* _tmp74_;
	GearyConfigFileGroup* _tmp77_;
	GeeList* _tmp78_;
	GeeList* _tmp79_ = NULL;
	GeeList* _tmp80_;
	GearyConfigFileGroup* _tmp83_;
	GearyConfigFileGroup* _tmp84_;
	gboolean _tmp85_;
	gboolean _tmp86_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, ACCOUNTS_TYPE_ACCOUNT_CONFIG_LEGACY, AccountsAccountConfigLegacy);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (config_file, GEARY_TYPE_CONFIG_FILE));
	_tmp0_ = geary_config_file_get_group (config_file, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_GROUP);
	config = _tmp0_;
	_tmp2_ = geary_account_information_get_primary_mailbox (info);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = geary_rf_c822_mailbox_address_get_name (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp4_);
	_tmp1_ = _tmp7_;
	if (_tmp1_ == NULL) {
		_tmp1_ = "";
	}
	_tmp8_ = config;
	geary_config_file_group_set_string (_tmp8_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_REAL_NAME_KEY, _tmp1_);
	_tmp9_ = config;
	_tmp10_ = geary_account_information_get_primary_mailbox (info);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp13_ = geary_rf_c822_mailbox_address_get_address (_tmp12_);
	_tmp14_ = _tmp13_;
	geary_config_file_group_set_string (_tmp9_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_PRIMARY_EMAIL_KEY, _tmp14_);
	_g_object_unref0 (_tmp12_);
	_tmp15_ = config;
	_tmp16_ = geary_account_information_get_label (info);
	_tmp17_ = _tmp16_;
	geary_config_file_group_set_string (_tmp15_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_NICKNAME_KEY, _tmp17_);
	_tmp18_ = config;
	_tmp19_ = geary_account_information_get_service_provider (info);
	_tmp20_ = _tmp19_;
	_tmp21_ = geary_service_provider_to_value (_tmp20_);
	_tmp22_ = _tmp21_;
	geary_config_file_group_set_string (_tmp18_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_SERVICE_PROVIDER_KEY, _tmp22_);
	_g_free0 (_tmp22_);
	_tmp23_ = config;
	_tmp24_ = geary_account_information_get_ordinal (info);
	_tmp25_ = _tmp24_;
	geary_config_file_group_set_int (_tmp23_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_ORDINAL_KEY, _tmp25_);
	_tmp26_ = config;
	_tmp27_ = geary_account_information_get_prefetch_period_days (info);
	_tmp28_ = _tmp27_;
	geary_config_file_group_set_int (_tmp26_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_PREFETCH_PERIOD_DAYS_KEY, _tmp28_);
	_tmp29_ = config;
	_tmp30_ = geary_account_information_get_save_sent (info);
	_tmp31_ = _tmp30_;
	geary_config_file_group_set_bool (_tmp29_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_SAVE_SENT_MAIL_KEY, _tmp31_);
	_tmp32_ = config;
	_tmp33_ = geary_account_information_get_use_signature (info);
	_tmp34_ = _tmp33_;
	geary_config_file_group_set_bool (_tmp32_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_USE_EMAIL_SIGNATURE_KEY, _tmp34_);
	_tmp35_ = config;
	_tmp36_ = geary_account_information_get_signature (info);
	_tmp37_ = _tmp36_;
	geary_config_file_group_set_string (_tmp35_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_EMAIL_SIGNATURE_KEY, _tmp37_);
	_tmp38_ = geary_account_information_get_has_sender_aliases (info);
	_tmp39_ = _tmp38_;
	if (_tmp39_) {
		GeeList* alts = NULL;
		GeeList* _tmp40_;
		GeeList* _tmp41_;
		GeeList* _tmp42_;
		gpointer _tmp43_;
		GearyRFC822MailboxAddress* _tmp44_;
		GearyConfigFileGroup* _tmp45_;
		GeeList* _tmp46_;
		GearyIterable* _tmp47_;
		GearyIterable* _tmp48_;
		GearyIterable* _tmp49_;
		GearyIterable* _tmp50_;
		GeeArrayList* _tmp51_;
		GeeArrayList* _tmp52_;
		_tmp40_ = geary_account_information_get_sender_mailboxes (info);
		_tmp41_ = _tmp40_;
		alts = _tmp41_;
		_tmp42_ = alts;
		_tmp43_ = gee_list_remove_at (_tmp42_, 0);
		_tmp44_ = (GearyRFC822MailboxAddress*) _tmp43_;
		_g_object_unref0 (_tmp44_);
		_tmp45_ = config;
		_tmp46_ = alts;
		_tmp47_ = geary_traverse (GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp48_ = _tmp47_;
		_tmp49_ = geary_iterable_map (_tmp48_, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, ____lambda55__gee_map_func, self);
		_tmp50_ = _tmp49_;
		_tmp51_ = geary_iterable_to_array_list (_tmp50_, NULL, NULL, NULL);
		_tmp52_ = _tmp51_;
		geary_config_file_group_set_string_list (_tmp45_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_ALTERNATE_EMAILS_KEY, G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GEE_TYPE_LIST, GeeList));
		_g_object_unref0 (_tmp52_);
		_g_object_unref0 (_tmp50_);
		_g_object_unref0 (_tmp48_);
		_g_object_unref0 (alts);
	}
	_tmp53_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	empty = G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, GEE_TYPE_LIST, GeeList);
	steps = NULL;
	_tmp54_ = geary_account_information_get_folder_steps_for_use (info, GEARY_FOLDER_SPECIAL_USE_DRAFTS);
	_g_object_unref0 (steps);
	steps = _tmp54_;
	_tmp56_ = steps;
	if (_tmp56_ != NULL) {
		GeeList* _tmp57_;
		_tmp57_ = steps;
		_tmp55_ = _tmp57_;
	} else {
		GeeList* _tmp58_;
		_tmp58_ = empty;
		_tmp55_ = _tmp58_;
	}
	_tmp59_ = config;
	geary_config_file_group_set_string_list (_tmp59_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_DRAFTS_FOLDER_KEY, _tmp55_);
	_tmp60_ = geary_account_information_get_folder_steps_for_use (info, GEARY_FOLDER_SPECIAL_USE_SENT);
	_g_object_unref0 (steps);
	steps = _tmp60_;
	_tmp62_ = steps;
	if (_tmp62_ != NULL) {
		GeeList* _tmp63_;
		_tmp63_ = steps;
		_tmp61_ = _tmp63_;
	} else {
		GeeList* _tmp64_;
		_tmp64_ = empty;
		_tmp61_ = _tmp64_;
	}
	_tmp65_ = config;
	geary_config_file_group_set_string_list (_tmp65_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_SENT_MAIL_FOLDER_KEY, _tmp61_);
	_tmp66_ = geary_account_information_get_folder_steps_for_use (info, GEARY_FOLDER_SPECIAL_USE_JUNK);
	_g_object_unref0 (steps);
	steps = _tmp66_;
	_tmp68_ = steps;
	if (_tmp68_ != NULL) {
		GeeList* _tmp69_;
		_tmp69_ = steps;
		_tmp67_ = _tmp69_;
	} else {
		GeeList* _tmp70_;
		_tmp70_ = empty;
		_tmp67_ = _tmp70_;
	}
	_tmp71_ = config;
	geary_config_file_group_set_string_list (_tmp71_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_SPAM_FOLDER_KEY, _tmp67_);
	_tmp72_ = geary_account_information_get_folder_steps_for_use (info, GEARY_FOLDER_SPECIAL_USE_TRASH);
	_g_object_unref0 (steps);
	steps = _tmp72_;
	_tmp74_ = steps;
	if (_tmp74_ != NULL) {
		GeeList* _tmp75_;
		_tmp75_ = steps;
		_tmp73_ = _tmp75_;
	} else {
		GeeList* _tmp76_;
		_tmp76_ = empty;
		_tmp73_ = _tmp76_;
	}
	_tmp77_ = config;
	geary_config_file_group_set_string_list (_tmp77_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_TRASH_FOLDER_KEY, _tmp73_);
	_tmp78_ = geary_account_information_get_folder_steps_for_use (info, GEARY_FOLDER_SPECIAL_USE_ARCHIVE);
	_g_object_unref0 (steps);
	steps = _tmp78_;
	_tmp80_ = steps;
	if (_tmp80_ != NULL) {
		GeeList* _tmp81_;
		_tmp81_ = steps;
		_tmp79_ = _tmp81_;
	} else {
		GeeList* _tmp82_;
		_tmp82_ = empty;
		_tmp79_ = _tmp82_;
	}
	_tmp83_ = config;
	geary_config_file_group_set_string_list (_tmp83_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_ARCHIVE_FOLDER_KEY, _tmp79_);
	_tmp84_ = config;
	_tmp85_ = geary_account_information_get_save_drafts (info);
	_tmp86_ = _tmp85_;
	geary_config_file_group_set_bool (_tmp84_, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_SAVE_DRAFTS_KEY, _tmp86_);
	_g_object_unref0 (steps);
	_g_object_unref0 (empty);
	_geary_config_file_group_unref0 (config);
}

AccountsAccountConfigLegacy*
accounts_account_config_legacy_construct (GType object_type)
{
	AccountsAccountConfigLegacy * self = NULL;
	self = (AccountsAccountConfigLegacy*) g_object_new (object_type, NULL);
	return self;
}

AccountsAccountConfigLegacy*
accounts_account_config_legacy_new (void)
{
	return accounts_account_config_legacy_construct (ACCOUNTS_TYPE_ACCOUNT_CONFIG_LEGACY);
}

static void
accounts_account_config_legacy_class_init (AccountsAccountConfigLegacyClass * klass,
                                           gpointer klass_data)
{
	accounts_account_config_legacy_parent_class = g_type_class_peek_parent (klass);
}

static void
accounts_account_config_legacy_accounts_account_config_interface_init (AccountsAccountConfigIface * iface,
                                                                       gpointer iface_data)
{
	accounts_account_config_legacy_accounts_account_config_parent_iface = g_type_interface_peek_parent (iface);
	iface->load = (GearyAccountInformation* (*) (AccountsAccountConfig*, GearyConfigFile*, const gchar*, GearyCredentialsMediator*, GearyServiceProvider*, const gchar*, GError**)) accounts_account_config_legacy_real_load;
	iface->save = (void (*) (AccountsAccountConfig*, GearyAccountInformation*, GearyConfigFile*)) accounts_account_config_legacy_real_save;
}

static void
accounts_account_config_legacy_instance_init (AccountsAccountConfigLegacy * self,
                                              gpointer klass)
{
}

/**
 * Manages persistence for un-versioned account configuration.
 */
static GType
accounts_account_config_legacy_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AccountsAccountConfigLegacyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) accounts_account_config_legacy_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AccountsAccountConfigLegacy), 0, (GInstanceInitFunc) accounts_account_config_legacy_instance_init, NULL };
	static const GInterfaceInfo accounts_account_config_info = { (GInterfaceInitFunc) accounts_account_config_legacy_accounts_account_config_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType accounts_account_config_legacy_type_id;
	accounts_account_config_legacy_type_id = g_type_register_static (G_TYPE_OBJECT, "AccountsAccountConfigLegacy", &g_define_type_info, 0);
	g_type_add_interface_static (accounts_account_config_legacy_type_id, ACCOUNTS_TYPE_ACCOUNT_CONFIG, &accounts_account_config_info);
	return accounts_account_config_legacy_type_id;
}

GType
accounts_account_config_legacy_get_type (void)
{
	static volatile gsize accounts_account_config_legacy_type_id__once = 0;
	if (g_once_init_enter (&accounts_account_config_legacy_type_id__once)) {
		GType accounts_account_config_legacy_type_id;
		accounts_account_config_legacy_type_id = accounts_account_config_legacy_get_type_once ();
		g_once_init_leave (&accounts_account_config_legacy_type_id__once, accounts_account_config_legacy_type_id);
	}
	return accounts_account_config_legacy_type_id__once;
}

/** Loads a supported service from a config file. */
static GearyTlsNegotiationMethod
___lambda49_ (AccountsServiceConfigV1* self,
              const gchar* value,
              GError** error)
{
	GError* _inner_error0_ = NULL;
	GearyTlsNegotiationMethod result;
	g_return_val_if_fail (value != NULL, 0);
	{
		GearyTlsNegotiationMethod _tmp0_ = 0;
		_tmp0_ = geary_tls_negotiation_method_for_value (value, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		GError* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = err;
		_tmp2_ = _tmp1_->message;
		_tmp3_ = g_error_new_literal (G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_INVALID_VALUE, _tmp2_);
		_inner_error0_ = _tmp3_;
		_g_error_free0 (err);
		goto __finally0;
	}
	__finally0:
	if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
		g_propagate_error (error, _inner_error0_);
		return 0;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
}

static gpointer
____lambda49__geary_config_file_parser (const gchar* value,
                                        gpointer self,
                                        GError** error)
{
	gpointer result;
	result = (gpointer) ((gintptr) ___lambda49_ ((AccountsServiceConfigV1*) self, value, error));
	return result;
}

static GearyCredentialsRequirement
___lambda50_ (AccountsServiceConfigV1* self,
              const gchar* value,
              GError** error)
{
	GError* _inner_error0_ = NULL;
	GearyCredentialsRequirement result;
	g_return_val_if_fail (value != NULL, 0);
	{
		GearyCredentialsRequirement _tmp0_ = 0;
		_tmp0_ = geary_credentials_requirement_for_value (value, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		GError* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = err;
		_tmp2_ = _tmp1_->message;
		_tmp3_ = g_error_new_literal (G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_INVALID_VALUE, _tmp2_);
		_inner_error0_ = _tmp3_;
		_g_error_free0 (err);
		goto __finally0;
	}
	__finally0:
	if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
		g_propagate_error (error, _inner_error0_);
		return 0;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
}

static gpointer
____lambda50__geary_config_file_parser (const gchar* value,
                                        gpointer self,
                                        GError** error)
{
	gpointer result;
	result = (gpointer) ((gintptr) ___lambda50_ ((AccountsServiceConfigV1*) self, value, error));
	return result;
}

static void
accounts_service_config_v1_real_load (AccountsServiceConfig* base,
                                      GearyConfigFile* config,
                                      GearyAccountInformation* account,
                                      GearyServiceInformation* service,
                                      GError** error)
{
	AccountsServiceConfigV1 * self;
	const gchar* _tmp0_ = NULL;
	GearyProtocol _tmp1_;
	GearyProtocol _tmp2_;
	GearyConfigFileGroup* service_config = NULL;
	GearyConfigFileGroup* _tmp3_;
	gchar* login = NULL;
	GearyConfigFileGroup* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	GearyConfigFileGroup* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GearyServiceProvider _tmp13_;
	GearyServiceProvider _tmp14_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, ACCOUNTS_TYPE_SERVICE_CONFIG_V1, AccountsServiceConfigV1);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (config, GEARY_TYPE_CONFIG_FILE));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (service, GEARY_TYPE_SERVICE_INFORMATION));
	_tmp1_ = geary_service_information_get_protocol (service);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == GEARY_PROTOCOL_IMAP) {
		_tmp0_ = ACCOUNTS_SERVICE_CONFIG_V1_GROUP_INCOMING;
	} else {
		_tmp0_ = ACCOUNTS_SERVICE_CONFIG_V1_GROUP_OUTGOING;
	}
	_tmp3_ = geary_config_file_get_group (config, _tmp0_);
	service_config = _tmp3_;
	_tmp4_ = service_config;
	_tmp5_ = geary_config_file_group_get_string (_tmp4_, ACCOUNTS_SERVICE_CONFIG_V1_LOGIN, NULL);
	login = _tmp5_;
	_tmp6_ = login;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		GearyCredentials* _tmp8_;
		GearyCredentials* _tmp9_;
		_tmp7_ = login;
		_tmp8_ = geary_credentials_new (GEARY_CREDENTIALS_METHOD_PASSWORD, _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		geary_service_information_set_credentials (service, _tmp9_);
		_g_object_unref0 (_tmp9_);
	}
	_tmp10_ = service_config;
	_tmp11_ = geary_service_information_get_remember_password (service);
	_tmp12_ = _tmp11_;
	geary_service_information_set_remember_password (service, geary_config_file_group_get_bool (_tmp10_, ACCOUNTS_SERVICE_CONFIG_V1_REMEMBER_PASSWORD, _tmp12_));
	_tmp13_ = geary_account_information_get_service_provider (account);
	_tmp14_ = _tmp13_;
	if (_tmp14_ == GEARY_SERVICE_PROVIDER_OTHER) {
		gchar* _tmp15_ = NULL;
		GearyConfigFileGroup* _tmp16_;
		gchar* _tmp17_;
		GearyConfigFileGroup* _tmp18_;
		guint16 _tmp19_;
		guint16 _tmp20_;
		GearyTlsNegotiationMethod _tmp21_ = 0;
		GearyConfigFileGroup* _tmp22_;
		gpointer _tmp23_;
		GearyCredentialsRequirement _tmp24_ = 0;
		GearyConfigFileGroup* _tmp25_;
		gpointer _tmp26_;
		guint16 _tmp27_;
		guint16 _tmp28_;
		_tmp16_ = service_config;
		_tmp17_ = geary_config_file_group_get_required_string (_tmp16_, ACCOUNTS_SERVICE_CONFIG_V1_HOST, &_inner_error0_);
		_tmp15_ = _tmp17_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if ((_inner_error0_->domain == ACCOUNTS_CONFIG_ERROR) || (_inner_error0_->domain == G_KEY_FILE_ERROR)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (login);
				_geary_config_file_group_unref0 (service_config);
				return;
			} else {
				_g_free0 (login);
				_geary_config_file_group_unref0 (service_config);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		geary_service_information_set_host (service, _tmp15_);
		_tmp18_ = service_config;
		_tmp19_ = geary_service_information_get_port (service);
		_tmp20_ = _tmp19_;
		geary_service_information_set_port (service, (guint16) geary_config_file_group_get_int (_tmp18_, ACCOUNTS_SERVICE_CONFIG_V1_PORT, (gint) _tmp20_));
		_tmp22_ = service_config;
		_tmp23_ = geary_config_file_group_parse_required_value (_tmp22_, GEARY_TYPE_TLS_NEGOTIATION_METHOD, NULL, NULL, ACCOUNTS_SERVICE_CONFIG_V1_SECURITY, ____lambda49__geary_config_file_parser, self, &_inner_error0_);
		_tmp21_ = (GearyTlsNegotiationMethod) ((gintptr) _tmp23_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if ((_inner_error0_->domain == ACCOUNTS_CONFIG_ERROR) || (_inner_error0_->domain == G_KEY_FILE_ERROR)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (_tmp15_);
				_g_free0 (login);
				_geary_config_file_group_unref0 (service_config);
				return;
			} else {
				_g_free0 (_tmp15_);
				_g_free0 (login);
				_geary_config_file_group_unref0 (service_config);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		geary_service_information_set_transport_security (service, _tmp21_);
		_tmp25_ = service_config;
		_tmp26_ = geary_config_file_group_parse_required_value (_tmp25_, GEARY_CREDENTIALS_TYPE_REQUIREMENT, NULL, NULL, ACCOUNTS_SERVICE_CONFIG_V1_CREDENTIALS, ____lambda50__geary_config_file_parser, self, &_inner_error0_);
		_tmp24_ = (GearyCredentialsRequirement) ((gintptr) _tmp26_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if ((_inner_error0_->domain == ACCOUNTS_CONFIG_ERROR) || (_inner_error0_->domain == G_KEY_FILE_ERROR)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (_tmp15_);
				_g_free0 (login);
				_geary_config_file_group_unref0 (service_config);
				return;
			} else {
				_g_free0 (_tmp15_);
				_g_free0 (login);
				_geary_config_file_group_unref0 (service_config);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		geary_service_information_set_credentials_requirement (service, _tmp24_);
		_tmp27_ = geary_service_information_get_port (service);
		_tmp28_ = _tmp27_;
		if (((gint) _tmp28_) == 0) {
			geary_service_information_set_port (service, geary_service_information_get_default_port (service));
		}
		_g_free0 (_tmp15_);
	}
	_g_free0 (login);
	_geary_config_file_group_unref0 (service_config);
}

/** Saves an service to a config file. */
static void
accounts_service_config_v1_real_save (AccountsServiceConfig* base,
                                      GearyAccountInformation* account,
                                      GearyServiceInformation* service,
                                      GearyConfigFile* config)
{
	AccountsServiceConfigV1 * self;
	const gchar* _tmp0_ = NULL;
	GearyProtocol _tmp1_;
	GearyProtocol _tmp2_;
	GearyConfigFileGroup* service_config = NULL;
	GearyConfigFileGroup* _tmp3_;
	GearyCredentials* _tmp4_;
	GearyCredentials* _tmp5_;
	GearyConfigFileGroup* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GearyServiceProvider _tmp14_;
	GearyServiceProvider _tmp15_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, ACCOUNTS_TYPE_SERVICE_CONFIG_V1, AccountsServiceConfigV1);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (service, GEARY_TYPE_SERVICE_INFORMATION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (config, GEARY_TYPE_CONFIG_FILE));
	_tmp1_ = geary_service_information_get_protocol (service);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == GEARY_PROTOCOL_IMAP) {
		_tmp0_ = ACCOUNTS_SERVICE_CONFIG_V1_GROUP_INCOMING;
	} else {
		_tmp0_ = ACCOUNTS_SERVICE_CONFIG_V1_GROUP_OUTGOING;
	}
	_tmp3_ = geary_config_file_get_group (config, _tmp0_);
	service_config = _tmp3_;
	_tmp4_ = geary_service_information_get_credentials (service);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		GearyConfigFileGroup* _tmp6_;
		GearyCredentials* _tmp7_;
		GearyCredentials* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp6_ = service_config;
		_tmp7_ = geary_service_information_get_credentials (service);
		_tmp8_ = _tmp7_;
		_tmp9_ = geary_credentials_get_user (_tmp8_);
		_tmp10_ = _tmp9_;
		geary_config_file_group_set_string (_tmp6_, ACCOUNTS_SERVICE_CONFIG_V1_LOGIN, _tmp10_);
	}
	_tmp11_ = service_config;
	_tmp12_ = geary_service_information_get_remember_password (service);
	_tmp13_ = _tmp12_;
	geary_config_file_group_set_bool (_tmp11_, ACCOUNTS_SERVICE_CONFIG_V1_REMEMBER_PASSWORD, _tmp13_);
	_tmp14_ = geary_account_information_get_service_provider (account);
	_tmp15_ = _tmp14_;
	if (_tmp15_ == GEARY_SERVICE_PROVIDER_OTHER) {
		GearyConfigFileGroup* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		GearyConfigFileGroup* _tmp19_;
		guint16 _tmp20_;
		guint16 _tmp21_;
		GearyConfigFileGroup* _tmp22_;
		GearyTlsNegotiationMethod _tmp23_;
		GearyTlsNegotiationMethod _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		GearyConfigFileGroup* _tmp27_;
		GearyCredentialsRequirement _tmp28_;
		GearyCredentialsRequirement _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp16_ = service_config;
		_tmp17_ = geary_service_information_get_host (service);
		_tmp18_ = _tmp17_;
		geary_config_file_group_set_string (_tmp16_, ACCOUNTS_SERVICE_CONFIG_V1_HOST, _tmp18_);
		_tmp19_ = service_config;
		_tmp20_ = geary_service_information_get_port (service);
		_tmp21_ = _tmp20_;
		geary_config_file_group_set_int (_tmp19_, ACCOUNTS_SERVICE_CONFIG_V1_PORT, (gint) _tmp21_);
		_tmp22_ = service_config;
		_tmp23_ = geary_service_information_get_transport_security (service);
		_tmp24_ = _tmp23_;
		_tmp25_ = geary_tls_negotiation_method_to_value (_tmp24_);
		_tmp26_ = _tmp25_;
		geary_config_file_group_set_string (_tmp22_, ACCOUNTS_SERVICE_CONFIG_V1_SECURITY, _tmp26_);
		_g_free0 (_tmp26_);
		_tmp27_ = service_config;
		_tmp28_ = geary_service_information_get_credentials_requirement (service);
		_tmp29_ = _tmp28_;
		_tmp30_ = geary_credentials_requirement_to_value (_tmp29_);
		_tmp31_ = _tmp30_;
		geary_config_file_group_set_string (_tmp27_, ACCOUNTS_SERVICE_CONFIG_V1_CREDENTIALS, _tmp31_);
		_g_free0 (_tmp31_);
	}
	_geary_config_file_group_unref0 (service_config);
}

AccountsServiceConfigV1*
accounts_service_config_v1_construct (GType object_type)
{
	AccountsServiceConfigV1 * self = NULL;
	self = (AccountsServiceConfigV1*) g_object_new (object_type, NULL);
	return self;
}

AccountsServiceConfigV1*
accounts_service_config_v1_new (void)
{
	return accounts_service_config_v1_construct (ACCOUNTS_TYPE_SERVICE_CONFIG_V1);
}

static void
accounts_service_config_v1_class_init (AccountsServiceConfigV1Class * klass,
                                       gpointer klass_data)
{
	accounts_service_config_v1_parent_class = g_type_class_peek_parent (klass);
}

static void
accounts_service_config_v1_accounts_service_config_interface_init (AccountsServiceConfigIface * iface,
                                                                   gpointer iface_data)
{
	accounts_service_config_v1_accounts_service_config_parent_iface = g_type_interface_peek_parent (iface);
	iface->load = (void (*) (AccountsServiceConfig*, GearyConfigFile*, GearyAccountInformation*, GearyServiceInformation*, GError**)) accounts_service_config_v1_real_load;
	iface->save = (void (*) (AccountsServiceConfig*, GearyAccountInformation*, GearyServiceInformation*, GearyConfigFile*)) accounts_service_config_v1_real_save;
}

static void
accounts_service_config_v1_instance_init (AccountsServiceConfigV1 * self,
                                          gpointer klass)
{
}

/**
 * Manages persistence for version 1 service configuration.
 */
static GType
accounts_service_config_v1_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AccountsServiceConfigV1Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) accounts_service_config_v1_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AccountsServiceConfigV1), 0, (GInstanceInitFunc) accounts_service_config_v1_instance_init, NULL };
	static const GInterfaceInfo accounts_service_config_info = { (GInterfaceInitFunc) accounts_service_config_v1_accounts_service_config_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType accounts_service_config_v1_type_id;
	accounts_service_config_v1_type_id = g_type_register_static (G_TYPE_OBJECT, "AccountsServiceConfigV1", &g_define_type_info, 0);
	g_type_add_interface_static (accounts_service_config_v1_type_id, ACCOUNTS_TYPE_SERVICE_CONFIG, &accounts_service_config_info);
	return accounts_service_config_v1_type_id;
}

GType
accounts_service_config_v1_get_type (void)
{
	static volatile gsize accounts_service_config_v1_type_id__once = 0;
	if (g_once_init_enter (&accounts_service_config_v1_type_id__once)) {
		GType accounts_service_config_v1_type_id;
		accounts_service_config_v1_type_id = accounts_service_config_v1_get_type_once ();
		g_once_init_leave (&accounts_service_config_v1_type_id__once, accounts_service_config_v1_type_id);
	}
	return accounts_service_config_v1_type_id__once;
}

/** Loads a supported service from a config file. */
static void
accounts_service_config_legacy_real_load (AccountsServiceConfig* base,
                                          GearyConfigFile* config,
                                          GearyAccountInformation* account,
                                          GearyServiceInformation* service,
                                          GError** error)
{
	AccountsServiceConfigLegacy * self;
	GearyConfigFileGroup* service_config = NULL;
	GearyConfigFileGroup* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GearyProtocol _tmp2_;
	GearyProtocol _tmp3_;
	gchar* prefix = NULL;
	gchar* _tmp4_;
	gchar* login = NULL;
	GearyConfigFileGroup* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GearyRFC822MailboxAddress* _tmp9_;
	GearyRFC822MailboxAddress* _tmp10_;
	GearyRFC822MailboxAddress* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	GearyConfigFileGroup* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	GearyServiceProvider _tmp26_;
	GearyServiceProvider _tmp27_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, ACCOUNTS_TYPE_SERVICE_CONFIG_LEGACY, AccountsServiceConfigLegacy);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (config, GEARY_TYPE_CONFIG_FILE));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (service, GEARY_TYPE_SERVICE_INFORMATION));
	_tmp0_ = geary_config_file_get_group (config, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_GROUP);
	service_config = _tmp0_;
	_tmp2_ = geary_service_information_get_protocol (service);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == GEARY_PROTOCOL_IMAP) {
		_tmp1_ = "imap_";
	} else {
		_tmp1_ = "smtp_";
	}
	_tmp4_ = g_strdup (_tmp1_);
	prefix = _tmp4_;
	_tmp5_ = service_config;
	_tmp6_ = prefix;
	_tmp7_ = g_strconcat (_tmp6_, ACCOUNTS_SERVICE_CONFIG_LEGACY_USERNAME, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = geary_account_information_get_primary_mailbox (account);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp12_ = geary_rf_c822_mailbox_address_get_address (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = geary_config_file_group_get_string (_tmp5_, _tmp8_, _tmp13_);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (_tmp11_);
	_g_free0 (_tmp8_);
	login = _tmp15_;
	_tmp16_ = login;
	if (_tmp16_ != NULL) {
		const gchar* _tmp17_;
		GearyCredentials* _tmp18_;
		GearyCredentials* _tmp19_;
		_tmp17_ = login;
		_tmp18_ = geary_credentials_new (GEARY_CREDENTIALS_METHOD_PASSWORD, _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		geary_service_information_set_credentials (service, _tmp19_);
		_g_object_unref0 (_tmp19_);
	}
	_tmp20_ = service_config;
	_tmp21_ = prefix;
	_tmp22_ = g_strconcat (_tmp21_, ACCOUNTS_SERVICE_CONFIG_LEGACY_REMEMBER_PASSWORD, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = geary_service_information_get_remember_password (service);
	_tmp25_ = _tmp24_;
	geary_service_information_set_remember_password (service, geary_config_file_group_get_bool (_tmp20_, _tmp23_, _tmp25_));
	_g_free0 (_tmp23_);
	_tmp26_ = geary_account_information_get_service_provider (account);
	_tmp27_ = _tmp26_;
	if (_tmp27_ == GEARY_SERVICE_PROVIDER_OTHER) {
		GearyConfigFileGroup* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		GearyConfigFileGroup* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		guint16 _tmp40_;
		guint16 _tmp41_;
		gboolean use_tls = FALSE;
		GearyConfigFileGroup* _tmp42_;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		GearyProtocol _tmp46_;
		GearyProtocol _tmp47_;
		gboolean _tmp48_;
		gboolean use_starttls = FALSE;
		GearyConfigFileGroup* _tmp49_;
		const gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		gboolean _tmp53_;
		GearyProtocol _tmp54_;
		GearyProtocol _tmp55_;
		_tmp28_ = service_config;
		_tmp29_ = prefix;
		_tmp30_ = g_strconcat (_tmp29_, ACCOUNTS_SERVICE_CONFIG_LEGACY_HOST, NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = geary_service_information_get_host (service);
		_tmp33_ = _tmp32_;
		_tmp34_ = geary_config_file_group_get_string (_tmp28_, _tmp31_, _tmp33_);
		_tmp35_ = _tmp34_;
		geary_service_information_set_host (service, _tmp35_);
		_g_free0 (_tmp35_);
		_g_free0 (_tmp31_);
		_tmp36_ = service_config;
		_tmp37_ = prefix;
		_tmp38_ = g_strconcat (_tmp37_, ACCOUNTS_SERVICE_CONFIG_LEGACY_PORT, NULL);
		_tmp39_ = _tmp38_;
		_tmp40_ = geary_service_information_get_port (service);
		_tmp41_ = _tmp40_;
		geary_service_information_set_port (service, (guint16) geary_config_file_group_get_int (_tmp36_, _tmp39_, (gint) _tmp41_));
		_g_free0 (_tmp39_);
		_tmp42_ = service_config;
		_tmp43_ = prefix;
		_tmp44_ = g_strconcat (_tmp43_, ACCOUNTS_SERVICE_CONFIG_LEGACY_SSL, NULL);
		_tmp45_ = _tmp44_;
		_tmp46_ = geary_service_information_get_protocol (service);
		_tmp47_ = _tmp46_;
		_tmp48_ = geary_config_file_group_get_bool (_tmp42_, _tmp45_, _tmp47_ == GEARY_PROTOCOL_IMAP);
		_g_free0 (_tmp45_);
		use_tls = _tmp48_;
		_tmp49_ = service_config;
		_tmp50_ = prefix;
		_tmp51_ = g_strconcat (_tmp50_, ACCOUNTS_SERVICE_CONFIG_LEGACY_STARTTLS, NULL);
		_tmp52_ = _tmp51_;
		_tmp53_ = geary_config_file_group_get_bool (_tmp49_, _tmp52_, TRUE);
		_g_free0 (_tmp52_);
		use_starttls = _tmp53_;
		if (use_tls) {
			geary_service_information_set_transport_security (service, GEARY_TLS_NEGOTIATION_METHOD_TRANSPORT);
		} else {
			if (use_starttls) {
				geary_service_information_set_transport_security (service, GEARY_TLS_NEGOTIATION_METHOD_START_TLS);
			} else {
				geary_service_information_set_transport_security (service, GEARY_TLS_NEGOTIATION_METHOD_NONE);
			}
		}
		_tmp54_ = geary_service_information_get_protocol (service);
		_tmp55_ = _tmp54_;
		if (_tmp55_ == GEARY_PROTOCOL_SMTP) {
			gboolean use_imap = FALSE;
			GearyConfigFileGroup* _tmp56_;
			GearyCredentials* _tmp57_;
			GearyCredentials* _tmp58_;
			gboolean no_auth = FALSE;
			GearyConfigFileGroup* _tmp59_;
			_tmp56_ = service_config;
			_tmp57_ = geary_service_information_get_credentials (service);
			_tmp58_ = _tmp57_;
			use_imap = geary_config_file_group_get_bool (_tmp56_, ACCOUNTS_SERVICE_CONFIG_LEGACY_SMTP_USE_IMAP_CREDENTIALS, _tmp58_ != NULL);
			_tmp59_ = service_config;
			no_auth = geary_config_file_group_get_bool (_tmp59_, ACCOUNTS_SERVICE_CONFIG_LEGACY_SMTP_NOAUTH, FALSE);
			if (use_imap) {
				geary_service_information_set_credentials_requirement (service, GEARY_CREDENTIALS_REQUIREMENT_USE_INCOMING);
			} else {
				if (!no_auth) {
					geary_service_information_set_credentials_requirement (service, GEARY_CREDENTIALS_REQUIREMENT_CUSTOM);
				} else {
					geary_service_information_set_credentials_requirement (service, GEARY_CREDENTIALS_REQUIREMENT_NONE);
				}
			}
		}
	}
	_g_free0 (login);
	_g_free0 (prefix);
	_geary_config_file_group_unref0 (service_config);
}

/** Saves an service to a config file. */
static void
accounts_service_config_legacy_real_save (AccountsServiceConfig* base,
                                          GearyAccountInformation* account,
                                          GearyServiceInformation* service,
                                          GearyConfigFile* config)
{
	AccountsServiceConfigLegacy * self;
	GearyConfigFileGroup* service_config = NULL;
	GearyConfigFileGroup* _tmp0_;
	gchar* prefix = NULL;
	GearyProtocol _tmp1_;
	GearyProtocol _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GearyCredentials* _tmp9_;
	GearyCredentials* _tmp10_;
	GearyConfigFileGroup* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	GearyServiceProvider _tmp25_;
	GearyServiceProvider _tmp26_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, ACCOUNTS_TYPE_SERVICE_CONFIG_LEGACY, AccountsServiceConfigLegacy);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (service, GEARY_TYPE_SERVICE_INFORMATION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (config, GEARY_TYPE_CONFIG_FILE));
	_tmp0_ = geary_config_file_get_group (config, ACCOUNTS_ACCOUNT_CONFIG_LEGACY_GROUP);
	service_config = _tmp0_;
	_tmp1_ = geary_service_information_get_protocol (service);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_protocol_to_value (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_ascii_strdown (_tmp4_, (gssize) -1);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp6_, "_", NULL);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	prefix = _tmp8_;
	_tmp9_ = geary_service_information_get_credentials (service);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		GearyConfigFileGroup* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GearyCredentials* _tmp15_;
		GearyCredentials* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp11_ = service_config;
		_tmp12_ = prefix;
		_tmp13_ = g_strconcat (_tmp12_, ACCOUNTS_SERVICE_CONFIG_LEGACY_USERNAME, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = geary_service_information_get_credentials (service);
		_tmp16_ = _tmp15_;
		_tmp17_ = geary_credentials_get_user (_tmp16_);
		_tmp18_ = _tmp17_;
		geary_config_file_group_set_string (_tmp11_, _tmp14_, _tmp18_);
		_g_free0 (_tmp14_);
	}
	_tmp19_ = service_config;
	_tmp20_ = prefix;
	_tmp21_ = g_strconcat (_tmp20_, ACCOUNTS_SERVICE_CONFIG_LEGACY_REMEMBER_PASSWORD, NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = geary_service_information_get_remember_password (service);
	_tmp24_ = _tmp23_;
	geary_config_file_group_set_bool (_tmp19_, _tmp22_, _tmp24_);
	_g_free0 (_tmp22_);
	_tmp25_ = geary_account_information_get_service_provider (account);
	_tmp26_ = _tmp25_;
	if (_tmp26_ == GEARY_SERVICE_PROVIDER_OTHER) {
		GearyConfigFileGroup* _tmp27_;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		GearyConfigFileGroup* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		guint16 _tmp37_;
		guint16 _tmp38_;
		GearyTlsNegotiationMethod _tmp39_;
		GearyTlsNegotiationMethod _tmp40_;
		GearyProtocol _tmp65_;
		GearyProtocol _tmp66_;
		_tmp27_ = service_config;
		_tmp28_ = prefix;
		_tmp29_ = g_strconcat (_tmp28_, ACCOUNTS_SERVICE_CONFIG_LEGACY_HOST, NULL);
		_tmp30_ = _tmp29_;
		_tmp31_ = geary_service_information_get_host (service);
		_tmp32_ = _tmp31_;
		geary_config_file_group_set_string (_tmp27_, _tmp30_, _tmp32_);
		_g_free0 (_tmp30_);
		_tmp33_ = service_config;
		_tmp34_ = prefix;
		_tmp35_ = g_strconcat (_tmp34_, ACCOUNTS_SERVICE_CONFIG_LEGACY_PORT, NULL);
		_tmp36_ = _tmp35_;
		_tmp37_ = geary_service_information_get_port (service);
		_tmp38_ = _tmp37_;
		geary_config_file_group_set_int (_tmp33_, _tmp36_, (gint) _tmp38_);
		_g_free0 (_tmp36_);
		_tmp39_ = geary_service_information_get_transport_security (service);
		_tmp40_ = _tmp39_;
		switch (_tmp40_) {
			case GEARY_TLS_NEGOTIATION_METHOD_NONE:
			{
				GearyConfigFileGroup* _tmp41_;
				const gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				GearyConfigFileGroup* _tmp45_;
				const gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				_tmp41_ = service_config;
				_tmp42_ = prefix;
				_tmp43_ = g_strconcat (_tmp42_, ACCOUNTS_SERVICE_CONFIG_LEGACY_SSL, NULL);
				_tmp44_ = _tmp43_;
				geary_config_file_group_set_bool (_tmp41_, _tmp44_, FALSE);
				_g_free0 (_tmp44_);
				_tmp45_ = service_config;
				_tmp46_ = prefix;
				_tmp47_ = g_strconcat (_tmp46_, ACCOUNTS_SERVICE_CONFIG_LEGACY_STARTTLS, NULL);
				_tmp48_ = _tmp47_;
				geary_config_file_group_set_bool (_tmp45_, _tmp48_, FALSE);
				_g_free0 (_tmp48_);
				break;
			}
			case GEARY_TLS_NEGOTIATION_METHOD_START_TLS:
			{
				GearyConfigFileGroup* _tmp49_;
				const gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				GearyConfigFileGroup* _tmp53_;
				const gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
				_tmp49_ = service_config;
				_tmp50_ = prefix;
				_tmp51_ = g_strconcat (_tmp50_, ACCOUNTS_SERVICE_CONFIG_LEGACY_SSL, NULL);
				_tmp52_ = _tmp51_;
				geary_config_file_group_set_bool (_tmp49_, _tmp52_, FALSE);
				_g_free0 (_tmp52_);
				_tmp53_ = service_config;
				_tmp54_ = prefix;
				_tmp55_ = g_strconcat (_tmp54_, ACCOUNTS_SERVICE_CONFIG_LEGACY_STARTTLS, NULL);
				_tmp56_ = _tmp55_;
				geary_config_file_group_set_bool (_tmp53_, _tmp56_, TRUE);
				_g_free0 (_tmp56_);
				break;
			}
			case GEARY_TLS_NEGOTIATION_METHOD_TRANSPORT:
			{
				GearyConfigFileGroup* _tmp57_;
				const gchar* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				GearyConfigFileGroup* _tmp61_;
				const gchar* _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				_tmp57_ = service_config;
				_tmp58_ = prefix;
				_tmp59_ = g_strconcat (_tmp58_, ACCOUNTS_SERVICE_CONFIG_LEGACY_SSL, NULL);
				_tmp60_ = _tmp59_;
				geary_config_file_group_set_bool (_tmp57_, _tmp60_, TRUE);
				_g_free0 (_tmp60_);
				_tmp61_ = service_config;
				_tmp62_ = prefix;
				_tmp63_ = g_strconcat (_tmp62_, ACCOUNTS_SERVICE_CONFIG_LEGACY_STARTTLS, NULL);
				_tmp64_ = _tmp63_;
				geary_config_file_group_set_bool (_tmp61_, _tmp64_, FALSE);
				_g_free0 (_tmp64_);
				break;
			}
			default:
			break;
		}
		_tmp65_ = geary_service_information_get_protocol (service);
		_tmp66_ = _tmp65_;
		if (_tmp66_ == GEARY_PROTOCOL_SMTP) {
			GearyCredentialsRequirement _tmp67_;
			GearyCredentialsRequirement _tmp68_;
			_tmp67_ = geary_service_information_get_credentials_requirement (service);
			_tmp68_ = _tmp67_;
			switch (_tmp68_) {
				case GEARY_CREDENTIALS_REQUIREMENT_NONE:
				{
					GearyConfigFileGroup* _tmp69_;
					GearyConfigFileGroup* _tmp70_;
					_tmp69_ = service_config;
					geary_config_file_group_set_bool (_tmp69_, ACCOUNTS_SERVICE_CONFIG_LEGACY_SMTP_USE_IMAP_CREDENTIALS, FALSE);
					_tmp70_ = service_config;
					geary_config_file_group_set_bool (_tmp70_, ACCOUNTS_SERVICE_CONFIG_LEGACY_SMTP_NOAUTH, TRUE);
					break;
				}
				case GEARY_CREDENTIALS_REQUIREMENT_USE_INCOMING:
				{
					GearyConfigFileGroup* _tmp71_;
					GearyConfigFileGroup* _tmp72_;
					_tmp71_ = service_config;
					geary_config_file_group_set_bool (_tmp71_, ACCOUNTS_SERVICE_CONFIG_LEGACY_SMTP_USE_IMAP_CREDENTIALS, TRUE);
					_tmp72_ = service_config;
					geary_config_file_group_set_bool (_tmp72_, ACCOUNTS_SERVICE_CONFIG_LEGACY_SMTP_NOAUTH, FALSE);
					break;
				}
				case GEARY_CREDENTIALS_REQUIREMENT_CUSTOM:
				{
					GearyConfigFileGroup* _tmp73_;
					GearyConfigFileGroup* _tmp74_;
					_tmp73_ = service_config;
					geary_config_file_group_set_bool (_tmp73_, ACCOUNTS_SERVICE_CONFIG_LEGACY_SMTP_USE_IMAP_CREDENTIALS, FALSE);
					_tmp74_ = service_config;
					geary_config_file_group_set_bool (_tmp74_, ACCOUNTS_SERVICE_CONFIG_LEGACY_SMTP_NOAUTH, FALSE);
					break;
				}
				default:
				break;
			}
		}
	}
	_g_free0 (prefix);
	_geary_config_file_group_unref0 (service_config);
}

AccountsServiceConfigLegacy*
accounts_service_config_legacy_construct (GType object_type)
{
	AccountsServiceConfigLegacy * self = NULL;
	self = (AccountsServiceConfigLegacy*) g_object_new (object_type, NULL);
	return self;
}

AccountsServiceConfigLegacy*
accounts_service_config_legacy_new (void)
{
	return accounts_service_config_legacy_construct (ACCOUNTS_TYPE_SERVICE_CONFIG_LEGACY);
}

static void
accounts_service_config_legacy_class_init (AccountsServiceConfigLegacyClass * klass,
                                           gpointer klass_data)
{
	accounts_service_config_legacy_parent_class = g_type_class_peek_parent (klass);
}

static void
accounts_service_config_legacy_accounts_service_config_interface_init (AccountsServiceConfigIface * iface,
                                                                       gpointer iface_data)
{
	accounts_service_config_legacy_accounts_service_config_parent_iface = g_type_interface_peek_parent (iface);
	iface->load = (void (*) (AccountsServiceConfig*, GearyConfigFile*, GearyAccountInformation*, GearyServiceInformation*, GError**)) accounts_service_config_legacy_real_load;
	iface->save = (void (*) (AccountsServiceConfig*, GearyAccountInformation*, GearyServiceInformation*, GearyConfigFile*)) accounts_service_config_legacy_real_save;
}

static void
accounts_service_config_legacy_instance_init (AccountsServiceConfigLegacy * self,
                                              gpointer klass)
{
}

/**
 * Manages persistence for un-versioned service configuration.
 */
static GType
accounts_service_config_legacy_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AccountsServiceConfigLegacyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) accounts_service_config_legacy_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AccountsServiceConfigLegacy), 0, (GInstanceInitFunc) accounts_service_config_legacy_instance_init, NULL };
	static const GInterfaceInfo accounts_service_config_info = { (GInterfaceInitFunc) accounts_service_config_legacy_accounts_service_config_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType accounts_service_config_legacy_type_id;
	accounts_service_config_legacy_type_id = g_type_register_static (G_TYPE_OBJECT, "AccountsServiceConfigLegacy", &g_define_type_info, 0);
	g_type_add_interface_static (accounts_service_config_legacy_type_id, ACCOUNTS_TYPE_SERVICE_CONFIG, &accounts_service_config_info);
	return accounts_service_config_legacy_type_id;
}

GType
accounts_service_config_legacy_get_type (void)
{
	static volatile gsize accounts_service_config_legacy_type_id__once = 0;
	if (g_once_init_enter (&accounts_service_config_legacy_type_id__once)) {
		GType accounts_service_config_legacy_type_id;
		accounts_service_config_legacy_type_id = accounts_service_config_legacy_get_type_once ();
		g_once_init_leave (&accounts_service_config_legacy_type_id__once, accounts_service_config_legacy_type_id);
	}
	return accounts_service_config_legacy_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

