/* imap-capabilities.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-capabilities.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

enum  {
	GEARY_IMAP_CAPABILITIES_0_PROPERTY,
	GEARY_IMAP_CAPABILITIES_REVISION_PROPERTY,
	GEARY_IMAP_CAPABILITIES_NUM_PROPERTIES
};
static GParamSpec* geary_imap_capabilities_properties[GEARY_IMAP_CAPABILITIES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GearyImapCapabilitiesPrivate {
	gint _revision;
};

static gint GearyImapCapabilities_private_offset;
static gpointer geary_imap_capabilities_parent_class = NULL;

static void geary_imap_capabilities_set_revision (GearyImapCapabilities* self,
                                           gint value);
static gchar* geary_imap_capabilities_real_to_string (GearyGenericCapabilities* base);
static void geary_imap_capabilities_finalize (GObject * obj);
static GType geary_imap_capabilities_get_type_once (void);
static void _vala_geary_imap_capabilities_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_geary_imap_capabilities_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
geary_imap_capabilities_get_instance_private (GearyImapCapabilities* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapCapabilities_private_offset);
}

gint
geary_imap_capabilities_get_revision (GearyImapCapabilities* self)
{
	gint result;
	g_return_val_if_fail (GEARY_IMAP_IS_CAPABILITIES (self), 0);
	result = self->priv->_revision;
	return result;
}

static void
geary_imap_capabilities_set_revision (GearyImapCapabilities* self,
                                      gint value)
{
	gint old_value;
	g_return_if_fail (GEARY_IMAP_IS_CAPABILITIES (self));
	old_value = geary_imap_capabilities_get_revision (self);
	if (old_value != value) {
		self->priv->_revision = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_capabilities_properties[GEARY_IMAP_CAPABILITIES_REVISION_PROPERTY]);
	}
}

/**
     * Creates an empty set of capabilities.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyImapCapabilities*
geary_imap_capabilities_construct (GType object_type,
                                   GearyImapStringParameter** capabilities,
                                   gint capabilities_length1,
                                   gint revision)
{
	GearyImapCapabilities * self = NULL;
	self = (GearyImapCapabilities*) geary_imap_capabilities_construct_empty (object_type, revision);
	{
		GearyImapStringParameter** cap_collection = NULL;
		gint cap_collection_length1 = 0;
		gint _cap_collection_size_ = 0;
		gint cap_it = 0;
		cap_collection = capabilities;
		cap_collection_length1 = capabilities_length1;
		for (cap_it = 0; cap_it < cap_collection_length1; cap_it = cap_it + 1) {
			GearyImapStringParameter* _tmp0_;
			GearyImapStringParameter* cap = NULL;
			_tmp0_ = _g_object_ref0 (cap_collection[cap_it]);
			cap = _tmp0_;
			{
				GearyImapStringParameter* _tmp1_;
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				_tmp1_ = cap;
				_tmp2_ = geary_imap_string_parameter_get_ascii (_tmp1_);
				_tmp3_ = _tmp2_;
				geary_generic_capabilities_parse_and_add_capability (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_GENERIC_CAPABILITIES, GearyGenericCapabilities), _tmp3_);
				_g_object_unref0 (cap);
			}
		}
	}
	return self;
}

GearyImapCapabilities*
geary_imap_capabilities_new (GearyImapStringParameter** capabilities,
                             gint capabilities_length1,
                             gint revision)
{
	return geary_imap_capabilities_construct (GEARY_IMAP_TYPE_CAPABILITIES, capabilities, capabilities_length1, revision);
}

/**
     * Creates an empty set of capabilities.
     */
GearyImapCapabilities*
geary_imap_capabilities_construct_empty (GType object_type,
                                         gint revision)
{
	GearyImapCapabilities * self = NULL;
	self = (GearyImapCapabilities*) geary_generic_capabilities_construct (object_type, GEARY_IMAP_CAPABILITIES_NAME_SEPARATOR, GEARY_IMAP_CAPABILITIES_VALUE_SEPARATOR);
	geary_imap_capabilities_set_revision (self, revision);
	return self;
}

GearyImapCapabilities*
geary_imap_capabilities_new_empty (gint revision)
{
	return geary_imap_capabilities_construct_empty (GEARY_IMAP_TYPE_CAPABILITIES, revision);
}

static gchar*
geary_imap_capabilities_real_to_string (GearyGenericCapabilities* base)
{
	GearyImapCapabilities * self;
	gint _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_CAPABILITIES, GearyImapCapabilities);
	_tmp0_ = self->priv->_revision;
	_tmp1_ = GEARY_GENERIC_CAPABILITIES_CLASS (geary_imap_capabilities_parent_class)->to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_GENERIC_CAPABILITIES, GearyGenericCapabilities));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("#%d: %s", _tmp0_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

/**
     * Indicates an IMAP session reported support for IMAP 4rev1.
     *
     * See [[https://tools.ietf.org/html/rfc2177]]
     */
gboolean
geary_imap_capabilities_supports_imap4rev1 (GearyImapCapabilities* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_CAPABILITIES (self), FALSE);
	result = geary_generic_capabilities_has_capability (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_GENERIC_CAPABILITIES, GearyGenericCapabilities), GEARY_IMAP_CAPABILITIES_IMAP4REV1);
	return result;
}

/**
     * Indicates the {@link ClientSession} reported support for IDLE.
     *
     * See [[https://tools.ietf.org/html/rfc2177]]
     */
gboolean
geary_imap_capabilities_supports_idle (GearyImapCapabilities* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_CAPABILITIES (self), FALSE);
	result = geary_generic_capabilities_has_capability (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_GENERIC_CAPABILITIES, GearyGenericCapabilities), GEARY_IMAP_CAPABILITIES_IDLE);
	return result;
}

/**
     * Indicates the {@link ClientSession} reported support for UIDPLUS.
     *
     * See [[https://tools.ietf.org/html/rfc4315]]
     */
gboolean
geary_imap_capabilities_supports_uidplus (GearyImapCapabilities* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_CAPABILITIES (self), FALSE);
	result = geary_generic_capabilities_has_capability (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_GENERIC_CAPABILITIES, GearyGenericCapabilities), GEARY_IMAP_CAPABILITIES_UIDPLUS);
	return result;
}

/**
     * Indicates the {@link ClientSession} reported support for SPECIAL-USE.
     *
     * See [[https://tools.ietf.org/html/rfc6154]]
     */
gboolean
geary_imap_capabilities_supports_special_use (GearyImapCapabilities* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_CAPABILITIES (self), FALSE);
	result = geary_generic_capabilities_has_capability (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_GENERIC_CAPABILITIES, GearyGenericCapabilities), GEARY_IMAP_CAPABILITIES_SPECIAL_USE);
	return result;
}

static void
geary_imap_capabilities_class_init (GearyImapCapabilitiesClass * klass,
                                    gpointer klass_data)
{
	geary_imap_capabilities_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapCapabilities_private_offset);
	((GearyGenericCapabilitiesClass *) klass)->to_string = (gchar* (*) (GearyGenericCapabilities*)) geary_imap_capabilities_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_capabilities_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_capabilities_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_capabilities_finalize;
	/**
	     * The version of this set of capabilities for an IMAP session.
	     *
	     * The capabilities that an IMAP session offers changes over time,
	     * for example after login or STARTTLS. This property supports
	     * detecting these changes.
	     *
	     * @see ClientSession.capabilities
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_CAPABILITIES_REVISION_PROPERTY, geary_imap_capabilities_properties[GEARY_IMAP_CAPABILITIES_REVISION_PROPERTY] = g_param_spec_int ("revision", "revision", "revision", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_capabilities_instance_init (GearyImapCapabilities * self,
                                       gpointer klass)
{
	self->priv = geary_imap_capabilities_get_instance_private (self);
}

static void
geary_imap_capabilities_finalize (GObject * obj)
{
	GearyImapCapabilities * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_CAPABILITIES, GearyImapCapabilities);
	G_OBJECT_CLASS (geary_imap_capabilities_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_imap_capabilities_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapCapabilitiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_capabilities_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapCapabilities), 0, (GInstanceInitFunc) geary_imap_capabilities_instance_init, NULL };
	GType geary_imap_capabilities_type_id;
	geary_imap_capabilities_type_id = g_type_register_static (GEARY_TYPE_GENERIC_CAPABILITIES, "GearyImapCapabilities", &g_define_type_info, 0);
	GearyImapCapabilities_private_offset = g_type_add_instance_private (geary_imap_capabilities_type_id, sizeof (GearyImapCapabilitiesPrivate));
	return geary_imap_capabilities_type_id;
}

GType
geary_imap_capabilities_get_type (void)
{
	static gsize geary_imap_capabilities_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_capabilities_type_id__once)) {
		GType geary_imap_capabilities_type_id;
		geary_imap_capabilities_type_id = geary_imap_capabilities_get_type_once ();
		g_once_init_leave (&geary_imap_capabilities_type_id__once, geary_imap_capabilities_type_id);
	}
	return geary_imap_capabilities_type_id__once;
}

static void
_vala_geary_imap_capabilities_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GearyImapCapabilities * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_CAPABILITIES, GearyImapCapabilities);
	switch (property_id) {
		case GEARY_IMAP_CAPABILITIES_REVISION_PROPERTY:
		g_value_set_int (value, geary_imap_capabilities_get_revision (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_capabilities_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GearyImapCapabilities * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_CAPABILITIES, GearyImapCapabilities);
	switch (property_id) {
		case GEARY_IMAP_CAPABILITIES_REVISION_PROPERTY:
		geary_imap_capabilities_set_revision (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

