/* imap-fetch-data-specifier.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-fetch-data-specifier.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define _g_free0(var) (var = (g_free (var), NULL))

/**
 * A symbolic representation of IMAP FETCH's specifier parameter.
 *
 * Most FETCH requests can use this simple specifier to return various parts of the message.
 * More complicated requests (and requests for partial header or body sections) must use a
 * {@link FetchBodyDataSpecifier} specifier.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-6.4.5]]
 *
 * @see FetchBodyDataSpecifier
 */
gchar*
geary_imap_fetch_data_specifier_to_string (GearyImapFetchDataSpecifier self)
{
	gchar* result;
	switch (self) {
		case GEARY_IMAP_FETCH_DATA_SPECIFIER_UID:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("uid");
			result = _tmp0_;
			return result;
		}
		case GEARY_IMAP_FETCH_DATA_SPECIFIER_FLAGS:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("flags");
			result = _tmp1_;
			return result;
		}
		case GEARY_IMAP_FETCH_DATA_SPECIFIER_INTERNALDATE:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("internaldate");
			result = _tmp2_;
			return result;
		}
		case GEARY_IMAP_FETCH_DATA_SPECIFIER_ENVELOPE:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("envelope");
			result = _tmp3_;
			return result;
		}
		case GEARY_IMAP_FETCH_DATA_SPECIFIER_BODYSTRUCTURE:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("bodystructure");
			result = _tmp4_;
			return result;
		}
		case GEARY_IMAP_FETCH_DATA_SPECIFIER_BODY:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("body");
			result = _tmp5_;
			return result;
		}
		case GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("rfc822");
			result = _tmp6_;
			return result;
		}
		case GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822_HEADER:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("rfc822.header");
			result = _tmp7_;
			return result;
		}
		case GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822_SIZE:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("rfc822.size");
			result = _tmp8_;
			return result;
		}
		case GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822_TEXT:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("rfc822.text");
			result = _tmp9_;
			return result;
		}
		case GEARY_IMAP_FETCH_DATA_SPECIFIER_FAST:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("fast");
			result = _tmp10_;
			return result;
		}
		case GEARY_IMAP_FETCH_DATA_SPECIFIER_ALL:
		{
			gchar* _tmp11_;
			_tmp11_ = g_strdup ("all");
			result = _tmp11_;
			return result;
		}
		case GEARY_IMAP_FETCH_DATA_SPECIFIER_FULL:
		{
			gchar* _tmp12_;
			_tmp12_ = g_strdup ("full");
			result = _tmp12_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

/**
     * Decodes a {@link StringParameter} into a {@link FetchDataSpecifier}.
     */
GearyImapFetchDataSpecifier
geary_imap_fetch_data_specifier_from_parameter (GearyImapStringParameter* strparam,
                                                GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	static GQuark _tmp2_label11 = 0;
	static GQuark _tmp2_label12 = 0;
	GError* _inner_error0_ = NULL;
	GearyImapFetchDataSpecifier result;
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (strparam), 0);
	_tmp0_ = geary_imap_string_parameter_as_lower (strparam);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	g_free (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("uid")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_FETCH_DATA_SPECIFIER_UID;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("flags")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_FETCH_DATA_SPECIFIER_FLAGS;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("internaldate")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_FETCH_DATA_SPECIFIER_INTERNALDATE;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("envelope")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_FETCH_DATA_SPECIFIER_ENVELOPE;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("bodystructure")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_FETCH_DATA_SPECIFIER_BODYSTRUCTURE;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("body")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_FETCH_DATA_SPECIFIER_BODY;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("rfc822")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("rfc822.header")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822_HEADER;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("rfc822.size")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822_SIZE;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("rfc822.text")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822_TEXT;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("fast")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_FETCH_DATA_SPECIFIER_FAST;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("all")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_FETCH_DATA_SPECIFIER_ALL;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label12) ? _tmp2_label12 : (_tmp2_label12 = g_quark_from_static_string ("full")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_FETCH_DATA_SPECIFIER_FULL;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				gchar* _tmp5_;
				GError* _tmp6_;
				GError* _tmp7_;
				_tmp4_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (strparam, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
				_tmp5_ = _tmp4_;
				_tmp6_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_PARSE_ERROR, "\"%s\" is not a valid fetch-command data item", _tmp5_);
				_tmp7_ = _tmp6_;
				_g_free0 (_tmp5_);
				_inner_error0_ = _tmp7_;
				if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return 0;
				}
			}
		}
	}
}

/**
     * Turns this {@link FetchDataSpecifier} into a {@link StringParameter} for transmission.
     */
GearyImapStringParameter*
geary_imap_fetch_data_specifier_to_parameter (GearyImapFetchDataSpecifier self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GearyImapAtomParameter* _tmp2_;
	GearyImapStringParameter* _tmp3_;
	GearyImapStringParameter* result;
	_tmp0_ = geary_imap_fetch_data_specifier_to_string (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_imap_atom_parameter_new (_tmp1_);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter);
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

/**
     * Returns the appropriate {@link FetchDataDecoder} for this {@link FetchDataSpecifier}.
     *
     * The FetchDataDecoder can then be used to convert the associated {@link Parameter}s into
     * {@link Imap.MessageData}.
     *
     * @return null if no FetchDataDecoder is associated with this value, or an invalid value.
     */
GearyImapFetchDataDecoder*
geary_imap_fetch_data_specifier_get_decoder (GearyImapFetchDataSpecifier self,
                                             GearyImapQuirks* quirks)
{
	GearyImapFetchDataDecoder* result;
	g_return_val_if_fail (GEARY_IMAP_IS_QUIRKS (quirks), NULL);
	switch (self) {
		case GEARY_IMAP_FETCH_DATA_SPECIFIER_UID:
		{
			GearyImapUIDDecoder* _tmp0_;
			_tmp0_ = geary_imap_uid_decoder_new ();
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_IMAP_TYPE_FETCH_DATA_DECODER, GearyImapFetchDataDecoder);
			return result;
		}
		case GEARY_IMAP_FETCH_DATA_SPECIFIER_FLAGS:
		{
			GearyImapMessageFlagsDecoder* _tmp1_;
			_tmp1_ = geary_imap_message_flags_decoder_new ();
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_IMAP_TYPE_FETCH_DATA_DECODER, GearyImapFetchDataDecoder);
			return result;
		}
		case GEARY_IMAP_FETCH_DATA_SPECIFIER_ENVELOPE:
		{
			GearyImapEnvelopeDecoder* _tmp2_;
			_tmp2_ = geary_imap_envelope_decoder_new (quirks);
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_IMAP_TYPE_FETCH_DATA_DECODER, GearyImapFetchDataDecoder);
			return result;
		}
		case GEARY_IMAP_FETCH_DATA_SPECIFIER_INTERNALDATE:
		{
			GearyImapInternalDateDecoder* _tmp3_;
			_tmp3_ = geary_imap_internal_date_decoder_new ();
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEARY_IMAP_TYPE_FETCH_DATA_DECODER, GearyImapFetchDataDecoder);
			return result;
		}
		case GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822_SIZE:
		{
			GearyImapRFC822SizeDecoder* _tmp4_;
			_tmp4_ = geary_imap_rf_c822_size_decoder_new ();
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEARY_IMAP_TYPE_FETCH_DATA_DECODER, GearyImapFetchDataDecoder);
			return result;
		}
		case GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822_HEADER:
		{
			GearyImapRFC822HeaderDecoder* _tmp5_;
			_tmp5_ = geary_imap_rf_c822_header_decoder_new ();
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEARY_IMAP_TYPE_FETCH_DATA_DECODER, GearyImapFetchDataDecoder);
			return result;
		}
		case GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822_TEXT:
		{
			GearyImapRFC822TextDecoder* _tmp6_;
			_tmp6_ = geary_imap_rf_c822_text_decoder_new ();
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEARY_IMAP_TYPE_FETCH_DATA_DECODER, GearyImapFetchDataDecoder);
			return result;
		}
		case GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822:
		{
			GearyImapRFC822FullDecoder* _tmp7_;
			_tmp7_ = geary_imap_rf_c822_full_decoder_new ();
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEARY_IMAP_TYPE_FETCH_DATA_DECODER, GearyImapFetchDataDecoder);
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}

 G_GNUC_NO_INLINE static GType
geary_imap_fetch_data_specifier_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_IMAP_FETCH_DATA_SPECIFIER_UID, "GEARY_IMAP_FETCH_DATA_SPECIFIER_UID", "uid"}, {GEARY_IMAP_FETCH_DATA_SPECIFIER_FLAGS, "GEARY_IMAP_FETCH_DATA_SPECIFIER_FLAGS", "flags"}, {GEARY_IMAP_FETCH_DATA_SPECIFIER_INTERNALDATE, "GEARY_IMAP_FETCH_DATA_SPECIFIER_INTERNALDATE", "internaldate"}, {GEARY_IMAP_FETCH_DATA_SPECIFIER_ENVELOPE, "GEARY_IMAP_FETCH_DATA_SPECIFIER_ENVELOPE", "envelope"}, {GEARY_IMAP_FETCH_DATA_SPECIFIER_BODYSTRUCTURE, "GEARY_IMAP_FETCH_DATA_SPECIFIER_BODYSTRUCTURE", "bodystructure"}, {GEARY_IMAP_FETCH_DATA_SPECIFIER_BODY, "GEARY_IMAP_FETCH_DATA_SPECIFIER_BODY", "body"}, {GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822, "GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822", "rfc822"}, {GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822_HEADER, "GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822_HEADER", "rfc822-header"}, {GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822_SIZE, "GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822_SIZE", "rfc822-size"}, {GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822_TEXT, "GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822_TEXT", "rfc822-text"}, {GEARY_IMAP_FETCH_DATA_SPECIFIER_FAST, "GEARY_IMAP_FETCH_DATA_SPECIFIER_FAST", "fast"}, {GEARY_IMAP_FETCH_DATA_SPECIFIER_ALL, "GEARY_IMAP_FETCH_DATA_SPECIFIER_ALL", "all"}, {GEARY_IMAP_FETCH_DATA_SPECIFIER_FULL, "GEARY_IMAP_FETCH_DATA_SPECIFIER_FULL", "full"}, {0, NULL, NULL}};
	GType geary_imap_fetch_data_specifier_type_id;
	geary_imap_fetch_data_specifier_type_id = g_enum_register_static ("GearyImapFetchDataSpecifier", values);
	return geary_imap_fetch_data_specifier_type_id;
}

GType
geary_imap_fetch_data_specifier_get_type (void)
{
	static gsize geary_imap_fetch_data_specifier_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_fetch_data_specifier_type_id__once)) {
		GType geary_imap_fetch_data_specifier_type_id;
		geary_imap_fetch_data_specifier_type_id = geary_imap_fetch_data_specifier_get_type_once ();
		g_once_init_leave (&geary_imap_fetch_data_specifier_type_id__once, geary_imap_fetch_data_specifier_type_id);
	}
	return geary_imap_fetch_data_specifier_type_id__once;
}

