/* imap-fetch-data-decoder.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-fetch-data-decoder.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>

enum  {
	GEARY_IMAP_FETCH_DATA_DECODER_0_PROPERTY,
	GEARY_IMAP_FETCH_DATA_DECODER_DATA_ITEM_PROPERTY,
	GEARY_IMAP_FETCH_DATA_DECODER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_fetch_data_decoder_properties[GEARY_IMAP_FETCH_DATA_DECODER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GEARY_IMAP_UID_DECODER_0_PROPERTY,
	GEARY_IMAP_UID_DECODER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_uid_decoder_properties[GEARY_IMAP_UID_DECODER_NUM_PROPERTIES];
enum  {
	GEARY_IMAP_MESSAGE_FLAGS_DECODER_0_PROPERTY,
	GEARY_IMAP_MESSAGE_FLAGS_DECODER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_message_flags_decoder_properties[GEARY_IMAP_MESSAGE_FLAGS_DECODER_NUM_PROPERTIES];
enum  {
	GEARY_IMAP_INTERNAL_DATE_DECODER_0_PROPERTY,
	GEARY_IMAP_INTERNAL_DATE_DECODER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_internal_date_decoder_properties[GEARY_IMAP_INTERNAL_DATE_DECODER_NUM_PROPERTIES];
enum  {
	GEARY_IMAP_RF_C822_SIZE_DECODER_0_PROPERTY,
	GEARY_IMAP_RF_C822_SIZE_DECODER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_rf_c822_size_decoder_properties[GEARY_IMAP_RF_C822_SIZE_DECODER_NUM_PROPERTIES];
enum  {
	GEARY_IMAP_ENVELOPE_DECODER_0_PROPERTY,
	GEARY_IMAP_ENVELOPE_DECODER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_envelope_decoder_properties[GEARY_IMAP_ENVELOPE_DECODER_NUM_PROPERTIES];
enum  {
	GEARY_IMAP_RF_C822_HEADER_DECODER_0_PROPERTY,
	GEARY_IMAP_RF_C822_HEADER_DECODER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_rf_c822_header_decoder_properties[GEARY_IMAP_RF_C822_HEADER_DECODER_NUM_PROPERTIES];
enum  {
	GEARY_IMAP_RF_C822_TEXT_DECODER_0_PROPERTY,
	GEARY_IMAP_RF_C822_TEXT_DECODER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_rf_c822_text_decoder_properties[GEARY_IMAP_RF_C822_TEXT_DECODER_NUM_PROPERTIES];
enum  {
	GEARY_IMAP_RF_C822_FULL_DECODER_0_PROPERTY,
	GEARY_IMAP_RF_C822_FULL_DECODER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_rf_c822_full_decoder_properties[GEARY_IMAP_RF_C822_FULL_DECODER_NUM_PROPERTIES];

struct _GearyImapFetchDataDecoderPrivate {
	GearyImapFetchDataSpecifier _data_item;
};

struct _GearyImapEnvelopeDecoderPrivate {
	GearyImapQuirks* quirks;
};

static gint GearyImapFetchDataDecoder_private_offset;
static gpointer geary_imap_fetch_data_decoder_parent_class = NULL;
static gpointer geary_imap_uid_decoder_parent_class = NULL;
static gpointer geary_imap_message_flags_decoder_parent_class = NULL;
static gpointer geary_imap_internal_date_decoder_parent_class = NULL;
static gpointer geary_imap_rf_c822_size_decoder_parent_class = NULL;
static gint GearyImapEnvelopeDecoder_private_offset;
static gpointer geary_imap_envelope_decoder_parent_class = NULL;
static gpointer geary_imap_rf_c822_header_decoder_parent_class = NULL;
static gpointer geary_imap_rf_c822_text_decoder_parent_class = NULL;
static gpointer geary_imap_rf_c822_full_decoder_parent_class = NULL;

static void geary_imap_fetch_data_decoder_set_data_item (GearyImapFetchDataDecoder* self,
                                                  GearyImapFetchDataSpecifier value);
static GearyImapMessageData* geary_imap_fetch_data_decoder_real_decode (GearyImapFetchDataDecoder* self,
                                                                 GearyImapParameter* param,
                                                                 GError** error);
static GearyImapMessageData* geary_imap_fetch_data_decoder_real_decode_string (GearyImapFetchDataDecoder* self,
                                                                        GearyImapStringParameter* param,
                                                                        GError** error);
static GearyImapMessageData* geary_imap_fetch_data_decoder_real_decode_list (GearyImapFetchDataDecoder* self,
                                                                      GearyImapListParameter* list,
                                                                      GError** error);
static GearyImapMessageData* geary_imap_fetch_data_decoder_real_decode_literal (GearyImapFetchDataDecoder* self,
                                                                         GearyImapLiteralParameter* literal,
                                                                         GError** error);
static GearyImapMessageData* geary_imap_fetch_data_decoder_real_decode_nil (GearyImapFetchDataDecoder* self,
                                                                     GearyImapNilParameter* nil,
                                                                     GError** error);
static void geary_imap_fetch_data_decoder_finalize (GObject * obj);
static GType geary_imap_fetch_data_decoder_get_type_once (void);
static void _vala_geary_imap_fetch_data_decoder_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_geary_imap_fetch_data_decoder_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
static GearyImapMessageData* geary_imap_uid_decoder_real_decode_string (GearyImapFetchDataDecoder* base,
                                                                 GearyImapStringParameter* stringp,
                                                                 GError** error);
static GType geary_imap_uid_decoder_get_type_once (void);
static GearyImapMessageData* geary_imap_message_flags_decoder_real_decode_list (GearyImapFetchDataDecoder* base,
                                                                         GearyImapListParameter* listp,
                                                                         GError** error);
static GType geary_imap_message_flags_decoder_get_type_once (void);
static GearyImapMessageData* geary_imap_internal_date_decoder_real_decode_string (GearyImapFetchDataDecoder* base,
                                                                           GearyImapStringParameter* stringp,
                                                                           GError** error);
static GType geary_imap_internal_date_decoder_get_type_once (void);
static GearyImapMessageData* geary_imap_rf_c822_size_decoder_real_decode_string (GearyImapFetchDataDecoder* base,
                                                                          GearyImapStringParameter* stringp,
                                                                          GError** error);
static GType geary_imap_rf_c822_size_decoder_get_type_once (void);
static GearyImapMessageData* geary_imap_envelope_decoder_real_decode_list (GearyImapFetchDataDecoder* base,
                                                                    GearyImapListParameter* listp,
                                                                    GError** error);
static GearyRFC822MailboxAddresses* geary_imap_envelope_decoder_parse_addresses (GearyImapEnvelopeDecoder* self,
                                                                          GearyImapListParameter* listp,
                                                                          GError** error);
static GearyRFC822MessageIDList* geary_imap_envelope_decoder_new_message_id_list (GearyImapEnvelopeDecoder* self,
                                                                           const gchar* rfc822);
static GearyRFC822MessageID* geary_imap_envelope_decoder_new_message_id (GearyImapEnvelopeDecoder* self,
                                                                  const gchar* rfc822);
static void geary_imap_envelope_decoder_finalize (GObject * obj);
static GType geary_imap_envelope_decoder_get_type_once (void);
static GearyImapMessageData* geary_imap_rf_c822_header_decoder_real_decode_literal (GearyImapFetchDataDecoder* base,
                                                                             GearyImapLiteralParameter* literalp,
                                                                             GError** error);
static GType geary_imap_rf_c822_header_decoder_get_type_once (void);
static GearyImapMessageData* geary_imap_rf_c822_text_decoder_real_decode_literal (GearyImapFetchDataDecoder* base,
                                                                           GearyImapLiteralParameter* literalp,
                                                                           GError** error);
static GearyImapMessageData* geary_imap_rf_c822_text_decoder_real_decode_nil (GearyImapFetchDataDecoder* base,
                                                                       GearyImapNilParameter* nilp,
                                                                       GError** error);
static GType geary_imap_rf_c822_text_decoder_get_type_once (void);
static GearyImapMessageData* geary_imap_rf_c822_full_decoder_real_decode_literal (GearyImapFetchDataDecoder* base,
                                                                           GearyImapLiteralParameter* literalp,
                                                                           GError** error);
static GType geary_imap_rf_c822_full_decoder_get_type_once (void);

static inline gpointer
geary_imap_fetch_data_decoder_get_instance_private (GearyImapFetchDataDecoder* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapFetchDataDecoder_private_offset);
}

GearyImapFetchDataSpecifier
geary_imap_fetch_data_decoder_get_data_item (GearyImapFetchDataDecoder* self)
{
	GearyImapFetchDataSpecifier result;
	g_return_val_if_fail (GEARY_IMAP_IS_FETCH_DATA_DECODER (self), 0);
	result = self->priv->_data_item;
	return result;
}

static void
geary_imap_fetch_data_decoder_set_data_item (GearyImapFetchDataDecoder* self,
                                             GearyImapFetchDataSpecifier value)
{
	GearyImapFetchDataSpecifier old_value;
	g_return_if_fail (GEARY_IMAP_IS_FETCH_DATA_DECODER (self));
	old_value = geary_imap_fetch_data_decoder_get_data_item (self);
	if (old_value != value) {
		self->priv->_data_item = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_fetch_data_decoder_properties[GEARY_IMAP_FETCH_DATA_DECODER_DATA_ITEM_PROPERTY]);
	}
}

GearyImapFetchDataDecoder*
geary_imap_fetch_data_decoder_construct (GType object_type,
                                         GearyImapFetchDataSpecifier data_item)
{
	GearyImapFetchDataDecoder * self = NULL;
	self = (GearyImapFetchDataDecoder*) geary_base_object_construct (object_type);
	geary_imap_fetch_data_decoder_set_data_item (self, data_item);
	return self;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static GearyImapMessageData*
geary_imap_fetch_data_decoder_real_decode (GearyImapFetchDataDecoder* self,
                                           GearyImapParameter* param,
                                           GError** error)
{
	GearyImapStringParameter* stringp = NULL;
	GearyImapStringParameter* _tmp0_;
	GearyImapStringParameter* _tmp1_;
	GearyImapListParameter* listp = NULL;
	GearyImapListParameter* _tmp6_;
	GearyImapListParameter* _tmp7_;
	GearyImapLiteralParameter* literalp = NULL;
	GearyImapLiteralParameter* _tmp12_;
	GearyImapLiteralParameter* _tmp13_;
	GearyImapNilParameter* nilp = NULL;
	GearyImapNilParameter* _tmp33_;
	GearyImapNilParameter* _tmp34_;
	GError* _inner_error0_ = NULL;
	GearyImapMessageData* result;
	g_return_val_if_fail (GEARY_IMAP_IS_PARAMETER (param), NULL);
	_tmp0_ = _g_object_ref0 (GEARY_IMAP_IS_STRING_PARAMETER (param) ? ((GearyImapStringParameter*) param) : NULL);
	stringp = _tmp0_;
	_tmp1_ = stringp;
	if (_tmp1_ != NULL) {
		GearyImapMessageData* _tmp2_ = NULL;
		GearyImapStringParameter* _tmp3_;
		GearyImapMessageData* _tmp4_;
		GearyImapMessageData* _tmp5_;
		_tmp3_ = stringp;
		_tmp4_ = geary_imap_fetch_data_decoder_decode_string (self, _tmp3_, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (stringp);
				return NULL;
			} else {
				_g_object_unref0 (stringp);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp5_ = _tmp2_;
		_tmp2_ = NULL;
		result = _tmp5_;
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (stringp);
		return result;
	}
	_tmp6_ = _g_object_ref0 (GEARY_IMAP_IS_LIST_PARAMETER (param) ? ((GearyImapListParameter*) param) : NULL);
	listp = _tmp6_;
	_tmp7_ = listp;
	if (_tmp7_ != NULL) {
		GearyImapMessageData* _tmp8_ = NULL;
		GearyImapListParameter* _tmp9_;
		GearyImapMessageData* _tmp10_;
		GearyImapMessageData* _tmp11_;
		_tmp9_ = listp;
		_tmp10_ = geary_imap_fetch_data_decoder_decode_list (self, _tmp9_, &_inner_error0_);
		_tmp8_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (listp);
				_g_object_unref0 (stringp);
				return NULL;
			} else {
				_g_object_unref0 (listp);
				_g_object_unref0 (stringp);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp11_ = _tmp8_;
		_tmp8_ = NULL;
		result = _tmp11_;
		_g_object_unref0 (_tmp8_);
		_g_object_unref0 (listp);
		_g_object_unref0 (stringp);
		return result;
	}
	_tmp12_ = _g_object_ref0 (GEARY_IMAP_IS_LITERAL_PARAMETER (param) ? ((GearyImapLiteralParameter*) param) : NULL);
	literalp = _tmp12_;
	_tmp13_ = literalp;
	if (_tmp13_ != NULL) {
		GearyImapMessageData* _tmp29_ = NULL;
		GearyImapLiteralParameter* _tmp30_;
		GearyImapMessageData* _tmp31_;
		GearyImapMessageData* _tmp32_;
		{
			GearyImapLiteralParameter* _tmp14_;
			GearyMemoryBuffer* _tmp15_;
			GearyMemoryBuffer* _tmp16_;
			gsize _tmp17_;
			gsize _tmp18_;
			_tmp14_ = literalp;
			_tmp15_ = geary_imap_literal_parameter_get_value (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = geary_memory_buffer_get_size (_tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_ <= ((gsize) GEARY_IMAP_LIST_PARAMETER_MAX_STRING_LITERAL_LENGTH)) {
				GearyImapMessageData* _tmp19_ = NULL;
				GearyImapLiteralParameter* _tmp20_;
				GearyImapStringParameter* _tmp21_;
				GearyImapStringParameter* _tmp22_;
				GearyImapMessageData* _tmp23_;
				GearyImapMessageData* _tmp24_;
				GearyImapMessageData* _tmp25_;
				_tmp20_ = literalp;
				_tmp21_ = geary_imap_literal_parameter_coerce_to_string_parameter (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = geary_imap_fetch_data_decoder_decode_string (self, _tmp22_, &_inner_error0_);
				_tmp24_ = _tmp23_;
				_g_object_unref0 (_tmp22_);
				_tmp19_ = _tmp24_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
						goto __catch0_geary_imap_error;
					}
					_g_object_unref0 (literalp);
					_g_object_unref0 (listp);
					_g_object_unref0 (stringp);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp25_ = _tmp19_;
				_tmp19_ = NULL;
				result = _tmp25_;
				_g_object_unref0 (_tmp19_);
				_g_object_unref0 (literalp);
				_g_object_unref0 (listp);
				_g_object_unref0 (stringp);
				return result;
			}
		}
		goto __finally0;
		__catch0_geary_imap_error:
		{
			GError* imap_err = NULL;
			GError* _tmp26_;
			imap_err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp26_ = imap_err;
			if (!g_error_matches (_tmp26_, GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_TYPE_ERROR)) {
				GError* _tmp27_;
				GError* _tmp28_;
				_tmp27_ = imap_err;
				_tmp28_ = _g_error_copy0 (_tmp27_);
				_inner_error0_ = _tmp28_;
				_g_error_free0 (imap_err);
				goto __finally0;
			}
			_g_error_free0 (imap_err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (literalp);
				_g_object_unref0 (listp);
				_g_object_unref0 (stringp);
				return NULL;
			} else {
				_g_object_unref0 (literalp);
				_g_object_unref0 (listp);
				_g_object_unref0 (stringp);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp30_ = literalp;
		_tmp31_ = geary_imap_fetch_data_decoder_decode_literal (self, _tmp30_, &_inner_error0_);
		_tmp29_ = _tmp31_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (literalp);
				_g_object_unref0 (listp);
				_g_object_unref0 (stringp);
				return NULL;
			} else {
				_g_object_unref0 (literalp);
				_g_object_unref0 (listp);
				_g_object_unref0 (stringp);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp32_ = _tmp29_;
		_tmp29_ = NULL;
		result = _tmp32_;
		_g_object_unref0 (_tmp29_);
		_g_object_unref0 (literalp);
		_g_object_unref0 (listp);
		_g_object_unref0 (stringp);
		return result;
	}
	_tmp33_ = _g_object_ref0 (GEARY_IMAP_IS_NIL_PARAMETER (param) ? ((GearyImapNilParameter*) param) : NULL);
	nilp = _tmp33_;
	_tmp34_ = nilp;
	if (_tmp34_ != NULL) {
		GearyImapMessageData* _tmp35_ = NULL;
		GearyImapNilParameter* _tmp36_;
		GearyImapMessageData* _tmp37_;
		GearyImapMessageData* _tmp38_;
		_tmp36_ = nilp;
		_tmp37_ = geary_imap_fetch_data_decoder_decode_nil (self, _tmp36_, &_inner_error0_);
		_tmp35_ = _tmp37_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (nilp);
				_g_object_unref0 (literalp);
				_g_object_unref0 (listp);
				_g_object_unref0 (stringp);
				return NULL;
			} else {
				_g_object_unref0 (nilp);
				_g_object_unref0 (literalp);
				_g_object_unref0 (listp);
				_g_object_unref0 (stringp);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp38_ = _tmp35_;
		_tmp35_ = NULL;
		result = _tmp38_;
		_g_object_unref0 (_tmp35_);
		_g_object_unref0 (nilp);
		_g_object_unref0 (literalp);
		_g_object_unref0 (listp);
		_g_object_unref0 (stringp);
		return result;
	}
	g_assert_not_reached ();
}

GearyImapMessageData*
geary_imap_fetch_data_decoder_decode (GearyImapFetchDataDecoder* self,
                                      GearyImapParameter* param,
                                      GError** error)
{
	GearyImapFetchDataDecoderClass* _klass_;
	g_return_val_if_fail (GEARY_IMAP_IS_FETCH_DATA_DECODER (self), NULL);
	_klass_ = GEARY_IMAP_FETCH_DATA_DECODER_GET_CLASS (self);
	if (_klass_->decode) {
		return _klass_->decode (self, param, error);
	}
	return NULL;
}

static GearyImapMessageData*
geary_imap_fetch_data_decoder_real_decode_string (GearyImapFetchDataDecoder* self,
                                                  GearyImapStringParameter* param,
                                                  GError** error)
{
	GearyImapFetchDataSpecifier _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _tmp3_;
	GError* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (param), NULL);
	_tmp0_ = self->priv->_data_item;
	_tmp1_ = geary_imap_fetch_data_specifier_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_TYPE_ERROR, "%s does not accept a string parameter", _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	_inner_error0_ = _tmp4_;
	if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

GearyImapMessageData*
geary_imap_fetch_data_decoder_decode_string (GearyImapFetchDataDecoder* self,
                                             GearyImapStringParameter* param,
                                             GError** error)
{
	GearyImapFetchDataDecoderClass* _klass_;
	g_return_val_if_fail (GEARY_IMAP_IS_FETCH_DATA_DECODER (self), NULL);
	_klass_ = GEARY_IMAP_FETCH_DATA_DECODER_GET_CLASS (self);
	if (_klass_->decode_string) {
		return _klass_->decode_string (self, param, error);
	}
	return NULL;
}

static GearyImapMessageData*
geary_imap_fetch_data_decoder_real_decode_list (GearyImapFetchDataDecoder* self,
                                                GearyImapListParameter* list,
                                                GError** error)
{
	GearyImapFetchDataSpecifier _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _tmp3_;
	GError* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (list), NULL);
	_tmp0_ = self->priv->_data_item;
	_tmp1_ = geary_imap_fetch_data_specifier_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_TYPE_ERROR, "%s does not accept a list parameter", _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	_inner_error0_ = _tmp4_;
	if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

GearyImapMessageData*
geary_imap_fetch_data_decoder_decode_list (GearyImapFetchDataDecoder* self,
                                           GearyImapListParameter* list,
                                           GError** error)
{
	GearyImapFetchDataDecoderClass* _klass_;
	g_return_val_if_fail (GEARY_IMAP_IS_FETCH_DATA_DECODER (self), NULL);
	_klass_ = GEARY_IMAP_FETCH_DATA_DECODER_GET_CLASS (self);
	if (_klass_->decode_list) {
		return _klass_->decode_list (self, list, error);
	}
	return NULL;
}

static GearyImapMessageData*
geary_imap_fetch_data_decoder_real_decode_literal (GearyImapFetchDataDecoder* self,
                                                   GearyImapLiteralParameter* literal,
                                                   GError** error)
{
	GearyImapFetchDataSpecifier _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _tmp3_;
	GError* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (GEARY_IMAP_IS_LITERAL_PARAMETER (literal), NULL);
	_tmp0_ = self->priv->_data_item;
	_tmp1_ = geary_imap_fetch_data_specifier_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_TYPE_ERROR, "%s does not accept a literal parameter", _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	_inner_error0_ = _tmp4_;
	if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

GearyImapMessageData*
geary_imap_fetch_data_decoder_decode_literal (GearyImapFetchDataDecoder* self,
                                              GearyImapLiteralParameter* literal,
                                              GError** error)
{
	GearyImapFetchDataDecoderClass* _klass_;
	g_return_val_if_fail (GEARY_IMAP_IS_FETCH_DATA_DECODER (self), NULL);
	_klass_ = GEARY_IMAP_FETCH_DATA_DECODER_GET_CLASS (self);
	if (_klass_->decode_literal) {
		return _klass_->decode_literal (self, literal, error);
	}
	return NULL;
}

static GearyImapMessageData*
geary_imap_fetch_data_decoder_real_decode_nil (GearyImapFetchDataDecoder* self,
                                               GearyImapNilParameter* nil,
                                               GError** error)
{
	GearyImapFetchDataSpecifier _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _tmp3_;
	GError* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (GEARY_IMAP_IS_NIL_PARAMETER (nil), NULL);
	_tmp0_ = self->priv->_data_item;
	_tmp1_ = geary_imap_fetch_data_specifier_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_TYPE_ERROR, "%s does not accept a nil parameter", _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	_inner_error0_ = _tmp4_;
	if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

GearyImapMessageData*
geary_imap_fetch_data_decoder_decode_nil (GearyImapFetchDataDecoder* self,
                                          GearyImapNilParameter* nil,
                                          GError** error)
{
	GearyImapFetchDataDecoderClass* _klass_;
	g_return_val_if_fail (GEARY_IMAP_IS_FETCH_DATA_DECODER (self), NULL);
	_klass_ = GEARY_IMAP_FETCH_DATA_DECODER_GET_CLASS (self);
	if (_klass_->decode_nil) {
		return _klass_->decode_nil (self, nil, error);
	}
	return NULL;
}

static void
geary_imap_fetch_data_decoder_class_init (GearyImapFetchDataDecoderClass * klass,
                                          gpointer klass_data)
{
	geary_imap_fetch_data_decoder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapFetchDataDecoder_private_offset);
	((GearyImapFetchDataDecoderClass *) klass)->decode = (GearyImapMessageData* (*) (GearyImapFetchDataDecoder*, GearyImapParameter*, GError**)) geary_imap_fetch_data_decoder_real_decode;
	((GearyImapFetchDataDecoderClass *) klass)->decode_string = (GearyImapMessageData* (*) (GearyImapFetchDataDecoder*, GearyImapStringParameter*, GError**)) geary_imap_fetch_data_decoder_real_decode_string;
	((GearyImapFetchDataDecoderClass *) klass)->decode_list = (GearyImapMessageData* (*) (GearyImapFetchDataDecoder*, GearyImapListParameter*, GError**)) geary_imap_fetch_data_decoder_real_decode_list;
	((GearyImapFetchDataDecoderClass *) klass)->decode_literal = (GearyImapMessageData* (*) (GearyImapFetchDataDecoder*, GearyImapLiteralParameter*, GError**)) geary_imap_fetch_data_decoder_real_decode_literal;
	((GearyImapFetchDataDecoderClass *) klass)->decode_nil = (GearyImapMessageData* (*) (GearyImapFetchDataDecoder*, GearyImapNilParameter*, GError**)) geary_imap_fetch_data_decoder_real_decode_nil;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_fetch_data_decoder_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_fetch_data_decoder_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_fetch_data_decoder_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_FETCH_DATA_DECODER_DATA_ITEM_PROPERTY, geary_imap_fetch_data_decoder_properties[GEARY_IMAP_FETCH_DATA_DECODER_DATA_ITEM_PROPERTY] = g_param_spec_enum ("data-item", "data-item", "data-item", GEARY_IMAP_TYPE_FETCH_DATA_SPECIFIER, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_fetch_data_decoder_instance_init (GearyImapFetchDataDecoder * self,
                                             gpointer klass)
{
	self->priv = geary_imap_fetch_data_decoder_get_instance_private (self);
}

static void
geary_imap_fetch_data_decoder_finalize (GObject * obj)
{
	GearyImapFetchDataDecoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_FETCH_DATA_DECODER, GearyImapFetchDataDecoder);
	G_OBJECT_CLASS (geary_imap_fetch_data_decoder_parent_class)->finalize (obj);
}

/**
 * FetchDataDecoder accept the result line of a FETCH response and decodes it into MessageData.
 * While they can be used standalone, they're intended to be used by FetchResults to process
 * a CommandResponse.
 *
 * Note that FetchDataDecoders are keyed off of FetchDataType; new implementations should add
 * themselves to FetchDataType.get_decoder().
 *
 * In the future FetchDataDecoder may be used to decode MessageData stored in other formats, such
 * as in a database.
 */
 G_GNUC_NO_INLINE static GType
geary_imap_fetch_data_decoder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapFetchDataDecoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_fetch_data_decoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapFetchDataDecoder), 0, (GInstanceInitFunc) geary_imap_fetch_data_decoder_instance_init, NULL };
	GType geary_imap_fetch_data_decoder_type_id;
	geary_imap_fetch_data_decoder_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyImapFetchDataDecoder", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	GearyImapFetchDataDecoder_private_offset = g_type_add_instance_private (geary_imap_fetch_data_decoder_type_id, sizeof (GearyImapFetchDataDecoderPrivate));
	return geary_imap_fetch_data_decoder_type_id;
}

GType
geary_imap_fetch_data_decoder_get_type (void)
{
	static gsize geary_imap_fetch_data_decoder_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_fetch_data_decoder_type_id__once)) {
		GType geary_imap_fetch_data_decoder_type_id;
		geary_imap_fetch_data_decoder_type_id = geary_imap_fetch_data_decoder_get_type_once ();
		g_once_init_leave (&geary_imap_fetch_data_decoder_type_id__once, geary_imap_fetch_data_decoder_type_id);
	}
	return geary_imap_fetch_data_decoder_type_id__once;
}

static void
_vala_geary_imap_fetch_data_decoder_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	GearyImapFetchDataDecoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_FETCH_DATA_DECODER, GearyImapFetchDataDecoder);
	switch (property_id) {
		case GEARY_IMAP_FETCH_DATA_DECODER_DATA_ITEM_PROPERTY:
		g_value_set_enum (value, geary_imap_fetch_data_decoder_get_data_item (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_fetch_data_decoder_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	GearyImapFetchDataDecoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_FETCH_DATA_DECODER, GearyImapFetchDataDecoder);
	switch (property_id) {
		case GEARY_IMAP_FETCH_DATA_DECODER_DATA_ITEM_PROPERTY:
		geary_imap_fetch_data_decoder_set_data_item (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

GearyImapUIDDecoder*
geary_imap_uid_decoder_construct (GType object_type)
{
	GearyImapUIDDecoder * self = NULL;
	self = (GearyImapUIDDecoder*) geary_imap_fetch_data_decoder_construct (object_type, GEARY_IMAP_FETCH_DATA_SPECIFIER_UID);
	return self;
}

GearyImapUIDDecoder*
geary_imap_uid_decoder_new (void)
{
	return geary_imap_uid_decoder_construct (GEARY_IMAP_TYPE_UID_DECODER);
}

static GearyImapMessageData*
geary_imap_uid_decoder_real_decode_string (GearyImapFetchDataDecoder* base,
                                           GearyImapStringParameter* stringp,
                                           GError** error)
{
	GearyImapUIDDecoder * self;
	gint64 _tmp0_ = 0LL;
	GearyImapUID* _tmp1_ = NULL;
	GearyImapUID* _tmp2_;
	GearyImapUID* _tmp3_;
	GError* _inner_error0_ = NULL;
	GearyImapMessageData* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_UID_DECODER, GearyImapUIDDecoder);
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (stringp), NULL);
	_tmp0_ = geary_imap_string_parameter_as_int64 (stringp, G_MININT64, G_MAXINT64, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = geary_imap_uid_new_checked (_tmp0_, &_inner_error0_);
	_tmp1_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = _tmp1_;
	_tmp1_ = NULL;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEARY_IMAP_TYPE_MESSAGE_DATA, GearyImapMessageData);
	_g_object_unref0 (_tmp1_);
	return result;
}

static void
geary_imap_uid_decoder_class_init (GearyImapUIDDecoderClass * klass,
                                   gpointer klass_data)
{
	geary_imap_uid_decoder_parent_class = g_type_class_peek_parent (klass);
	((GearyImapFetchDataDecoderClass *) klass)->decode_string = (GearyImapMessageData* (*) (GearyImapFetchDataDecoder*, GearyImapStringParameter*, GError**)) geary_imap_uid_decoder_real_decode_string;
}

static void
geary_imap_uid_decoder_instance_init (GearyImapUIDDecoder * self,
                                      gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
geary_imap_uid_decoder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapUIDDecoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_uid_decoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapUIDDecoder), 0, (GInstanceInitFunc) geary_imap_uid_decoder_instance_init, NULL };
	GType geary_imap_uid_decoder_type_id;
	geary_imap_uid_decoder_type_id = g_type_register_static (GEARY_IMAP_TYPE_FETCH_DATA_DECODER, "GearyImapUIDDecoder", &g_define_type_info, 0);
	return geary_imap_uid_decoder_type_id;
}

GType
geary_imap_uid_decoder_get_type (void)
{
	static gsize geary_imap_uid_decoder_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_uid_decoder_type_id__once)) {
		GType geary_imap_uid_decoder_type_id;
		geary_imap_uid_decoder_type_id = geary_imap_uid_decoder_get_type_once ();
		g_once_init_leave (&geary_imap_uid_decoder_type_id__once, geary_imap_uid_decoder_type_id);
	}
	return geary_imap_uid_decoder_type_id__once;
}

GearyImapMessageFlagsDecoder*
geary_imap_message_flags_decoder_construct (GType object_type)
{
	GearyImapMessageFlagsDecoder * self = NULL;
	self = (GearyImapMessageFlagsDecoder*) geary_imap_fetch_data_decoder_construct (object_type, GEARY_IMAP_FETCH_DATA_SPECIFIER_FLAGS);
	return self;
}

GearyImapMessageFlagsDecoder*
geary_imap_message_flags_decoder_new (void)
{
	return geary_imap_message_flags_decoder_construct (GEARY_IMAP_TYPE_MESSAGE_FLAGS_DECODER);
}

static GearyImapMessageData*
geary_imap_message_flags_decoder_real_decode_list (GearyImapFetchDataDecoder* base,
                                                   GearyImapListParameter* listp,
                                                   GError** error)
{
	GearyImapMessageFlagsDecoder * self;
	GeeList* flags = NULL;
	GeeArrayList* _tmp0_;
	GeeList* _tmp12_;
	GearyImapMessageFlags* _tmp13_;
	GError* _inner_error0_ = NULL;
	GearyImapMessageData* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_MESSAGE_FLAGS_DECODER, GearyImapMessageFlagsDecoder);
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (listp), NULL);
	_tmp0_ = gee_array_list_new (GEARY_IMAP_TYPE_MESSAGE_FLAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	flags = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				GearyImapStringParameter* _tmp5_ = NULL;
				GearyImapStringParameter* _tmp6_;
				GeeList* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				GearyImapMessageFlag* _tmp10_;
				GearyImapMessageFlag* _tmp11_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = ctr;
					ctr = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = geary_imap_list_parameter_get_size (listp);
				_tmp4_ = _tmp3_;
				if (!(ctr < _tmp4_)) {
					break;
				}
				_tmp6_ = geary_imap_list_parameter_get_as_string (listp, ctr, &_inner_error0_);
				_tmp5_ = _tmp6_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_object_unref0 (flags);
						return NULL;
					} else {
						_g_object_unref0 (flags);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp7_ = flags;
				_tmp8_ = geary_imap_string_parameter_get_ascii (_tmp5_);
				_tmp9_ = _tmp8_;
				_tmp10_ = geary_imap_message_flag_new (_tmp9_);
				_tmp11_ = _tmp10_;
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection), _tmp11_);
				_g_object_unref0 (_tmp11_);
				_g_object_unref0 (_tmp5_);
			}
		}
	}
	_tmp12_ = flags;
	_tmp13_ = geary_imap_message_flags_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_COLLECTION, GeeCollection));
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEARY_IMAP_TYPE_MESSAGE_DATA, GearyImapMessageData);
	_g_object_unref0 (flags);
	return result;
}

static void
geary_imap_message_flags_decoder_class_init (GearyImapMessageFlagsDecoderClass * klass,
                                             gpointer klass_data)
{
	geary_imap_message_flags_decoder_parent_class = g_type_class_peek_parent (klass);
	((GearyImapFetchDataDecoderClass *) klass)->decode_list = (GearyImapMessageData* (*) (GearyImapFetchDataDecoder*, GearyImapListParameter*, GError**)) geary_imap_message_flags_decoder_real_decode_list;
}

static void
geary_imap_message_flags_decoder_instance_init (GearyImapMessageFlagsDecoder * self,
                                                gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
geary_imap_message_flags_decoder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapMessageFlagsDecoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_message_flags_decoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapMessageFlagsDecoder), 0, (GInstanceInitFunc) geary_imap_message_flags_decoder_instance_init, NULL };
	GType geary_imap_message_flags_decoder_type_id;
	geary_imap_message_flags_decoder_type_id = g_type_register_static (GEARY_IMAP_TYPE_FETCH_DATA_DECODER, "GearyImapMessageFlagsDecoder", &g_define_type_info, 0);
	return geary_imap_message_flags_decoder_type_id;
}

GType
geary_imap_message_flags_decoder_get_type (void)
{
	static gsize geary_imap_message_flags_decoder_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_message_flags_decoder_type_id__once)) {
		GType geary_imap_message_flags_decoder_type_id;
		geary_imap_message_flags_decoder_type_id = geary_imap_message_flags_decoder_get_type_once ();
		g_once_init_leave (&geary_imap_message_flags_decoder_type_id__once, geary_imap_message_flags_decoder_type_id);
	}
	return geary_imap_message_flags_decoder_type_id__once;
}

GearyImapInternalDateDecoder*
geary_imap_internal_date_decoder_construct (GType object_type)
{
	GearyImapInternalDateDecoder * self = NULL;
	self = (GearyImapInternalDateDecoder*) geary_imap_fetch_data_decoder_construct (object_type, GEARY_IMAP_FETCH_DATA_SPECIFIER_INTERNALDATE);
	return self;
}

GearyImapInternalDateDecoder*
geary_imap_internal_date_decoder_new (void)
{
	return geary_imap_internal_date_decoder_construct (GEARY_IMAP_TYPE_INTERNAL_DATE_DECODER);
}

static GearyImapMessageData*
geary_imap_internal_date_decoder_real_decode_string (GearyImapFetchDataDecoder* base,
                                                     GearyImapStringParameter* stringp,
                                                     GError** error)
{
	GearyImapInternalDateDecoder * self;
	GearyImapInternalDate* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GearyImapInternalDate* _tmp3_;
	GearyImapInternalDate* _tmp4_;
	GError* _inner_error0_ = NULL;
	GearyImapMessageData* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_INTERNAL_DATE_DECODER, GearyImapInternalDateDecoder);
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (stringp), NULL);
	_tmp1_ = geary_imap_string_parameter_get_ascii (stringp);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_imap_internal_date_decode (_tmp2_, &_inner_error0_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEARY_IMAP_TYPE_MESSAGE_DATA, GearyImapMessageData);
	_g_object_unref0 (_tmp0_);
	return result;
}

static void
geary_imap_internal_date_decoder_class_init (GearyImapInternalDateDecoderClass * klass,
                                             gpointer klass_data)
{
	geary_imap_internal_date_decoder_parent_class = g_type_class_peek_parent (klass);
	((GearyImapFetchDataDecoderClass *) klass)->decode_string = (GearyImapMessageData* (*) (GearyImapFetchDataDecoder*, GearyImapStringParameter*, GError**)) geary_imap_internal_date_decoder_real_decode_string;
}

static void
geary_imap_internal_date_decoder_instance_init (GearyImapInternalDateDecoder * self,
                                                gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
geary_imap_internal_date_decoder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapInternalDateDecoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_internal_date_decoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapInternalDateDecoder), 0, (GInstanceInitFunc) geary_imap_internal_date_decoder_instance_init, NULL };
	GType geary_imap_internal_date_decoder_type_id;
	geary_imap_internal_date_decoder_type_id = g_type_register_static (GEARY_IMAP_TYPE_FETCH_DATA_DECODER, "GearyImapInternalDateDecoder", &g_define_type_info, 0);
	return geary_imap_internal_date_decoder_type_id;
}

GType
geary_imap_internal_date_decoder_get_type (void)
{
	static gsize geary_imap_internal_date_decoder_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_internal_date_decoder_type_id__once)) {
		GType geary_imap_internal_date_decoder_type_id;
		geary_imap_internal_date_decoder_type_id = geary_imap_internal_date_decoder_get_type_once ();
		g_once_init_leave (&geary_imap_internal_date_decoder_type_id__once, geary_imap_internal_date_decoder_type_id);
	}
	return geary_imap_internal_date_decoder_type_id__once;
}

GearyImapRFC822SizeDecoder*
geary_imap_rf_c822_size_decoder_construct (GType object_type)
{
	GearyImapRFC822SizeDecoder * self = NULL;
	self = (GearyImapRFC822SizeDecoder*) geary_imap_fetch_data_decoder_construct (object_type, GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822_SIZE);
	return self;
}

GearyImapRFC822SizeDecoder*
geary_imap_rf_c822_size_decoder_new (void)
{
	return geary_imap_rf_c822_size_decoder_construct (GEARY_IMAP_TYPE_RF_C822_SIZE_DECODER);
}

static GearyImapMessageData*
geary_imap_rf_c822_size_decoder_real_decode_string (GearyImapFetchDataDecoder* base,
                                                    GearyImapStringParameter* stringp,
                                                    GError** error)
{
	GearyImapRFC822SizeDecoder * self;
	gint64 _tmp0_ = 0LL;
	GearyImapRFC822Size* _tmp1_;
	GError* _inner_error0_ = NULL;
	GearyImapMessageData* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_RF_C822_SIZE_DECODER, GearyImapRFC822SizeDecoder);
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (stringp), NULL);
	_tmp0_ = geary_imap_string_parameter_as_int64 (stringp, (gint64) 0, G_MAXINT64, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = geary_imap_rf_c822_size_new (_tmp0_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_IMAP_TYPE_MESSAGE_DATA, GearyImapMessageData);
	return result;
}

static void
geary_imap_rf_c822_size_decoder_class_init (GearyImapRFC822SizeDecoderClass * klass,
                                            gpointer klass_data)
{
	geary_imap_rf_c822_size_decoder_parent_class = g_type_class_peek_parent (klass);
	((GearyImapFetchDataDecoderClass *) klass)->decode_string = (GearyImapMessageData* (*) (GearyImapFetchDataDecoder*, GearyImapStringParameter*, GError**)) geary_imap_rf_c822_size_decoder_real_decode_string;
}

static void
geary_imap_rf_c822_size_decoder_instance_init (GearyImapRFC822SizeDecoder * self,
                                               gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
geary_imap_rf_c822_size_decoder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapRFC822SizeDecoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_rf_c822_size_decoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapRFC822SizeDecoder), 0, (GInstanceInitFunc) geary_imap_rf_c822_size_decoder_instance_init, NULL };
	GType geary_imap_rf_c822_size_decoder_type_id;
	geary_imap_rf_c822_size_decoder_type_id = g_type_register_static (GEARY_IMAP_TYPE_FETCH_DATA_DECODER, "GearyImapRFC822SizeDecoder", &g_define_type_info, 0);
	return geary_imap_rf_c822_size_decoder_type_id;
}

GType
geary_imap_rf_c822_size_decoder_get_type (void)
{
	static gsize geary_imap_rf_c822_size_decoder_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_rf_c822_size_decoder_type_id__once)) {
		GType geary_imap_rf_c822_size_decoder_type_id;
		geary_imap_rf_c822_size_decoder_type_id = geary_imap_rf_c822_size_decoder_get_type_once ();
		g_once_init_leave (&geary_imap_rf_c822_size_decoder_type_id__once, geary_imap_rf_c822_size_decoder_type_id);
	}
	return geary_imap_rf_c822_size_decoder_type_id__once;
}

static inline gpointer
geary_imap_envelope_decoder_get_instance_private (GearyImapEnvelopeDecoder* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapEnvelopeDecoder_private_offset);
}

GearyImapEnvelopeDecoder*
geary_imap_envelope_decoder_construct (GType object_type,
                                       GearyImapQuirks* quirks)
{
	GearyImapEnvelopeDecoder * self = NULL;
	GearyImapQuirks* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_QUIRKS (quirks), NULL);
	self = (GearyImapEnvelopeDecoder*) geary_imap_fetch_data_decoder_construct (object_type, GEARY_IMAP_FETCH_DATA_SPECIFIER_ENVELOPE);
	_tmp0_ = _g_object_ref0 (quirks);
	_g_object_unref0 (self->priv->quirks);
	self->priv->quirks = _tmp0_;
	return self;
}

GearyImapEnvelopeDecoder*
geary_imap_envelope_decoder_new (GearyImapQuirks* quirks)
{
	return geary_imap_envelope_decoder_construct (GEARY_IMAP_TYPE_ENVELOPE_DECODER, quirks);
}

static GearyImapMessageData*
geary_imap_envelope_decoder_real_decode_list (GearyImapFetchDataDecoder* base,
                                              GearyImapListParameter* listp,
                                              GError** error)
{
	GearyImapEnvelopeDecoder * self;
	GearyImapStringParameter* sent = NULL;
	GearyImapStringParameter* _tmp0_;
	GearyImapStringParameter* subject = NULL;
	GearyImapStringParameter* _tmp1_;
	GearyImapListParameter* from = NULL;
	GearyImapListParameter* _tmp2_;
	GearyImapListParameter* sender = NULL;
	GearyImapListParameter* _tmp3_;
	GearyImapListParameter* reply_to = NULL;
	GearyImapListParameter* _tmp4_;
	GearyImapListParameter* to = NULL;
	GearyImapListParameter* _tmp5_;
	GearyImapListParameter* cc = NULL;
	GearyImapListParameter* _tmp6_;
	GearyImapListParameter* bcc = NULL;
	GearyImapListParameter* _tmp7_;
	GearyImapStringParameter* in_reply_to = NULL;
	GearyImapStringParameter* _tmp8_;
	GearyImapStringParameter* message_id = NULL;
	GearyImapStringParameter* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GearyImapStringParameter* _tmp11_;
	GearyRFC822Date* sent_date = NULL;
	GearyImapStringParameter* _tmp13_;
	GearyRFC822MailboxAddresses* _tmp22_ = NULL;
	GearyImapListParameter* _tmp23_;
	GearyRFC822MailboxAddresses* _tmp24_;
	GearyRFC822MailboxAddresses* _tmp25_ = NULL;
	GearyImapListParameter* _tmp26_;
	GearyRFC822MailboxAddresses* _tmp27_;
	GearyRFC822MailboxAddresses* _tmp28_ = NULL;
	GearyImapListParameter* _tmp29_;
	GearyRFC822MailboxAddresses* _tmp30_;
	GearyRFC822MailboxAddresses* _tmp31_ = NULL;
	GearyImapListParameter* _tmp32_;
	GearyRFC822MailboxAddresses* _tmp35_ = NULL;
	GearyImapListParameter* _tmp36_;
	GearyRFC822MailboxAddresses* _tmp39_ = NULL;
	GearyImapListParameter* _tmp40_;
	GearyRFC822MessageIDList* _tmp43_ = NULL;
	GearyImapStringParameter* _tmp44_;
	GearyRFC822MessageID* _tmp49_ = NULL;
	GearyImapStringParameter* _tmp50_;
	GearyRFC822Date* _tmp55_;
	GearyImapStringParameter* _tmp56_;
	const gchar* _tmp57_;
	const gchar* _tmp58_;
	GearyRFC822Subject* _tmp59_;
	GearyRFC822Subject* _tmp60_;
	GearyImapEnvelope* _tmp61_;
	GearyImapMessageData* _tmp62_;
	GError* _inner_error0_ = NULL;
	GearyImapMessageData* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_ENVELOPE_DECODER, GearyImapEnvelopeDecoder);
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (listp), NULL);
	_tmp0_ = geary_imap_list_parameter_get_as_nullable_string (listp, 0, &_inner_error0_);
	sent = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = geary_imap_list_parameter_get_as_empty_string (listp, 1, &_inner_error0_);
	subject = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (sent);
			return NULL;
		} else {
			_g_object_unref0 (sent);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = geary_imap_list_parameter_get_as_empty_list (listp, 2, &_inner_error0_);
	from = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (subject);
			_g_object_unref0 (sent);
			return NULL;
		} else {
			_g_object_unref0 (subject);
			_g_object_unref0 (sent);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = geary_imap_list_parameter_get_as_empty_list (listp, 3, &_inner_error0_);
	sender = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (from);
			_g_object_unref0 (subject);
			_g_object_unref0 (sent);
			return NULL;
		} else {
			_g_object_unref0 (from);
			_g_object_unref0 (subject);
			_g_object_unref0 (sent);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp4_ = geary_imap_list_parameter_get_as_empty_list (listp, 4, &_inner_error0_);
	reply_to = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (sender);
			_g_object_unref0 (from);
			_g_object_unref0 (subject);
			_g_object_unref0 (sent);
			return NULL;
		} else {
			_g_object_unref0 (sender);
			_g_object_unref0 (from);
			_g_object_unref0 (subject);
			_g_object_unref0 (sent);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = geary_imap_list_parameter_get_as_nullable_list (listp, 5, &_inner_error0_);
	to = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (reply_to);
			_g_object_unref0 (sender);
			_g_object_unref0 (from);
			_g_object_unref0 (subject);
			_g_object_unref0 (sent);
			return NULL;
		} else {
			_g_object_unref0 (reply_to);
			_g_object_unref0 (sender);
			_g_object_unref0 (from);
			_g_object_unref0 (subject);
			_g_object_unref0 (sent);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = geary_imap_list_parameter_get_as_nullable_list (listp, 6, &_inner_error0_);
	cc = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (to);
			_g_object_unref0 (reply_to);
			_g_object_unref0 (sender);
			_g_object_unref0 (from);
			_g_object_unref0 (subject);
			_g_object_unref0 (sent);
			return NULL;
		} else {
			_g_object_unref0 (to);
			_g_object_unref0 (reply_to);
			_g_object_unref0 (sender);
			_g_object_unref0 (from);
			_g_object_unref0 (subject);
			_g_object_unref0 (sent);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp7_ = geary_imap_list_parameter_get_as_nullable_list (listp, 7, &_inner_error0_);
	bcc = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (cc);
			_g_object_unref0 (to);
			_g_object_unref0 (reply_to);
			_g_object_unref0 (sender);
			_g_object_unref0 (from);
			_g_object_unref0 (subject);
			_g_object_unref0 (sent);
			return NULL;
		} else {
			_g_object_unref0 (cc);
			_g_object_unref0 (to);
			_g_object_unref0 (reply_to);
			_g_object_unref0 (sender);
			_g_object_unref0 (from);
			_g_object_unref0 (subject);
			_g_object_unref0 (sent);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp8_ = geary_imap_list_parameter_get_as_nullable_string (listp, 8, &_inner_error0_);
	in_reply_to = _tmp8_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (bcc);
			_g_object_unref0 (cc);
			_g_object_unref0 (to);
			_g_object_unref0 (reply_to);
			_g_object_unref0 (sender);
			_g_object_unref0 (from);
			_g_object_unref0 (subject);
			_g_object_unref0 (sent);
			return NULL;
		} else {
			_g_object_unref0 (bcc);
			_g_object_unref0 (cc);
			_g_object_unref0 (to);
			_g_object_unref0 (reply_to);
			_g_object_unref0 (sender);
			_g_object_unref0 (from);
			_g_object_unref0 (subject);
			_g_object_unref0 (sent);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp9_ = geary_imap_list_parameter_get_as_nullable_string (listp, 9, &_inner_error0_);
	message_id = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (in_reply_to);
			_g_object_unref0 (bcc);
			_g_object_unref0 (cc);
			_g_object_unref0 (to);
			_g_object_unref0 (reply_to);
			_g_object_unref0 (sender);
			_g_object_unref0 (from);
			_g_object_unref0 (subject);
			_g_object_unref0 (sent);
			return NULL;
		} else {
			_g_object_unref0 (in_reply_to);
			_g_object_unref0 (bcc);
			_g_object_unref0 (cc);
			_g_object_unref0 (to);
			_g_object_unref0 (reply_to);
			_g_object_unref0 (sender);
			_g_object_unref0 (from);
			_g_object_unref0 (subject);
			_g_object_unref0 (sent);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp11_ = message_id;
	if (_tmp11_ != NULL) {
		GearyImapStringParameter* _tmp12_;
		_tmp12_ = message_id;
		_tmp10_ = geary_imap_string_parameter_is_empty (_tmp12_);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		_g_object_unref0 (message_id);
		message_id = NULL;
	}
	sent_date = NULL;
	_tmp13_ = sent;
	if (_tmp13_ != NULL) {
		{
			GearyRFC822Date* _tmp14_ = NULL;
			GearyImapStringParameter* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			GearyRFC822Date* _tmp18_;
			GearyRFC822Date* _tmp19_;
			_tmp15_ = sent;
			_tmp16_ = geary_imap_string_parameter_get_ascii (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = geary_rf_c822_date_new_from_rfc822_string (_tmp17_, &_inner_error0_);
			_tmp14_ = _tmp18_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp19_ = _tmp14_;
			_tmp14_ = NULL;
			_g_object_unref0 (sent_date);
			sent_date = _tmp19_;
			_g_object_unref0 (_tmp14_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp20_;
			const gchar* _tmp21_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp20_ = err;
			_tmp21_ = _tmp20_->message;
			g_warning ("imap-fetch-data-decoder.vala:159: Error parsing sent date from FETCH e" \
"nvelope: %s", _tmp21_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (sent_date);
				_g_object_unref0 (message_id);
				_g_object_unref0 (in_reply_to);
				_g_object_unref0 (bcc);
				_g_object_unref0 (cc);
				_g_object_unref0 (to);
				_g_object_unref0 (reply_to);
				_g_object_unref0 (sender);
				_g_object_unref0 (from);
				_g_object_unref0 (subject);
				_g_object_unref0 (sent);
				return NULL;
			} else {
				_g_object_unref0 (sent_date);
				_g_object_unref0 (message_id);
				_g_object_unref0 (in_reply_to);
				_g_object_unref0 (bcc);
				_g_object_unref0 (cc);
				_g_object_unref0 (to);
				_g_object_unref0 (reply_to);
				_g_object_unref0 (sender);
				_g_object_unref0 (from);
				_g_object_unref0 (subject);
				_g_object_unref0 (sent);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp23_ = from;
	_tmp24_ = geary_imap_envelope_decoder_parse_addresses (self, _tmp23_, &_inner_error0_);
	_tmp22_ = _tmp24_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (sent_date);
			_g_object_unref0 (message_id);
			_g_object_unref0 (in_reply_to);
			_g_object_unref0 (bcc);
			_g_object_unref0 (cc);
			_g_object_unref0 (to);
			_g_object_unref0 (reply_to);
			_g_object_unref0 (sender);
			_g_object_unref0 (from);
			_g_object_unref0 (subject);
			_g_object_unref0 (sent);
			return NULL;
		} else {
			_g_object_unref0 (sent_date);
			_g_object_unref0 (message_id);
			_g_object_unref0 (in_reply_to);
			_g_object_unref0 (bcc);
			_g_object_unref0 (cc);
			_g_object_unref0 (to);
			_g_object_unref0 (reply_to);
			_g_object_unref0 (sender);
			_g_object_unref0 (from);
			_g_object_unref0 (subject);
			_g_object_unref0 (sent);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp26_ = sender;
	_tmp27_ = geary_imap_envelope_decoder_parse_addresses (self, _tmp26_, &_inner_error0_);
	_tmp25_ = _tmp27_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp22_);
			_g_object_unref0 (sent_date);
			_g_object_unref0 (message_id);
			_g_object_unref0 (in_reply_to);
			_g_object_unref0 (bcc);
			_g_object_unref0 (cc);
			_g_object_unref0 (to);
			_g_object_unref0 (reply_to);
			_g_object_unref0 (sender);
			_g_object_unref0 (from);
			_g_object_unref0 (subject);
			_g_object_unref0 (sent);
			return NULL;
		} else {
			_g_object_unref0 (_tmp22_);
			_g_object_unref0 (sent_date);
			_g_object_unref0 (message_id);
			_g_object_unref0 (in_reply_to);
			_g_object_unref0 (bcc);
			_g_object_unref0 (cc);
			_g_object_unref0 (to);
			_g_object_unref0 (reply_to);
			_g_object_unref0 (sender);
			_g_object_unref0 (from);
			_g_object_unref0 (subject);
			_g_object_unref0 (sent);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp29_ = reply_to;
	_tmp30_ = geary_imap_envelope_decoder_parse_addresses (self, _tmp29_, &_inner_error0_);
	_tmp28_ = _tmp30_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp25_);
			_g_object_unref0 (_tmp22_);
			_g_object_unref0 (sent_date);
			_g_object_unref0 (message_id);
			_g_object_unref0 (in_reply_to);
			_g_object_unref0 (bcc);
			_g_object_unref0 (cc);
			_g_object_unref0 (to);
			_g_object_unref0 (reply_to);
			_g_object_unref0 (sender);
			_g_object_unref0 (from);
			_g_object_unref0 (subject);
			_g_object_unref0 (sent);
			return NULL;
		} else {
			_g_object_unref0 (_tmp25_);
			_g_object_unref0 (_tmp22_);
			_g_object_unref0 (sent_date);
			_g_object_unref0 (message_id);
			_g_object_unref0 (in_reply_to);
			_g_object_unref0 (bcc);
			_g_object_unref0 (cc);
			_g_object_unref0 (to);
			_g_object_unref0 (reply_to);
			_g_object_unref0 (sender);
			_g_object_unref0 (from);
			_g_object_unref0 (subject);
			_g_object_unref0 (sent);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp32_ = to;
	if (_tmp32_ != NULL) {
		GearyImapListParameter* _tmp33_;
		GearyRFC822MailboxAddresses* _tmp34_;
		_tmp33_ = to;
		_tmp34_ = geary_imap_envelope_decoder_parse_addresses (self, _tmp33_, &_inner_error0_);
		_g_object_unref0 (_tmp31_);
		_tmp31_ = _tmp34_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_tmp31_);
				_g_object_unref0 (_tmp28_);
				_g_object_unref0 (_tmp25_);
				_g_object_unref0 (_tmp22_);
				_g_object_unref0 (sent_date);
				_g_object_unref0 (message_id);
				_g_object_unref0 (in_reply_to);
				_g_object_unref0 (bcc);
				_g_object_unref0 (cc);
				_g_object_unref0 (to);
				_g_object_unref0 (reply_to);
				_g_object_unref0 (sender);
				_g_object_unref0 (from);
				_g_object_unref0 (subject);
				_g_object_unref0 (sent);
				return NULL;
			} else {
				_g_object_unref0 (_tmp31_);
				_g_object_unref0 (_tmp28_);
				_g_object_unref0 (_tmp25_);
				_g_object_unref0 (_tmp22_);
				_g_object_unref0 (sent_date);
				_g_object_unref0 (message_id);
				_g_object_unref0 (in_reply_to);
				_g_object_unref0 (bcc);
				_g_object_unref0 (cc);
				_g_object_unref0 (to);
				_g_object_unref0 (reply_to);
				_g_object_unref0 (sender);
				_g_object_unref0 (from);
				_g_object_unref0 (subject);
				_g_object_unref0 (sent);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	} else {
		_g_object_unref0 (_tmp31_);
		_tmp31_ = NULL;
	}
	_tmp36_ = cc;
	if (_tmp36_ != NULL) {
		GearyImapListParameter* _tmp37_;
		GearyRFC822MailboxAddresses* _tmp38_;
		_tmp37_ = cc;
		_tmp38_ = geary_imap_envelope_decoder_parse_addresses (self, _tmp37_, &_inner_error0_);
		_g_object_unref0 (_tmp35_);
		_tmp35_ = _tmp38_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_tmp35_);
				_g_object_unref0 (_tmp31_);
				_g_object_unref0 (_tmp28_);
				_g_object_unref0 (_tmp25_);
				_g_object_unref0 (_tmp22_);
				_g_object_unref0 (sent_date);
				_g_object_unref0 (message_id);
				_g_object_unref0 (in_reply_to);
				_g_object_unref0 (bcc);
				_g_object_unref0 (cc);
				_g_object_unref0 (to);
				_g_object_unref0 (reply_to);
				_g_object_unref0 (sender);
				_g_object_unref0 (from);
				_g_object_unref0 (subject);
				_g_object_unref0 (sent);
				return NULL;
			} else {
				_g_object_unref0 (_tmp35_);
				_g_object_unref0 (_tmp31_);
				_g_object_unref0 (_tmp28_);
				_g_object_unref0 (_tmp25_);
				_g_object_unref0 (_tmp22_);
				_g_object_unref0 (sent_date);
				_g_object_unref0 (message_id);
				_g_object_unref0 (in_reply_to);
				_g_object_unref0 (bcc);
				_g_object_unref0 (cc);
				_g_object_unref0 (to);
				_g_object_unref0 (reply_to);
				_g_object_unref0 (sender);
				_g_object_unref0 (from);
				_g_object_unref0 (subject);
				_g_object_unref0 (sent);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	} else {
		_g_object_unref0 (_tmp35_);
		_tmp35_ = NULL;
	}
	_tmp40_ = bcc;
	if (_tmp40_ != NULL) {
		GearyImapListParameter* _tmp41_;
		GearyRFC822MailboxAddresses* _tmp42_;
		_tmp41_ = bcc;
		_tmp42_ = geary_imap_envelope_decoder_parse_addresses (self, _tmp41_, &_inner_error0_);
		_g_object_unref0 (_tmp39_);
		_tmp39_ = _tmp42_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_tmp39_);
				_g_object_unref0 (_tmp35_);
				_g_object_unref0 (_tmp31_);
				_g_object_unref0 (_tmp28_);
				_g_object_unref0 (_tmp25_);
				_g_object_unref0 (_tmp22_);
				_g_object_unref0 (sent_date);
				_g_object_unref0 (message_id);
				_g_object_unref0 (in_reply_to);
				_g_object_unref0 (bcc);
				_g_object_unref0 (cc);
				_g_object_unref0 (to);
				_g_object_unref0 (reply_to);
				_g_object_unref0 (sender);
				_g_object_unref0 (from);
				_g_object_unref0 (subject);
				_g_object_unref0 (sent);
				return NULL;
			} else {
				_g_object_unref0 (_tmp39_);
				_g_object_unref0 (_tmp35_);
				_g_object_unref0 (_tmp31_);
				_g_object_unref0 (_tmp28_);
				_g_object_unref0 (_tmp25_);
				_g_object_unref0 (_tmp22_);
				_g_object_unref0 (sent_date);
				_g_object_unref0 (message_id);
				_g_object_unref0 (in_reply_to);
				_g_object_unref0 (bcc);
				_g_object_unref0 (cc);
				_g_object_unref0 (to);
				_g_object_unref0 (reply_to);
				_g_object_unref0 (sender);
				_g_object_unref0 (from);
				_g_object_unref0 (subject);
				_g_object_unref0 (sent);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	} else {
		_g_object_unref0 (_tmp39_);
		_tmp39_ = NULL;
	}
	_tmp44_ = in_reply_to;
	if (_tmp44_ != NULL) {
		GearyImapStringParameter* _tmp45_;
		const gchar* _tmp46_;
		const gchar* _tmp47_;
		GearyRFC822MessageIDList* _tmp48_;
		_tmp45_ = in_reply_to;
		_tmp46_ = geary_imap_string_parameter_get_ascii (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = geary_imap_envelope_decoder_new_message_id_list (self, _tmp47_);
		_g_object_unref0 (_tmp43_);
		_tmp43_ = _tmp48_;
	} else {
		_g_object_unref0 (_tmp43_);
		_tmp43_ = NULL;
	}
	_tmp50_ = message_id;
	if (_tmp50_ != NULL) {
		GearyImapStringParameter* _tmp51_;
		const gchar* _tmp52_;
		const gchar* _tmp53_;
		GearyRFC822MessageID* _tmp54_;
		_tmp51_ = message_id;
		_tmp52_ = geary_imap_string_parameter_get_ascii (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = geary_imap_envelope_decoder_new_message_id (self, _tmp53_);
		_g_object_unref0 (_tmp49_);
		_tmp49_ = _tmp54_;
	} else {
		_g_object_unref0 (_tmp49_);
		_tmp49_ = NULL;
	}
	_tmp55_ = sent_date;
	_tmp56_ = subject;
	_tmp57_ = geary_imap_string_parameter_get_ascii (_tmp56_);
	_tmp58_ = _tmp57_;
	_tmp59_ = geary_rf_c822_subject_new_from_rfc822_string (_tmp58_);
	_tmp60_ = _tmp59_;
	_tmp61_ = geary_imap_envelope_new (_tmp55_, _tmp60_, _tmp22_, _tmp25_, _tmp28_, _tmp31_, _tmp35_, _tmp39_, _tmp43_, _tmp49_);
	_tmp62_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, GEARY_IMAP_TYPE_MESSAGE_DATA, GearyImapMessageData);
	_g_object_unref0 (_tmp60_);
	result = _tmp62_;
	_g_object_unref0 (_tmp49_);
	_g_object_unref0 (_tmp43_);
	_g_object_unref0 (_tmp39_);
	_g_object_unref0 (_tmp35_);
	_g_object_unref0 (_tmp31_);
	_g_object_unref0 (_tmp28_);
	_g_object_unref0 (_tmp25_);
	_g_object_unref0 (_tmp22_);
	_g_object_unref0 (sent_date);
	_g_object_unref0 (message_id);
	_g_object_unref0 (in_reply_to);
	_g_object_unref0 (bcc);
	_g_object_unref0 (cc);
	_g_object_unref0 (to);
	_g_object_unref0 (reply_to);
	_g_object_unref0 (sender);
	_g_object_unref0 (from);
	_g_object_unref0 (subject);
	_g_object_unref0 (sent);
	return result;
}

static GearyRFC822MailboxAddresses*
geary_imap_envelope_decoder_parse_addresses (GearyImapEnvelopeDecoder* self,
                                             GearyImapListParameter* listp,
                                             GError** error)
{
	GeeList* list = NULL;
	GeeArrayList* _tmp0_;
	GeeList* _tmp49_;
	GearyRFC822MailboxAddresses* _tmp50_;
	GError* _inner_error0_ = NULL;
	GearyRFC822MailboxAddresses* result;
	g_return_val_if_fail (GEARY_IMAP_IS_ENVELOPE_DECODER (self), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (listp), NULL);
	_tmp0_ = gee_array_list_new (GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				GearyImapListParameter* fields = NULL;
				GearyImapListParameter* _tmp5_;
				GearyImapStringParameter* name = NULL;
				GearyImapListParameter* _tmp6_;
				GearyImapStringParameter* _tmp7_;
				GearyImapStringParameter* source_route = NULL;
				GearyImapListParameter* _tmp8_;
				GearyImapStringParameter* _tmp9_;
				GearyImapStringParameter* mailbox = NULL;
				GearyImapListParameter* _tmp10_;
				GearyImapStringParameter* _tmp11_;
				GearyImapStringParameter* domain = NULL;
				GearyImapListParameter* _tmp12_;
				GearyImapStringParameter* _tmp13_;
				GearyImapStringParameter* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				GearyImapQuirks* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				GearyImapStringParameter* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				GearyImapQuirks* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_ = NULL;
				GearyImapStringParameter* _tmp27_;
				const gchar* _tmp31_ = NULL;
				GearyImapStringParameter* _tmp32_;
				const gchar* _tmp36_ = NULL;
				GearyImapStringParameter* _tmp37_;
				const gchar* _tmp41_ = NULL;
				GearyImapStringParameter* _tmp42_;
				GearyRFC822MailboxAddress* addr = NULL;
				GearyRFC822MailboxAddress* _tmp46_;
				GeeList* _tmp47_;
				GearyRFC822MailboxAddress* _tmp48_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = ctr;
					ctr = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = geary_imap_list_parameter_get_size (listp);
				_tmp4_ = _tmp3_;
				if (!(ctr < _tmp4_)) {
					break;
				}
				_tmp5_ = geary_imap_list_parameter_get_as_empty_list (listp, ctr, &_inner_error0_);
				fields = _tmp5_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_object_unref0 (list);
						return NULL;
					} else {
						_g_object_unref0 (list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp6_ = fields;
				_tmp7_ = geary_imap_list_parameter_get_as_nullable_string (_tmp6_, 0, &_inner_error0_);
				name = _tmp7_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_object_unref0 (fields);
						_g_object_unref0 (list);
						return NULL;
					} else {
						_g_object_unref0 (fields);
						_g_object_unref0 (list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp8_ = fields;
				_tmp9_ = geary_imap_list_parameter_get_as_nullable_string (_tmp8_, 1, &_inner_error0_);
				source_route = _tmp9_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_object_unref0 (name);
						_g_object_unref0 (fields);
						_g_object_unref0 (list);
						return NULL;
					} else {
						_g_object_unref0 (name);
						_g_object_unref0 (fields);
						_g_object_unref0 (list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp10_ = fields;
				_tmp11_ = geary_imap_list_parameter_get_as_empty_string (_tmp10_, 2, &_inner_error0_);
				mailbox = _tmp11_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_object_unref0 (source_route);
						_g_object_unref0 (name);
						_g_object_unref0 (fields);
						_g_object_unref0 (list);
						return NULL;
					} else {
						_g_object_unref0 (source_route);
						_g_object_unref0 (name);
						_g_object_unref0 (fields);
						_g_object_unref0 (list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp12_ = fields;
				_tmp13_ = geary_imap_list_parameter_get_as_empty_string (_tmp12_, 3, &_inner_error0_);
				domain = _tmp13_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_object_unref0 (mailbox);
						_g_object_unref0 (source_route);
						_g_object_unref0 (name);
						_g_object_unref0 (fields);
						_g_object_unref0 (list);
						return NULL;
					} else {
						_g_object_unref0 (mailbox);
						_g_object_unref0 (source_route);
						_g_object_unref0 (name);
						_g_object_unref0 (fields);
						_g_object_unref0 (list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp14_ = mailbox;
				_tmp15_ = geary_imap_string_parameter_get_ascii (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = self->priv->quirks;
				_tmp18_ = geary_imap_quirks_get_empty_envelope_mailbox_name (_tmp17_);
				_tmp19_ = _tmp18_;
				if (g_strcmp0 (_tmp16_, _tmp19_) == 0) {
					_g_object_unref0 (mailbox);
					mailbox = NULL;
				}
				_tmp20_ = domain;
				_tmp21_ = geary_imap_string_parameter_get_ascii (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = self->priv->quirks;
				_tmp24_ = geary_imap_quirks_get_empty_envelope_host_name (_tmp23_);
				_tmp25_ = _tmp24_;
				if (g_strcmp0 (_tmp22_, _tmp25_) == 0) {
					_g_object_unref0 (domain);
					domain = NULL;
				}
				_tmp27_ = name;
				if (_tmp27_ != NULL) {
					GearyImapStringParameter* _tmp28_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					_tmp28_ = name;
					_tmp29_ = geary_imap_string_parameter_get_nullable_ascii (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp26_ = _tmp30_;
				} else {
					_tmp26_ = NULL;
				}
				_tmp32_ = source_route;
				if (_tmp32_ != NULL) {
					GearyImapStringParameter* _tmp33_;
					const gchar* _tmp34_;
					const gchar* _tmp35_;
					_tmp33_ = source_route;
					_tmp34_ = geary_imap_string_parameter_get_nullable_ascii (_tmp33_);
					_tmp35_ = _tmp34_;
					_tmp31_ = _tmp35_;
				} else {
					_tmp31_ = NULL;
				}
				_tmp37_ = mailbox;
				if (_tmp37_ != NULL) {
					GearyImapStringParameter* _tmp38_;
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					_tmp38_ = mailbox;
					_tmp39_ = geary_imap_string_parameter_get_ascii (_tmp38_);
					_tmp40_ = _tmp39_;
					_tmp36_ = _tmp40_;
				} else {
					_tmp36_ = "";
				}
				_tmp42_ = domain;
				if (_tmp42_ != NULL) {
					GearyImapStringParameter* _tmp43_;
					const gchar* _tmp44_;
					const gchar* _tmp45_;
					_tmp43_ = domain;
					_tmp44_ = geary_imap_string_parameter_get_ascii (_tmp43_);
					_tmp45_ = _tmp44_;
					_tmp41_ = _tmp45_;
				} else {
					_tmp41_ = "";
				}
				_tmp46_ = geary_rf_c822_mailbox_address_new_imap (_tmp26_, _tmp31_, _tmp36_, _tmp41_);
				addr = _tmp46_;
				_tmp47_ = list;
				_tmp48_ = addr;
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, GEE_TYPE_COLLECTION, GeeCollection), _tmp48_);
				_g_object_unref0 (addr);
				_g_object_unref0 (domain);
				_g_object_unref0 (mailbox);
				_g_object_unref0 (source_route);
				_g_object_unref0 (name);
				_g_object_unref0 (fields);
			}
		}
	}
	_tmp49_ = list;
	_tmp50_ = geary_rf_c822_mailbox_addresses_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GEE_TYPE_COLLECTION, GeeCollection));
	result = _tmp50_;
	_g_object_unref0 (list);
	return result;
}

static GearyRFC822MessageID*
geary_imap_envelope_decoder_new_message_id (GearyImapEnvelopeDecoder* self,
                                            const gchar* rfc822)
{
	GearyRFC822MessageID* id = NULL;
	GError* _inner_error0_ = NULL;
	GearyRFC822MessageID* result;
	g_return_val_if_fail (GEARY_IMAP_IS_ENVELOPE_DECODER (self), NULL);
	id = NULL;
	if (!geary_string_is_empty_or_whitespace (rfc822)) {
		{
			GearyRFC822MessageID* _tmp0_ = NULL;
			GearyRFC822MessageID* _tmp1_;
			GearyRFC822MessageID* _tmp2_;
			_tmp1_ = geary_rf_c822_message_id_new_from_rfc822_string (rfc822, &_inner_error0_);
			_tmp0_ = _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
					goto __catch0_geary_rf_c822_error;
				}
				_g_object_unref0 (id);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp2_ = _tmp0_;
			_tmp0_ = NULL;
			_g_object_unref0 (id);
			id = _tmp2_;
			_g_object_unref0 (_tmp0_);
		}
		goto __finally0;
		__catch0_geary_rf_c822_error:
		{
			GError* err = NULL;
			GError* _tmp3_;
			const gchar* _tmp4_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = err;
			_tmp4_ = _tmp3_->message;
			g_debug ("imap-fetch-data-decoder.vala:216: Failed to parse message id: %s", _tmp4_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = id;
	return result;
}

static GearyRFC822MessageIDList*
geary_imap_envelope_decoder_new_message_id_list (GearyImapEnvelopeDecoder* self,
                                                 const gchar* rfc822)
{
	GearyRFC822MessageIDList* list = NULL;
	GError* _inner_error0_ = NULL;
	GearyRFC822MessageIDList* result;
	g_return_val_if_fail (GEARY_IMAP_IS_ENVELOPE_DECODER (self), NULL);
	list = NULL;
	if (!geary_string_is_empty_or_whitespace (rfc822)) {
		{
			GearyRFC822MessageIDList* _tmp0_ = NULL;
			GearyRFC822MessageIDList* _tmp1_;
			GearyRFC822MessageIDList* _tmp2_;
			_tmp1_ = geary_rf_c822_message_id_list_new_from_rfc822_string (rfc822, &_inner_error0_);
			_tmp0_ = _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
					goto __catch0_geary_rf_c822_error;
				}
				_g_object_unref0 (list);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp2_ = _tmp0_;
			_tmp0_ = NULL;
			_g_object_unref0 (list);
			list = _tmp2_;
			_g_object_unref0 (_tmp0_);
		}
		goto __finally0;
		__catch0_geary_rf_c822_error:
		{
			GError* err = NULL;
			GError* _tmp3_;
			const gchar* _tmp4_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = err;
			_tmp4_ = _tmp3_->message;
			g_debug ("imap-fetch-data-decoder.vala:228: Failed to parse message id list: %s", _tmp4_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = list;
	return result;
}

static void
geary_imap_envelope_decoder_class_init (GearyImapEnvelopeDecoderClass * klass,
                                        gpointer klass_data)
{
	geary_imap_envelope_decoder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapEnvelopeDecoder_private_offset);
	((GearyImapFetchDataDecoderClass *) klass)->decode_list = (GearyImapMessageData* (*) (GearyImapFetchDataDecoder*, GearyImapListParameter*, GError**)) geary_imap_envelope_decoder_real_decode_list;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_envelope_decoder_finalize;
}

static void
geary_imap_envelope_decoder_instance_init (GearyImapEnvelopeDecoder * self,
                                           gpointer klass)
{
	self->priv = geary_imap_envelope_decoder_get_instance_private (self);
}

static void
geary_imap_envelope_decoder_finalize (GObject * obj)
{
	GearyImapEnvelopeDecoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_ENVELOPE_DECODER, GearyImapEnvelopeDecoder);
	_g_object_unref0 (self->priv->quirks);
	G_OBJECT_CLASS (geary_imap_envelope_decoder_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_imap_envelope_decoder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapEnvelopeDecoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_envelope_decoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapEnvelopeDecoder), 0, (GInstanceInitFunc) geary_imap_envelope_decoder_instance_init, NULL };
	GType geary_imap_envelope_decoder_type_id;
	geary_imap_envelope_decoder_type_id = g_type_register_static (GEARY_IMAP_TYPE_FETCH_DATA_DECODER, "GearyImapEnvelopeDecoder", &g_define_type_info, 0);
	GearyImapEnvelopeDecoder_private_offset = g_type_add_instance_private (geary_imap_envelope_decoder_type_id, sizeof (GearyImapEnvelopeDecoderPrivate));
	return geary_imap_envelope_decoder_type_id;
}

GType
geary_imap_envelope_decoder_get_type (void)
{
	static gsize geary_imap_envelope_decoder_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_envelope_decoder_type_id__once)) {
		GType geary_imap_envelope_decoder_type_id;
		geary_imap_envelope_decoder_type_id = geary_imap_envelope_decoder_get_type_once ();
		g_once_init_leave (&geary_imap_envelope_decoder_type_id__once, geary_imap_envelope_decoder_type_id);
	}
	return geary_imap_envelope_decoder_type_id__once;
}

GearyImapRFC822HeaderDecoder*
geary_imap_rf_c822_header_decoder_construct (GType object_type)
{
	GearyImapRFC822HeaderDecoder * self = NULL;
	self = (GearyImapRFC822HeaderDecoder*) geary_imap_fetch_data_decoder_construct (object_type, GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822_HEADER);
	return self;
}

GearyImapRFC822HeaderDecoder*
geary_imap_rf_c822_header_decoder_new (void)
{
	return geary_imap_rf_c822_header_decoder_construct (GEARY_IMAP_TYPE_RF_C822_HEADER_DECODER);
}

static GearyImapMessageData*
geary_imap_rf_c822_header_decoder_real_decode_literal (GearyImapFetchDataDecoder* base,
                                                       GearyImapLiteralParameter* literalp,
                                                       GError** error)
{
	GearyImapRFC822HeaderDecoder * self;
	GearyImapRFC822Header* _tmp0_ = NULL;
	GearyMemoryBuffer* _tmp1_;
	GearyMemoryBuffer* _tmp2_;
	GearyImapRFC822Header* _tmp3_;
	GearyImapRFC822Header* _tmp4_;
	GError* _inner_error0_ = NULL;
	GearyImapMessageData* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_RF_C822_HEADER_DECODER, GearyImapRFC822HeaderDecoder);
	g_return_val_if_fail (GEARY_IMAP_IS_LITERAL_PARAMETER (literalp), NULL);
	_tmp1_ = geary_imap_literal_parameter_get_value (literalp);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_imap_rf_c822_header_new (_tmp2_, &_inner_error0_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEARY_IMAP_TYPE_MESSAGE_DATA, GearyImapMessageData);
	_g_object_unref0 (_tmp0_);
	return result;
}

static void
geary_imap_rf_c822_header_decoder_class_init (GearyImapRFC822HeaderDecoderClass * klass,
                                              gpointer klass_data)
{
	geary_imap_rf_c822_header_decoder_parent_class = g_type_class_peek_parent (klass);
	((GearyImapFetchDataDecoderClass *) klass)->decode_literal = (GearyImapMessageData* (*) (GearyImapFetchDataDecoder*, GearyImapLiteralParameter*, GError**)) geary_imap_rf_c822_header_decoder_real_decode_literal;
}

static void
geary_imap_rf_c822_header_decoder_instance_init (GearyImapRFC822HeaderDecoder * self,
                                                 gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
geary_imap_rf_c822_header_decoder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapRFC822HeaderDecoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_rf_c822_header_decoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapRFC822HeaderDecoder), 0, (GInstanceInitFunc) geary_imap_rf_c822_header_decoder_instance_init, NULL };
	GType geary_imap_rf_c822_header_decoder_type_id;
	geary_imap_rf_c822_header_decoder_type_id = g_type_register_static (GEARY_IMAP_TYPE_FETCH_DATA_DECODER, "GearyImapRFC822HeaderDecoder", &g_define_type_info, 0);
	return geary_imap_rf_c822_header_decoder_type_id;
}

GType
geary_imap_rf_c822_header_decoder_get_type (void)
{
	static gsize geary_imap_rf_c822_header_decoder_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_rf_c822_header_decoder_type_id__once)) {
		GType geary_imap_rf_c822_header_decoder_type_id;
		geary_imap_rf_c822_header_decoder_type_id = geary_imap_rf_c822_header_decoder_get_type_once ();
		g_once_init_leave (&geary_imap_rf_c822_header_decoder_type_id__once, geary_imap_rf_c822_header_decoder_type_id);
	}
	return geary_imap_rf_c822_header_decoder_type_id__once;
}

GearyImapRFC822TextDecoder*
geary_imap_rf_c822_text_decoder_construct (GType object_type)
{
	GearyImapRFC822TextDecoder * self = NULL;
	self = (GearyImapRFC822TextDecoder*) geary_imap_fetch_data_decoder_construct (object_type, GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822_TEXT);
	return self;
}

GearyImapRFC822TextDecoder*
geary_imap_rf_c822_text_decoder_new (void)
{
	return geary_imap_rf_c822_text_decoder_construct (GEARY_IMAP_TYPE_RF_C822_TEXT_DECODER);
}

static GearyImapMessageData*
geary_imap_rf_c822_text_decoder_real_decode_literal (GearyImapFetchDataDecoder* base,
                                                     GearyImapLiteralParameter* literalp,
                                                     GError** error)
{
	GearyImapRFC822TextDecoder * self;
	GearyMemoryBuffer* _tmp0_;
	GearyMemoryBuffer* _tmp1_;
	GearyImapRFC822Text* _tmp2_;
	GearyImapMessageData* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_RF_C822_TEXT_DECODER, GearyImapRFC822TextDecoder);
	g_return_val_if_fail (GEARY_IMAP_IS_LITERAL_PARAMETER (literalp), NULL);
	_tmp0_ = geary_imap_literal_parameter_get_value (literalp);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_imap_rf_c822_text_new (_tmp1_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_IMAP_TYPE_MESSAGE_DATA, GearyImapMessageData);
	return result;
}

static GearyImapMessageData*
geary_imap_rf_c822_text_decoder_real_decode_nil (GearyImapFetchDataDecoder* base,
                                                 GearyImapNilParameter* nilp,
                                                 GError** error)
{
	GearyImapRFC822TextDecoder * self;
	GearyMemoryEmptyBuffer* _tmp0_;
	GearyMemoryEmptyBuffer* _tmp1_;
	GearyImapRFC822Text* _tmp2_;
	GearyImapMessageData* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_RF_C822_TEXT_DECODER, GearyImapRFC822TextDecoder);
	g_return_val_if_fail (GEARY_IMAP_IS_NIL_PARAMETER (nilp), NULL);
	_tmp0_ = geary_memory_empty_buffer_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_imap_rf_c822_text_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer));
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_IMAP_TYPE_MESSAGE_DATA, GearyImapMessageData);
	return result;
}

static void
geary_imap_rf_c822_text_decoder_class_init (GearyImapRFC822TextDecoderClass * klass,
                                            gpointer klass_data)
{
	geary_imap_rf_c822_text_decoder_parent_class = g_type_class_peek_parent (klass);
	((GearyImapFetchDataDecoderClass *) klass)->decode_literal = (GearyImapMessageData* (*) (GearyImapFetchDataDecoder*, GearyImapLiteralParameter*, GError**)) geary_imap_rf_c822_text_decoder_real_decode_literal;
	((GearyImapFetchDataDecoderClass *) klass)->decode_nil = (GearyImapMessageData* (*) (GearyImapFetchDataDecoder*, GearyImapNilParameter*, GError**)) geary_imap_rf_c822_text_decoder_real_decode_nil;
}

static void
geary_imap_rf_c822_text_decoder_instance_init (GearyImapRFC822TextDecoder * self,
                                               gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
geary_imap_rf_c822_text_decoder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapRFC822TextDecoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_rf_c822_text_decoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapRFC822TextDecoder), 0, (GInstanceInitFunc) geary_imap_rf_c822_text_decoder_instance_init, NULL };
	GType geary_imap_rf_c822_text_decoder_type_id;
	geary_imap_rf_c822_text_decoder_type_id = g_type_register_static (GEARY_IMAP_TYPE_FETCH_DATA_DECODER, "GearyImapRFC822TextDecoder", &g_define_type_info, 0);
	return geary_imap_rf_c822_text_decoder_type_id;
}

GType
geary_imap_rf_c822_text_decoder_get_type (void)
{
	static gsize geary_imap_rf_c822_text_decoder_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_rf_c822_text_decoder_type_id__once)) {
		GType geary_imap_rf_c822_text_decoder_type_id;
		geary_imap_rf_c822_text_decoder_type_id = geary_imap_rf_c822_text_decoder_get_type_once ();
		g_once_init_leave (&geary_imap_rf_c822_text_decoder_type_id__once, geary_imap_rf_c822_text_decoder_type_id);
	}
	return geary_imap_rf_c822_text_decoder_type_id__once;
}

GearyImapRFC822FullDecoder*
geary_imap_rf_c822_full_decoder_construct (GType object_type)
{
	GearyImapRFC822FullDecoder * self = NULL;
	self = (GearyImapRFC822FullDecoder*) geary_imap_fetch_data_decoder_construct (object_type, GEARY_IMAP_FETCH_DATA_SPECIFIER_RFC822);
	return self;
}

GearyImapRFC822FullDecoder*
geary_imap_rf_c822_full_decoder_new (void)
{
	return geary_imap_rf_c822_full_decoder_construct (GEARY_IMAP_TYPE_RF_C822_FULL_DECODER);
}

static GearyImapMessageData*
geary_imap_rf_c822_full_decoder_real_decode_literal (GearyImapFetchDataDecoder* base,
                                                     GearyImapLiteralParameter* literalp,
                                                     GError** error)
{
	GearyImapRFC822FullDecoder * self;
	GearyMemoryBuffer* _tmp0_;
	GearyMemoryBuffer* _tmp1_;
	GearyImapRFC822Full* _tmp2_;
	GearyImapMessageData* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_RF_C822_FULL_DECODER, GearyImapRFC822FullDecoder);
	g_return_val_if_fail (GEARY_IMAP_IS_LITERAL_PARAMETER (literalp), NULL);
	_tmp0_ = geary_imap_literal_parameter_get_value (literalp);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_imap_rf_c822_full_new (_tmp1_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_IMAP_TYPE_MESSAGE_DATA, GearyImapMessageData);
	return result;
}

static void
geary_imap_rf_c822_full_decoder_class_init (GearyImapRFC822FullDecoderClass * klass,
                                            gpointer klass_data)
{
	geary_imap_rf_c822_full_decoder_parent_class = g_type_class_peek_parent (klass);
	((GearyImapFetchDataDecoderClass *) klass)->decode_literal = (GearyImapMessageData* (*) (GearyImapFetchDataDecoder*, GearyImapLiteralParameter*, GError**)) geary_imap_rf_c822_full_decoder_real_decode_literal;
}

static void
geary_imap_rf_c822_full_decoder_instance_init (GearyImapRFC822FullDecoder * self,
                                               gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
geary_imap_rf_c822_full_decoder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapRFC822FullDecoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_rf_c822_full_decoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapRFC822FullDecoder), 0, (GInstanceInitFunc) geary_imap_rf_c822_full_decoder_instance_init, NULL };
	GType geary_imap_rf_c822_full_decoder_type_id;
	geary_imap_rf_c822_full_decoder_type_id = g_type_register_static (GEARY_IMAP_TYPE_FETCH_DATA_DECODER, "GearyImapRFC822FullDecoder", &g_define_type_info, 0);
	return geary_imap_rf_c822_full_decoder_type_id;
}

GType
geary_imap_rf_c822_full_decoder_get_type (void)
{
	static gsize geary_imap_rf_c822_full_decoder_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_rf_c822_full_decoder_type_id__once)) {
		GType geary_imap_rf_c822_full_decoder_type_id;
		geary_imap_rf_c822_full_decoder_type_id = geary_imap_rf_c822_full_decoder_get_type_once ();
		g_once_init_leave (&geary_imap_rf_c822_full_decoder_type_id__once, geary_imap_rf_c822_full_decoder_type_id);
	}
	return geary_imap_rf_c822_full_decoder_type_id__once;
}

