/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.json;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import tim.prune.App;
import tim.prune.data.Field;
import tim.prune.data.SourceInfo;
import tim.prune.load.json.JsonBlock;
import tim.prune.load.json.JsonPoint;

public class JsonFileLoader {
    private App _app = null;
    private Stack<JsonBlock> _jsonBlocks = null;
    private ArrayList<JsonPoint> _jsonPoints = null;
    private boolean _newSegment = true;

    public JsonFileLoader(App app) {
        this._app = app;
        this._jsonBlocks = new Stack();
        this._jsonPoints = new ArrayList();
    }

    public void openFile(File file) {
        Field[] fieldArray;
        block16: {
            BufferedReader bufferedReader = null;
            try {
                try {
                    bufferedReader = new BufferedReader(new FileReader(file));
                    fieldArray = bufferedReader.readLine();
                    while (fieldArray != null) {
                        this.processTokensInLine((String)fieldArray);
                        fieldArray = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    this._app.showErrorMessage("error.load.dialogtitle", "error.load.noread");
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block16;
                    }
                    catch (Exception exception) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        if (this._jsonPoints.size() > 0) {
            fieldArray = new Field[]{Field.LATITUDE, Field.LONGITUDE, Field.ALTITUDE, Field.NEW_SEGMENT};
            this._app.informDataLoaded(fieldArray, this.makeDataArray(), null, new SourceInfo(file, SourceInfo.FILE_TYPE.JSON), null);
        }
    }

    private void processTokensInLine(String string) {
        if (string == null) {
            return;
        }
        String string2 = string.strip();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        char[] cArray = string2.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (bl || c == '\"') {
                stringBuilder.append(c);
            } else if (" :,".indexOf(c) >= 0) {
                this.processToken(stringBuilder.toString());
                stringBuilder.setLength(0);
            } else if ("[{".indexOf(c) >= 0) {
                this._jsonBlocks.add(new JsonBlock());
            } else if ("]}".indexOf(c) >= 0) {
                this.processToken(stringBuilder.toString());
                stringBuilder.setLength(0);
                this.processBlock(this._jsonBlocks.pop());
            } else {
                stringBuilder.append(c);
            }
            if (c == '\"' && !bl2) {
                bl = !bl;
            }
            bl2 = c == '\\' && !bl2;
            ++n2;
        }
        this.processToken(stringBuilder.toString());
    }

    private void processToken(String string) {
        if (string == null || string.isBlank()) {
            return;
        }
        if (string.equals("\"coordinates\"")) {
            this._newSegment = true;
        }
        this._jsonBlocks.peek().addToken(string);
    }

    private void processBlock(JsonBlock jsonBlock) {
        if (jsonBlock.areFieldsValid()) {
            this._jsonPoints.add(jsonBlock.createSinglePoint(this._newSegment));
            this._newSegment = false;
        } else if (jsonBlock.areSingleCoordsValid()) {
            this._jsonBlocks.peek().addSingleCoordsFrom(jsonBlock);
        } else if (jsonBlock.isCoordListValid()) {
            this._jsonBlocks.peek().addCoordListFrom(jsonBlock);
        } else if (jsonBlock.hasValidCoordList()) {
            int n = 0;
            while (n < jsonBlock.getNumPoints()) {
                this._jsonPoints.add(jsonBlock.createPointFromList(n));
                ++n;
            }
            this._newSegment = true;
        }
    }

    private Object[][] makeDataArray() {
        Object[][] objectArray = new Object[this._jsonPoints.size()][];
        int n = 0;
        while (n < this._jsonPoints.size()) {
            JsonPoint jsonPoint = this._jsonPoints.get(n);
            objectArray[n] = new String[]{jsonPoint._latitude, jsonPoint._longitude, jsonPoint._altitude, jsonPoint._newSegment ? "1" : "0"};
            ++n;
        }
        return objectArray;
    }
}

