/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.tagexpression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.platform.launcher.tagexpression.Token;

class Tokenizer {
    private static final Pattern PATTERN = Pattern.compile("\\s*(?:(?:(?:any|none)\\(\\))|[()!|&]|(?:[^\\s()!|&]+))", 2);

    Tokenizer() {
    }

    List<Token> tokenize(String infixTagExpression) {
        if (infixTagExpression == null) {
            return Collections.emptyList();
        }
        ArrayList<Token> parts = new ArrayList<Token>();
        Matcher matcher = PATTERN.matcher(infixTagExpression);
        while (matcher.find()) {
            parts.add(new Token(matcher.start(), matcher.group()));
        }
        return parts;
    }
}

