/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.notifications;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionResponse;
import org.opensearch.client.Client;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.commons.notifications.NotificationsPluginInterface;
import org.opensearch.commons.notifications.action.BaseResponse;
import org.opensearch.commons.notifications.action.CreateNotificationConfigRequest;
import org.opensearch.commons.notifications.action.CreateNotificationConfigResponse;
import org.opensearch.commons.notifications.action.DeleteNotificationConfigRequest;
import org.opensearch.commons.notifications.action.DeleteNotificationConfigResponse;
import org.opensearch.commons.notifications.action.GetChannelListRequest;
import org.opensearch.commons.notifications.action.GetChannelListResponse;
import org.opensearch.commons.notifications.action.GetNotificationConfigRequest;
import org.opensearch.commons.notifications.action.GetNotificationConfigResponse;
import org.opensearch.commons.notifications.action.GetPluginFeaturesRequest;
import org.opensearch.commons.notifications.action.GetPluginFeaturesResponse;
import org.opensearch.commons.notifications.action.LegacyPublishNotificationRequest;
import org.opensearch.commons.notifications.action.LegacyPublishNotificationResponse;
import org.opensearch.commons.notifications.action.NotificationsActions;
import org.opensearch.commons.notifications.action.SendNotificationRequest;
import org.opensearch.commons.notifications.action.SendNotificationResponse;
import org.opensearch.commons.notifications.action.UpdateNotificationConfigRequest;
import org.opensearch.commons.notifications.action.UpdateNotificationConfigResponse;
import org.opensearch.commons.notifications.model.ChannelMessage;
import org.opensearch.commons.notifications.model.EventSource;
import org.opensearch.commons.utils.SecureClientWrapper;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ$\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000e0\nJ$\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00110\nJ$\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00132\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00140\nJ$\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00162\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00170\nJ$\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00192\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u001a0\nJ:\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020#0\nJ$\u0010$\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020%2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020&0\nJ:\u0010'\u001a\b\u0012\u0004\u0012\u0002H(0\n\"\b\b\u0000\u0010(*\u00020)2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H(0\n2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u0002H(0+H\u0002\u00a8\u0006-"}, d2={"Lorg/opensearch/commons/notifications/NotificationsPluginInterface;", "", "()V", "createNotificationConfig", "", "client", "Lorg/opensearch/client/node/NodeClient;", "request", "Lorg/opensearch/commons/notifications/action/CreateNotificationConfigRequest;", "listener", "Lorg/opensearch/action/ActionListener;", "Lorg/opensearch/commons/notifications/action/CreateNotificationConfigResponse;", "deleteNotificationConfig", "Lorg/opensearch/commons/notifications/action/DeleteNotificationConfigRequest;", "Lorg/opensearch/commons/notifications/action/DeleteNotificationConfigResponse;", "getChannelList", "Lorg/opensearch/commons/notifications/action/GetChannelListRequest;", "Lorg/opensearch/commons/notifications/action/GetChannelListResponse;", "getNotificationConfig", "Lorg/opensearch/commons/notifications/action/GetNotificationConfigRequest;", "Lorg/opensearch/commons/notifications/action/GetNotificationConfigResponse;", "getPluginFeatures", "Lorg/opensearch/commons/notifications/action/GetPluginFeaturesRequest;", "Lorg/opensearch/commons/notifications/action/GetPluginFeaturesResponse;", "publishLegacyNotification", "Lorg/opensearch/commons/notifications/action/LegacyPublishNotificationRequest;", "Lorg/opensearch/commons/notifications/action/LegacyPublishNotificationResponse;", "sendNotification", "eventSource", "Lorg/opensearch/commons/notifications/model/EventSource;", "channelMessage", "Lorg/opensearch/commons/notifications/model/ChannelMessage;", "channelIds", "", "", "Lorg/opensearch/commons/notifications/action/SendNotificationResponse;", "updateNotificationConfig", "Lorg/opensearch/commons/notifications/action/UpdateNotificationConfigRequest;", "Lorg/opensearch/commons/notifications/action/UpdateNotificationConfigResponse;", "wrapActionListener", "Response", "Lorg/opensearch/commons/notifications/action/BaseResponse;", "recreate", "Lkotlin/Function1;", "Lorg/opensearch/common/io/stream/Writeable;", "common-utils"})
public final class NotificationsPluginInterface {
    @NotNull
    public static final NotificationsPluginInterface INSTANCE = new NotificationsPluginInterface();

    private NotificationsPluginInterface() {
    }

    public final void createNotificationConfig(@NotNull NodeClient client, @NotNull CreateNotificationConfigRequest request, @NotNull ActionListener<CreateNotificationConfigResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        client.execute(NotificationsActions.INSTANCE.getCREATE_NOTIFICATION_CONFIG_ACTION_TYPE(), (ActionRequest)request, this.wrapActionListener(listener, createNotificationConfig.1.INSTANCE));
    }

    public final void updateNotificationConfig(@NotNull NodeClient client, @NotNull UpdateNotificationConfigRequest request, @NotNull ActionListener<UpdateNotificationConfigResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        client.execute(NotificationsActions.INSTANCE.getUPDATE_NOTIFICATION_CONFIG_ACTION_TYPE(), (ActionRequest)request, this.wrapActionListener(listener, updateNotificationConfig.1.INSTANCE));
    }

    public final void deleteNotificationConfig(@NotNull NodeClient client, @NotNull DeleteNotificationConfigRequest request, @NotNull ActionListener<DeleteNotificationConfigResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        client.execute(NotificationsActions.INSTANCE.getDELETE_NOTIFICATION_CONFIG_ACTION_TYPE(), (ActionRequest)request, this.wrapActionListener(listener, deleteNotificationConfig.1.INSTANCE));
    }

    public final void getNotificationConfig(@NotNull NodeClient client, @NotNull GetNotificationConfigRequest request, @NotNull ActionListener<GetNotificationConfigResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        client.execute(NotificationsActions.INSTANCE.getGET_NOTIFICATION_CONFIG_ACTION_TYPE(), (ActionRequest)request, this.wrapActionListener(listener, getNotificationConfig.1.INSTANCE));
    }

    public final void getPluginFeatures(@NotNull NodeClient client, @NotNull GetPluginFeaturesRequest request, @NotNull ActionListener<GetPluginFeaturesResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        client.execute(NotificationsActions.INSTANCE.getGET_PLUGIN_FEATURES_ACTION_TYPE(), (ActionRequest)request, this.wrapActionListener(listener, getPluginFeatures.1.INSTANCE));
    }

    public final void getChannelList(@NotNull NodeClient client, @NotNull GetChannelListRequest request, @NotNull ActionListener<GetChannelListResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        client.execute(NotificationsActions.INSTANCE.getGET_CHANNEL_LIST_ACTION_TYPE(), (ActionRequest)request, this.wrapActionListener(listener, getChannelList.1.INSTANCE));
    }

    public final void sendNotification(@NotNull NodeClient client, @NotNull EventSource eventSource, @NotNull ChannelMessage channelMessage, @NotNull List<String> channelIds, @NotNull ActionListener<SendNotificationResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)eventSource, (String)"eventSource");
        Intrinsics.checkNotNullParameter((Object)channelMessage, (String)"channelMessage");
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        String threadContext = (String)client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        SecureClientWrapper wrapper = new SecureClientWrapper((Client)client);
        wrapper.execute(NotificationsActions.INSTANCE.getSEND_NOTIFICATION_ACTION_TYPE(), (ActionRequest)new SendNotificationRequest(eventSource, channelMessage, channelIds, threadContext), this.wrapActionListener(listener, sendNotification.1.INSTANCE));
    }

    public final void publishLegacyNotification(@NotNull NodeClient client, @NotNull LegacyPublishNotificationRequest request, @NotNull ActionListener<LegacyPublishNotificationResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        client.execute(NotificationsActions.INSTANCE.getLEGACY_PUBLISH_NOTIFICATION_ACTION_TYPE(), (ActionRequest)request, this.wrapActionListener(listener, publishLegacyNotification.1.INSTANCE));
    }

    private final <Response extends BaseResponse> ActionListener<Response> wrapActionListener(ActionListener<Response> listener, Function1<? super Writeable, ? extends Response> recreate) {
        return (ActionListener)new ActionListener<ActionResponse>(recreate, listener){
            final /* synthetic */ Function1<Writeable, Response> $recreate;
            final /* synthetic */ ActionListener<Response> $listener;
            {
                this.$recreate = $recreate;
                this.$listener = $listener;
            }

            public void onResponse(@NotNull ActionResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                BaseResponse baseResponse = response instanceof BaseResponse ? (BaseResponse)response : null;
                if (baseResponse == null) {
                    baseResponse = (BaseResponse)((Object)this.$recreate.invoke((Object)response));
                }
                BaseResponse recreated = baseResponse;
                this.$listener.onResponse((Object)((Object)recreated));
            }

            public void onFailure(@NotNull Exception exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                this.$listener.onFailure(exception);
            }
        };
    }
}

