/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.model.AnomalyDetectorType;
import org.opensearch.ad.stats.ADStat;
import org.opensearch.ad.stats.ADStats;
import org.opensearch.ad.stats.ADStatsResponse;
import org.opensearch.ad.stats.StatNames;
import org.opensearch.ad.transport.ADStatsNodesAction;
import org.opensearch.ad.transport.ADStatsNodesResponse;
import org.opensearch.ad.transport.ADStatsRequest;
import org.opensearch.ad.transport.StatsAnomalyDetectorAction;
import org.opensearch.ad.transport.StatsAnomalyDetectorResponse;
import org.opensearch.ad.util.MultiResponsesDelegateActionListener;
import org.opensearch.ad.util.RestHandlerUtils;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.bucket.terms.StringTerms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class StatsAnomalyDetectorTransportAction
extends HandledTransportAction<ADStatsRequest, StatsAnomalyDetectorResponse> {
    public static final String DETECTOR_TYPE_AGG = "detector_type_agg";
    private final Logger logger = LogManager.getLogger(StatsAnomalyDetectorTransportAction.class);
    private final Client client;
    private final ADStats adStats;
    private final ClusterService clusterService;

    @Inject
    public StatsAnomalyDetectorTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, ADStats adStats, ClusterService clusterService) {
        super(StatsAnomalyDetectorAction.NAME, transportService, actionFilters, ADStatsRequest::new);
        this.client = client;
        this.adStats = adStats;
        this.clusterService = clusterService;
    }

    protected void doExecute(Task task, ADStatsRequest request, ActionListener<StatsAnomalyDetectorResponse> actionListener) {
        ActionListener listener = RestHandlerUtils.wrapRestActionListener(actionListener, CommonErrorMessages.FAIL_TO_GET_STATS);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.getStats(this.client, (ActionListener<StatsAnomalyDetectorResponse>)listener, request);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            listener.onFailure(e);
        }
    }

    private void getStats(Client client, ActionListener<StatsAnomalyDetectorResponse> listener, ADStatsRequest adStatsRequest) {
        MultiResponsesDelegateActionListener<ADStatsResponse> delegateListener = new MultiResponsesDelegateActionListener<ADStatsResponse>(this.getRestStatsListener(listener), 2, "Unable to return AD Stats", false);
        this.getClusterStats(client, delegateListener, adStatsRequest);
        this.getNodeStats(client, delegateListener, adStatsRequest);
    }

    private ActionListener<ADStatsResponse> getRestStatsListener(ActionListener<StatsAnomalyDetectorResponse> listener) {
        return ActionListener.wrap(adStatsResponse -> listener.onResponse((Object)new StatsAnomalyDetectorResponse((ADStatsResponse)adStatsResponse)), exception -> listener.onFailure((Exception)new OpenSearchStatusException(exception.getMessage(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
    }

    private void getClusterStats(Client client, MultiResponsesDelegateActionListener<ADStatsResponse> listener, ADStatsRequest adStatsRequest) {
        ADStatsResponse adStatsResponse = new ADStatsResponse();
        if ((adStatsRequest.getStatsToBeRetrieved().contains(StatNames.DETECTOR_COUNT.getName()) || adStatsRequest.getStatsToBeRetrieved().contains(StatNames.SINGLE_ENTITY_DETECTOR_COUNT.getName()) || adStatsRequest.getStatsToBeRetrieved().contains(StatNames.MULTI_ENTITY_DETECTOR_COUNT.getName())) && this.clusterService.state().getRoutingTable().hasIndex(".opendistro-anomaly-detectors")) {
            TermsAggregationBuilder termsAgg = (TermsAggregationBuilder)AggregationBuilders.terms((String)DETECTOR_TYPE_AGG).field("detector_type");
            SearchRequest request = new SearchRequest().indices(new String[]{".opendistro-anomaly-detectors"}).source(new SearchSourceBuilder().aggregation((AggregationBuilder)termsAgg).size(0).trackTotalHits(true));
            client.search(request, ActionListener.wrap(r -> {
                StringTerms aggregation = (StringTerms)r.getAggregations().get(DETECTOR_TYPE_AGG);
                List buckets = aggregation.getBuckets();
                long totalDetectors = r.getHits().getTotalHits().value;
                long totalSingleEntityDetectors = 0L;
                long totalMultiEntityDetectors = 0L;
                for (StringTerms.Bucket b : buckets) {
                    if (AnomalyDetectorType.SINGLE_ENTITY.name().equals(b.getKeyAsString()) || AnomalyDetectorType.REALTIME_SINGLE_ENTITY.name().equals(b.getKeyAsString()) || AnomalyDetectorType.HISTORICAL_SINGLE_ENTITY.name().equals(b.getKeyAsString())) {
                        totalSingleEntityDetectors += b.getDocCount();
                    }
                    if (!AnomalyDetectorType.MULTI_ENTITY.name().equals(b.getKeyAsString()) && !AnomalyDetectorType.REALTIME_MULTI_ENTITY.name().equals(b.getKeyAsString()) && !AnomalyDetectorType.HISTORICAL_MULTI_ENTITY.name().equals(b.getKeyAsString())) continue;
                    totalMultiEntityDetectors += b.getDocCount();
                }
                if (adStatsRequest.getStatsToBeRetrieved().contains(StatNames.DETECTOR_COUNT.getName())) {
                    this.adStats.getStat(StatNames.DETECTOR_COUNT.getName()).setValue(totalDetectors);
                }
                if (adStatsRequest.getStatsToBeRetrieved().contains(StatNames.SINGLE_ENTITY_DETECTOR_COUNT.getName())) {
                    this.adStats.getStat(StatNames.SINGLE_ENTITY_DETECTOR_COUNT.getName()).setValue(totalSingleEntityDetectors);
                }
                if (adStatsRequest.getStatsToBeRetrieved().contains(StatNames.MULTI_ENTITY_DETECTOR_COUNT.getName())) {
                    this.adStats.getStat(StatNames.MULTI_ENTITY_DETECTOR_COUNT.getName()).setValue(totalMultiEntityDetectors);
                }
                adStatsResponse.setClusterStats(this.getClusterStatsMap(adStatsRequest));
                listener.onResponse(adStatsResponse);
            }, e -> listener.onFailure((Exception)e)));
        } else {
            adStatsResponse.setClusterStats(this.getClusterStatsMap(adStatsRequest));
            listener.onResponse(adStatsResponse);
        }
    }

    private Map<String, Object> getClusterStatsMap(ADStatsRequest adStatsRequest) {
        HashMap<String, Object> clusterStats = new HashMap<String, Object>();
        Set<String> statsToBeRetrieved = adStatsRequest.getStatsToBeRetrieved();
        this.adStats.getClusterStats().entrySet().stream().filter(s -> statsToBeRetrieved.contains(s.getKey())).forEach(s -> clusterStats.put((String)s.getKey(), ((ADStat)s.getValue()).getValue()));
        return clusterStats;
    }

    private void getNodeStats(Client client, MultiResponsesDelegateActionListener<ADStatsResponse> listener, ADStatsRequest adStatsRequest) {
        client.execute((ActionType)ADStatsNodesAction.INSTANCE, (ActionRequest)adStatsRequest, ActionListener.wrap(adStatsResponse -> {
            ADStatsResponse restADStatsResponse = new ADStatsResponse();
            restADStatsResponse.setADStatsNodesResponse((ADStatsNodesResponse)((Object)adStatsResponse));
            listener.onResponse(restADStatsResponse);
        }, listener::onFailure));
    }
}

