"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _configSchema = require("@osd/config-schema");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
// Router factory
var _default = (iRouter, basePath) => {
  if (basePath == null || basePath == '') {
    throw new TypeError('Base path is null');
  }

  const requestHandler = handler => async (context, request, response) => {
    try {
      return await handler(context, request, response);
    } catch (e) {
      throw e;
    }
  };

  return ['get', 'put', 'post', 'delete'].reduce((router, method) => {
    router[method] = (path, handler) => {
      switch (method) {
        case 'get':
          {
            iRouter.get({
              path: `${basePath}${path}`,
              validate: {
                params: _configSchema.schema.any(),
                query: _configSchema.schema.any()
              }
            }, requestHandler(handler));
            break;
          }

        case 'put':
          {
            iRouter.put({
              path: `${basePath}${path}`,
              validate: {
                params: _configSchema.schema.any(),
                query: _configSchema.schema.any(),
                body: _configSchema.schema.any()
              }
            }, requestHandler(handler));
            break;
          }

        case 'post':
          {
            iRouter.post({
              path: `${basePath}${path}`,
              validate: {
                params: _configSchema.schema.any(),
                query: _configSchema.schema.any(),
                body: _configSchema.schema.any()
              }
            }, requestHandler(handler));
            break;
          }

        case 'delete':
          {
            iRouter.delete({
              path: `${basePath}${path}`,
              validate: {
                params: _configSchema.schema.any(),
                query: _configSchema.schema.any(),
                body: _configSchema.schema.any()
              }
            }, requestHandler(handler));
            break;
          }

        default:
          {
            break;
          }
      }
    };

    return router;
  }, {});
};

exports.default = _default;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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