"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFloorPlotTime = exports.formatAnomalyNumber = exports.SHOW_DECIMAL_NUMBER_THRESHOLD = exports.NO_PERMISSIONS_KEY_WORD = void 0;
exports.mapKeysDeep = mapKeysDeep;
exports.toSnake = exports.toFixedNumberForAnomaly = exports.toFixedNumber = exports.toCamel = exports.prettifyErrorMessage = void 0;

var _lodash = require("lodash");

var _constants = require("./constants");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
const SHOW_DECIMAL_NUMBER_THRESHOLD = 0.01;
exports.SHOW_DECIMAL_NUMBER_THRESHOLD = SHOW_DECIMAL_NUMBER_THRESHOLD;

function mapKeysDeep(obj, fn) {
  if (Array.isArray(obj)) {
    return (0, _lodash.map)(obj, innerObj => mapKeysDeep(innerObj, fn));
  } else {
    //@ts-ignore
    return (0, _lodash.isPlainObject)(obj) ? (0, _lodash.mapValues)((0, _lodash.mapKeys)(obj, fn), value => mapKeysDeep(value, fn)) : obj;
  }
}

const toSnake = (value, key) => (0, _lodash.snakeCase)(key);

exports.toSnake = toSnake;

const toCamel = (value, key) => (0, _lodash.camelCase)(key);

exports.toCamel = toCamel;

const getFloorPlotTime = plotTime => {
  return Math.floor(plotTime / _constants.MIN_IN_MILLI_SECS) * _constants.MIN_IN_MILLI_SECS;
};

exports.getFloorPlotTime = getFloorPlotTime;

const toFixedNumber = (num, digits, base) => {
  var pow = Math.pow(base || 10, digits || 2);
  return Math.round(num * pow) / pow;
}; // 1.If num>0.01, will keep two digits;
// 2.If num<0.01, will use scientific notation, for example 0.001234 will become 1.23e-3


exports.toFixedNumber = toFixedNumber;

const toFixedNumberForAnomaly = num => {
  return num >= SHOW_DECIMAL_NUMBER_THRESHOLD ? toFixedNumber(num, 2) : Number(num.toExponential(2));
};

exports.toFixedNumberForAnomaly = toFixedNumberForAnomaly;

const formatAnomalyNumber = num => {
  return num >= SHOW_DECIMAL_NUMBER_THRESHOLD ? num.toFixed(2) : num.toExponential(2);
};

exports.formatAnomalyNumber = formatAnomalyNumber;
const PERMISSIONS_ERROR_PATTERN = /no permissions for \[(.+)\] and User \[name=(.+), backend_roles/;
const NO_PERMISSIONS_KEY_WORD = 'no permissions';
exports.NO_PERMISSIONS_KEY_WORD = NO_PERMISSIONS_KEY_WORD;

const prettifyErrorMessage = rawErrorMessage => {
  if ((0, _lodash.isEmpty)(rawErrorMessage) || rawErrorMessage === 'undefined') {
    return 'Unknown error is returned.';
  }

  const match = rawErrorMessage.match(PERMISSIONS_ERROR_PATTERN);

  if ((0, _lodash.isEmpty)(match)) {
    return rawErrorMessage;
  } else {
    return `User ${match[2]} has no permissions to [${match[1]}].`;
  }
};

exports.prettifyErrorMessage = prettifyErrorMessage;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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