"use strict";

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
module.exports = {
  rootDir: "../",
  setupFiles: ["<rootDir>/test/polyfills.ts", "<rootDir>/test/setupTests.ts"],
  setupFilesAfterEnv: ["<rootDir>/test/setup.jest.ts"],
  roots: ["<rootDir>"],
  coverageDirectory: "./coverage",
  moduleNameMapper: {
    "\\.(css|less|scss)$": "<rootDir>/test/mocks/styleMock.ts",
    "^ui/(.*)": "<rootDir>/../../src/legacy/ui/public/$1/"
  },
  coverageReporters: ["lcov", "text", "cobertura"],
  testMatch: ["**/*.test.js", "**/*.test.jsx", "**/*.test.ts", "**/*.test.tsx"],
  collectCoverageFrom: ["**/*.ts", "**/*.tsx", "**/*.js", "**/*.jsx", "!**/models/**", "!**/node_modules/**", "!**/index.ts", "!<rootDir>/index.js", "!<rootDir>/public/app.js", "!<rootDir>/public/temporary/**", "!<rootDir>/babel.config.js", "!<rootDir>/test/**", "!<rootDir>/server/**", "!<rootDir>/coverage/**", "!<rootDir>/scripts/**", "!<rootDir>/build/**", "!<rootDir>/cypress/**", "!**/vendor/**"],
  clearMocks: true,
  testPathIgnorePatterns: ["<rootDir>/build/", "<rootDir>/node_modules/"],
  modulePathIgnorePatterns: ["indexManagementDashboards"],
  testEnvironment: "jsdom"
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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