"use strict";
/*
 * Copyright 2021 Palantir Technologies, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.HotkeysTarget2 = void 0;
var tslib_1 = require("tslib");
var React = tslib_1.__importStar(require("react"));
var Errors = tslib_1.__importStar(require("../../common/errors"));
var utils_1 = require("../../common/utils");
var hooks_1 = require("../../hooks");
/**
 * Utility component which allows consumers to use the new `useHotkeys` hook inside
 * React component classes. The implementation simply passes through to the hook.
 */
var HotkeysTarget2 = function (_a) {
    var children = _a.children, hotkeys = _a.hotkeys, options = _a.options;
    var _b = hooks_1.useHotkeys(hotkeys, options), handleKeyDown = _b.handleKeyDown, handleKeyUp = _b.handleKeyUp;
    // run props validation
    React.useEffect(function () {
        if (!utils_1.isNodeEnv("production")) {
            if (typeof children !== "function" && hotkeys.some(function (h) { return !h.global; })) {
                console.error(Errors.HOTKEYS_TARGET2_CHILDREN_LOCAL_HOTKEYS);
            }
        }
    }, [hotkeys]);
    if (typeof children === "function") {
        return children({ handleKeyDown: handleKeyDown, handleKeyUp: handleKeyUp });
    }
    else {
        return children;
    }
};
exports.HotkeysTarget2 = HotkeysTarget2;
//# sourceMappingURL=hotkeysTarget2.js.map