"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLPlugin = void 0;

var _shared = require("../../common/constants/shared");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const PPLPlugin = function (Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.ppl = components.clientAction.namespaceFactory();
  const ppl = Client.prototype.ppl.prototype;
  ppl.pplQuery = ca({
    url: {
      fmt: `${_shared.PPL_ENDPOINT}`,
      params: {
        format: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  ppl.sqlQuery = ca({
    url: {
      fmt: `${_shared.SQL_ENDPOINT}`,
      params: {
        format: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
};

exports.PPLPlugin = PPLPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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