/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeManagedPrefixListsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeManagedPrefixListsRequestMarshaller
implements Marshaller<Request<DescribeManagedPrefixListsRequest>, DescribeManagedPrefixListsRequest> {
    public Request<DescribeManagedPrefixListsRequest> marshall(DescribeManagedPrefixListsRequest describeManagedPrefixListsRequest) {
        SdkInternalList describeManagedPrefixListsRequestPrefixListIdsList;
        if (describeManagedPrefixListsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeManagedPrefixListsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeManagedPrefixLists");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeManagedPrefixListsRequestFiltersList = (SdkInternalList)describeManagedPrefixListsRequest.getFilters();
        if (!describeManagedPrefixListsRequestFiltersList.isEmpty() || !describeManagedPrefixListsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeManagedPrefixListsRequestFiltersListValue : describeManagedPrefixListsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeManagedPrefixListsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeManagedPrefixListsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeManagedPrefixListsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeManagedPrefixListsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeManagedPrefixListsRequest.getMaxResults()));
        }
        if (describeManagedPrefixListsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeManagedPrefixListsRequest.getNextToken()));
        }
        if (!(describeManagedPrefixListsRequestPrefixListIdsList = (SdkInternalList)describeManagedPrefixListsRequest.getPrefixListIds()).isEmpty() || !describeManagedPrefixListsRequestPrefixListIdsList.isAutoConstruct()) {
            int prefixListIdsListIndex = 1;
            for (String describeManagedPrefixListsRequestPrefixListIdsListValue : describeManagedPrefixListsRequestPrefixListIdsList) {
                if (describeManagedPrefixListsRequestPrefixListIdsListValue != null) {
                    request.addParameter("PrefixListId." + prefixListIdsListIndex, StringUtils.fromString((String)describeManagedPrefixListsRequestPrefixListIdsListValue));
                }
                ++prefixListIdsListIndex;
            }
        }
        return request;
    }
}

