/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.PacketHeaderStatement;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class PacketHeaderStatementStaxUnmarshaller
implements Unmarshaller<PacketHeaderStatement, StaxUnmarshallerContext> {
    private static PacketHeaderStatementStaxUnmarshaller instance;

    public PacketHeaderStatement unmarshall(StaxUnmarshallerContext context) throws Exception {
        PacketHeaderStatement packetHeaderStatement = new PacketHeaderStatement();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return packetHeaderStatement;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("sourceAddressSet", targetDepth)) {
                    packetHeaderStatement.withSourceAddresses(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("sourceAddressSet/item", targetDepth)) {
                    packetHeaderStatement.withSourceAddresses(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("destinationAddressSet", targetDepth)) {
                    packetHeaderStatement.withDestinationAddresses(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("destinationAddressSet/item", targetDepth)) {
                    packetHeaderStatement.withDestinationAddresses(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("sourcePortSet", targetDepth)) {
                    packetHeaderStatement.withSourcePorts(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("sourcePortSet/item", targetDepth)) {
                    packetHeaderStatement.withSourcePorts(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("destinationPortSet", targetDepth)) {
                    packetHeaderStatement.withDestinationPorts(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("destinationPortSet/item", targetDepth)) {
                    packetHeaderStatement.withDestinationPorts(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("sourcePrefixListSet", targetDepth)) {
                    packetHeaderStatement.withSourcePrefixLists(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("sourcePrefixListSet/item", targetDepth)) {
                    packetHeaderStatement.withSourcePrefixLists(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("destinationPrefixListSet", targetDepth)) {
                    packetHeaderStatement.withDestinationPrefixLists(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("destinationPrefixListSet/item", targetDepth)) {
                    packetHeaderStatement.withDestinationPrefixLists(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("protocolSet", targetDepth)) {
                    packetHeaderStatement.withProtocols(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("protocolSet/item", targetDepth)) continue;
                packetHeaderStatement.withProtocols(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return packetHeaderStatement;
    }

    public static PacketHeaderStatementStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PacketHeaderStatementStaxUnmarshaller();
        }
        return instance;
    }
}

