/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.core;

import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Record;
import org.jooq.Result;
import org.opensearch.performanceanalyzer.metricsdb.MetricsDB;
import org.opensearch.performanceanalyzer.rca.framework.core.Queryable;
import org.opensearch.performanceanalyzer.reader.ReaderMetricsProcessor;

public class MetricsDBProvider
implements Queryable {
    private static final Logger LOG = LogManager.getLogger(MetricsDBProvider.class);

    @Override
    public MetricsDB getMetricsDB() throws Exception {
        ReaderMetricsProcessor processor = ReaderMetricsProcessor.getInstance();
        if (processor == null) {
            LOG.error("RCA: ReaderMetricsProcessor not initialized");
            throw new Exception("ReaderMetricsProcessor not initialized");
        }
        Map.Entry<Long, MetricsDB> dbEntry = processor.getMetricsDB();
        if (dbEntry == null) {
            LOG.error("RCA: MetricsDB not initialized");
            throw new Exception("Metrics DB not initialized");
        }
        return dbEntry.getValue();
    }

    @Override
    public Result<Record> queryMetrics(MetricsDB db, String metricName) {
        return db.queryMetric(metricName);
    }

    @Override
    public Result<Record> queryMetrics(MetricsDB db, String metricName, String dimension, String aggregation) throws Exception {
        Result<Record> queryResult = db.queryMetric(Collections.singletonList(metricName), Collections.singletonList(aggregation), Collections.singletonList(dimension));
        return queryResult;
    }

    @Override
    public long getDBTimestamp(MetricsDB db) {
        return 0L;
    }
}

