/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.stats;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.opensearch.performanceanalyzer.rca.stats.collectors.SampleAggregator;
import org.opensearch.performanceanalyzer.rca.stats.format.Formatter;
import org.opensearch.performanceanalyzer.rca.stats.measurements.MeasurementSet;

public class RcaStatsReporter {
    private final List<SampleAggregator> aggregators;
    private int idxOfCollectorToReport;

    public RcaStatsReporter(List<SampleAggregator> aggregators) {
        this.aggregators = aggregators;
        this.idxOfCollectorToReport = 0;
    }

    public boolean getNextReport(Formatter formatter) {
        if (this.aggregators == null || this.aggregators.isEmpty()) {
            return false;
        }
        SampleAggregator collector = this.aggregators.get(this.idxOfCollectorToReport);
        collector.fillValuesAndReset(formatter);
        boolean ret = true;
        ++this.idxOfCollectorToReport;
        if (this.idxOfCollectorToReport == this.aggregators.size()) {
            ret = false;
            this.idxOfCollectorToReport = 0;
        }
        return ret;
    }

    @VisibleForTesting
    public boolean isMeasurementCollected(MeasurementSet measure) {
        for (SampleAggregator aggregator : this.aggregators) {
            if (!aggregator.isMeasurementObserved(measure)) continue;
            return true;
        }
        return false;
    }
}

