/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.reader;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.BatchBindStep;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Name;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.DBUtils;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.reader.Removable;

public class HttpRequestMetricsSnapshot
implements Removable {
    private static final Logger LOG = LogManager.getLogger(HttpRequestMetricsSnapshot.class);
    private static final Long EXPIRE_AFTER = 600000L;
    private final DSLContext create;
    private final Long windowStartTime;
    private final String tableName;
    private List<String> columns;

    public HttpRequestMetricsSnapshot(Connection conn, Long windowStartTime) throws Exception {
        this.create = DSL.using((Connection)conn, (SQLDialect)SQLDialect.SQLITE);
        this.windowStartTime = windowStartTime;
        this.tableName = "http_rq_" + windowStartTime;
        this.columns = new ArrayList<String>(){
            {
                this.add(Fields.RID.toString());
                this.add(Fields.OPERATION.toString());
                this.add(Fields.INDICES.toString());
                this.add(Fields.HTTP_RESP_CODE.toString());
                this.add(Fields.EXCEPTION.toString());
                this.add(Fields.HTTP_REQUEST_DOCS.toString());
                this.add(Fields.ST.toString());
                this.add(Fields.ET.toString());
            }
        };
        ArrayList fields = new ArrayList<Field<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.RID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.OPERATION.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.INDICES.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.HTTP_RESP_CODE.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.EXCEPTION.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.HTTP_REQUEST_DOCS.toString()), Long.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.ST.toString()), Long.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.ET.toString()), Long.class));
            }
        };
        this.create.createTable(this.tableName).columns((Collection)fields).execute();
    }

    public void putStartMetric(Long startTime, Long itemCount, Map<String, String> dimensions) {
        HashMap<Field, String> dimensionMap = new HashMap<Field, String>();
        for (Map.Entry<String, String> dimension : dimensions.entrySet()) {
            dimensionMap.put(DSL.field((Name)DSL.name((String)dimension.getKey()), String.class), dimension.getValue());
        }
        this.create.insertInto(DSL.table((String)this.tableName)).set(DSL.field((Name)DSL.name((String)Fields.ST.toString()), Long.class), (Object)startTime).set(DSL.field((Name)DSL.name((String)Fields.HTTP_REQUEST_DOCS.toString()), Long.class), (Object)itemCount).set(dimensionMap).execute();
    }

    public BatchBindStep startBatchPut() {
        ArrayList<Object> dummyValues = new ArrayList<Object>();
        for (int i = 0; i < this.columns.size(); ++i) {
            dummyValues.add(null);
        }
        return this.create.batch((Query)this.create.insertInto(DSL.table((String)this.tableName)).values(dummyValues));
    }

    public void putEndMetric(Long endTime, Map<String, String> dimensions) {
        HashMap<Field, String> dimensionMap = new HashMap<Field, String>();
        for (Map.Entry<String, String> dimension : dimensions.entrySet()) {
            dimensionMap.put(DSL.field((Name)DSL.name((String)dimension.getKey()), String.class), dimension.getValue());
        }
        this.create.insertInto(DSL.table((String)this.tableName)).set(DSL.field((Name)DSL.name((String)Fields.ET.toString()), Long.class), (Object)endTime).set(dimensionMap).execute();
    }

    public Result<Record> fetchAll() {
        return this.create.select(new SelectField[0]).from((TableLike)DSL.table((String)this.tableName)).fetch();
    }

    public SelectHavingStep<Record> groupByRidSelect() {
        ArrayList fields = new ArrayList<SelectField<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.RID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.OPERATION.toString()), String.class));
            }
        };
        fields.add((SelectField<?>)DSL.max((Field)DSL.field((String)Fields.ST.toString(), Long.class)).as(DSL.name((String)Fields.ST.toString())));
        fields.add((SelectField<?>)DSL.max((Field)DSL.field((String)Fields.ET.toString(), Long.class)).as(DSL.name((String)Fields.ET.toString())));
        fields.add((SelectField<?>)DSL.max((Field)DSL.field((String)Fields.INDICES.toString())).as(DSL.name((String)Fields.INDICES.toString())));
        fields.add((SelectField<?>)DSL.max((Field)DSL.field((String)Fields.HTTP_RESP_CODE.toString())).as(DSL.name((String)Fields.HTTP_RESP_CODE.toString())));
        fields.add((SelectField<?>)DSL.max((Field)DSL.field((String)Fields.EXCEPTION.toString())).as(DSL.name((String)Fields.EXCEPTION.toString())));
        fields.add((SelectField<?>)DSL.max((Field)DSL.field((String)Fields.HTTP_REQUEST_DOCS.toString())).as(DSL.name((String)Fields.HTTP_REQUEST_DOCS.toString())));
        return this.create.select((Collection)fields).from((TableLike)DSL.table((String)this.tableName)).groupBy(new GroupField[]{DSL.field((String)Fields.RID.toString())});
    }

    public SelectHavingStep<Record> fetchLatencyTable() {
        ArrayList fields = new ArrayList<SelectField<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.RID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.OPERATION.toString()), String.class));
                this.add(DSL.field((String)Fields.ST.toString(), Long.class));
                this.add(DSL.field((String)Fields.ET.toString(), Long.class));
                this.add(DSL.field((String)Fields.HTTP_RESP_CODE.toString()));
                this.add(DSL.field((String)Fields.INDICES.toString()));
                this.add(DSL.field((String)Fields.EXCEPTION.toString()));
                this.add(DSL.field((String)Fields.HTTP_REQUEST_DOCS.toString()));
            }
        };
        fields.add((SelectField<?>)DSL.field((String)Fields.ET.toString()).minus(DSL.field((String)Fields.ST.toString())).as(DSL.name((String)Fields.LAT.toString())));
        return this.create.select((Collection)fields).from(this.groupByRidSelect()).where(new Condition[]{DSL.field((String)Fields.ET.toString()).isNotNull().and(DSL.field((String)Fields.ST.toString()).isNotNull())});
    }

    public Result<Record> fetchLatencyByOp() {
        ArrayList fields = new ArrayList<SelectField<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.OPERATION.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.HTTP_RESP_CODE.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.INDICES.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.EXCEPTION.toString()), String.class));
                this.add(DSL.sum((Field)DSL.field((Name)DSL.name((String)Fields.HTTP_REQUEST_DOCS.toString()), Long.class)).as(DBUtils.getAggFieldName(Fields.HTTP_REQUEST_DOCS.toString(), "sum")));
                this.add(DSL.avg((Field)DSL.field((Name)DSL.name((String)Fields.HTTP_REQUEST_DOCS.toString()), Long.class)).as(DBUtils.getAggFieldName(Fields.HTTP_REQUEST_DOCS.toString(), "avg")));
                this.add(DSL.min((Field)DSL.field((Name)DSL.name((String)Fields.HTTP_REQUEST_DOCS.toString()), Long.class)).as(DBUtils.getAggFieldName(Fields.HTTP_REQUEST_DOCS.toString(), "min")));
                this.add(DSL.max((Field)DSL.field((Name)DSL.name((String)Fields.HTTP_REQUEST_DOCS.toString()), Long.class)).as(DBUtils.getAggFieldName(Fields.HTTP_REQUEST_DOCS.toString(), "max")));
                this.add(DSL.sum((Field)DSL.field((Name)DSL.name((String)Fields.LAT.toString()), Double.class)).as(DBUtils.getAggFieldName(Fields.LAT.toString(), "sum")));
                this.add(DSL.avg((Field)DSL.field((Name)DSL.name((String)Fields.LAT.toString()), Double.class)).as(DBUtils.getAggFieldName(Fields.LAT.toString(), "avg")));
                this.add(DSL.min((Field)DSL.field((Name)DSL.name((String)Fields.LAT.toString()), Double.class)).as(DBUtils.getAggFieldName(Fields.LAT.toString(), "min")));
                this.add(DSL.max((Field)DSL.field((Name)DSL.name((String)Fields.LAT.toString()), Double.class)).as(DBUtils.getAggFieldName(Fields.LAT.toString(), "max")));
                this.add(DSL.count().as(Fields.HTTP_TOTAL_REQUESTS.toString()));
            }
        };
        ArrayList groupByFields = new ArrayList<Field<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.OPERATION.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.HTTP_RESP_CODE.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.INDICES.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.EXCEPTION.toString()), String.class));
            }
        };
        return this.create.select((Collection)fields).from(this.fetchLatencyTable()).groupBy((Collection)groupByFields).fetch();
    }

    public SelectHavingStep<Record> fetchInflightRequests() {
        ArrayList fields = new ArrayList<SelectField<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.RID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.OPERATION.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.INDICES.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.HTTP_RESP_CODE.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.EXCEPTION.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.HTTP_REQUEST_DOCS.toString()), Long.class));
                this.add(DSL.field((String)Fields.ST.toString(), Long.class));
                this.add(DSL.field((String)Fields.ET.toString(), Long.class));
            }
        };
        return this.create.select((Collection)fields).from(this.groupByRidSelect()).where(new Condition[]{DSL.field((String)Fields.ST.toString()).isNotNull().and(DSL.field((String)Fields.ET.toString()).isNull()).and(DSL.field((String)Fields.ST.toString()).gt((Object)(this.windowStartTime - EXPIRE_AFTER)))});
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void remove() {
        LOG.debug("Dropping table - {}", (Object)this.tableName);
        this.create.dropTable(DSL.table((String)this.tableName)).execute();
    }

    public void rolloverInflightRequests(HttpRequestMetricsSnapshot prevSnap) {
        this.create.insertInto(DSL.table((String)this.tableName)).select((Select)this.create.select(new SelectField[0]).from(prevSnap.fetchInflightRequests())).execute();
    }

    public static enum Fields {
        RID("rid"),
        OPERATION(AllMetrics.CommonDimension.OPERATION.toString()),
        INDICES(AllMetrics.HttpDimension.INDICES.toString()),
        HTTP_RESP_CODE(AllMetrics.HttpDimension.HTTP_RESP_CODE.toString()),
        EXCEPTION(AllMetrics.CommonDimension.EXCEPTION.toString()),
        HTTP_REQUEST_DOCS(AllMetrics.HttpMetric.HTTP_REQUEST_DOCS.toString()),
        ST("st"),
        ET("et"),
        LAT("lat"),
        HTTP_TOTAL_REQUESTS(AllMetrics.HttpMetric.HTTP_TOTAL_REQUESTS.toString());

        private final String fieldValue;

        private Fields(String fieldValue) {
            this.fieldValue = fieldValue;
        }

        public String toString() {
            return this.fieldValue;
        }
    }
}

