/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.opensearch.performanceanalyzer.collectors.StatExceptionCode;
import org.opensearch.performanceanalyzer.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.util.JsonPathNotFoundException;

public class JsonConverter {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Logger LOG = LogManager.getLogger(JsonConverter.class);

    public static String writeValueAsString(Object value) {
        try {
            return MAPPER.writeValueAsString(value);
        }
        catch (JsonGenerationException e) {
            LOG.warn("Json generation error " + e.getMessage());
            throw new IllegalArgumentException(e);
        }
        catch (JsonMappingException e) {
            LOG.warn("Json Mapping Error: " + e.getMessage());
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            LOG.warn("IO error: " + e.getMessage());
            throw new IllegalArgumentException(e);
        }
    }

    public static Map<String, Object> createMapFrom(String json) {
        try {
            if (json.trim().length() != 0) {
                return (Map)MAPPER.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
        }
        catch (IOException e) {
            LOG.debug("IO error: {} for json {} with ExceptionCode: {}", new Supplier[]{() -> e.toString(), () -> json, () -> StatExceptionCode.JSON_PARSER_ERROR.toString()});
            StatsCollector.instance().logException(StatExceptionCode.JSON_PARSER_ERROR);
        }
        return Collections.emptyMap();
    }

    public static JsonNode getChildNode(String jsonString, String ... paths) throws JsonProcessingException, IOException {
        JsonNode rootNode = MAPPER.readTree(jsonString);
        return JsonConverter.getChildNode(rootNode, paths);
    }

    public static JsonNode getChildNode(JsonNode jsonNode, String ... paths) {
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            if (!jsonNode.has(path)) {
                return null;
            }
            jsonNode = jsonNode.get(path);
        }
        return jsonNode;
    }

    public static long getLongValue(String jsonString, String ... paths) throws JsonPathNotFoundException, JsonProcessingException, IOException {
        JsonNode jsonNode = JsonConverter.getChildNode(jsonString, paths);
        if (jsonNode != null) {
            return jsonNode.longValue();
        }
        throw new JsonPathNotFoundException();
    }
}

