/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.jooq.tools.StringUtils;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;
import org.opensearch.performanceanalyzer.config.overrides.ConfigOverridesWrapper;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ExceptionsAndErrors;
import org.opensearch.performanceanalyzer.rca.framework.metrics.WriterMetrics;
import org.opensearch.performanceanalyzer.rca.stats.measurements.MeasurementSet;

public class FaultDetectionMetricsCollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    public static final int SAMPLING_TIME_INTERVAL = ((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(FaultDetectionMetricsCollector.class)).samplingInterval;
    private static final int KEYS_PATH_LENGTH = 3;
    private static final Logger LOG = LogManager.getLogger(FaultDetectionMetricsCollector.class);
    private static final String FAULT_DETECTION_HANDLER_NAME = "org.opensearch.performanceanalyzer.handler.ClusterFaultDetectionStatsHandler";
    private static final String FAULT_DETECTION_HANDLER_METRIC_QUEUE = "metricQueue";
    private final ConfigOverridesWrapper configOverridesWrapper;
    private final PerformanceAnalyzerController controller;
    private StringBuilder value = new StringBuilder();
    private static final ObjectMapper mapper = new ObjectMapper();

    public FaultDetectionMetricsCollector(PerformanceAnalyzerController controller, ConfigOverridesWrapper configOverridesWrapper) {
        super(SAMPLING_TIME_INTERVAL, "FaultDetectionMetricsCollector");
        this.configOverridesWrapper = configOverridesWrapper;
        this.controller = controller;
    }

    public void collectMetrics(long startTime) {
        if (!this.controller.isCollectorEnabled(this.configOverridesWrapper, this.getCollectorName())) {
            return;
        }
        long mCurrT = System.currentTimeMillis();
        Class<?> faultDetectionHandler = null;
        try {
            faultDetectionHandler = Class.forName(FAULT_DETECTION_HANDLER_NAME);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("No Handler Detected for Fault Detection. Skipping FaultDetectionMetricsCollector");
            return;
        }
        try {
            BlockingQueue metricQueue = (BlockingQueue)this.getFaultDetectionHandlerMetricsQueue(faultDetectionHandler).get(null);
            ArrayList metrics = new ArrayList();
            metricQueue.drainTo(metrics);
            ArrayList<ClusterFaultDetectionContext> faultDetectionContextsList = new ArrayList<ClusterFaultDetectionContext>();
            for (String metric : metrics) {
                faultDetectionContextsList.add((ClusterFaultDetectionContext)mapper.readValue(metric, ClusterFaultDetectionContext.class));
            }
            for (ClusterFaultDetectionContext clusterFaultDetectionContext : faultDetectionContextsList) {
                this.value.setLength(0);
                this.value.append(PerformanceAnalyzerMetrics.getCurrentTimeMetric());
                PerformanceAnalyzerMetrics.addMetricEntry((StringBuilder)this.value, (String)AllMetrics.FaultDetectionDimension.SOURCE_NODE_ID.toString(), (String)clusterFaultDetectionContext.getSourceNodeId());
                PerformanceAnalyzerMetrics.addMetricEntry((StringBuilder)this.value, (String)AllMetrics.FaultDetectionDimension.TARGET_NODE_ID.toString(), (String)clusterFaultDetectionContext.getTargetNodeId());
                if (StringUtils.isEmpty((String)clusterFaultDetectionContext.getStartTime())) {
                    PerformanceAnalyzerMetrics.addMetricEntry((StringBuilder)this.value, (String)AllMetrics.CommonMetric.FINISH_TIME.toString(), (String)clusterFaultDetectionContext.getFinishTime());
                    PerformanceAnalyzerMetrics.addMetricEntry((StringBuilder)this.value, (String)"fault", (String)clusterFaultDetectionContext.getFault());
                    this.saveMetricValues(this.value.toString(), startTime, new String[]{clusterFaultDetectionContext.getType(), clusterFaultDetectionContext.getRequestId(), "finish"});
                    continue;
                }
                PerformanceAnalyzerMetrics.addMetricEntry((StringBuilder)this.value, (String)AllMetrics.CommonMetric.START_TIME.toString(), (String)clusterFaultDetectionContext.getStartTime());
                this.saveMetricValues(this.value.toString(), startTime, new String[]{clusterFaultDetectionContext.getType(), clusterFaultDetectionContext.getRequestId(), "start"});
            }
            PerformanceAnalyzerApp.WRITER_METRICS_AGGREGATOR.updateStat((MeasurementSet)WriterMetrics.FAULT_DETECTION_COLLECTOR_EXECUTION_TIME, "", (Number)(System.currentTimeMillis() - mCurrT));
        }
        catch (Exception ex) {
            PerformanceAnalyzerApp.ERRORS_AND_EXCEPTIONS_AGGREGATOR.updateStat((MeasurementSet)ExceptionsAndErrors.FAULT_DETECTION_COLLECTOR_ERROR, "", (Number)(System.currentTimeMillis() - mCurrT));
            LOG.debug("Exception in Collecting FaultDetection Metrics: {} for startTime {}", new Supplier[]{() -> ex.toString(), () -> startTime});
        }
    }

    Field getFaultDetectionHandlerMetricsQueue(Class<?> faultDetectionHandler) throws Exception {
        Field metricsQueue = faultDetectionHandler.getDeclaredField(FAULT_DETECTION_HANDLER_METRIC_QUEUE);
        metricsQueue.setAccessible(true);
        return metricsQueue;
    }

    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 3) {
            throw new RuntimeException("keys length should be 3");
        }
        return PerformanceAnalyzerMetrics.generatePath((long)startTime, (String[])new String[]{"fault_detection", keysPath[0], keysPath[1], keysPath[2]});
    }

    public static class ClusterFaultDetectionContext {
        String type;
        String sourceNodeId;
        String targetNodeId;
        String requestId;
        String fault;
        String startTime;
        String finishTime;

        public String getType() {
            return this.type;
        }

        public String getSourceNodeId() {
            return this.sourceNodeId;
        }

        public String getTargetNodeId() {
            return this.targetNodeId;
        }

        public String getFault() {
            return this.fault;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public String getFinishTime() {
            return this.finishTime;
        }

        public String getRequestId() {
            return this.requestId;
        }
    }
}

