/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty;

import com.azure.core.http.HttpClient;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.netty.NettyAsyncHttpClient;
import com.azure.core.http.netty.implementation.HttpProxyHandler;
import com.azure.core.util.AuthorizationChallengeHandler;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import reactor.netty.http.client.HttpClientConfig;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.transport.AddressUtils;
import reactor.netty.transport.ProxyProvider;

public class NettyAsyncHttpClientBuilder {
    private static final long MINIMUM_TIMEOUT = TimeUnit.MILLISECONDS.toMillis(1L);
    private static final long DEFAULT_CONNECT_TIMEOUT;
    private static final long DEFAULT_WRITE_TIMEOUT;
    private static final long DEFAULT_RESPONSE_TIMEOUT;
    private static final long DEFAULT_READ_TIMEOUT;
    private static final ClientLogger LOGGER;
    private final reactor.netty.http.client.HttpClient baseHttpClient;
    private ProxyOptions proxyOptions;
    private ConnectionProvider connectionProvider;
    private boolean enableWiretap;
    private int port = 80;
    private EventLoopGroup eventLoopGroup;
    private Configuration configuration;
    private boolean disableBufferCopy;
    private Duration connectTimeout;
    private Duration writeTimeout;
    private Duration responseTimeout;
    private Duration readTimeout;

    public NettyAsyncHttpClientBuilder() {
        this.baseHttpClient = null;
    }

    public NettyAsyncHttpClientBuilder(reactor.netty.http.client.HttpClient nettyHttpClient) {
        this.baseHttpClient = Objects.requireNonNull(nettyHttpClient, "'nettyHttpClient' cannot be null.");
    }

    public HttpClient build() {
        AtomicReference proxyChallengeHolder;
        reactor.netty.http.client.HttpClient nettyHttpClient;
        boolean addressResolverWasSetByBuilder = false;
        if (this.baseHttpClient != null) {
            nettyHttpClient = this.baseHttpClient;
        } else if (this.connectionProvider != null) {
            nettyHttpClient = (reactor.netty.http.client.HttpClient)reactor.netty.http.client.HttpClient.create((ConnectionProvider)this.connectionProvider).resolver((AddressResolverGroup)DefaultAddressResolverGroup.INSTANCE);
            addressResolverWasSetByBuilder = true;
        } else {
            nettyHttpClient = (reactor.netty.http.client.HttpClient)reactor.netty.http.client.HttpClient.create().resolver((AddressResolverGroup)DefaultAddressResolverGroup.INSTANCE);
            addressResolverWasSetByBuilder = true;
        }
        nettyHttpClient = (reactor.netty.http.client.HttpClient)nettyHttpClient.port(this.port).wiretap(this.enableWiretap).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)NettyAsyncHttpClientBuilder.getTimeoutMillis(this.connectTimeout, DEFAULT_CONNECT_TIMEOUT)));
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        ProxyOptions buildProxyOptions = this.proxyOptions == null && buildConfiguration != Configuration.NONE ? ProxyOptions.fromConfiguration((Configuration)buildConfiguration, (boolean)true) : this.proxyOptions;
        boolean useCustomProxyHandler = NettyAsyncHttpClientBuilder.shouldUseCustomProxyHandler(buildProxyOptions);
        AuthorizationChallengeHandler handler = useCustomProxyHandler ? new AuthorizationChallengeHandler(buildProxyOptions.getUsername(), buildProxyOptions.getPassword()) : null;
        AtomicReference atomicReference = proxyChallengeHolder = useCustomProxyHandler ? new AtomicReference() : null;
        if (this.eventLoopGroup != null) {
            nettyHttpClient = (reactor.netty.http.client.HttpClient)nettyHttpClient.runOn(this.eventLoopGroup);
        }
        if (buildProxyOptions != null) {
            if (handler != null) {
                Pattern nonProxyHostsPattern = CoreUtils.isNullOrEmpty((CharSequence)buildProxyOptions.getNonProxyHosts()) ? null : Pattern.compile(buildProxyOptions.getNonProxyHosts(), 2);
                nettyHttpClient = (reactor.netty.http.client.HttpClient)nettyHttpClient.doOnChannelInit((connectionObserver, channel, socketAddress) -> {
                    if (NettyAsyncHttpClientBuilder.shouldApplyProxy(socketAddress, nonProxyHostsPattern)) {
                        channel.pipeline().addFirst("reactor.left.proxyHandler", (ChannelHandler)new HttpProxyHandler(AddressUtils.replaceWithResolved((InetSocketAddress)buildProxyOptions.getAddress()), handler, proxyChallengeHolder));
                    }
                });
            } else {
                nettyHttpClient = (reactor.netty.http.client.HttpClient)nettyHttpClient.proxy(proxy -> proxy.type(NettyAsyncHttpClientBuilder.toReactorNettyProxyType(buildProxyOptions.getType(), LOGGER)).address(buildProxyOptions.getAddress()).username(buildProxyOptions.getUsername()).password(ignored -> buildProxyOptions.getPassword()).nonProxyHosts(buildProxyOptions.getNonProxyHosts()));
            }
            AddressResolverGroup resolver = ((HttpClientConfig)nettyHttpClient.configuration()).resolver();
            if (resolver == null || addressResolverWasSetByBuilder) {
                nettyHttpClient = (reactor.netty.http.client.HttpClient)nettyHttpClient.resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE);
            }
        }
        return new NettyAsyncHttpClient(nettyHttpClient, this.disableBufferCopy, NettyAsyncHttpClientBuilder.getTimeoutMillis(this.readTimeout, DEFAULT_READ_TIMEOUT), NettyAsyncHttpClientBuilder.getTimeoutMillis(this.writeTimeout, DEFAULT_WRITE_TIMEOUT), NettyAsyncHttpClientBuilder.getTimeoutMillis(this.responseTimeout, DEFAULT_RESPONSE_TIMEOUT));
    }

    public NettyAsyncHttpClientBuilder connectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
        return this;
    }

    public NettyAsyncHttpClientBuilder proxy(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public NettyAsyncHttpClientBuilder wiretap(boolean enableWiretap) {
        this.enableWiretap = enableWiretap;
        return this;
    }

    public NettyAsyncHttpClientBuilder port(int port) {
        this.port = port;
        return this;
    }

    @Deprecated
    public NettyAsyncHttpClientBuilder nioEventLoopGroup(NioEventLoopGroup nioEventLoopGroup) {
        this.eventLoopGroup = nioEventLoopGroup;
        return this;
    }

    public NettyAsyncHttpClientBuilder eventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    public NettyAsyncHttpClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public NettyAsyncHttpClientBuilder disableBufferCopy(boolean disableBufferCopy) {
        this.disableBufferCopy = disableBufferCopy;
        return this;
    }

    public NettyAsyncHttpClientBuilder connectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public NettyAsyncHttpClientBuilder writeTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public NettyAsyncHttpClientBuilder responseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
        return this;
    }

    public NettyAsyncHttpClientBuilder readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    private static boolean shouldUseCustomProxyHandler(ProxyOptions options) {
        return options != null && options.getUsername() != null && options.getType() == ProxyOptions.Type.HTTP;
    }

    private static ProxyProvider.Proxy toReactorNettyProxyType(ProxyOptions.Type azureProxyType, ClientLogger logger) {
        switch (azureProxyType) {
            case HTTP: {
                return ProxyProvider.Proxy.HTTP;
            }
            case SOCKS4: {
                return ProxyProvider.Proxy.SOCKS4;
            }
            case SOCKS5: {
                return ProxyProvider.Proxy.SOCKS5;
            }
        }
        throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown 'ProxyOptions.Type' enum value"));
    }

    private static boolean shouldApplyProxy(SocketAddress socketAddress, Pattern nonProxyHostsPattern) {
        if (nonProxyHostsPattern == null) {
            return true;
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            return true;
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        return !nonProxyHostsPattern.matcher(inetSocketAddress.getHostString()).matches();
    }

    static long getTimeoutMillis(Duration configuredTimeout, long defaultTimeout) {
        if (configuredTimeout == null) {
            return defaultTimeout;
        }
        if (configuredTimeout.isZero() || configuredTimeout.isNegative()) {
            return 0L;
        }
        return Math.max(configuredTimeout.toMillis(), MINIMUM_TIMEOUT);
    }

    static {
        LOGGER = new ClientLogger(NettyAsyncHttpClientBuilder.class);
        Configuration configuration = Configuration.getGlobalConfiguration();
        DEFAULT_CONNECT_TIMEOUT = CoreUtils.getDefaultTimeoutFromEnvironment((Configuration)configuration, (String)"AZURE_REQUEST_CONNECT_TIMEOUT", (Duration)Duration.ofSeconds(10L), (ClientLogger)LOGGER).toMillis();
        DEFAULT_WRITE_TIMEOUT = CoreUtils.getDefaultTimeoutFromEnvironment((Configuration)configuration, (String)"AZURE_REQUEST_WRITE_TIMEOUT", (Duration)Duration.ofSeconds(60L), (ClientLogger)LOGGER).toMillis();
        DEFAULT_RESPONSE_TIMEOUT = CoreUtils.getDefaultTimeoutFromEnvironment((Configuration)configuration, (String)"AZURE_REQUEST_RESPONSE_TIMEOUT", (Duration)Duration.ofSeconds(60L), (ClientLogger)LOGGER).toMillis();
        DEFAULT_READ_TIMEOUT = CoreUtils.getDefaultTimeoutFromEnvironment((Configuration)configuration, (String)"AZURE_REQUEST_READ_TIMEOUT", (Duration)Duration.ofSeconds(60L), (ClientLogger)LOGGER).toMillis();
    }
}

