/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Logger;
import javax.crypto.Mac;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsVerificationSignature;
import org.apache.cxf.rt.security.crypto.HmacUtils;

public class HmacJwsSignatureVerifier
implements JwsSignatureVerifier {
    protected static final Logger LOG = LogUtils.getL7dLogger(HmacJwsSignatureVerifier.class);
    private final byte[] key;
    private final AlgorithmParameterSpec hmacSpec;
    private final SignatureAlgorithm supportedAlgo;

    public HmacJwsSignatureVerifier(String encodedKey) {
        this(JoseUtils.decode(encodedKey), SignatureAlgorithm.HS256);
    }

    public HmacJwsSignatureVerifier(String encodedKey, SignatureAlgorithm supportedAlgo) {
        this(JoseUtils.decode(encodedKey), supportedAlgo);
    }

    public HmacJwsSignatureVerifier(byte[] key, SignatureAlgorithm supportedAlgo) {
        this(key, null, supportedAlgo);
    }

    public HmacJwsSignatureVerifier(byte[] key, AlgorithmParameterSpec spec, SignatureAlgorithm supportedAlgo) {
        this.key = key;
        this.hmacSpec = spec;
        this.supportedAlgo = supportedAlgo;
    }

    @Override
    public boolean verify(JwsHeaders headers, String unsignedText, byte[] signature) {
        byte[] expected = this.computeMac(headers, unsignedText);
        return MessageDigest.isEqual(expected, signature);
    }

    private byte[] computeMac(JwsHeaders headers, String text) {
        String sigAlgo = this.checkAlgorithm(headers.getSignatureAlgorithm());
        return HmacUtils.computeHmac((byte[])this.key, (String)AlgorithmUtils.toJavaName(sigAlgo), (AlgorithmParameterSpec)this.hmacSpec, (String)text);
    }

    protected String checkAlgorithm(SignatureAlgorithm sigAlgo) {
        if (sigAlgo == null) {
            LOG.warning("Signature algorithm is not set");
            throw new JwsException(JwsException.Error.ALGORITHM_NOT_SET);
        }
        String algo = sigAlgo.getJwaName();
        if (!AlgorithmUtils.isHmacSign(algo) || !algo.equals(this.supportedAlgo.getJwaName())) {
            LOG.warning("Invalid signature algorithm: " + algo);
            throw new JwsException(JwsException.Error.INVALID_ALGORITHM);
        }
        return algo;
    }

    @Override
    public SignatureAlgorithm getAlgorithm() {
        return this.supportedAlgo;
    }

    @Override
    public JwsVerificationSignature createJwsVerificationSignature(JwsHeaders headers) {
        String sigAlgo = this.checkAlgorithm(headers.getSignatureAlgorithm());
        Mac mac = HmacUtils.getInitializedMac((byte[])this.key, (String)AlgorithmUtils.toJavaName(sigAlgo), (AlgorithmParameterSpec)this.hmacSpec);
        return new HmacJwsVerificationSignature(mac);
    }

    private static class HmacJwsVerificationSignature
    implements JwsVerificationSignature {
        private Mac mac;

        HmacJwsVerificationSignature(Mac mac) {
            this.mac = mac;
        }

        @Override
        public void update(byte[] src, int off, int len) {
            this.mac.update(src, off, len);
        }

        @Override
        public boolean verify(byte[] signature) {
            byte[] macBytes = this.mac.doFinal();
            return MessageDigest.isEqual(macBytes, signature);
        }
    }
}

