/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.client.tasks.NodeData;
import org.opensearch.client.tasks.OpenSearchException;
import org.opensearch.client.tasks.TaskGroup;
import org.opensearch.client.tasks.TaskId;
import org.opensearch.client.tasks.TaskInfo;
import org.opensearch.client.tasks.TaskOperationFailure;

public class ListTasksResponse {
    protected final List<TaskOperationFailure> taskFailures = new ArrayList<TaskOperationFailure>();
    protected final List<OpenSearchException> nodeFailures = new ArrayList<OpenSearchException>();
    protected final List<NodeData> nodesInfoData = new ArrayList<NodeData>();
    protected final List<TaskInfo> tasks = new ArrayList<TaskInfo>();
    protected final List<TaskGroup> taskGroups = new ArrayList<TaskGroup>();

    ListTasksResponse(List<NodeData> nodesInfoData, List<TaskOperationFailure> taskFailures, List<OpenSearchException> nodeFailures) {
        if (taskFailures != null) {
            this.taskFailures.addAll(taskFailures);
        }
        if (nodeFailures != null) {
            this.nodeFailures.addAll(nodeFailures);
        }
        if (nodesInfoData != null) {
            this.nodesInfoData.addAll(nodesInfoData);
        }
        this.tasks.addAll(this.nodesInfoData.stream().flatMap(nodeData -> nodeData.getTasks().stream()).collect(Collectors.toList()));
        this.taskGroups.addAll(this.buildTaskGroups());
    }

    private List<TaskGroup> buildTaskGroups() {
        HashMap<TaskId, TaskGroup.Builder> taskGroups = new HashMap<TaskId, TaskGroup.Builder>();
        ArrayList<TaskGroup.Builder> topLevelTasks = new ArrayList<TaskGroup.Builder>();
        for (TaskInfo taskInfo : this.tasks) {
            taskGroups.put(taskInfo.getTaskId(), TaskGroup.builder(taskInfo));
        }
        for (TaskGroup.Builder taskGroup : taskGroups.values()) {
            TaskId parentTaskId = taskGroup.getTaskInfo().getParentTaskId();
            if (parentTaskId != null) {
                TaskGroup.Builder parentTask = (TaskGroup.Builder)taskGroups.get(parentTaskId);
                if (parentTask != null) {
                    parentTask.addGroup(taskGroup);
                    continue;
                }
                topLevelTasks.add(taskGroup);
                continue;
            }
            topLevelTasks.add(taskGroup);
        }
        return Collections.unmodifiableList(topLevelTasks.stream().map(TaskGroup.Builder::build).collect(Collectors.toList()));
    }

    public List<TaskInfo> getTasks() {
        return this.tasks;
    }

    public Map<String, List<TaskInfo>> getPerNodeTasks() {
        return this.getTasks().stream().collect(Collectors.groupingBy(TaskInfo::getNodeId));
    }

    public List<TaskOperationFailure> getTaskFailures() {
        return this.taskFailures;
    }

    public List<OpenSearchException> getNodeFailures() {
        return this.nodeFailures;
    }

    public List<TaskGroup> getTaskGroups() {
        return this.taskGroups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListTasksResponse)) {
            return false;
        }
        ListTasksResponse response = (ListTasksResponse)o;
        return this.nodesInfoData.equals(response.nodesInfoData) && Objects.equals(this.getTaskFailures(), response.getTaskFailures()) && Objects.equals(this.getNodeFailures(), response.getNodeFailures()) && Objects.equals(this.getTasks(), response.getTasks()) && Objects.equals(this.getTaskGroups(), response.getTaskGroups());
    }

    public int hashCode() {
        return Objects.hash(this.nodesInfoData, this.getTaskFailures(), this.getNodeFailures(), this.getTasks(), this.getTaskGroups());
    }

    public String toString() {
        return "CancelTasksResponse{nodesInfoData=" + this.nodesInfoData + ", taskFailures=" + this.taskFailures + ", nodeFailures=" + this.nodeFailures + ", tasks=" + this.tasks + ", taskGroups=" + this.taskGroups + "}";
    }
}

