/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.planner.resource.monitor;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.legacy.query.planner.core.Config;
import org.opensearch.sql.legacy.query.planner.resource.Stats;
import org.opensearch.sql.legacy.query.planner.resource.monitor.Monitor;

public class TotalMemoryMonitor
implements Monitor {
    private static final Logger LOG = LogManager.getLogger();
    private final Stats stats;
    private final int limit;

    public TotalMemoryMonitor(Stats stats, Config config) {
        this.stats = stats;
        this.limit = config.circuitBreakLimit();
    }

    @Override
    public boolean isHealthy() {
        Stats.MemStats memStats = this.stats.collectMemStats();
        int usage = this.percentage(this.memUsage(memStats));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Memory usage and limit: {}%, {}%", (Object)usage, (Object)this.limit);
        }
        return usage < this.limit;
    }

    private int percentage(double usage) {
        return (int)Math.round(usage * 100.0);
    }

    private double memUsage(Stats.MemStats memStats) {
        return 1.0 * (double)(memStats.getTotal() - memStats.getFree()) / (double)memStats.getTotal();
    }
}

