/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.protocol.response.format;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public enum Format {
    JDBC("jdbc"),
    CSV("csv"),
    RAW("raw"),
    VIZ("viz");

    private final String formatName;
    private static final Map<String, Format> ALL_FORMATS;

    public static Optional<Format> of(String formatName) {
        String format = Strings.isNullOrEmpty((String)formatName) ? "jdbc" : formatName.toLowerCase();
        return Optional.ofNullable(ALL_FORMATS.getOrDefault(format, null));
    }

    @Generated
    private Format(String formatName) {
        this.formatName = formatName;
    }

    @Generated
    public String getFormatName() {
        return this.formatName;
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Format format : Format.values()) {
            builder.put((Object)format.formatName, (Object)format);
        }
        ALL_FORMATS = builder.build();
    }
}

