/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.menu;

import com.google.common.base.Preconditions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.annotation.Nonnull;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class MenuIcon
implements Icon {
    private static final MenuIcon DARK_GRAY_ICON = new MenuIcon(Color.DARK_GRAY);
    private static final MenuIcon GRAY_ICON = new MenuIcon(Color.GRAY);
    private final int WIDTH = 14;
    private final int HEIGHT = 14;
    @Nonnull
    private final Color color;

    public MenuIcon(@Nonnull Color color) {
        this.color = (Color)Preconditions.checkNotNull((Object)color);
    }

    public static MenuIcon getGrayIcon() {
        return GRAY_ICON;
    }

    public static MenuIcon getDarkGrayIcon() {
        return DARK_GRAY_ICON;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.color);
        boolean padding = true;
        int barWidth = 12;
        int barHeight = 2;
        int spacingHeight = 2;
        int xOffset = x + 1;
        int yOffset = y + 2;
        g2.fillRect(xOffset, yOffset, 12, 2);
        g2.fillRect(xOffset, yOffset += 4, 12, 2);
        g2.fillRect(xOffset, yOffset += 4, 12, 2);
    }

    @Override
    public int getIconWidth() {
        return 14;
    }

    @Override
    public int getIconHeight() {
        return 14;
    }

    public static void main(String[] args) {
        JLabel label = new JLabel("Hello");
        label.setIcon(MenuIcon.getGrayIcon());
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add((Component)label, "North");
        f.pack();
        f.setVisible(true);
    }
}

