from abc import abstractmethod
from logging import Logger

from .amqp_object import AMQPObject, Method as AMQPMethod
from .spec import BasicProperties

LOGGER: Logger

class Frame(AMQPObject):
    frame_type: int
    channel_number: int
    def __init__(self, frame_type: int, channel_number: int) -> None: ...
    @abstractmethod
    def marshal(self) -> bytes: ...

class Method(Frame):
    method: AMQPMethod
    def __init__(self, channel_number: int, method: AMQPMethod) -> None: ...
    def marshal(self) -> bytes: ...

class Header(Frame):
    body_size: int
    properties: BasicProperties
    def __init__(self, channel_number: int, body_size: int, props: BasicProperties) -> None: ...
    def marshal(self) -> bytes: ...

class Body(Frame):
    fragment: bytes
    def __init__(self, channel_number: int, fragment: bytes) -> None: ...
    def marshal(self) -> bytes: ...

class Heartbeat(Frame):
    def __init__(self) -> None: ...
    def marshal(self) -> bytes: ...

class ProtocolHeader(AMQPObject):
    frame_type: int
    major: int
    minor: int
    revision: int
    def __init__(self, major: int | None = ..., minor: int | None = ..., revision: int | None = ...) -> None: ...
    def marshal(self) -> bytes: ...

def decode_frame(data_in: bytes) -> tuple[int, Frame | None]: ...
