from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TColStd import *
from OCC.Core.TopoDS import *
from OCC.Core.gp import *
from OCC.Core.TopAbs import *
from OCC.Core.Adaptor3d import *
from OCC.Core.BRepAdaptor import *
from OCC.Core.Adaptor2d import *

BRepTopAdaptor_SeqOfPtr = NewType('BRepTopAdaptor_SeqOfPtr', TColStd_SequenceOfAddress)

class BRepTopAdaptor_FClass2d:
    def __init__(self, F: TopoDS_Face, Tol: float) -> None: ...
    def Copy(self, Other: BRepTopAdaptor_FClass2d) -> BRepTopAdaptor_FClass2d: ...
    def Destroy(self) -> None: ...
    def Perform(self, Puv: gp_Pnt2d, RecadreOnPeriodic: Optional[bool] = True) -> TopAbs_State: ...
    def PerformInfinitePoint(self) -> TopAbs_State: ...
    def TestOnRestriction(self, Puv: gp_Pnt2d, Tol: float, RecadreOnPeriodic: Optional[bool] = True) -> TopAbs_State: ...

class BRepTopAdaptor_HVertex(Adaptor3d_HVertex):
    def __init__(self, Vtx: TopoDS_Vertex, Curve: BRepAdaptor_Curve2d) -> None: ...
    def ChangeVertex(self) -> TopoDS_Vertex: ...
    def IsSame(self, Other: Adaptor3d_HVertex) -> bool: ...
    def Orientation(self) -> TopAbs_Orientation: ...
    def Parameter(self, C: Adaptor2d_Curve2d) -> float: ...
    def Resolution(self, C: Adaptor2d_Curve2d) -> float: ...
    def Value(self) -> gp_Pnt2d: ...
    def Vertex(self) -> TopoDS_Vertex: ...

class BRepTopAdaptor_Tool:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, F: TopoDS_Face, Tol2d: float) -> None: ...
    @overload
    def __init__(self, Surface: Adaptor3d_Surface, Tol2d: float) -> None: ...
    def Destroy(self) -> None: ...
    def GetSurface(self) -> Adaptor3d_Surface: ...
    def GetTopolTool(self) -> BRepTopAdaptor_TopolTool: ...
    @overload
    def Init(self, F: TopoDS_Face, Tol2d: float) -> None: ...
    @overload
    def Init(self, Surface: Adaptor3d_Surface, Tol2d: float) -> None: ...
    def SetTopolTool(self, TT: BRepTopAdaptor_TopolTool) -> None: ...

class BRepTopAdaptor_TopolTool(Adaptor3d_TopolTool):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Surface: Adaptor3d_Surface) -> None: ...
    def Classify(self, P2d: gp_Pnt2d, Tol: float, RecadreOnPeriodic: Optional[bool] = True) -> TopAbs_State: ...
    def ComputeSamplePoints(self) -> None: ...
    def Destroy(self) -> None: ...
    def DomainIsInfinite(self) -> bool: ...
    def Edge(self) -> None: ...
    def Has3d(self) -> bool: ...
    def Init(self) -> None: ...
    def InitVertexIterator(self) -> None: ...
    @overload
    def Initialize(self) -> None: ...
    @overload
    def Initialize(self, S: Adaptor3d_Surface) -> None: ...
    @overload
    def Initialize(self, Curve: Adaptor2d_Curve2d) -> None: ...
    def IsThePointOn(self, P2d: gp_Pnt2d, Tol: float, RecadreOnPeriodic: Optional[bool] = True) -> bool: ...
    def More(self) -> bool: ...
    def MoreVertex(self) -> bool: ...
    def NbSamples(self) -> int: ...
    def NbSamplesU(self) -> int: ...
    def NbSamplesV(self) -> int: ...
    def Next(self) -> None: ...
    def NextVertex(self) -> None: ...
    @overload
    def Orientation(self, C: Adaptor2d_Curve2d) -> TopAbs_Orientation: ...
    @overload
    def Orientation(self, C: Adaptor3d_HVertex) -> TopAbs_Orientation: ...
    def Pnt(self, V: Adaptor3d_HVertex) -> gp_Pnt: ...
    def SamplePoint(self, Index: int, P2d: gp_Pnt2d, P3d: gp_Pnt) -> None: ...
    @overload
    def Tol3d(self, C: Adaptor2d_Curve2d) -> float: ...
    @overload
    def Tol3d(self, V: Adaptor3d_HVertex) -> float: ...
    def Value(self) -> Adaptor2d_Curve2d: ...
    def Vertex(self) -> Adaptor3d_HVertex: ...

# harray1 classes
# harray2 classes
# hsequence classes

