from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TopoDS import *
from OCC.Core.Message import *
from OCC.Core.Geom2d import *
from OCC.Core.Geom import *
from OCC.Core.TopLoc import *
from OCC.Core.TopAbs import *

BinTools_LocationSetPtr = NewType('BinTools_LocationSetPtr', BinTools_LocationSet)

class BinTools_ObjectType(IntEnum):
    BinTools_ObjectType_Unknown: int = ...
    BinTools_ObjectType_Reference8: int = ...
    BinTools_ObjectType_Reference16: int = ...
    BinTools_ObjectType_Reference32: int = ...
    BinTools_ObjectType_Reference64: int = ...
    BinTools_ObjectType_Location: int = ...
    BinTools_ObjectType_SimpleLocation: int = ...
    BinTools_ObjectType_EmptyLocation: int = ...
    BinTools_ObjectType_LocationEnd: int = ...
    BinTools_ObjectType_Curve: int = ...
    BinTools_ObjectType_EmptyCurve: int = ...
    BinTools_ObjectType_Curve2d: int = ...
    BinTools_ObjectType_EmptyCurve2d: int = ...
    BinTools_ObjectType_Surface: int = ...
    BinTools_ObjectType_EmptySurface: int = ...
    BinTools_ObjectType_Polygon3d: int = ...
    BinTools_ObjectType_EmptyPolygon3d: int = ...
    BinTools_ObjectType_PolygonOnTriangulation: int = ...
    BinTools_ObjectType_EmptyPolygonOnTriangulation: int = ...
    BinTools_ObjectType_Triangulation: int = ...
    BinTools_ObjectType_EmptyTriangulation: int = ...
    BinTools_ObjectType_EmptyShape: int = ...
    BinTools_ObjectType_EndShape: int = ...

BinTools_ObjectType_Unknown = BinTools_ObjectType.BinTools_ObjectType_Unknown
BinTools_ObjectType_Reference8 = BinTools_ObjectType.BinTools_ObjectType_Reference8
BinTools_ObjectType_Reference16 = BinTools_ObjectType.BinTools_ObjectType_Reference16
BinTools_ObjectType_Reference32 = BinTools_ObjectType.BinTools_ObjectType_Reference32
BinTools_ObjectType_Reference64 = BinTools_ObjectType.BinTools_ObjectType_Reference64
BinTools_ObjectType_Location = BinTools_ObjectType.BinTools_ObjectType_Location
BinTools_ObjectType_SimpleLocation = BinTools_ObjectType.BinTools_ObjectType_SimpleLocation
BinTools_ObjectType_EmptyLocation = BinTools_ObjectType.BinTools_ObjectType_EmptyLocation
BinTools_ObjectType_LocationEnd = BinTools_ObjectType.BinTools_ObjectType_LocationEnd
BinTools_ObjectType_Curve = BinTools_ObjectType.BinTools_ObjectType_Curve
BinTools_ObjectType_EmptyCurve = BinTools_ObjectType.BinTools_ObjectType_EmptyCurve
BinTools_ObjectType_Curve2d = BinTools_ObjectType.BinTools_ObjectType_Curve2d
BinTools_ObjectType_EmptyCurve2d = BinTools_ObjectType.BinTools_ObjectType_EmptyCurve2d
BinTools_ObjectType_Surface = BinTools_ObjectType.BinTools_ObjectType_Surface
BinTools_ObjectType_EmptySurface = BinTools_ObjectType.BinTools_ObjectType_EmptySurface
BinTools_ObjectType_Polygon3d = BinTools_ObjectType.BinTools_ObjectType_Polygon3d
BinTools_ObjectType_EmptyPolygon3d = BinTools_ObjectType.BinTools_ObjectType_EmptyPolygon3d
BinTools_ObjectType_PolygonOnTriangulation = BinTools_ObjectType.BinTools_ObjectType_PolygonOnTriangulation
BinTools_ObjectType_EmptyPolygonOnTriangulation = BinTools_ObjectType.BinTools_ObjectType_EmptyPolygonOnTriangulation
BinTools_ObjectType_Triangulation = BinTools_ObjectType.BinTools_ObjectType_Triangulation
BinTools_ObjectType_EmptyTriangulation = BinTools_ObjectType.BinTools_ObjectType_EmptyTriangulation
BinTools_ObjectType_EmptyShape = BinTools_ObjectType.BinTools_ObjectType_EmptyShape
BinTools_ObjectType_EndShape = BinTools_ObjectType.BinTools_ObjectType_EndShape

class BinTools_FormatVersion(IntEnum):
    BinTools_FormatVersion_VERSION_1: int = ...
    BinTools_FormatVersion_VERSION_2: int = ...
    BinTools_FormatVersion_VERSION_3: int = ...
    BinTools_FormatVersion_VERSION_4: int = ...
    BinTools_FormatVersion_CURRENT: int = ...

BinTools_FormatVersion_VERSION_1 = BinTools_FormatVersion.BinTools_FormatVersion_VERSION_1
BinTools_FormatVersion_VERSION_2 = BinTools_FormatVersion.BinTools_FormatVersion_VERSION_2
BinTools_FormatVersion_VERSION_3 = BinTools_FormatVersion.BinTools_FormatVersion_VERSION_3
BinTools_FormatVersion_VERSION_4 = BinTools_FormatVersion.BinTools_FormatVersion_VERSION_4
BinTools_FormatVersion_CURRENT = BinTools_FormatVersion.BinTools_FormatVersion_CURRENT


class bintools:
    @overload
    @staticmethod
    def Read(theShape: TopoDS_Shape, theFile: str, theRange: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    @staticmethod
    def Write(theShape: TopoDS_Shape, theFile: str, theRange: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    @staticmethod
    def Write(theShape: TopoDS_Shape, theFile: str, theWithTriangles: bool, theWithNormals: bool, theVersion: BinTools_FormatVersion, theRange: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...

class BinTools_Curve2dSet:
    def __init__(self) -> None: ...
    def Add(self, C: Geom2d_Curve) -> int: ...
    def Clear(self) -> None: ...
    def Curve2d(self, I: int) -> Geom2d_Curve: ...
    def Index(self, C: Geom2d_Curve) -> int: ...
    @staticmethod
    def WriteCurve2d(C: Geom2d_Curve, OS: BinTools_OStream) -> None: ...

class BinTools_CurveSet:
    def __init__(self) -> None: ...
    def Add(self, C: Geom_Curve) -> int: ...
    def Clear(self) -> None: ...
    def Curve(self, I: int) -> Geom_Curve: ...
    def Index(self, C: Geom_Curve) -> int: ...
    @staticmethod
    def WriteCurve(C: Geom_Curve, OS: BinTools_OStream) -> None: ...

class BinTools_LocationSet:
    def __init__(self) -> None: ...
    def Add(self, L: TopLoc_Location) -> int: ...
    def Clear(self) -> None: ...
    def Index(self, L: TopLoc_Location) -> int: ...
    def Location(self, I: int) -> TopLoc_Location: ...
    def NbLocations(self) -> int: ...

class BinTools_ShapeSetBase:
    def __init__(self) -> None: ...
    def Clear(self) -> None: ...
    def FormatNb(self) -> int: ...
    def IsWithNormals(self) -> bool: ...
    def IsWithTriangles(self) -> bool: ...
    def SetFormatNb(self, theFormatNb: int) -> None: ...
    def SetWithNormals(self, theWithNormals: bool) -> None: ...
    def SetWithTriangles(self, theWithTriangles: bool) -> None: ...

class BinTools_SurfaceSet:
    def __init__(self) -> None: ...
    def Add(self, S: Geom_Surface) -> int: ...
    def Clear(self) -> None: ...
    def Index(self, S: Geom_Surface) -> int: ...
    def Surface(self, I: int) -> Geom_Surface: ...
    @staticmethod
    def WriteSurface(S: Geom_Surface, OS: BinTools_OStream) -> None: ...

class BinTools_ShapeReader(BinTools_ShapeSetBase):
    def __init__(self) -> None: ...
    def Clear(self) -> None: ...
    def ReadLocation(self, theStream: BinTools_IStream) -> TopLoc_Location: ...

class BinTools_ShapeSet(BinTools_ShapeSetBase):
    def __init__(self) -> None: ...
    def Add(self, S: TopoDS_Shape) -> int: ...
    def AddShape(self, S: TopoDS_Shape) -> None: ...
    def AddShapes(self, S1: TopoDS_Shape, S2: TopoDS_Shape) -> None: ...
    def ChangeLocations(self) -> BinTools_LocationSet: ...
    def Clear(self) -> None: ...
    def Index(self, S: TopoDS_Shape) -> int: ...
    def Locations(self) -> BinTools_LocationSet: ...
    def NbShapes(self) -> int: ...
    def Shape(self, I: int) -> TopoDS_Shape: ...

class BinTools_ShapeWriter(BinTools_ShapeSetBase):
    def __init__(self) -> None: ...
    def Clear(self) -> None: ...
    def WriteLocation(self, theStream: BinTools_OStream, theLocation: TopLoc_Location) -> None: ...

#classnotwrapped
class BinTools_IStream: ...

#classnotwrapped
class BinTools_OStream: ...

# harray1 classes
# harray2 classes
# hsequence classes

bintools_GetBool = bintools.GetBool
bintools_GetExtChar = bintools.GetExtChar
bintools_GetInteger = bintools.GetInteger
bintools_GetReal = bintools.GetReal
bintools_GetShortReal = bintools.GetShortReal
bintools_PutBool = bintools.PutBool
bintools_PutExtChar = bintools.PutExtChar
bintools_PutInteger = bintools.PutInteger
bintools_PutReal = bintools.PutReal
bintools_PutShortReal = bintools.PutShortReal
bintools_Read = bintools.Read
bintools_Read = bintools.Read
bintools_Write = bintools.Write
bintools_Write = bintools.Write
bintools_Write = bintools.Write
bintools_Write = bintools.Write
BinTools_Curve2dSet_ReadCurve2d = BinTools_Curve2dSet.ReadCurve2d
BinTools_Curve2dSet_WriteCurve2d = BinTools_Curve2dSet.WriteCurve2d
BinTools_CurveSet_ReadCurve = BinTools_CurveSet.ReadCurve
BinTools_CurveSet_WriteCurve = BinTools_CurveSet.WriteCurve
BinTools_SurfaceSet_ReadSurface = BinTools_SurfaceSet.ReadSurface
BinTools_SurfaceSet_WriteSurface = BinTools_SurfaceSet.WriteSurface
