/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.utility;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.tools.commandline.state.ShellState;
import schemacrawler.tools.commandline.utility.CommandLineUtility;
import us.fatehi.utility.Utility;

public final class CommandLineLogger {
    private final Logger logger;

    public CommandLineLogger(Logger logger) {
        this.logger = Objects.requireNonNull(logger, "No logger provided");
    }

    public void logFatalStackTrace(Throwable t) {
        if (t == null || !this.logger.isLoggable(Level.SEVERE)) {
            return;
        }
        this.logger.log(Level.SEVERE, t.getMessage(), t);
    }

    public void logSafeArguments(String[] args) {
        if (args == null || !this.logger.isLoggable(Level.INFO)) {
            return;
        }
        String passwordRedacted = "<password provided>";
        StringJoiner argsList = new StringJoiner(System.lineSeparator());
        Iterator<String> iterator = Arrays.asList(args).iterator();
        while (iterator.hasNext()) {
            String arg = iterator.next();
            if (arg == null) continue;
            if (arg.matches("--password.*=.*")) {
                argsList.add("<password provided>");
                continue;
            }
            if (arg.startsWith("--password")) {
                argsList.add("<password provided>");
                if (!iterator.hasNext()) continue;
                iterator.next();
                continue;
            }
            argsList.add(arg);
        }
        this.logger.log(Level.INFO, String.format("Command line: %n%s", argsList.toString()));
    }

    public void logState(ShellState state) {
        if (!this.logger.isLoggable(Level.INFO)) {
            return;
        }
        this.logger.log(Level.INFO, CommandLineUtility.getEnvironment(state));
    }

    public void logSystemClasspath() {
        if (!this.logger.isLoggable(Level.CONFIG)) {
            return;
        }
        this.logger.log(Level.CONFIG, String.format("Classpath: %n%s", this.printPath(System.getProperty("java.class.path"))));
        this.logger.log(Level.CONFIG, String.format("LD_LIBRARY_PATH: %n%s", this.printPath(System.getenv("LD_LIBRARY_PATH"))));
    }

    public void logSystemProperties() {
        if (!this.logger.isLoggable(Level.CONFIG)) {
            return;
        }
        TreeMap<String, String> systemProperties = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> propertyValue : System.getProperties().entrySet()) {
            String name = (String)propertyValue.getKey();
            if (!name.startsWith("java.") && !name.startsWith("os.") || name.endsWith(".path")) continue;
            systemProperties.put(name, (String)propertyValue.getValue());
        }
        this.logger.log(Level.CONFIG, String.format("System properties: %n%s", Utility.join(systemProperties, (String)System.lineSeparator())));
    }

    private String printPath(String path) {
        if (path == null) {
            return "";
        }
        return String.join((CharSequence)System.lineSeparator(), path.split(File.pathSeparator));
    }
}

