/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc.dbpool;

import com.ibm.db2.jcc.DB2ConnectionPoolDataSource;
import com.ibm.db2.jcc.DB2SimpleDataSource;
import com.ibm.db2.jcc.a.b.a;
import com.ibm.db2.jcc.am.ap;
import com.ibm.db2.jcc.am.ds;
import com.ibm.db2.jcc.dbpool.e;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.sql.DataSource;

abstract class DB2BaseConnectionPool {
    private static Runtime runTime = null;
    protected static final String NEW_LINE = "\r\n";
    protected DB2ConnectionPoolDataSource sds = new DB2ConnectionPoolDataSource();
    protected static final String DBPOOL_OBJECT_KEY = "JCC_INTERNAL_KEY_TO_GET_INTERNAL_DATASOURCE_dbpoolcrt_";
    protected int maxPoolSize = 4;
    protected int minPoolSize = 2;
    protected int initialPoolSize = 2;
    protected int acquireIncrement = 1;
    protected int maxIdleTime = 100;
    protected int idleConnectionTestPeriod = 100;
    protected static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    protected String preferredTestQuery = "SELECT current date FROM sysibm.sysdummy1";
    protected boolean testConnectionOnCheckin = false;
    protected boolean testConnectionOnCheckout = false;
    private int acquireRetryAttempts = 1;
    private int acquireRetryDelay = 1;
    private int poolLoggingFrequency = 0;
    private static final String defaultPoolNameString = "[db2-pool-";
    private String connectionPoolName = "[db2-pool-" + System.currentTimeMillis() + "]";
    private boolean autoCommit = true;
    String password;

    public abstract String getPoolStats();

    protected abstract void onExit(StringBuilder var1);

    private void initalize() {
        if (!ap.d2) {
            // empty if block
        }
        if (runTime == null) {
            runTime = Runtime.getRuntime();
            runTime.addShutdownHook(new e(this));
        }
    }

    public DB2BaseConnectionPool() {
        this.initalize();
        this.sds.setAutoCommit(this.getAutoCommit());
    }

    protected void logPoolInfo(String string, String string2) {
        if (this.getPoolLoggingFrequency() <= 0) {
            return;
        }
        if (!a.a(this.connectionPoolName + string + string2) && ds.C != null) {
            ds.C.println(this.connectionPoolName + string + string2);
        }
    }

    protected void logDebugPoolInfo(String string, String string2) {
        if (!a.a(this.connectionPoolName + string + string2) && ds.C != null) {
            ds.C.println(this.connectionPoolName + string + string2);
        }
    }

    public synchronized void setConnectionTimeout(int n2) {
        this.sds.setConnectionTimeout(n2);
    }

    public int getLoginTimeout() {
        return this.sds.getLoginTimeout();
    }

    public synchronized void setLoginTimeout(int n2) {
        this.sds.setLoginTimeout(n2);
    }

    public int getConnectionTimeout() {
        return this.sds.getConnectionTimeout();
    }

    public void setDriverType(int n2) {
        this.sds.setDriverType(n2);
    }

    public int getDriverType() {
        return this.sds.getDriverType();
    }

    public synchronized void setTraceLevel(int n2) {
        this.sds.setTraceLevel(n2);
    }

    public void setTraceFile(String string) {
        this.sds.setTraceFile(string);
    }

    public String getTraceFile() {
        return this.sds.getTraceFile();
    }

    public int getTraceLevel() {
        return this.sds.getTraceLevel();
    }

    public synchronized void setPassword(String string) {
        this.password = string;
        this.sds.setPassword(string);
    }

    public synchronized void setUser(String string) {
        this.sds.setUser(string);
    }

    public String getUser() {
        return this.sds.getUser();
    }

    public synchronized void setDatabaseName(String string) {
        this.sds.setDatabaseName(string);
    }

    public String getDatabaseName() {
        return this.sds.getDatabaseName();
    }

    public synchronized void setPortNumber(int n2) {
        this.sds.setPortNumber(n2);
    }

    public int getPortNumber() {
        return this.sds.getPortNumber();
    }

    public void setServerName(String string) {
        this.sds.setServerName(string);
    }

    public String getServerName() {
        return this.sds.getServerName();
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int n2) {
        if (n2 < 4) {
            n2 = 4;
        }
        this.maxPoolSize = n2;
    }

    public void setMinPoolSize(int n2) {
        if (n2 < 2) {
            n2 = 2;
        }
        this.minPoolSize = n2;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public void setInitialPoolSize(int n2) {
        if (n2 < 2) {
            n2 = 2;
        }
        this.initialPoolSize = n2;
    }

    public void setAcquireIncrement(int n2) {
        if (n2 < 1) {
            n2 = 1;
        }
        this.acquireIncrement = n2;
    }

    public int getAcquireIncrement() {
        return this.acquireIncrement;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int n2) {
        if (n2 < 100) {
            n2 = 100;
        }
        this.maxIdleTime = n2;
    }

    public PrintWriter getLogWriter() {
        return this.sds.getLogWriter();
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.sds.setLogWriter(printWriter);
    }

    public String getPreferredTestQuery() {
        return this.preferredTestQuery;
    }

    public void setPreferredTestQuery(String string) {
        if (string != null && string.length() > 0) {
            this.preferredTestQuery = string;
        }
    }

    public boolean isTestConnectionOnCheckin() {
        return this.testConnectionOnCheckin;
    }

    public void setTestConnectionOnCheckin(boolean bl2) {
        this.testConnectionOnCheckin = bl2;
    }

    public boolean isTestConnectionOnCheckout() {
        return this.testConnectionOnCheckout;
    }

    public void setTestConnectionOnCheckout(boolean bl2) {
        this.testConnectionOnCheckout = bl2;
    }

    public int getAcquireRetryAttempts() {
        return this.acquireRetryAttempts;
    }

    public void setAcquireRetryAttempts(int n2) {
        if (n2 < 1) {
            n2 = 1;
        }
        this.acquireRetryAttempts = n2;
    }

    public int getAcquireRetryDelay() {
        return this.acquireRetryDelay;
    }

    public void setAcquireRetryDelay(int n2) {
        if (n2 < 1) {
            n2 = 1;
        }
        this.acquireRetryDelay = n2;
    }

    public int getPoolLoggingFrequency() {
        return this.poolLoggingFrequency;
    }

    public void setPoolLoggingFrequency(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        this.poolLoggingFrequency = n2;
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean bl2) {
        this.autoCommit = bl2;
    }

    public DB2ConnectionPoolDataSource getDataSource() {
        return this.sds;
    }

    public void setDataSource(DataSource dataSource) {
        DB2SimpleDataSource dB2SimpleDataSource = (DB2SimpleDataSource)dataSource;
        this.initializePooolableDataSource(dB2SimpleDataSource);
    }

    protected void sleep(int n2) {
        try {
            Thread.sleep(1000 * n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void initializePooolableDataSource(DB2ConnectionPoolDataSource dB2ConnectionPoolDataSource) {
        this.findpassword(dB2ConnectionPoolDataSource);
        this.setUser(dB2ConnectionPoolDataSource.getUser());
        this.sds = dB2ConnectionPoolDataSource;
    }

    protected void initializePooolableDataSource(DB2SimpleDataSource dB2SimpleDataSource) {
        this.findpassword(dB2SimpleDataSource);
        this.setUser(dB2SimpleDataSource.getUser());
        this.setServerName(dB2SimpleDataSource.getServerName());
        this.setPortNumber(dB2SimpleDataSource.getPortNumber());
        this.setDatabaseName(dB2SimpleDataSource.getDatabaseName());
        this.setTraceLevel(dB2SimpleDataSource.getTraceLevel());
        this.setTraceFile(dB2SimpleDataSource.getTraceFile());
        this.sds.setLoginTimeout(dB2SimpleDataSource.getLoginTimeout());
        this.sds.setConnectionTimeout(this.getConnectionTimeout());
        this.sds.setDriverType(dB2SimpleDataSource.getDriverType());
        this.sds.setLogWriter(dB2SimpleDataSource.getLogWriter());
        this.setAutoCommit(dB2SimpleDataSource.getAutoCommit());
    }

    private void findpassword(DB2SimpleDataSource dB2SimpleDataSource) {
        try {
            Field field = dB2SimpleDataSource.getClass().getDeclaredField("password");
            field.setAccessible(true);
            Object object = field.get(dB2SimpleDataSource);
            this.setPassword(object + "");
        }
        catch (Exception exception) {
            this.logPoolInfo("exception while getting password from ds", exception.toString());
        }
    }

    private void findpassword(DB2ConnectionPoolDataSource dB2ConnectionPoolDataSource) {
        try {
            Field field = dB2ConnectionPoolDataSource.getClass().getDeclaredField("password");
            field.setAccessible(true);
            Object object = field.get(dB2ConnectionPoolDataSource);
            this.setPassword(object + "");
        }
        catch (Exception exception) {
            this.logPoolInfo("exception while getting password pds", exception.toString());
        }
    }
}

