/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.math.BigDecimal;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.ArrowResultUtil;
import net.snowflake.client.core.arrow.BigIntToFixedConverter;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;

public class BigIntToScaledFixedConverter
extends BigIntToFixedConverter {
    public BigIntToScaledFixedConverter(ValueVector fieldVector, int columnIndex, DataConversionContext context, int scale) {
        super(fieldVector, columnIndex, context);
        this.logicalTypeStr = String.format("%s(%s,%s)", new Object[]{SnowflakeType.FIXED, fieldVector.getField().getMetadata().get("precision"), fieldVector.getField().getMetadata().get("scale")});
        this.sfScale = scale;
    }

    @Override
    public float toFloat(int index) throws SFException {
        return (float)this.toDouble(index);
    }

    @Override
    public double toDouble(int index) throws SFException {
        if (this.isNull(index)) {
            return 0.0;
        }
        if (this.sfScale > 9) {
            return this.toBigDecimal(index).doubleValue();
        }
        int scale = this.sfScale;
        double res = this.getLong(index);
        return res /= (double)ArrowResultUtil.powerOfTen(scale);
    }

    @Override
    public short toShort(int index) throws SFException {
        if (this.isNull(index)) {
            return 0;
        }
        BigDecimal val = this.toBigDecimal(index);
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Short", val.toPlainString());
    }

    @Override
    public int toInt(int index) throws SFException {
        if (this.isNull(index)) {
            return 0;
        }
        BigDecimal val = this.toBigDecimal(index);
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Int", val.toPlainString());
    }

    @Override
    public long toLong(int index) throws SFException {
        if (this.isNull(index)) {
            return 0L;
        }
        BigDecimal val = this.toBigDecimal(index);
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Long", val.toPlainString());
    }

    @Override
    public Object toObject(int index) {
        return this.toBigDecimal(index);
    }

    @Override
    public String toString(int index) {
        return this.isNull(index) ? null : BigDecimal.valueOf(this.getLong(index), this.sfScale).toPlainString();
    }

    @Override
    public boolean toBoolean(int index) throws SFException {
        if (this.isNull(index)) {
            return false;
        }
        BigDecimal val = this.toBigDecimal(index);
        if (val.compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        if (val.compareTo(BigDecimal.ONE) == 0) {
            return true;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Boolean", val.toPlainString());
    }

    @Override
    public byte[] toBytes(int index) {
        if (this.isNull(index)) {
            return null;
        }
        this.byteBuf.putLong(0, this.getLong(index));
        return this.byteBuf.array();
    }
}

