/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import net.snowflake.client.jdbc.SnowflakeUtil;

public class SnowflakeTimestampWithTimezone
extends Timestamp {
    private static final long serialVersionUID = 1L;
    private TimeZone timezone = TimeZone.getTimeZone("UTC");

    public SnowflakeTimestampWithTimezone(long seconds, int nanoseconds, TimeZone timezone) {
        super(seconds);
        this.setNanos(nanoseconds);
        this.timezone = timezone;
    }

    public SnowflakeTimestampWithTimezone(Timestamp ts, TimeZone timezone) {
        this(ts.getTime(), ts.getNanos(), timezone);
    }

    public SnowflakeTimestampWithTimezone(Timestamp ts) {
        this(ts.getTime(), ts.getNanos(), TimeZone.getTimeZone("UTC"));
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public ZonedDateTime toZonedDateTime() {
        return ZonedDateTime.ofInstant(this.toInstant(), this.timezone.toZoneId());
    }

    @Override
    public synchronized String toString() {
        int trailingZeros = 0;
        int tmpNanos = this.getNanos();
        if (tmpNanos == 0) {
            trailingZeros = 8;
        } else {
            while (tmpNanos % 10 == 0) {
                tmpNanos /= 10;
                ++trailingZeros;
            }
        }
        String baseFormat = "uuuu-MM-dd HH:mm:ss.";
        StringBuilder buf = new StringBuilder("uuuu-MM-dd HH:mm:ss.".length() + 9 - trailingZeros);
        buf.append("uuuu-MM-dd HH:mm:ss.");
        for (int i = 0; i < 9 - trailingZeros; ++i) {
            buf.append("S");
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(buf.toString());
        ZoneOffset offset = ZoneId.of(this.timezone.getID()).getRules().getOffset(this.toInstant());
        LocalDateTime ldt = LocalDateTime.ofEpochSecond(SnowflakeUtil.getSecondsFromMillis(this.getTime()), this.getNanos(), offset);
        return ldt.format(formatter);
    }
}

