/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.rpc;

import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ApiCallContext;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ResponseObserver;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ServerStreamingCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.Watchdog;
import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.threeten.bp.Duration;

class WatchdogServerStreamingCallable<RequestT, ResponseT>
extends ServerStreamingCallable<RequestT, ResponseT> {
    private final ServerStreamingCallable<RequestT, ResponseT> inner;
    private final Watchdog watchdog;

    WatchdogServerStreamingCallable(ServerStreamingCallable<RequestT, ResponseT> inner, Watchdog watchdog) {
        Preconditions.checkNotNull(inner);
        Preconditions.checkNotNull(watchdog);
        this.inner = inner;
        this.watchdog = watchdog;
    }

    @Override
    public void call(RequestT request, ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
        Duration waitTimeout = MoreObjects.firstNonNull(context.getStreamWaitTimeout(), Duration.ZERO);
        Duration idleTimeout = MoreObjects.firstNonNull(context.getStreamIdleTimeout(), Duration.ZERO);
        responseObserver = this.watchdog.watch(responseObserver, waitTimeout, idleTimeout);
        this.inner.call(request, responseObserver, context);
    }
}

