/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob;

import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.AccessCondition;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.DoesServiceRequest;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.OperationContext;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageException;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.BlobOutputStream;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.BlobOutputStreamInternal;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.BlobRequestOptions;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.CloudAppendBlob;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.CloudBlockBlob;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.CloudPageBlob;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.Utility;

final class BlobEncryptStream
extends BlobOutputStream {
    OperationContext opContext;
    BlobRequestOptions options;
    private CipherOutputStream cipherStream;

    protected BlobEncryptStream(CloudBlockBlob blockBlob, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext, Cipher cipher) throws StorageException {
        this.opContext = opContext;
        this.options = options;
        this.options.setValidateEncryptionPolicy(false);
        BlobOutputStreamInternal blobStream = new BlobOutputStreamInternal(blockBlob, accessCondition, options, opContext);
        this.cipherStream = new CipherOutputStream(blobStream, cipher);
    }

    @DoesServiceRequest
    protected BlobEncryptStream(CloudPageBlob pageBlob, long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext, Cipher cipher) throws StorageException {
        this.opContext = opContext;
        this.options = options;
        this.options.setValidateEncryptionPolicy(false);
        BlobOutputStreamInternal blobStream = new BlobOutputStreamInternal(pageBlob, length, accessCondition, options, opContext);
        this.cipherStream = new CipherOutputStream(blobStream, cipher);
    }

    @DoesServiceRequest
    protected BlobEncryptStream(CloudAppendBlob appendBlob, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext, Cipher cipher) throws StorageException {
        this.opContext = opContext;
        this.options = options;
        this.options.setValidateEncryptionPolicy(false);
        BlobOutputStreamInternal blobStream = new BlobOutputStreamInternal(appendBlob, accessCondition, options, opContext);
        this.cipherStream = new CipherOutputStream(blobStream, cipher);
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        this.cipherStream.write(data, offset, length);
    }

    @Override
    public void write(InputStream sourceStream, long writeLength) throws IOException, StorageException {
        Utility.writeToOutputStream(sourceStream, this, writeLength, false, false, this.opContext, this.options, false);
    }

    @Override
    public void flush() throws IOException {
        this.cipherStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.cipherStream.close();
    }
}

