/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import java.math.BigInteger;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.extern.decimal.Decimal128;
import org.firebirdsql.extern.decimal.Decimal64;
import org.firebirdsql.gds.ng.DefaultDatatypeCoder;

public final class LittleEndianDatatypeCoder
extends DefaultDatatypeCoder {
    public static LittleEndianDatatypeCoder forEncodingFactory(IEncodingFactory encodingFactory) {
        return encodingFactory.getOrCreateDatatypeCoder(LittleEndianDatatypeCoder.class);
    }

    public LittleEndianDatatypeCoder(IEncodingFactory encodingFactory) {
        super(encodingFactory);
    }

    @Override
    public int sizeOfShort() {
        return 2;
    }

    @Override
    public byte[] encodeShort(short value) {
        byte[] ret = new byte[]{(byte)(value & 0xFF), (byte)(value >>> 8 & 0xFF)};
        return ret;
    }

    @Override
    public void encodeShort(int value, byte[] target, int fromIndex) {
        target[fromIndex] = (byte)(value & 0xFF);
        target[fromIndex + 1] = (byte)(value >>> 8 & 0xFF);
    }

    @Override
    public short decodeShort(byte[] byte_int) {
        return (short)((byte_int[0] & 0xFF) + ((byte_int[1] & 0xFF) << 8));
    }

    @Override
    public short decodeShort(byte[] bytes, int fromIndex) {
        return (short)((bytes[fromIndex] & 0xFF) + ((bytes[fromIndex + 1] & 0xFF) << 8));
    }

    @Override
    public byte[] encodeInt(int value) {
        byte[] ret = new byte[]{(byte)(value & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 24 & 0xFF)};
        return ret;
    }

    @Override
    public void encodeInt(int value, byte[] target, int fromIndex) {
        target[fromIndex] = (byte)(value & 0xFF);
        target[fromIndex + 1] = (byte)(value >>> 8 & 0xFF);
        target[fromIndex + 2] = (byte)(value >>> 16 & 0xFF);
        target[fromIndex + 3] = (byte)(value >>> 24 & 0xFF);
    }

    @Override
    public int decodeInt(byte[] byte_int) {
        return (byte_int[0] & 0xFF) + ((byte_int[1] & 0xFF) << 8) + ((byte_int[2] & 0xFF) << 16) + ((byte_int[3] & 0xFF) << 24);
    }

    @Override
    public int decodeInt(byte[] bytes, int fromIndex) {
        return (bytes[fromIndex] & 0xFF) + ((bytes[fromIndex + 1] & 0xFF) << 8) + ((bytes[fromIndex + 2] & 0xFF) << 16) + ((bytes[fromIndex + 3] & 0xFF) << 24);
    }

    @Override
    public byte[] encodeLong(long value) {
        byte[] ret = new byte[]{(byte)(value & 0xFFL), (byte)(value >>> 8 & 0xFFL), (byte)(value >>> 16 & 0xFFL), (byte)(value >>> 24 & 0xFFL), (byte)(value >>> 32 & 0xFFL), (byte)(value >>> 40 & 0xFFL), (byte)(value >>> 48 & 0xFFL), (byte)(value >>> 56 & 0xFFL)};
        return ret;
    }

    @Override
    public long decodeLong(byte[] byte_int) {
        return (long)(byte_int[0] & 0xFF) + ((long)(byte_int[1] & 0xFF) << 8) + ((long)(byte_int[2] & 0xFF) << 16) + ((long)(byte_int[3] & 0xFF) << 24) + ((long)(byte_int[4] & 0xFF) << 32) + ((long)(byte_int[5] & 0xFF) << 40) + ((long)(byte_int[6] & 0xFF) << 48) + ((long)(byte_int[7] & 0xFF) << 56);
    }

    @Override
    public Decimal64 decodeDecimal64(byte[] data) {
        return super.decodeDecimal64(this.reverseByteOrder(data));
    }

    @Override
    public byte[] encodeDecimal64(Decimal64 decimal64) {
        return this.reverseByteOrder(super.encodeDecimal64(decimal64));
    }

    @Override
    public Decimal128 decodeDecimal128(byte[] data) {
        return super.decodeDecimal128(this.reverseByteOrder(data));
    }

    @Override
    public byte[] encodeDecimal128(Decimal128 decimal128) {
        return this.reverseByteOrder(super.encodeDecimal128(decimal128));
    }

    @Override
    public BigInteger decodeInt128(byte[] data) {
        return super.decodeInt128(this.reverseByteOrder(data));
    }

    @Override
    public byte[] encodeInt128(BigInteger bigInteger) {
        return this.reverseByteOrder(super.encodeInt128(bigInteger));
    }

    private byte[] reverseByteOrder(byte[] array) {
        byte[] newArray = new byte[array.length];
        int maxIndex = newArray.length - 1;
        for (int idx = 0; idx < array.length; ++idx) {
            newArray[idx] = array[maxIndex - idx];
        }
        return newArray;
    }
}

