/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Catalog;
import schemacrawler.tools.lint.LintCollector;
import schemacrawler.tools.lint.Linter;
import schemacrawler.tools.lint.LinterRegistry;
import schemacrawler.tools.lint.config.LinterConfig;
import schemacrawler.tools.lint.config.LinterConfigs;
import us.fatehi.utility.string.StringFormat;

public final class Linters
implements Iterable<Linter> {
    private static final Logger LOGGER = Logger.getLogger(Linters.class.getName());
    private final List<Linter> linters;
    private final LintCollector collector;
    private final LinterRegistry registry;

    public Linters(LinterConfigs linterConfigs, boolean runAllLinters) {
        Objects.requireNonNull(linterConfigs, "No linter configs provided");
        this.linters = new ArrayList<Linter>();
        this.collector = new LintCollector();
        this.registry = new LinterRegistry();
        Set<String> registeredLinters = this.registry.allRegisteredLinters();
        for (LinterConfig linterConfig : linterConfigs) {
            if (linterConfig == null) continue;
            String linterId = linterConfig.getLinterId();
            registeredLinters.remove(linterId);
            if (!linterConfig.isRunLinter()) {
                LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Not running configured linter <%s>", new Object[]{linterConfig}));
                continue;
            }
            Linter linter = this.newLinter(linterId);
            if (linter == null) continue;
            linter.configure(linterConfig);
            this.linters.add(linter);
        }
        if (runAllLinters) {
            for (String linterId : registeredLinters) {
                Linter linter = this.newLinter(linterId);
                this.linters.add(linter);
            }
        }
    }

    public boolean exceedsThreshold() {
        for (Linter linter : this.linters) {
            if (!linter.exceedsThreshold()) continue;
            return true;
        }
        return false;
    }

    public LintCollector getCollector() {
        return this.collector;
    }

    public String getLintSummary() {
        ArrayList<Linter> linters = new ArrayList<Linter>(this.linters);
        final class LinterComparator
        implements Comparator<Linter> {
            LinterComparator() {
            }

            @Override
            public int compare(Linter linter1, Linter linter2) {
                if (linter1 == null) {
                    return -1;
                }
                if (linter2 == null) {
                    return 1;
                }
                int comparison = 0;
                if (comparison == 0) {
                    comparison = linter1.getSeverity().compareTo(linter2.getSeverity());
                }
                if (comparison == 0) {
                    comparison = linter1.getLintCount() - linter2.getLintCount();
                }
                if (comparison == 0) {
                    comparison = linter1.getLinterId().compareTo(linter2.getLinterId());
                }
                return comparison;
            }
        }
        linters.sort(new LinterComparator());
        StringBuilder buffer = new StringBuilder(1024);
        for (Linter linter : linters) {
            if (linter.getLintCount() <= 0) continue;
            buffer.append(String.format("%8s%s %5d- %s%n", "[" + (Object)((Object)linter.getSeverity()) + "]", linter.exceedsThreshold() ? "*" : " ", linter.getLintCount(), linter.getSummary()));
        }
        if (buffer.length() > 0) {
            buffer.insert(0, "Summary of schema lints:\n");
        }
        return buffer.toString();
    }

    @Override
    public Iterator<Linter> iterator() {
        return this.linters.iterator();
    }

    public void lint(Catalog catalog, Connection connection) {
        for (Linter linter : this.linters) {
            LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Linting with <%s>", new Object[]{linter.getLinterInstanceId()}));
            try {
                linter.lint(catalog, connection);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not run linter <%s>", new Object[]{linter.getLinterInstanceId()}));
            }
        }
    }

    public int size() {
        return this.linters.size();
    }

    public String toString() {
        return this.linters.toString();
    }

    private Linter newLinter(String linterId) {
        Linter linter = this.registry.newLinter(linterId);
        if (linter != null) {
            linter.setLintCollector(this.collector);
        } else {
            LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find linter <%s>", new Object[]{linterId}));
        }
        return linter;
    }
}

