/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.IOException;
import java.net.Proxy;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.apache.http.conn.ssl.SSLConnectionSocketFactory;
import net.snowflake.client.jdbc.internal.apache.http.protocol.HttpContext;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SFSSLConnectionSocketFactory
extends SSLConnectionSocketFactory {
    static final SFLogger logger = SFLoggerFactory.getLogger(SFSSLConnectionSocketFactory.class);
    private static final String SSL_VERSION = "TLSv1.2";
    private final boolean socksProxyDisabled;

    public SFSSLConnectionSocketFactory(TrustManager[] trustManagers, boolean socksProxyDisabled) throws NoSuchAlgorithmException, KeyManagementException {
        super(SFSSLConnectionSocketFactory.initSSLContext(trustManagers), new String[]{SSL_VERSION}, SFSSLConnectionSocketFactory.decideCipherSuites(), SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        this.socksProxyDisabled = socksProxyDisabled;
    }

    private static SSLContext initSSLContext(TrustManager[] trustManagers) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance(SSL_VERSION);
        sslContext.init(null, trustManagers, null);
        return sslContext;
    }

    @Override
    public Socket createSocket(HttpContext ctx) throws IOException {
        return this.socksProxyDisabled ? new Socket(Proxy.NO_PROXY) : super.createSocket(ctx);
    }

    private static String[] decideCipherSuites() {
        String sysCipherSuites = SnowflakeUtil.systemGetProperty("https.cipherSuites");
        String[] cipherSuites = sysCipherSuites != null ? sysCipherSuites.split(",") : ((SSLServerSocketFactory)SSLServerSocketFactory.getDefault()).getDefaultCipherSuites();
        logger.trace("Cipher suites used: {}", () -> Arrays.toString(cipherSuites));
        return cipherSuites;
    }
}

