/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto;

import java.security.GeneralSecurityException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSAlgorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSHeader;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSSigner;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.EdDSAProvider;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.Curve;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.OctetKeyPair;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.Base64URL;
import net.snowflake.client.jdbc.internal.google.crypto.tink.subtle.Ed25519Sign;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class Ed25519Signer
extends EdDSAProvider
implements JWSSigner {
    private final OctetKeyPair privateKey;
    private final Ed25519Sign tinkSigner;

    public Ed25519Signer(OctetKeyPair privateKey) throws JOSEException {
        if (!Curve.Ed25519.equals(privateKey.getCurve())) {
            throw new JOSEException("Ed25519Signer only supports OctetKeyPairs with crv=Ed25519");
        }
        if (!privateKey.isPrivate()) {
            throw new JOSEException("The OctetKeyPair doesn't contain a private part");
        }
        this.privateKey = privateKey;
        try {
            this.tinkSigner = new Ed25519Sign(privateKey.getDecodedD());
        }
        catch (GeneralSecurityException e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    public OctetKeyPair getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Base64URL sign(JWSHeader header, byte[] signingInput) throws JOSEException {
        byte[] jwsSignature;
        JWSAlgorithm alg = header.getAlgorithm();
        if (!JWSAlgorithm.EdDSA.equals(alg)) {
            throw new JOSEException("Ed25519Signer requires alg=EdDSA in JWSHeader");
        }
        try {
            jwsSignature = this.tinkSigner.sign(signingInput);
        }
        catch (GeneralSecurityException e) {
            throw new JOSEException(e.getMessage(), e);
        }
        return Base64URL.encode(jwsSignature);
    }
}

