/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.config;

import java.io.File;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.DataObject;

public interface PrintConfiguration
extends DataObject {
    public static final String EXPORT = "Export file";
    public static final String EXPORT_AND_PRINT = "Export and print";
    public static final String PIPE = "Pipe to printer";

    public String getAction();

    @Adjustable(editable=true, info="Action", category="Print/Export", choices={"Export file", "Export and print", "Pipe to printer"}, key="0", forceComboBox=true, gap=2)
    public void setAction(String var1);

    public File getExportFile();

    @Adjustable(editable=true, info="File to export", category="Print/Export", depends="action!=Pipe to printer", key="1", tooltip="The name of the file to be exported")
    public void setExportFile(File var1);

    public boolean isEraseExportFile();

    @Adjustable(editable=true, info="Erase file when printed", category="Print/Export", key="11", depends="action=Export and print")
    public void setEraseExportFile(boolean var1);

    public String getCommand();

    @Adjustable(editable=true, info="Printer", category="Print/Export", depends="action!=Export file", key="2", tooltip="The command for printing the file", gap=2)
    public void setCommand(String var1);

    public String getFormat();

    @Adjustable(editable=true, info="Page format", category="Print/Export", key="3", choices={"A0", "A1", "A2", "A3", "A4", "A5", "A6"})
    public void setFormat(String var1);

    public String getOrientation();

    @Adjustable(editable=true, info="Orientation", category="Print/Export", key="4", choices={"Portrait", "Landscape"})
    public void setOrientation(String var1);

    public boolean isMultipage();

    @Adjustable(editable=true, info="Multiple pages", category="Print/Export", key="5")
    public void setMultipage(boolean var1);

    public boolean isRepeatHeads();

    @Adjustable(editable=false, info="Repeat lifeline heads", category="Print/Export", key="6", depends="multipage=true")
    public void setRepeatHeads(boolean var1);

    public boolean isCenterVertically();

    @Adjustable(editable=true, info="Center vertically", category="Print/Export", key="7", depends="multipage=false")
    public void setCenterVertically(boolean var1);

    public boolean isCenterHorizontally();

    @Adjustable(editable=true, info="Center horizontally", category="Print/Export", key="8")
    public void setCenterHorizontally(boolean var1);

    public boolean isFitToPage();

    @Adjustable(editable=true, info="Fit to page", category="Print/Export", key="9", depends="multipage=false")
    public void setFitToPage(boolean var1);
}

