<!--
title: Serverless Framework - Spotinst Functions Guide - Credentials
menuText: Credentials
menuOrder: 4
description: How to set up the Serverless Framework with your Spotinst Functions credentials
layout: Doc
-->

<!-- DOCS-SITE-LINK:START automatically generated -->

### [Read this on the main serverless docs site](https://www.serverless.com/framework/docs/providers/spotinst/guide/credentials)

<!-- DOCS-SITE-LINK:END -->

# Spotinst Functions - Credentials

The Serverless Framework needs access to your Spotinst account so that it can create and manage resources on your behalf. Please make sure you have created and saved your Permanent or Temporary Token before continuing.

## Configure Credentials

You will need to have your account ID number and your account token ready. Your account ID can be found on the Spotinst console and your token can be generated by following the [Create Token Guide](./create-token.md).

In order to run the config credentials command from the terminal you will need to start a new Spotinst project and install the plugin. First you will need to run the create a new project using the Spotinst template. To do this run:

```bash
serverless create -t spotinst-nodejs -p new-function
```

Then navigate to the directory that was just created `new-function` and install the Spotinst Serverless Plugin:

```bash
cd new-function
npm install
```

Once this has completed you will be able to configure your credentials by running

```bash
serverless config credentials -p spotinst -a {your account id} -t {your token}
```

This will create a ~/.spotinst/credentials file the file should look like this when if done correctly:

```bash
default:
    token: {your token}
    account: {your account number}
```

After this is set up properly you will be able to deploy functions from your computer and monitor them on the Spotinst Console.
