"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.detector = void 0;
const types_1 = require("./types");
const keys = Object.keys(types_1.typeHandlers);
// This map helps avoid validating for every single image type
const firstBytes = {
    0x38: 'psd',
    0x42: 'bmp',
    0x44: 'dds',
    0x47: 'gif',
    0x49: 'tiff',
    0x4d: 'tiff',
    0x52: 'webp',
    0x69: 'icns',
    0x89: 'png',
    0xff: 'jpg'
};
function detector(buffer) {
    const byte = buffer[0];
    if (byte in firstBytes) {
        const type = firstBytes[byte];
        if (type && types_1.typeHandlers[type].validate(buffer)) {
            return type;
        }
    }
    const finder = (key) => types_1.typeHandlers[key].validate(buffer);
    return keys.find(finder);
}
exports.detector = detector;
