complete -c wezterm -n "__fish_use_subcommand" -l config-file -d 'Specify the configuration file to use, overrides the normal configuration file resolution' -r -F
complete -c wezterm -n "__fish_use_subcommand" -l config -d 'Override specific configuration values' -r
complete -c wezterm -n "__fish_use_subcommand" -s n -l skip-config -d 'Skip loading wezterm.lua'
complete -c wezterm -n "__fish_use_subcommand" -s h -l help -d 'Print help information'
complete -c wezterm -n "__fish_use_subcommand" -s V -l version -d 'Print version information'
complete -c wezterm -n "__fish_use_subcommand" -f -a "start" -d 'Start the GUI, optionally running an alternative program'
complete -c wezterm -n "__fish_use_subcommand" -f -a "ssh" -d 'Establish an ssh session'
complete -c wezterm -n "__fish_use_subcommand" -f -a "serial" -d 'Open a serial port'
complete -c wezterm -n "__fish_use_subcommand" -f -a "connect" -d 'Connect to wezterm multiplexer'
complete -c wezterm -n "__fish_use_subcommand" -f -a "ls-fonts" -d 'Display information about fonts'
complete -c wezterm -n "__fish_use_subcommand" -f -a "show-keys" -d 'Show key assignments'
complete -c wezterm -n "__fish_use_subcommand" -f -a "cli" -d 'Interact with experimental mux server'
complete -c wezterm -n "__fish_use_subcommand" -f -a "imgcat" -d 'Output an image to the terminal'
complete -c wezterm -n "__fish_use_subcommand" -f -a "set-working-directory" -d 'Advise the terminal of the current working directory by emitting an OSC 7 escape sequence'
complete -c wezterm -n "__fish_use_subcommand" -f -a "record" -d 'Record a terminal session as an asciicast'
complete -c wezterm -n "__fish_use_subcommand" -f -a "replay" -d 'Replay an asciicast terminal session'
complete -c wezterm -n "__fish_use_subcommand" -f -a "shell-completion" -d 'Generate shell completion information'
complete -c wezterm -n "__fish_use_subcommand" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c wezterm -n "__fish_seen_subcommand_from start" -l cwd -d 'Specify the current working directory for the initially spawned program' -r -f -a "(__fish_complete_directories)"
complete -c wezterm -n "__fish_seen_subcommand_from start" -l class -d 'Override the default windowing system class. The default is "org.wezfurlong.wezterm". Under X11 and Windows this changes the window class. Under Wayland this changes the app_id. This changes the class for all windows spawned by this instance of wezterm, including error, update and ssh authentication dialogs' -r
complete -c wezterm -n "__fish_seen_subcommand_from start" -l workspace -d 'Override the default workspace with the provided name. The default is "default"' -r
complete -c wezterm -n "__fish_seen_subcommand_from start" -l position -d 'Override the position for the initial window launched by this process.' -r
complete -c wezterm -n "__fish_seen_subcommand_from start" -l no-auto-connect -d 'If true, do not connect to domains marked as connect_automatically in your wezterm configuration file'
complete -c wezterm -n "__fish_seen_subcommand_from start" -l always-new-process -d 'If enabled, don\'t try to ask an existing wezterm GUI instance to start the command.  Instead, always start the GUI in this invocation of wezterm so that you can wait for the command to complete by waiting for this wezterm process to finish'
complete -c wezterm -n "__fish_seen_subcommand_from start" -s h -l help -d 'Print help information (use `--help` for more detail)'
complete -c wezterm -n "__fish_seen_subcommand_from ssh" -s o -l ssh-option -d 'Override specific SSH configuration options. `wezterm ssh` is able to parse some (but not all!) options from your `~/.ssh/config` and `/etc/ssh/ssh_config` files. This command line switch allows you to override or otherwise specify ssh_config style options' -r
complete -c wezterm -n "__fish_seen_subcommand_from ssh" -l class -d 'Override the default windowing system class. The default is "org.wezfurlong.wezterm". Under X11 and Windows this changes the window class. Under Wayland this changes the app_id. This changes the class for all windows spawned by this instance of wezterm, including error, update and ssh authentication dialogs' -r
complete -c wezterm -n "__fish_seen_subcommand_from ssh" -l position -d 'Override the position for the initial window launched by this process.' -r
complete -c wezterm -n "__fish_seen_subcommand_from ssh" -s v -d 'Enable verbose ssh protocol tracing. The trace information is printed to the stderr stream of the process'
complete -c wezterm -n "__fish_seen_subcommand_from ssh" -s h -l help -d 'Print help information (use `--help` for more detail)'
complete -c wezterm -n "__fish_seen_subcommand_from serial" -l baud -d 'Set the baud rate.  The default is 9600 baud' -r
complete -c wezterm -n "__fish_seen_subcommand_from serial" -l class -d 'Override the default windowing system class. The default is "org.wezfurlong.wezterm". Under X11 and Windows this changes the window class. Under Wayland this changes the app_id. This changes the class for all windows spawned by this instance of wezterm, including error, update and ssh authentication dialogs' -r
complete -c wezterm -n "__fish_seen_subcommand_from serial" -l position -d 'Override the position for the initial window launched by this process.' -r
complete -c wezterm -n "__fish_seen_subcommand_from serial" -s h -l help -d 'Print help information (use `--help` for more detail)'
complete -c wezterm -n "__fish_seen_subcommand_from connect" -l class -d 'Override the default windowing system class. The default is "org.wezfurlong.wezterm". Under X11 and Windows this changes the window class. Under Wayland this changes the app_id. This changes the class for all windows spawned by this instance of wezterm, including error, update and ssh authentication dialogs' -r
complete -c wezterm -n "__fish_seen_subcommand_from connect" -l workspace -d 'Override the default workspace with the provided name. The default is "default"' -r
complete -c wezterm -n "__fish_seen_subcommand_from connect" -l position -d 'Override the position for the initial window launched by this process.' -r
complete -c wezterm -n "__fish_seen_subcommand_from connect" -s h -l help -d 'Print help information (use `--help` for more detail)'
complete -c wezterm -n "__fish_seen_subcommand_from ls-fonts" -l text -d 'Explain which fonts are used to render the supplied text string' -r
complete -c wezterm -n "__fish_seen_subcommand_from ls-fonts" -l codepoints -d 'Explain which fonts are used to render the specified unicode code point sequence. Code points are comma separated hex values' -r
complete -c wezterm -n "__fish_seen_subcommand_from ls-fonts" -l list-system -d 'Whether to list all fonts available to the system'
complete -c wezterm -n "__fish_seen_subcommand_from ls-fonts" -l rasterize-ascii -d 'Show rasterized glyphs for the text in --text or --codepoints using ascii blocks'
complete -c wezterm -n "__fish_seen_subcommand_from ls-fonts" -s h -l help -d 'Print help information'
complete -c wezterm -n "__fish_seen_subcommand_from show-keys" -l key-table -d 'In lua mode, show only the named key table' -r
complete -c wezterm -n "__fish_seen_subcommand_from show-keys" -l lua -d 'Show the keys as lua config statements'
complete -c wezterm -n "__fish_seen_subcommand_from show-keys" -s h -l help -d 'Print help information'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -l class -d 'When connecting to a gui instance, if you started the gui with `--class SOMETHING`, you should also pass that same value here in order for the client to find the correct gui instance' -r
complete -c wezterm -n "__fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -l no-auto-start -d 'Don\'t automatically start the server'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -l prefer-mux -d 'Prefer connecting to a background mux server. The default is to prefer connecting to a running wezterm gui instance'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help information'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -f -a "list" -d 'list windows, tabs and panes'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -f -a "list-clients" -d 'list clients'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -f -a "proxy" -d 'start rpc proxy pipe'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -f -a "tlscreds" -d 'obtain tls credentials'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -f -a "move-pane-to-new-tab" -d 'Move a pane into a new tab'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -f -a "split-pane" -d 'split the current pane.
Outputs the pane-id for the newly created pane on success'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -f -a "spawn" -d 'Spawn a command into a new window or tab
Outputs the pane-id for the newly created pane on success'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -f -a "send-text" -d 'Send text to a pane as though it were pasted. If bracketed paste mode is enabled in the pane, then the text will be sent as a bracketed paste'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -f -a "activate-pane-direction" -d 'Activate an adjacent pane in the specified direction'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from list" -l format -d 'Controls the output format. "table" and "json" are possible formats' -r
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help information'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from list-clients" -l format -d 'Controls the output format. "table" and "json" are possible formats' -r
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from list-clients" -s h -l help -d 'Print help information'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from proxy" -s h -l help -d 'Print help information'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from tlscreds" -s h -l help -d 'Print help information'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from move-pane-to-new-tab" -l pane-id -d 'Specify the pane that should be moved. The default is to use the current pane based on the environment variable WEZTERM_PANE' -r
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from move-pane-to-new-tab" -l window-id -d 'Specify the window into which the new tab will be created. If omitted, the window associated with the current pane is used' -r
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from move-pane-to-new-tab" -l workspace -d 'If creating a new window, override the default workspace name with the provided name.  The default name is "default"' -r
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from move-pane-to-new-tab" -l new-window -d 'Create tab in a new window, rather than the window currently containing the pane'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from move-pane-to-new-tab" -s h -l help -d 'Print help information'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from split-pane" -l pane-id -d 'Specify the pane that should be split. The default is to use the current pane based on the environment variable WEZTERM_PANE' -r
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from split-pane" -l cells -d 'The number of cells that the new split should have. If omitted, 50% of the available space is used' -r
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from split-pane" -l percent -d 'Specify the number of cells that the new split should have, expressed as a percentage of the available space' -r
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from split-pane" -l cwd -d 'Specify the current working directory for the initially spawned program' -r -f -a "(__fish_complete_directories)"
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from split-pane" -l move-pane-id -d 'Instead of spawning a new command, move the specified pane into the newly created split' -r
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from split-pane" -l horizontal -d 'Equivalent to `--right`. If neither this nor any other direction is specified, the default is equivalent to `--bottom`'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from split-pane" -l left -d 'Split horizontally, with the new pane on the left'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from split-pane" -l right -d 'Split horizontally, with the new pane on the right'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from split-pane" -l top -d 'Split vertically, with the new pane on the top'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from split-pane" -l bottom -d 'Split vertically, with the new pane on the bottom'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from split-pane" -l top-level -d 'Rather than splitting the active pane, split the entire window'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from split-pane" -s h -l help -d 'Print help information'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from spawn" -l pane-id -d 'Specify the current pane. The default is to use the current pane based on the environment variable WEZTERM_PANE. The pane is used to determine the current domain and window' -r
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from spawn" -l domain-name -r
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from spawn" -l window-id -d 'Specify the window into which to spawn a tab. If omitted, the window associated with the current pane is used. Cannot be used with `--workspace` or `--new-window`' -r
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from spawn" -l cwd -d 'Specify the current working directory for the initially spawned program' -r -f -a "(__fish_complete_directories)"
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from spawn" -l workspace -d 'When creating a new window, override the default workspace name with the provided name.  The default name is "default". Requires `--new-window`' -r
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from spawn" -l new-window -d 'Spawn into a new window, rather than a new tab'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from spawn" -s h -l help -d 'Print help information'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from send-text" -l pane-id -d 'Specify the target pane. The default is to use the current pane based on the environment variable WEZTERM_PANE' -r
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from send-text" -l no-paste -d 'Send the text directly, rather than as a bracketed paste'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from send-text" -s h -l help -d 'Print help information'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from activate-pane-direction" -s h -l help -d 'Print help information'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -f -a "list" -d 'list windows, tabs and panes'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -f -a "list-clients" -d 'list clients'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -f -a "proxy" -d 'start rpc proxy pipe'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -f -a "tlscreds" -d 'obtain tls credentials'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -f -a "move-pane-to-new-tab" -d 'Move a pane into a new tab'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -f -a "split-pane" -d 'split the current pane.
Outputs the pane-id for the newly created pane on success'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -f -a "spawn" -d 'Spawn a command into a new window or tab
Outputs the pane-id for the newly created pane on success'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -f -a "send-text" -d 'Send text to a pane as though it were pasted. If bracketed paste mode is enabled in the pane, then the text will be sent as a bracketed paste'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -f -a "activate-pane-direction" -d 'Activate an adjacent pane in the specified direction'
complete -c wezterm -n "__fish_seen_subcommand_from cli; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c wezterm -n "__fish_seen_subcommand_from imgcat" -l width -d 'Specify the display width; defaults to "auto" which automatically selects an appropriate size.  You may also use an integer value `N` to specify the number of cells, or `Npx` to specify the number of pixels, or `N%` to size relative to the terminal width' -r
complete -c wezterm -n "__fish_seen_subcommand_from imgcat" -l height -d 'Specify the display height; defaults to "auto" which automatically selects an appropriate size.  You may also use an integer value `N` to specify the number of cells, or `Npx` to specify the number of pixels, or `N%` to size relative to the terminal height' -r
complete -c wezterm -n "__fish_seen_subcommand_from imgcat" -l no-preserve-aspect-ratio -d 'Do not respect the aspect ratio.  The default is to respect the aspect ratio'
complete -c wezterm -n "__fish_seen_subcommand_from imgcat" -s h -l help -d 'Print help information'
complete -c wezterm -n "__fish_seen_subcommand_from set-working-directory" -s h -l help -d 'Print help information'
complete -c wezterm -n "__fish_seen_subcommand_from record" -s h -l help -d 'Print help information'
complete -c wezterm -n "__fish_seen_subcommand_from replay" -l explain -d 'Explain what is being sent/received'
complete -c wezterm -n "__fish_seen_subcommand_from replay" -s h -l help -d 'Print help information'
complete -c wezterm -n "__fish_seen_subcommand_from shell-completion" -l shell -d 'Which shell to generate for' -r -f -a "{bash	,elvish	,fish	,power-shell	,zsh	,fig	}"
complete -c wezterm -n "__fish_seen_subcommand_from shell-completion" -s h -l help -d 'Print help information'
complete -c wezterm -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from serial; and not __fish_seen_subcommand_from connect; and not __fish_seen_subcommand_from ls-fonts; and not __fish_seen_subcommand_from show-keys; and not __fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from imgcat; and not __fish_seen_subcommand_from set-working-directory; and not __fish_seen_subcommand_from record; and not __fish_seen_subcommand_from replay; and not __fish_seen_subcommand_from shell-completion; and not __fish_seen_subcommand_from help" -f -a "start" -d 'Start the GUI, optionally running an alternative program'
complete -c wezterm -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from serial; and not __fish_seen_subcommand_from connect; and not __fish_seen_subcommand_from ls-fonts; and not __fish_seen_subcommand_from show-keys; and not __fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from imgcat; and not __fish_seen_subcommand_from set-working-directory; and not __fish_seen_subcommand_from record; and not __fish_seen_subcommand_from replay; and not __fish_seen_subcommand_from shell-completion; and not __fish_seen_subcommand_from help" -f -a "ssh" -d 'Establish an ssh session'
complete -c wezterm -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from serial; and not __fish_seen_subcommand_from connect; and not __fish_seen_subcommand_from ls-fonts; and not __fish_seen_subcommand_from show-keys; and not __fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from imgcat; and not __fish_seen_subcommand_from set-working-directory; and not __fish_seen_subcommand_from record; and not __fish_seen_subcommand_from replay; and not __fish_seen_subcommand_from shell-completion; and not __fish_seen_subcommand_from help" -f -a "serial" -d 'Open a serial port'
complete -c wezterm -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from serial; and not __fish_seen_subcommand_from connect; and not __fish_seen_subcommand_from ls-fonts; and not __fish_seen_subcommand_from show-keys; and not __fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from imgcat; and not __fish_seen_subcommand_from set-working-directory; and not __fish_seen_subcommand_from record; and not __fish_seen_subcommand_from replay; and not __fish_seen_subcommand_from shell-completion; and not __fish_seen_subcommand_from help" -f -a "connect" -d 'Connect to wezterm multiplexer'
complete -c wezterm -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from serial; and not __fish_seen_subcommand_from connect; and not __fish_seen_subcommand_from ls-fonts; and not __fish_seen_subcommand_from show-keys; and not __fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from imgcat; and not __fish_seen_subcommand_from set-working-directory; and not __fish_seen_subcommand_from record; and not __fish_seen_subcommand_from replay; and not __fish_seen_subcommand_from shell-completion; and not __fish_seen_subcommand_from help" -f -a "ls-fonts" -d 'Display information about fonts'
complete -c wezterm -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from serial; and not __fish_seen_subcommand_from connect; and not __fish_seen_subcommand_from ls-fonts; and not __fish_seen_subcommand_from show-keys; and not __fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from imgcat; and not __fish_seen_subcommand_from set-working-directory; and not __fish_seen_subcommand_from record; and not __fish_seen_subcommand_from replay; and not __fish_seen_subcommand_from shell-completion; and not __fish_seen_subcommand_from help" -f -a "show-keys" -d 'Show key assignments'
complete -c wezterm -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from serial; and not __fish_seen_subcommand_from connect; and not __fish_seen_subcommand_from ls-fonts; and not __fish_seen_subcommand_from show-keys; and not __fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from imgcat; and not __fish_seen_subcommand_from set-working-directory; and not __fish_seen_subcommand_from record; and not __fish_seen_subcommand_from replay; and not __fish_seen_subcommand_from shell-completion; and not __fish_seen_subcommand_from help" -f -a "cli" -d 'Interact with experimental mux server'
complete -c wezterm -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from serial; and not __fish_seen_subcommand_from connect; and not __fish_seen_subcommand_from ls-fonts; and not __fish_seen_subcommand_from show-keys; and not __fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from imgcat; and not __fish_seen_subcommand_from set-working-directory; and not __fish_seen_subcommand_from record; and not __fish_seen_subcommand_from replay; and not __fish_seen_subcommand_from shell-completion; and not __fish_seen_subcommand_from help" -f -a "imgcat" -d 'Output an image to the terminal'
complete -c wezterm -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from serial; and not __fish_seen_subcommand_from connect; and not __fish_seen_subcommand_from ls-fonts; and not __fish_seen_subcommand_from show-keys; and not __fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from imgcat; and not __fish_seen_subcommand_from set-working-directory; and not __fish_seen_subcommand_from record; and not __fish_seen_subcommand_from replay; and not __fish_seen_subcommand_from shell-completion; and not __fish_seen_subcommand_from help" -f -a "set-working-directory" -d 'Advise the terminal of the current working directory by emitting an OSC 7 escape sequence'
complete -c wezterm -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from serial; and not __fish_seen_subcommand_from connect; and not __fish_seen_subcommand_from ls-fonts; and not __fish_seen_subcommand_from show-keys; and not __fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from imgcat; and not __fish_seen_subcommand_from set-working-directory; and not __fish_seen_subcommand_from record; and not __fish_seen_subcommand_from replay; and not __fish_seen_subcommand_from shell-completion; and not __fish_seen_subcommand_from help" -f -a "record" -d 'Record a terminal session as an asciicast'
complete -c wezterm -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from serial; and not __fish_seen_subcommand_from connect; and not __fish_seen_subcommand_from ls-fonts; and not __fish_seen_subcommand_from show-keys; and not __fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from imgcat; and not __fish_seen_subcommand_from set-working-directory; and not __fish_seen_subcommand_from record; and not __fish_seen_subcommand_from replay; and not __fish_seen_subcommand_from shell-completion; and not __fish_seen_subcommand_from help" -f -a "replay" -d 'Replay an asciicast terminal session'
complete -c wezterm -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from serial; and not __fish_seen_subcommand_from connect; and not __fish_seen_subcommand_from ls-fonts; and not __fish_seen_subcommand_from show-keys; and not __fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from imgcat; and not __fish_seen_subcommand_from set-working-directory; and not __fish_seen_subcommand_from record; and not __fish_seen_subcommand_from replay; and not __fish_seen_subcommand_from shell-completion; and not __fish_seen_subcommand_from help" -f -a "shell-completion" -d 'Generate shell completion information'
complete -c wezterm -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from serial; and not __fish_seen_subcommand_from connect; and not __fish_seen_subcommand_from ls-fonts; and not __fish_seen_subcommand_from show-keys; and not __fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from imgcat; and not __fish_seen_subcommand_from set-working-directory; and not __fish_seen_subcommand_from record; and not __fish_seen_subcommand_from replay; and not __fish_seen_subcommand_from shell-completion; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c wezterm -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction" -f -a "list" -d 'list windows, tabs and panes'
complete -c wezterm -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction" -f -a "list-clients" -d 'list clients'
complete -c wezterm -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction" -f -a "proxy" -d 'start rpc proxy pipe'
complete -c wezterm -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction" -f -a "tlscreds" -d 'obtain tls credentials'
complete -c wezterm -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction" -f -a "move-pane-to-new-tab" -d 'Move a pane into a new tab'
complete -c wezterm -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction" -f -a "split-pane" -d 'split the current pane.
Outputs the pane-id for the newly created pane on success'
complete -c wezterm -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction" -f -a "spawn" -d 'Spawn a command into a new window or tab
Outputs the pane-id for the newly created pane on success'
complete -c wezterm -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction" -f -a "send-text" -d 'Send text to a pane as though it were pasted. If bracketed paste mode is enabled in the pane, then the text will be sent as a bracketed paste'
complete -c wezterm -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from cli; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from proxy; and not __fish_seen_subcommand_from tlscreds; and not __fish_seen_subcommand_from move-pane-to-new-tab; and not __fish_seen_subcommand_from split-pane; and not __fish_seen_subcommand_from spawn; and not __fish_seen_subcommand_from send-text; and not __fish_seen_subcommand_from activate-pane-direction" -f -a "activate-pane-direction" -d 'Activate an adjacent pane in the specified direction'
