/* im-details.c generated by valac 0.56.3, the Vala compiler
 * generated from im-details.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include "folks/folks.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

enum  {
	FOLKS_IM_FIELD_DETAILS_0_PROPERTY,
	FOLKS_IM_FIELD_DETAILS_NUM_PROPERTIES
};
static GParamSpec* folks_im_field_details_properties[FOLKS_IM_FIELD_DETAILS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksImDetailsChangeImAddressesData FolksImDetailsChangeImAddressesData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

/**
 * Errors related to IM addresses and IM address handling.
 */
struct _FolksImDetailsChangeImAddressesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksImDetails* self;
	GeeMultiMap* im_addresses;
	GError* _tmp0_;
	GError* _inner_error0_;
};

static gpointer folks_im_field_details_parent_class = NULL;

static gboolean folks_im_field_details_real_equal (FolksAbstractFieldDetails* base,
                                            FolksAbstractFieldDetails* that);
static guint folks_im_field_details_real_hash (FolksAbstractFieldDetails* base);
static GType folks_im_field_details_get_type_once (void);
static void folks_im_details_real_change_im_addresses_data_free (gpointer _data);
static void folks_im_details_real_change_im_addresses (FolksImDetails* self,
                                                GeeMultiMap* im_addresses,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static gboolean folks_im_details_real_change_im_addresses_co (FolksImDetailsChangeImAddressesData* _data_);
static GType folks_im_details_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

GQuark
folks_im_details_error_quark (void)
{
	return g_quark_from_static_string ("folks-im-details-error-quark");
}

static GType
folks_im_details_error_get_type_once (void)
{
	static const GEnumValue values[] = {{FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS, "FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS", "invalid-im-address"}, {0, NULL, NULL}};
	GType folks_im_details_error_type_id;
	folks_im_details_error_type_id = g_enum_register_static ("FolksImDetailsError", values);
	return folks_im_details_error_type_id;
}

GType
folks_im_details_error_get_type (void)
{
	static volatile gsize folks_im_details_error_type_id__once = 0;
	if (g_once_init_enter (&folks_im_details_error_type_id__once)) {
		GType folks_im_details_error_type_id;
		folks_im_details_error_type_id = folks_im_details_error_get_type_once ();
		g_once_init_leave (&folks_im_details_error_type_id__once, folks_im_details_error_type_id);
	}
	return folks_im_details_error_type_id__once;
}

/**
   * Create a new ImFieldDetails.
   *
   * @param value the value of the field, which should be a valid, non-empty
   * IM address
   * @param parameters initial parameters. See
   * {@link AbstractFieldDetails.parameters}. A ``null`` value is equivalent to
   * an empty map of parameters.
   *
   * @return a new ImFieldDetails
   *
   * @since 0.6.0
   */
FolksImFieldDetails*
folks_im_field_details_construct (GType object_type,
                                  const gchar* value,
                                  GeeMultiMap* parameters)
{
	FolksImFieldDetails * self = NULL;
	g_return_val_if_fail (value != NULL, NULL);
	self = (FolksImFieldDetails*) folks_abstract_field_details_construct (object_type, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free);
	if (g_strcmp0 (value, "") == 0) {
		g_warning ("im-details.vala:64: Empty IM address passed to ImFieldDetails.");
	}
	folks_abstract_field_details_set_value ((FolksAbstractFieldDetails*) self, value);
	if (parameters != NULL) {
		folks_abstract_field_details_set_parameters ((FolksAbstractFieldDetails*) self, G_TYPE_CHECK_INSTANCE_CAST (parameters, GEE_TYPE_MULTI_MAP, GeeMultiMap));
	}
	return self;
}

FolksImFieldDetails*
folks_im_field_details_new (const gchar* value,
                            GeeMultiMap* parameters)
{
	return folks_im_field_details_construct (FOLKS_TYPE_IM_FIELD_DETAILS, value, parameters);
}

/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static gboolean
folks_im_field_details_real_equal (FolksAbstractFieldDetails* base,
                                   FolksAbstractFieldDetails* that)
{
	FolksImFieldDetails * self;
	gboolean result;
	self = (FolksImFieldDetails*) base;
	g_return_val_if_fail (that != NULL, FALSE);
	result = FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (folks_im_field_details_parent_class)->equal (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails), that);
	return result;
}

/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static guint
folks_im_field_details_real_hash (FolksAbstractFieldDetails* base)
{
	FolksImFieldDetails * self;
	guint result;
	self = (FolksImFieldDetails*) base;
	result = FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (folks_im_field_details_parent_class)->hash (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails));
	return result;
}

static void
folks_im_field_details_class_init (FolksImFieldDetailsClass * klass,
                                   gpointer klass_data)
{
	folks_im_field_details_parent_class = g_type_class_peek_parent (klass);
	((FolksAbstractFieldDetailsClass *) klass)->equal = (gboolean (*) (FolksAbstractFieldDetails*, FolksAbstractFieldDetails*)) folks_im_field_details_real_equal;
	((FolksAbstractFieldDetailsClass *) klass)->hash = (guint (*) (FolksAbstractFieldDetails*)) folks_im_field_details_real_hash;
}

static void
folks_im_field_details_instance_init (FolksImFieldDetails * self,
                                      gpointer klass)
{
}

/**
 * Object representing an IM address value that can have some parameters
 * associated with it.
 *
 * See {@link Folks.AbstractFieldDetails}.
 *
 * @since 0.6.0
 */
static GType
folks_im_field_details_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksImFieldDetailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_im_field_details_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksImFieldDetails), 0, (GInstanceInitFunc) folks_im_field_details_instance_init, NULL };
	GType folks_im_field_details_type_id;
	folks_im_field_details_type_id = g_type_register_static (FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, "FolksImFieldDetails", &g_define_type_info, 0);
	return folks_im_field_details_type_id;
}

GType
folks_im_field_details_get_type (void)
{
	static volatile gsize folks_im_field_details_type_id__once = 0;
	if (g_once_init_enter (&folks_im_field_details_type_id__once)) {
		GType folks_im_field_details_type_id;
		folks_im_field_details_type_id = folks_im_field_details_get_type_once ();
		g_once_init_leave (&folks_im_field_details_type_id__once, folks_im_field_details_type_id);
	}
	return folks_im_field_details_type_id__once;
}

static void
folks_im_details_real_change_im_addresses_data_free (gpointer _data)
{
	FolksImDetailsChangeImAddressesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->im_addresses);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksImDetailsChangeImAddressesData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
folks_im_details_real_change_im_addresses (FolksImDetails* self,
                                           GeeMultiMap* im_addresses,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	FolksImDetailsChangeImAddressesData* _data_;
	FolksImDetails* _tmp0_;
	GeeMultiMap* _tmp1_;
	g_return_if_fail (im_addresses != NULL);
	_data_ = g_slice_new0 (FolksImDetailsChangeImAddressesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_im_details_real_change_im_addresses_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (im_addresses);
	_g_object_unref0 (_data_->im_addresses);
	_data_->im_addresses = _tmp1_;
	folks_im_details_real_change_im_addresses_co (_data_);
}

static void
folks_im_details_real_change_im_addresses_finish (FolksImDetails* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	FolksImDetailsChangeImAddressesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Change the contact's set of IM addresses.
   *
   * It's preferred to call this rather than setting
   * {@link ImDetails.im_addresses} directly, as this method gives error
   * notification and will only return once the IM addresses have been written
   * to the relevant backing store (or the operation's failed).
   *
   * @param im_addresses the new map of protocols to IM addresses
   * @throws PropertyError if setting the IM addresses failed
   * @since 0.6.2
   */
static gboolean
folks_im_details_real_change_im_addresses_co (FolksImDetailsChangeImAddressesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _ ("IM addresses are not writeable on this contact."));
	_data_->_inner_error0_ = _data_->_tmp0_;
	if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
folks_im_details_change_im_addresses (FolksImDetails* self,
                                      GeeMultiMap* im_addresses,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	FolksImDetailsIface* _iface_;
	_iface_ = FOLKS_IM_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_im_addresses) {
		_iface_->change_im_addresses (self, im_addresses, _callback_, _user_data_);
	}
}

void
folks_im_details_change_im_addresses_finish (FolksImDetails* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	FolksImDetailsIface* _iface_;
	_iface_ = FOLKS_IM_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_im_addresses_finish) {
		_iface_->change_im_addresses_finish (self, _res_, error);
	}
}

/**
   * Normalise an IM address so that it's suitable for string comparison.
   *
   * IM addresses for various protocols can be represented in different ways,
   * only one of which is canonical. In order to allow simple string comparisons
   * of IM addresses to work, the IM addresses must be normalised beforehand.
   *
   * If the provided IM address is invalid,
   * {@link Folks.ImDetailsError.INVALID_IM_ADDRESS} will be thrown. Note that
   * this isn't guaranteed to be thrown for all invalid addresses, but if it is
   * thrown, the address is guaranteed to be invalid.
   *
   * @param im_address the address to normalise
   * @param protocol the protocol of this im_address
   *
   * @since 0.2.0
   * @throws Folks.ImDetailsError if the provided IM address was invalid
   */
static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
folks_im_details_normalise_im_address (const gchar* im_address,
                                       const gchar* protocol,
                                       GError** error)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (im_address != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	if (g_strcmp0 (protocol, "aim") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (protocol, "myspace") == 0;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp1_ = string_replace (im_address, " ", "");
		_tmp2_ = _tmp1_;
		_tmp3_ = g_utf8_strdown (_tmp2_, (gssize) -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_utf8_normalize (_tmp4_, (gssize) -1, G_NORMALIZE_DEFAULT);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		result = _tmp6_;
		return result;
	} else {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		if (g_strcmp0 (protocol, "irc") == 0) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = g_strcmp0 (protocol, "yahoo") == 0;
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = g_strcmp0 (protocol, "yahoojp") == 0;
		}
		if (_tmp8_) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = g_strcmp0 (protocol, "groupwise") == 0;
		}
		if (_tmp7_) {
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp10_ = g_utf8_strdown (im_address, (gssize) -1);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_utf8_normalize (_tmp11_, (gssize) -1, G_NORMALIZE_DEFAULT);
			_tmp13_ = _tmp12_;
			_g_free0 (_tmp11_);
			result = _tmp13_;
			return result;
		} else {
			if (g_strcmp0 (protocol, "jabber") == 0) {
				gchar** parts = NULL;
				gchar** _tmp14_;
				gchar** _tmp15_;
				gint parts_length1;
				gint _parts_size_;
				gchar** _tmp16_;
				gint _tmp16__length1;
				gchar* resource = NULL;
				gchar** _tmp18_;
				gint _tmp18__length1;
				gchar** _tmp22_;
				gint _tmp22__length1;
				const gchar* _tmp23_;
				gchar** _tmp24_;
				gchar** _tmp25_;
				gchar** _tmp26_;
				gint _tmp26__length1;
				gchar* node = NULL;
				gchar* _domain = NULL;
				gchar** _tmp28_;
				gint _tmp28__length1;
				gboolean _tmp38_ = FALSE;
				gboolean _tmp39_ = FALSE;
				gboolean _tmp40_ = FALSE;
				const gchar* _tmp41_;
				gchar* domain = NULL;
				const gchar* _tmp50_;
				gchar* _tmp51_;
				const gchar* _tmp52_;
				gchar* normalised = NULL;
				gboolean _tmp55_ = FALSE;
				const gchar* _tmp56_;
				const gchar* _tmp71_;
				gchar* _tmp72_;
				_tmp15_ = _tmp14_ = g_strsplit (im_address, "/", 2);
				parts = _tmp15_;
				parts_length1 = _vala_array_length (_tmp14_);
				_parts_size_ = parts_length1;
				_tmp16_ = parts;
				_tmp16__length1 = parts_length1;
				if (_tmp16__length1 < 1) {
					GError* _tmp17_;
					_tmp17_ = g_error_new (FOLKS_IM_DETAILS_ERROR, FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS, _ ("The IM address ‘%s’ could not be understood."), im_address);
					_inner_error0_ = _tmp17_;
					if (_inner_error0_->domain == FOLKS_IM_DETAILS_ERROR) {
						g_propagate_error (error, _inner_error0_);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						return NULL;
					} else {
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				resource = NULL;
				_tmp18_ = parts;
				_tmp18__length1 = parts_length1;
				if (_tmp18__length1 == 2) {
					gchar** _tmp19_;
					gint _tmp19__length1;
					const gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp19_ = parts;
					_tmp19__length1 = parts_length1;
					_tmp20_ = _tmp19_[1];
					_tmp21_ = g_strdup (_tmp20_);
					_g_free0 (resource);
					resource = _tmp21_;
				}
				_tmp22_ = parts;
				_tmp22__length1 = parts_length1;
				_tmp23_ = _tmp22_[0];
				_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, "@", 2);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				parts = _tmp25_;
				parts_length1 = _vala_array_length (_tmp24_);
				_parts_size_ = parts_length1;
				_tmp26_ = parts;
				_tmp26__length1 = parts_length1;
				if (_tmp26__length1 < 1) {
					GError* _tmp27_;
					_tmp27_ = g_error_new (FOLKS_IM_DETAILS_ERROR, FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS, _ ("The IM address ‘%s’ could not be understood."), im_address);
					_inner_error0_ = _tmp27_;
					if (_inner_error0_->domain == FOLKS_IM_DETAILS_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (resource);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						return NULL;
					} else {
						_g_free0 (resource);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp28_ = parts;
				_tmp28__length1 = parts_length1;
				if (_tmp28__length1 == 2) {
					gchar** _tmp29_;
					gint _tmp29__length1;
					const gchar* _tmp30_;
					gchar* _tmp31_;
					gchar** _tmp32_;
					gint _tmp32__length1;
					const gchar* _tmp33_;
					gchar* _tmp34_;
					_tmp29_ = parts;
					_tmp29__length1 = parts_length1;
					_tmp30_ = _tmp29_[0];
					_tmp31_ = g_strdup (_tmp30_);
					_g_free0 (node);
					node = _tmp31_;
					_tmp32_ = parts;
					_tmp32__length1 = parts_length1;
					_tmp33_ = _tmp32_[1];
					_tmp34_ = g_strdup (_tmp33_);
					_g_free0 (_domain);
					_domain = _tmp34_;
				} else {
					gchar** _tmp35_;
					gint _tmp35__length1;
					const gchar* _tmp36_;
					gchar* _tmp37_;
					_g_free0 (node);
					node = NULL;
					_tmp35_ = parts;
					_tmp35__length1 = parts_length1;
					_tmp36_ = _tmp35_[0];
					_tmp37_ = g_strdup (_tmp36_);
					_g_free0 (_domain);
					_domain = _tmp37_;
				}
				_tmp41_ = node;
				if (_tmp41_ != NULL) {
					const gchar* _tmp42_;
					_tmp42_ = node;
					_tmp40_ = g_strcmp0 (_tmp42_, "") == 0;
				} else {
					_tmp40_ = FALSE;
				}
				if (_tmp40_) {
					_tmp39_ = TRUE;
				} else {
					gboolean _tmp43_ = FALSE;
					const gchar* _tmp44_;
					_tmp44_ = _domain;
					if (_tmp44_ == NULL) {
						_tmp43_ = TRUE;
					} else {
						const gchar* _tmp45_;
						_tmp45_ = _domain;
						_tmp43_ = g_strcmp0 (_tmp45_, "") == 0;
					}
					_tmp39_ = _tmp43_;
				}
				if (_tmp39_) {
					_tmp38_ = TRUE;
				} else {
					gboolean _tmp46_ = FALSE;
					const gchar* _tmp47_;
					_tmp47_ = resource;
					if (_tmp47_ != NULL) {
						const gchar* _tmp48_;
						_tmp48_ = resource;
						_tmp46_ = g_strcmp0 (_tmp48_, "") == 0;
					} else {
						_tmp46_ = FALSE;
					}
					_tmp38_ = _tmp46_;
				}
				if (_tmp38_) {
					GError* _tmp49_;
					_tmp49_ = g_error_new (FOLKS_IM_DETAILS_ERROR, FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS, _ ("The IM address ‘%s’ could not be understood."), im_address);
					_inner_error0_ = _tmp49_;
					if (_inner_error0_->domain == FOLKS_IM_DETAILS_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (_domain);
						_g_free0 (node);
						_g_free0 (resource);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						return NULL;
					} else {
						_g_free0 (_domain);
						_g_free0 (node);
						_g_free0 (resource);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp50_ = _domain;
				_tmp51_ = g_utf8_strdown ((const gchar*) _tmp50_, (gssize) -1);
				domain = _tmp51_;
				_tmp52_ = node;
				if (_tmp52_ != NULL) {
					const gchar* _tmp53_;
					gchar* _tmp54_;
					_tmp53_ = node;
					_tmp54_ = g_utf8_strdown ((const gchar*) _tmp53_, (gssize) -1);
					_g_free0 (node);
					node = _tmp54_;
				}
				normalised = NULL;
				_tmp56_ = node;
				if (_tmp56_ != NULL) {
					const gchar* _tmp57_;
					_tmp57_ = resource;
					_tmp55_ = _tmp57_ != NULL;
				} else {
					_tmp55_ = FALSE;
				}
				if (_tmp55_) {
					const gchar* _tmp58_;
					const gchar* _tmp59_;
					const gchar* _tmp60_;
					gchar* _tmp61_;
					_tmp58_ = node;
					_tmp59_ = domain;
					_tmp60_ = resource;
					_tmp61_ = g_strdup_printf ("%s@%s/%s", (const gchar*) _tmp58_, _tmp59_, (const gchar*) _tmp60_);
					_g_free0 (normalised);
					normalised = _tmp61_;
				} else {
					const gchar* _tmp62_;
					_tmp62_ = node;
					if (_tmp62_ != NULL) {
						const gchar* _tmp63_;
						const gchar* _tmp64_;
						gchar* _tmp65_;
						_tmp63_ = node;
						_tmp64_ = domain;
						_tmp65_ = g_strdup_printf ("%s@%s", (const gchar*) _tmp63_, _tmp64_);
						_g_free0 (normalised);
						normalised = _tmp65_;
					} else {
						const gchar* _tmp66_;
						_tmp66_ = resource;
						if (_tmp66_ != NULL) {
							const gchar* _tmp67_;
							const gchar* _tmp68_;
							gchar* _tmp69_;
							_tmp67_ = domain;
							_tmp68_ = resource;
							_tmp69_ = g_strdup_printf ("%s/%s", _tmp67_, (const gchar*) _tmp68_);
							_g_free0 (normalised);
							normalised = _tmp69_;
						} else {
							GError* _tmp70_;
							_tmp70_ = g_error_new (FOLKS_IM_DETAILS_ERROR, FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS, _ ("The IM address ‘%s’ could not be understood."), im_address);
							_inner_error0_ = _tmp70_;
							if (_inner_error0_->domain == FOLKS_IM_DETAILS_ERROR) {
								g_propagate_error (error, _inner_error0_);
								_g_free0 (normalised);
								_g_free0 (domain);
								_g_free0 (_domain);
								_g_free0 (node);
								_g_free0 (resource);
								parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
								return NULL;
							} else {
								_g_free0 (normalised);
								_g_free0 (domain);
								_g_free0 (_domain);
								_g_free0 (node);
								_g_free0 (resource);
								parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
						}
					}
				}
				_tmp71_ = normalised;
				_tmp72_ = g_utf8_normalize ((const gchar*) _tmp71_, (gssize) -1, G_NORMALIZE_NFKC);
				result = _tmp72_;
				_g_free0 (normalised);
				_g_free0 (domain);
				_g_free0 (_domain);
				_g_free0 (node);
				_g_free0 (resource);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				return result;
			} else {
				gchar* _tmp73_;
				_tmp73_ = g_utf8_normalize (im_address, (gssize) -1, G_NORMALIZE_DEFAULT);
				result = _tmp73_;
				return result;
			}
		}
	}
}

GeeMultiMap*
folks_im_details_get_im_addresses (FolksImDetails* self)
{
	FolksImDetailsIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = FOLKS_IM_DETAILS_GET_INTERFACE (self);
	if (_iface_->get_im_addresses) {
		return _iface_->get_im_addresses (self);
	}
	return NULL;
}

void
folks_im_details_set_im_addresses (FolksImDetails* self,
                                   GeeMultiMap* value)
{
	FolksImDetailsIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = FOLKS_IM_DETAILS_GET_INTERFACE (self);
	if (_iface_->set_im_addresses) {
		_iface_->set_im_addresses (self, value);
	}
}

static void
folks_im_details_default_init (FolksImDetailsIface * iface,
                               gpointer iface_data)
{
	/**
	   * A mapping of IM protocol to an (unordered) set of IM addresses.
	   *
	   * Each mapping is from an arbitrary protocol identifier to a set of IM
	   * addresses on that protocol for the contact, listed in no particular order.
	   *
	   * There must be no duplicate IM addresses in each set, though a given
	   * IM address may be present in the sets for different protocols.
	   *
	   * All the IM addresses must be normalised using
	   * {@link ImDetails.normalise_im_address} before being added to this property.
	   *
	   * @since 0.5.1
	   */
	g_object_interface_install_property (iface, g_param_spec_object ("im-addresses", "im-addresses", "im-addresses", GEE_TYPE_MULTI_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	iface->change_im_addresses = folks_im_details_real_change_im_addresses;
	iface->change_im_addresses_finish = folks_im_details_real_change_im_addresses_finish;
}

/**
 * IM addresses exposed by an object implementing {@link PresenceDetails}.
 *
 * @since 0.1.13
 */
static GType
folks_im_details_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksImDetailsIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_im_details_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType folks_im_details_type_id;
	folks_im_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksImDetails", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (folks_im_details_type_id, G_TYPE_OBJECT);
	return folks_im_details_type_id;
}

GType
folks_im_details_get_type (void)
{
	static volatile gsize folks_im_details_type_id__once = 0;
	if (g_once_init_enter (&folks_im_details_type_id__once)) {
		GType folks_im_details_type_id;
		folks_im_details_type_id = folks_im_details_get_type_once ();
		g_once_init_leave (&folks_im_details_type_id__once, folks_im_details_type_id);
	}
	return folks_im_details_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

