/* sudoku-view.c generated by valac 0.56.3, the Vala compiler
 * generated from sudoku-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include "libsudoku.h"
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SUDOKU_CELL_VIEW (sudoku_cell_view_get_type ())
#define SUDOKU_CELL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_CELL_VIEW, SudokuCellView))
#define SUDOKU_CELL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewClass))
#define IS_SUDOKU_CELL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_CELL_VIEW))
#define IS_SUDOKU_CELL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_CELL_VIEW))
#define SUDOKU_CELL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewClass))

typedef struct _SudokuCellView SudokuCellView;
typedef struct _SudokuCellViewClass SudokuCellViewClass;
typedef struct _SudokuCellViewPrivate SudokuCellViewPrivate;

#define TYPE_NUMBER_PICKER (number_picker_get_type ())
#define NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER_PICKER, NumberPicker))
#define NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER_PICKER, NumberPickerClass))
#define IS_NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER_PICKER))
#define IS_NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER_PICKER))
#define NUMBER_PICKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER_PICKER, NumberPickerClass))

typedef struct _NumberPicker NumberPicker;
typedef struct _NumberPickerClass NumberPickerClass;
enum  {
	SUDOKU_CELL_VIEW_0_PROPERTY,
	SUDOKU_CELL_VIEW_VALUE_PROPERTY,
	SUDOKU_CELL_VIEW_IS_FIXED_PROPERTY,
	SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES_PROPERTY,
	SUDOKU_CELL_VIEW_INITIALIZE_EARMARKS_PROPERTY,
	SUDOKU_CELL_VIEW_SHOW_WARNINGS_PROPERTY,
	SUDOKU_CELL_VIEW_SELECTED_PROPERTY,
	SUDOKU_CELL_VIEW_HIGHLIGHTED_BACKGROUND_PROPERTY,
	SUDOKU_CELL_VIEW_HIGHLIGHTED_VALUE_PROPERTY,
	SUDOKU_CELL_VIEW_NUM_PROPERTIES
};
static GParamSpec* sudoku_cell_view_properties[SUDOKU_CELL_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
typedef struct _SudokuViewPrivate SudokuViewPrivate;
enum  {
	SUDOKU_VIEW_0_PROPERTY,
	SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY,
	SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY,
	SUDOKU_VIEW_INITIALIZE_EARMARKS_PROPERTY,
	SUDOKU_VIEW_HIGHLIGHTER_PROPERTY,
	SUDOKU_VIEW_NUM_PROPERTIES
};
static GParamSpec* sudoku_view_properties[SUDOKU_VIEW_NUM_PROPERTIES];
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;

struct _SudokuCellView {
	GtkDrawingArea parent_instance;
	SudokuCellViewPrivate * priv;
};

struct _SudokuCellViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _SudokuCellViewPrivate {
	gdouble size_ratio;
	GtkPopover* popover;
	GtkPopover* earmark_popover;
	SudokuGame* game;
	gint row;
	gint col;
	gboolean initialized_earmarks;
	gboolean left_control;
	gboolean right_control;
	gboolean _show_possibilities;
	gboolean _initialize_earmarks;
	gboolean _show_warnings;
	gboolean _selected;
	gboolean _highlighted_background;
	gboolean _highlighted_value;
	NumberPicker* number_picker;
	NumberPicker* earmark_picker;
	GtkEventControllerKey* key_controller;
};

struct _SudokuView {
	GtkAspectFrame parent_instance;
	SudokuViewPrivate * priv;
	SudokuGame* game;
};

struct _SudokuViewClass {
	GtkAspectFrameClass parent_class;
};

struct _SudokuViewPrivate {
	SudokuCellView** cells;
	gint cells_length1;
	gint cells_length2;
	gboolean previous_board_broken_state;
	GtkOverlay* overlay;
	GtkDrawingArea* drawing;
	GtkGrid* grid;
	gint selected_row;
	gint selected_col;
	gboolean _show_warnings;
	gboolean _show_possibilities;
	gboolean _initialize_earmarks;
	gboolean _highlighter;
};

struct _Block9Data {
	int _ref_count_;
	SudokuView* self;
	SudokuGame* game;
};

struct _Block10Data {
	int _ref_count_;
	Block9Data * _data9_;
	gint cell_row;
	gint cell_col;
};

static gint SudokuCellView_private_offset;
static gpointer sudoku_cell_view_parent_class = NULL;
static gint SudokuView_private_offset;
static gpointer sudoku_view_parent_class = NULL;

VALA_EXTERN GType sudoku_cell_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuCellView, g_object_unref)
VALA_EXTERN GType number_picker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NumberPicker, g_object_unref)
VALA_EXTERN SudokuCellView* sudoku_cell_view_new (gint row,
                                      gint col,
                                      SudokuGame** game);
VALA_EXTERN SudokuCellView* sudoku_cell_view_construct (GType object_type,
                                            gint row,
                                            gint col,
                                            SudokuGame** game);
static inline void sudoku_cell_view_init_keyboard (SudokuCellView* self);
VALA_EXTERN void sudoku_cell_view_set_value (SudokuCellView* self,
                                 gint value);
VALA_EXTERN gboolean sudoku_cell_view_get_is_fixed (SudokuCellView* self);
static gboolean sudoku_cell_view_focus_out_cb (SudokuCellView* self,
                                        GtkWidget* widget,
                                        GdkEventFocus* event);
static gboolean _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                    GdkEventFocus* event,
                                                                    gpointer self);
VALA_EXTERN void sudoku_cell_view_cell_changed_cb (SudokuCellView* self,
                                       gint row,
                                       gint col,
                                       gint old_val,
                                       gint new_val);
static void _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed (SudokuGame* _sender,
                                                                 gint row,
                                                                 gint col,
                                                                 gint old_val,
                                                                 gint new_val,
                                                                 gpointer self);
static gboolean sudoku_cell_view_real_button_press_event (GtkWidget* base,
                                                   GdkEventButton* event);
VALA_EXTERN void sudoku_cell_view_hide_both_popovers (SudokuCellView* self);
static void sudoku_cell_view_show_earmark_picker (SudokuCellView* self);
static void sudoku_cell_view_show_number_picker (SudokuCellView* self);
static void sudoku_cell_view_create_earmark_picker (SudokuCellView* self);
VALA_EXTERN NumberPicker* number_picker_new (SudokuBoard** board,
                                 gboolean earmark);
VALA_EXTERN NumberPicker* number_picker_construct (GType object_type,
                                       SudokuBoard** board,
                                       gboolean earmark);
static void __lambda10_ (SudokuCellView* self,
                  gint number,
                  gboolean state);
VALA_EXTERN gint sudoku_cell_view_get_value (SudokuCellView* self);
static void ___lambda10__number_picker_earmark_state_changed (NumberPicker* _sender,
                                                       gint number,
                                                       gboolean active,
                                                       gpointer self);
VALA_EXTERN void number_picker_set_earmarks (NumberPicker* self,
                                 gint row,
                                 gint col);
static void __lambda7_ (SudokuCellView* self,
                 NumberPicker* o,
                 gint number);
static void ___lambda7__number_picker_number_picked (NumberPicker* _sender,
                                              gint number,
                                              gpointer self);
VALA_EXTERN void number_picker_set_clear_button_visibility (NumberPicker* self,
                                                gboolean visible);
static void __lambda8_ (SudokuCellView* self);
static void sudoku_cell_view_destroy_popover (SudokuCellView* self,
                                       GtkPopover** popover,
                                       NumberPicker** picker);
static void ___lambda8__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static gboolean __lambda9_ (SudokuCellView* self);
static gboolean ___lambda9__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                 GdkEventFocus* event,
                                                 gpointer self);
static void __lambda11_ (SudokuCellView* self);
static void ___lambda11__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static gboolean __lambda12_ (SudokuCellView* self);
static gboolean ___lambda12__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                  GdkEventFocus* event,
                                                  gpointer self);
static gboolean sudoku_cell_view_warn_incorrect_solution (SudokuCellView* self);
static gint sudoku_cell_view_key_map_keypad (SudokuCellView* self,
                                      const gchar* key_name);
static inline gboolean sudoku_cell_view_on_key_pressed (SudokuCellView* self,
                                          GtkEventControllerKey* _key_controller,
                                          guint keyval,
                                          guint keycode,
                                          GdkModifierType state);
static gboolean _sudoku_cell_view_on_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                guint keyval,
                                                                                guint keycode,
                                                                                GdkModifierType state,
                                                                                gpointer self);
static inline void sudoku_cell_view_on_key_release (SudokuCellView* self,
                                      GtkEventControllerKey* _key_controller,
                                      guint keyval,
                                      guint keycode,
                                      GdkModifierType state);
static void _sudoku_cell_view_on_key_release_gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                             guint keyval,
                                                                             guint keycode,
                                                                             GdkModifierType state,
                                                                             gpointer self);
VALA_EXTERN void number_picker_set_earmark (NumberPicker* self,
                                gint row,
                                gint col,
                                gint index,
                                gboolean state);
static gboolean sudoku_cell_view_real_draw (GtkWidget* base,
                                     cairo_t* c);
static void sudoku_cell_view_print_centered (SudokuCellView* self,
                                      cairo_t* c,
                                      const gchar* text,
                                      gdouble width,
                                      gdouble height);
VALA_EXTERN void sudoku_cell_view_clear (SudokuCellView* self);
VALA_EXTERN gboolean sudoku_cell_view_get_show_possibilities (SudokuCellView* self);
VALA_EXTERN void sudoku_cell_view_set_show_possibilities (SudokuCellView* self,
                                              gboolean value);
VALA_EXTERN gboolean sudoku_cell_view_get_initialize_earmarks (SudokuCellView* self);
VALA_EXTERN void sudoku_cell_view_set_initialize_earmarks (SudokuCellView* self,
                                               gboolean value);
VALA_EXTERN gboolean sudoku_cell_view_get_show_warnings (SudokuCellView* self);
VALA_EXTERN void sudoku_cell_view_set_show_warnings (SudokuCellView* self,
                                         gboolean value);
VALA_EXTERN gboolean sudoku_cell_view_get_selected (SudokuCellView* self);
VALA_EXTERN void sudoku_cell_view_set_selected (SudokuCellView* self,
                                    gboolean value);
VALA_EXTERN gboolean sudoku_cell_view_get_highlighted_background (SudokuCellView* self);
VALA_EXTERN void sudoku_cell_view_set_highlighted_background (SudokuCellView* self,
                                                  gboolean value);
VALA_EXTERN gboolean sudoku_cell_view_get_highlighted_value (SudokuCellView* self);
VALA_EXTERN void sudoku_cell_view_set_highlighted_value (SudokuCellView* self,
                                             gboolean value);
static void sudoku_cell_view_finalize (GObject * obj);
static GType sudoku_cell_view_get_type_once (void);
static void _vala_sudoku_cell_view_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_sudoku_cell_view_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
VALA_EXTERN GType sudoku_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuView, g_object_unref)
static void sudoku_view_set_selected (SudokuView* self,
                               gint cell_row,
                               gint cell_col);
VALA_EXTERN SudokuView* sudoku_view_new (SudokuGame* game);
VALA_EXTERN SudokuView* sudoku_view_construct (GType object_type,
                                   SudokuGame* game);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static gboolean sudoku_view_draw_board (SudokuView* self,
                                 cairo_t* c);
static gboolean _sudoku_view_draw_board_gtk_widget_draw (GtkWidget* _sender,
                                                  cairo_t* cr,
                                                  gpointer self);
static void __lambda13_ (SudokuView* self);
static void ___lambda13__sudoku_game_paused_changed (SudokuGame* _sender,
                                              gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static gboolean ________lambda14_ (Block10Data* _data10_);
static void sudoku_view_update_highlights (SudokuView* self);
static gboolean _________lambda14__gtk_widget_focus_in_event (GtkWidget* _sender,
                                                       GdkEventFocus* event,
                                                       gpointer self);
static gboolean ________lambda15_ (Block10Data* _data10_);
static gboolean _________lambda15__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                        GdkEventFocus* event,
                                                        gpointer self);
static void ________lambda16_ (Block10Data* _data10_,
                        GObject* s,
                        GParamSpec* p);
static void _________lambda16__g_object_notify (GObject* _sender,
                                         GParamSpec* pspec,
                                         gpointer self);
VALA_EXTERN void sudoku_view_clear (SudokuView* self);
VALA_EXTERN void sudoku_view_hide_popovers (SudokuView* self);
VALA_EXTERN gboolean sudoku_view_get_show_warnings (SudokuView* self);
VALA_EXTERN void sudoku_view_set_show_warnings (SudokuView* self,
                                    gboolean value);
VALA_EXTERN gboolean sudoku_view_get_show_possibilities (SudokuView* self);
VALA_EXTERN void sudoku_view_set_show_possibilities (SudokuView* self,
                                         gboolean value);
VALA_EXTERN gboolean sudoku_view_get_initialize_earmarks (SudokuView* self);
VALA_EXTERN void sudoku_view_set_initialize_earmarks (SudokuView* self,
                                          gboolean value);
VALA_EXTERN gboolean sudoku_view_get_highlighter (SudokuView* self);
VALA_EXTERN void sudoku_view_set_highlighter (SudokuView* self,
                                  gboolean value);
static void sudoku_view_finalize (GObject * obj);
static GType sudoku_view_get_type_once (void);
static void _vala_sudoku_view_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_sudoku_view_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

const GdkRGBA selected_bg_color = {0.7, 0.8, 0.9, 1.0};
const GdkRGBA fixed_cell_color = {0.8, 0.8, 0.8, 1.0};
const GdkRGBA highlight_color = {0.93, 0.93, 0.93, 1.0};
const GdkRGBA free_cell_color = {1.0, 1.0, 1.0, 1.0};

static inline gpointer
sudoku_cell_view_get_instance_private (SudokuCellView* self)
{
	return G_STRUCT_MEMBER_P (self, SudokuCellView_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                           GdkEventFocus* event,
                                                           gpointer self)
{
	gboolean result;
	result = sudoku_cell_view_focus_out_cb ((SudokuCellView*) self, _sender, event);
	return result;
}

static void
_sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed (SudokuGame* _sender,
                                                            gint row,
                                                            gint col,
                                                            gint old_val,
                                                            gint new_val,
                                                            gpointer self)
{
	sudoku_cell_view_cell_changed_cb ((SudokuCellView*) self, row, col, old_val, new_val);
}

SudokuCellView*
sudoku_cell_view_construct (GType object_type,
                            gint row,
                            gint col,
                            SudokuGame** game)
{
	SudokuCellView * self = NULL;
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (*game != NULL, NULL);
	self = (SudokuCellView*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (*game);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp0_;
	self->priv->row = row;
	self->priv->col = col;
	sudoku_cell_view_init_keyboard (self);
	_tmp1_ = (*game)->board;
	sudoku_cell_view_set_value (self, sudoku_board_get (_tmp1_, row, col));
	gtk_widget_set_can_focus ((GtkWidget*) self, TRUE);
	gtk_widget_set_events ((GtkWidget*) self, ((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_KEY_PRESS_MASK);
	_tmp3_ = sudoku_cell_view_get_is_fixed (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp2_ = (*game)->mode == GAME_MODE_PLAY;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		return self;
	}
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event, self, 0);
	g_signal_connect_object (*game, "cell-changed", (GCallback) _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed, self, 0);
	return self;
}

SudokuCellView*
sudoku_cell_view_new (gint row,
                      gint col,
                      SudokuGame** game)
{
	return sudoku_cell_view_construct (TYPE_SUDOKU_CELL_VIEW, row, col, game);
}

static gboolean
sudoku_cell_view_real_button_press_event (GtkWidget* base,
                                          GdkEventButton* event)
{
	SudokuCellView * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	SudokuGame* _tmp4_;
	gboolean _tmp11_ = FALSE;
	GtkPopover* _tmp12_;
	gboolean result;
	self = (SudokuCellView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button != ((guint) 1)) {
		_tmp0_ = event->button != ((guint) 3);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	g_object_get ((GtkWidget*) self, "is-focus", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		gtk_widget_grab_focus ((GtkWidget*) self);
	}
	_tmp4_ = self->priv->game;
	if (_tmp4_->mode == GAME_MODE_PLAY) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = sudoku_cell_view_get_is_fixed (self);
		_tmp7_ = _tmp6_;
		if (_tmp7_) {
			_tmp5_ = TRUE;
		} else {
			SudokuGame* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp8_ = self->priv->game;
			_tmp9_ = sudoku_game_get_paused (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp5_ = _tmp10_;
		}
		_tmp3_ = _tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp12_ = self->priv->popover;
	if (_tmp12_ != NULL) {
		_tmp11_ = TRUE;
	} else {
		GtkPopover* _tmp13_;
		_tmp13_ = self->priv->earmark_popover;
		_tmp11_ = _tmp13_ != NULL;
	}
	if (_tmp11_) {
		sudoku_cell_view_hide_both_popovers (self);
		result = FALSE;
		return result;
	}
	if (event->button == ((guint) 1)) {
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		if (!self->priv->_show_possibilities) {
			_tmp15_ = (event->state & GDK_CONTROL_MASK) > 0;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			SudokuGame* _tmp16_;
			_tmp16_ = self->priv->game;
			_tmp14_ = _tmp16_->mode == GAME_MODE_PLAY;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			sudoku_cell_view_show_earmark_picker (self);
		} else {
			sudoku_cell_view_show_number_picker (self);
		}
	} else {
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		if (!self->priv->_show_possibilities) {
			_tmp18_ = event->button == ((guint) 3);
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			SudokuGame* _tmp19_;
			_tmp19_ = self->priv->game;
			_tmp17_ = _tmp19_->mode == GAME_MODE_PLAY;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			sudoku_cell_view_show_earmark_picker (self);
		}
	}
	result = FALSE;
	return result;
}

static void
__lambda10_ (SudokuCellView* self,
             gint number,
             gboolean state)
{
	SudokuGame* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	if (state) {
		SudokuGame* _tmp0_;
		SudokuBoard* _tmp1_;
		_tmp0_ = self->priv->game;
		_tmp1_ = _tmp0_->board;
		sudoku_board_enable_earmark (_tmp1_, self->priv->row, self->priv->col, number);
	} else {
		SudokuGame* _tmp2_;
		SudokuBoard* _tmp3_;
		_tmp2_ = self->priv->game;
		_tmp3_ = _tmp2_->board;
		sudoku_board_disable_earmark (_tmp3_, self->priv->row, self->priv->col, number);
	}
	_tmp4_ = self->priv->game;
	_tmp5_ = sudoku_cell_view_get_value (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = sudoku_cell_view_get_value (self);
	_tmp8_ = _tmp7_;
	g_signal_emit_by_name (_tmp4_, "cell-changed", self->priv->row, self->priv->col, _tmp6_, _tmp8_);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
___lambda10__number_picker_earmark_state_changed (NumberPicker* _sender,
                                                  gint number,
                                                  gboolean active,
                                                  gpointer self)
{
	__lambda10_ ((SudokuCellView*) self, number, active);
}

static void
sudoku_cell_view_create_earmark_picker (SudokuCellView* self)
{
	SudokuGame* _tmp0_;
	NumberPicker* _tmp1_;
	NumberPicker* _tmp2_;
	NumberPicker* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = number_picker_new (&_tmp0_->board, TRUE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->earmark_picker);
	self->priv->earmark_picker = _tmp1_;
	_tmp2_ = self->priv->earmark_picker;
	g_signal_connect_object (_tmp2_, "earmark-state-changed", (GCallback) ___lambda10__number_picker_earmark_state_changed, self, 0);
	_tmp3_ = self->priv->earmark_picker;
	number_picker_set_earmarks (_tmp3_, self->priv->row, self->priv->col);
}

static void
__lambda7_ (SudokuCellView* self,
            NumberPicker* o,
            gint number)
{
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	GtkPopover* _tmp2_;
	g_return_if_fail (o != NULL);
	sudoku_cell_view_set_value (self, number);
	if (number == 0) {
		g_object_notify ((GObject*) self, "value");
	}
	_tmp0_ = self->priv->game;
	_tmp1_ = _tmp0_->board;
	sudoku_board_disable_all_earmarks (_tmp1_, self->priv->row, self->priv->col);
	_tmp2_ = self->priv->popover;
	gtk_widget_hide ((GtkWidget*) _tmp2_);
}

static void
___lambda7__number_picker_number_picked (NumberPicker* _sender,
                                         gint number,
                                         gpointer self)
{
	__lambda7_ ((SudokuCellView*) self, _sender, number);
}

static void
__lambda8_ (SudokuCellView* self)
{
	GtkPopover* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->popover;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		sudoku_cell_view_destroy_popover (self, &self->priv->popover, &self->priv->number_picker);
	}
}

static void
___lambda8__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda8_ ((SudokuCellView*) self);
}

static gboolean
__lambda9_ (SudokuCellView* self)
{
	GtkPopover* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->popover;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	result = TRUE;
	return result;
}

static gboolean
___lambda9__gtk_widget_focus_out_event (GtkWidget* _sender,
                                        GdkEventFocus* event,
                                        gpointer self)
{
	gboolean result;
	result = __lambda9_ ((SudokuCellView*) self);
	return result;
}

static void
sudoku_cell_view_show_number_picker (SudokuCellView* self)
{
	GtkPopover* _tmp0_;
	SudokuGame* _tmp2_;
	NumberPicker* _tmp3_;
	NumberPicker* _tmp4_;
	NumberPicker* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GtkPopover* _tmp8_;
	GtkPopover* _tmp9_;
	NumberPicker* _tmp10_;
	GtkPopover* _tmp11_;
	GtkPopover* _tmp12_;
	GtkPopover* _tmp13_;
	GtkPopover* _tmp14_;
	GtkPopover* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->earmark_popover;
	if (_tmp0_ != NULL) {
		GtkPopover* _tmp1_;
		_tmp1_ = self->priv->earmark_popover;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	}
	_tmp2_ = self->priv->game;
	_tmp3_ = number_picker_new (&_tmp2_->board, FALSE);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->number_picker);
	self->priv->number_picker = _tmp3_;
	_tmp4_ = self->priv->number_picker;
	g_signal_connect_object (_tmp4_, "number-picked", (GCallback) ___lambda7__number_picker_number_picked, self, 0);
	_tmp5_ = self->priv->number_picker;
	_tmp6_ = sudoku_cell_view_get_value (self);
	_tmp7_ = _tmp6_;
	number_picker_set_clear_button_visibility (_tmp5_, _tmp7_ != 0);
	_tmp8_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->popover);
	self->priv->popover = _tmp8_;
	_tmp9_ = self->priv->popover;
	_tmp10_ = self->priv->number_picker;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->popover;
	gtk_popover_set_modal (_tmp11_, FALSE);
	_tmp12_ = self->priv->popover;
	gtk_popover_set_position (_tmp12_, GTK_POS_BOTTOM);
	_tmp13_ = self->priv->popover;
	g_signal_connect_object ((GObject*) _tmp13_, "notify::visible", (GCallback) ___lambda8__g_object_notify, self, 0);
	_tmp14_ = self->priv->popover;
	g_signal_connect_object ((GtkWidget*) _tmp14_, "focus-out-event", (GCallback) ___lambda9__gtk_widget_focus_out_event, self, 0);
	_tmp15_ = self->priv->popover;
	gtk_widget_show ((GtkWidget*) _tmp15_);
}

static void
__lambda11_ (SudokuCellView* self)
{
	GtkPopover* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->earmark_popover;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		sudoku_cell_view_destroy_popover (self, &self->priv->earmark_popover, &self->priv->earmark_picker);
	}
}

static void
___lambda11__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda11_ ((SudokuCellView*) self);
}

static gboolean
__lambda12_ (SudokuCellView* self)
{
	GtkPopover* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->earmark_popover;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	result = TRUE;
	return result;
}

static gboolean
___lambda12__gtk_widget_focus_out_event (GtkWidget* _sender,
                                         GdkEventFocus* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda12_ ((SudokuCellView*) self);
	return result;
}

static void
sudoku_cell_view_show_earmark_picker (SudokuCellView* self)
{
	GtkPopover* _tmp0_;
	GtkPopover* _tmp2_;
	GtkPopover* _tmp3_;
	NumberPicker* _tmp4_;
	GtkPopover* _tmp5_;
	GtkPopover* _tmp6_;
	GtkPopover* _tmp7_;
	GtkPopover* _tmp8_;
	GtkPopover* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->popover;
	if (_tmp0_ != NULL) {
		GtkPopover* _tmp1_;
		_tmp1_ = self->priv->popover;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	}
	sudoku_cell_view_create_earmark_picker (self);
	_tmp2_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->earmark_popover);
	self->priv->earmark_popover = _tmp2_;
	_tmp3_ = self->priv->earmark_popover;
	_tmp4_ = self->priv->earmark_picker;
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->earmark_popover;
	gtk_popover_set_modal (_tmp5_, FALSE);
	_tmp6_ = self->priv->earmark_popover;
	gtk_popover_set_position (_tmp6_, GTK_POS_BOTTOM);
	_tmp7_ = self->priv->earmark_popover;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::visible", (GCallback) ___lambda11__g_object_notify, self, 0);
	_tmp8_ = self->priv->earmark_popover;
	g_signal_connect_object ((GtkWidget*) _tmp8_, "focus-out-event", (GCallback) ___lambda12__gtk_widget_focus_out_event, self, 0);
	_tmp9_ = self->priv->earmark_popover;
	gtk_widget_show ((GtkWidget*) _tmp9_);
}

static void
sudoku_cell_view_destroy_popover (SudokuCellView* self,
                                  GtkPopover** popover,
                                  NumberPicker** picker)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (*popover != NULL);
	g_return_if_fail (*picker != NULL);
	_g_object_unref0 (*picker);
	*picker = NULL;
	if ((*popover) != NULL) {
		gtk_widget_destroy ((GtkWidget*) (*popover));
		_g_object_unref0 (*popover);
		*popover = NULL;
		if (sudoku_cell_view_warn_incorrect_solution (self)) {
			gtk_widget_queue_draw ((GtkWidget*) self);
		}
	}
}

void
sudoku_cell_view_hide_both_popovers (SudokuCellView* self)
{
	GtkPopover* _tmp0_;
	GtkPopover* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->popover;
	if (_tmp0_ != NULL) {
		GtkPopover* _tmp1_;
		_tmp1_ = self->priv->popover;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	}
	_tmp2_ = self->priv->earmark_popover;
	if (_tmp2_ != NULL) {
		GtkPopover* _tmp3_;
		_tmp3_ = self->priv->earmark_popover;
		gtk_widget_hide ((GtkWidget*) _tmp3_);
	}
}

static gboolean
sudoku_cell_view_focus_out_cb (SudokuCellView* self,
                               GtkWidget* widget,
                               GdkEventFocus* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	sudoku_cell_view_hide_both_popovers (self);
	result = FALSE;
	return result;
}

static gint
sudoku_cell_view_key_map_keypad (SudokuCellView* self,
                                 const gchar* key_name)
{
	gboolean _tmp0_ = FALSE;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (key_name != NULL, 0);
	if (g_strcmp0 (key_name, "KP_0") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (key_name, "0") == 0;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	if (g_strcmp0 (key_name, "KP_1") == 0) {
		result = 1;
		return result;
	}
	if (g_strcmp0 (key_name, "KP_2") == 0) {
		result = 2;
		return result;
	}
	if (g_strcmp0 (key_name, "KP_3") == 0) {
		result = 3;
		return result;
	}
	if (g_strcmp0 (key_name, "KP_4") == 0) {
		result = 4;
		return result;
	}
	if (g_strcmp0 (key_name, "KP_5") == 0) {
		result = 5;
		return result;
	}
	if (g_strcmp0 (key_name, "KP_6") == 0) {
		result = 6;
		return result;
	}
	if (g_strcmp0 (key_name, "KP_7") == 0) {
		result = 7;
		return result;
	}
	if (g_strcmp0 (key_name, "KP_8") == 0) {
		result = 8;
		return result;
	}
	if (g_strcmp0 (key_name, "KP_9") == 0) {
		result = 9;
		return result;
	}
	result = -1;
	return result;
}

static gboolean
_sudoku_cell_view_on_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                       guint keyval,
                                                                       guint keycode,
                                                                       GdkModifierType state,
                                                                       gpointer self)
{
	gboolean result;
	result = sudoku_cell_view_on_key_pressed ((SudokuCellView*) self, _sender, keyval, keycode, state);
	return result;
}

static void
_sudoku_cell_view_on_key_release_gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                        guint keyval,
                                                                        guint keycode,
                                                                        GdkModifierType state,
                                                                        gpointer self)
{
	sudoku_cell_view_on_key_release ((SudokuCellView*) self, _sender, keyval, keycode, state);
}

static inline void
sudoku_cell_view_init_keyboard (SudokuCellView* self)
{
	GtkEventControllerKey* _tmp0_;
	GtkEventControllerKey* _tmp1_;
	GtkEventControllerKey* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) self);
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp0_;
	_tmp1_ = self->priv->key_controller;
	g_signal_connect_object (_tmp1_, "key-pressed", (GCallback) _sudoku_cell_view_on_key_pressed_gtk_event_controller_key_key_pressed, self, 0);
	_tmp2_ = self->priv->key_controller;
	g_signal_connect_object (_tmp2_, "key-released", (GCallback) _sudoku_cell_view_on_key_release_gtk_event_controller_key_key_released, self, 0);
}

static inline gboolean
sudoku_cell_view_on_key_pressed (SudokuCellView* self,
                                 GtkEventControllerKey* _key_controller,
                                 guint keyval,
                                 guint keycode,
                                 GdkModifierType state)
{
	gboolean _tmp0_ = FALSE;
	SudokuGame* _tmp1_;
	gchar* k_name = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gint k_no = 0;
	const gchar* _tmp10_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	const gchar* _tmp33_;
	const gchar* _tmp38_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (_key_controller != NULL, FALSE);
	if (keyval == GDK_KEY_Control_L) {
		self->priv->left_control = TRUE;
	}
	if (keyval == GDK_KEY_Control_R) {
		self->priv->right_control = TRUE;
	}
	_tmp1_ = self->priv->game;
	if (_tmp1_->mode == GAME_MODE_PLAY) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = sudoku_cell_view_get_is_fixed (self);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			_tmp2_ = TRUE;
		} else {
			SudokuGame* _tmp5_;
			gboolean _tmp6_;
			gboolean _tmp7_;
			_tmp5_ = self->priv->game;
			_tmp6_ = sudoku_game_get_paused (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp2_ = _tmp7_;
		}
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = gdk_keyval_name (keyval);
	_tmp9_ = g_strdup (_tmp8_);
	k_name = _tmp9_;
	_tmp10_ = k_name;
	k_no = atoi (_tmp10_);
	if (k_no == 0) {
		const gchar* _tmp11_;
		_tmp11_ = k_name;
		k_no = sudoku_cell_view_key_map_keypad (self, _tmp11_);
	}
	if (k_no >= 1) {
		_tmp12_ = k_no <= 9;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		GtkPopover* _tmp15_;
		gboolean want_earmark = FALSE;
		gboolean _tmp17_ = FALSE;
		_tmp15_ = self->priv->earmark_popover;
		if (_tmp15_ != NULL) {
			GtkPopover* _tmp16_;
			_tmp16_ = self->priv->earmark_popover;
			_tmp14_ = gtk_widget_is_visible ((GtkWidget*) _tmp16_);
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			_tmp13_ = (state & GDK_CONTROL_MASK) > 0;
		}
		want_earmark = _tmp13_;
		if (want_earmark) {
			SudokuGame* _tmp18_;
			_tmp18_ = self->priv->game;
			_tmp17_ = _tmp18_->mode == GAME_MODE_PLAY;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			gboolean new_state = FALSE;
			SudokuGame* _tmp19_;
			SudokuBoard* _tmp20_;
			NumberPicker* _tmp23_;
			_tmp19_ = self->priv->game;
			_tmp20_ = _tmp19_->board;
			new_state = !sudoku_board_is_earmark_enabled (_tmp20_, self->priv->row, self->priv->col, k_no);
			if (new_state) {
				SudokuGame* _tmp21_;
				_tmp21_ = self->priv->game;
				sudoku_game_enable_earmark (_tmp21_, self->priv->row, self->priv->col, k_no);
			} else {
				SudokuGame* _tmp22_;
				_tmp22_ = self->priv->game;
				sudoku_game_disable_earmark (_tmp22_, self->priv->row, self->priv->col, k_no);
			}
			_tmp23_ = self->priv->earmark_picker;
			if (_tmp23_ != NULL) {
				NumberPicker* _tmp24_;
				_tmp24_ = self->priv->earmark_picker;
				number_picker_set_earmark (_tmp24_, self->priv->row, self->priv->col, k_no - 1, new_state);
			}
			gtk_widget_queue_draw ((GtkWidget*) self);
		} else {
			SudokuGame* _tmp25_;
			SudokuBoard* _tmp26_;
			sudoku_cell_view_set_value (self, k_no);
			_tmp25_ = self->priv->game;
			_tmp26_ = _tmp25_->board;
			sudoku_board_disable_all_earmarks (_tmp26_, self->priv->row, self->priv->col);
			sudoku_cell_view_hide_both_popovers (self);
		}
		result = TRUE;
		_g_free0 (k_name);
		return result;
	}
	if (k_no == 0) {
		_tmp28_ = TRUE;
	} else {
		const gchar* _tmp29_;
		_tmp29_ = k_name;
		_tmp28_ = g_strcmp0 (_tmp29_, "BackSpace") == 0;
	}
	if (_tmp28_) {
		_tmp27_ = TRUE;
	} else {
		const gchar* _tmp30_;
		_tmp30_ = k_name;
		_tmp27_ = g_strcmp0 (_tmp30_, "Delete") == 0;
	}
	if (_tmp27_) {
		sudoku_cell_view_set_value (self, 0);
		g_object_notify ((GObject*) self, "value");
		result = TRUE;
		_g_free0 (k_name);
		return result;
	}
	_tmp33_ = k_name;
	if (g_strcmp0 (_tmp33_, "space") == 0) {
		_tmp32_ = TRUE;
	} else {
		const gchar* _tmp34_;
		_tmp34_ = k_name;
		_tmp32_ = g_strcmp0 (_tmp34_, "Return") == 0;
	}
	if (_tmp32_) {
		_tmp31_ = TRUE;
	} else {
		const gchar* _tmp35_;
		_tmp35_ = k_name;
		_tmp31_ = g_strcmp0 (_tmp35_, "KP_Enter") == 0;
	}
	if (_tmp31_) {
		GtkPopover* _tmp36_;
		_tmp36_ = self->priv->popover;
		if (_tmp36_ != NULL) {
			GtkPopover* _tmp37_;
			_tmp37_ = self->priv->popover;
			gtk_widget_hide ((GtkWidget*) _tmp37_);
			result = FALSE;
			_g_free0 (k_name);
			return result;
		}
		sudoku_cell_view_show_number_picker (self);
		result = TRUE;
		_g_free0 (k_name);
		return result;
	}
	_tmp38_ = k_name;
	if (g_strcmp0 (_tmp38_, "Escape") == 0) {
		sudoku_cell_view_hide_both_popovers (self);
		result = TRUE;
		_g_free0 (k_name);
		return result;
	}
	result = FALSE;
	_g_free0 (k_name);
	return result;
}

static inline void
sudoku_cell_view_on_key_release (SudokuCellView* self,
                                 GtkEventControllerKey* _key_controller,
                                 guint keyval,
                                 guint keycode,
                                 GdkModifierType state)
{
	gboolean control_released = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_key_controller != NULL);
	control_released = FALSE;
	if (keyval == GDK_KEY_Control_L) {
		self->priv->left_control = FALSE;
		control_released = TRUE;
	}
	if (keyval == GDK_KEY_Control_R) {
		self->priv->right_control = FALSE;
		control_released = TRUE;
	}
	if (control_released) {
		_tmp0_ = sudoku_cell_view_warn_incorrect_solution (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
}

static gboolean
sudoku_cell_view_real_draw (GtkWidget* base,
                            cairo_t* c)
{
	SudokuCellView * self;
	GdkRGBA background_color = {0};
	gboolean _tmp0_ = FALSE;
	GdkRGBA _tmp21_;
	GdkRGBA _tmp22_;
	GdkRGBA _tmp23_;
	GdkRGBA _tmp24_;
	gboolean _tmp25_ = FALSE;
	SudokuGame* _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_;
	gboolean _tmp41_;
	gboolean* marks = NULL;
	gint marks_length1;
	gint _marks_size_;
	gboolean* _tmp71_;
	gint _tmp71__length1;
	gboolean _tmp104_ = FALSE;
	gboolean result;
	self = (SudokuCellView*) base;
	g_return_val_if_fail (c != NULL, FALSE);
	if (self->priv->_selected) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		g_object_get ((GtkWidget*) self, "is-focus", &_tmp1_, NULL);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		background_color = selected_bg_color;
	} else {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = sudoku_cell_view_get_is_fixed (self);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			background_color = fixed_cell_color;
		} else {
			if (self->priv->_highlighted_background) {
				background_color = highlight_color;
			} else {
				background_color = free_cell_color;
			}
		}
	}
	if (sudoku_cell_view_warn_incorrect_solution (self)) {
		gboolean cell_error = FALSE;
		gint solution = 0;
		SudokuGame* _tmp5_;
		SudokuBoard* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		cell_error = FALSE;
		_tmp5_ = self->priv->game;
		_tmp6_ = _tmp5_->board;
		solution = sudoku_board_get_solution (_tmp6_, self->priv->row, self->priv->col);
		_tmp7_ = sudoku_cell_view_get_value (self);
		_tmp8_ = _tmp7_;
		if (_tmp8_ != 0) {
			gint _tmp9_;
			gint _tmp10_;
			_tmp9_ = sudoku_cell_view_get_value (self);
			_tmp10_ = _tmp9_;
			cell_error = _tmp10_ != solution;
		} else {
			gboolean* marks = NULL;
			SudokuGame* _tmp11_;
			SudokuBoard* _tmp12_;
			gint _tmp13_ = 0;
			gboolean* _tmp14_;
			gint marks_length1;
			gint _marks_size_;
			gboolean earmarked = FALSE;
			gboolean solution_found = FALSE;
			gboolean _tmp20_ = FALSE;
			_tmp11_ = self->priv->game;
			_tmp12_ = _tmp11_->board;
			_tmp14_ = sudoku_board_get_earmarks (_tmp12_, self->priv->row, self->priv->col, &_tmp13_);
			marks = _tmp14_;
			marks_length1 = _tmp13_;
			_marks_size_ = marks_length1;
			earmarked = FALSE;
			solution_found = FALSE;
			{
				gint num = 0;
				num = 1;
				{
					gboolean _tmp15_ = FALSE;
					_tmp15_ = TRUE;
					while (TRUE) {
						gboolean* _tmp17_;
						gint _tmp17__length1;
						gboolean* _tmp18_;
						gint _tmp18__length1;
						gboolean _tmp19_;
						if (!_tmp15_) {
							gint _tmp16_;
							_tmp16_ = num;
							num = _tmp16_ + 1;
						}
						_tmp15_ = FALSE;
						_tmp17_ = marks;
						_tmp17__length1 = marks_length1;
						if (!(num <= _tmp17__length1)) {
							break;
						}
						_tmp18_ = marks;
						_tmp18__length1 = marks_length1;
						_tmp19_ = _tmp18_[num - 1];
						if (_tmp19_) {
							earmarked = TRUE;
							if (num == solution) {
								solution_found = TRUE;
							}
						}
					}
				}
			}
			if (earmarked) {
				_tmp20_ = !solution_found;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				cell_error = TRUE;
			}
			marks = (g_free (marks), NULL);
		}
		if (cell_error) {
			background_color.green = background_color.green * 0.6;
			background_color.blue = background_color.blue * 0.6;
		}
	}
	_tmp21_ = background_color;
	_tmp22_ = background_color;
	_tmp23_ = background_color;
	_tmp24_ = background_color;
	cairo_set_source_rgba (c, _tmp21_.red, _tmp22_.green, _tmp23_.blue, _tmp24_.alpha);
	cairo_rectangle (c, (gdouble) 0, (gdouble) 0, (gdouble) gtk_widget_get_allocated_width ((GtkWidget*) self), (gdouble) gtk_widget_get_allocated_height ((GtkWidget*) self));
	cairo_fill (c);
	if (self->priv->_show_warnings) {
		SudokuGame* _tmp26_;
		SudokuBoard* _tmp27_;
		GeeSet* _tmp28_;
		Coord _tmp29_ = {0};
		_tmp26_ = self->priv->game;
		_tmp27_ = _tmp26_->board;
		_tmp28_ = _tmp27_->broken_coords;
		coord_init (&_tmp29_, self->priv->row, self->priv->col);
		_tmp25_ = gee_collection_contains ((GeeCollection*) _tmp28_, &_tmp29_);
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		cairo_set_source_rgb (c, 1.0, 0.0, 0.0);
	} else {
		if (self->priv->_highlighted_value) {
			cairo_set_source_rgb (c, 0.2, 0.4, 0.9);
		} else {
			if (self->priv->_selected) {
				cairo_set_source_rgb (c, 0.2, 0.2, 0.2);
			} else {
				cairo_set_source_rgb (c, 0.0, 0.0, 0.0);
			}
		}
	}
	_tmp30_ = self->priv->game;
	_tmp31_ = sudoku_game_get_paused (_tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp32_) {
		result = FALSE;
		return result;
	}
	_tmp33_ = sudoku_cell_view_get_value (self);
	_tmp34_ = _tmp33_;
	if (_tmp34_ != 0) {
		gdouble height = 0.0;
		gdouble width = 0.0;
		gchar* text = NULL;
		gint _tmp35_;
		gint _tmp36_;
		gchar* _tmp37_;
		const gchar* _tmp38_;
		height = (gdouble) gtk_widget_get_allocated_height ((GtkWidget*) self);
		width = (gdouble) gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp35_ = sudoku_cell_view_get_value (self);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_strdup_printf ("%d", _tmp36_);
		text = _tmp37_;
		cairo_set_font_size (c, height / self->priv->size_ratio);
		_tmp38_ = text;
		sudoku_cell_view_print_centered (self, c, _tmp38_, width, height);
		result = FALSE;
		_g_free0 (text);
		return result;
	}
	_tmp40_ = sudoku_cell_view_get_is_fixed (self);
	_tmp41_ = _tmp40_;
	if (_tmp41_) {
		SudokuGame* _tmp42_;
		_tmp42_ = self->priv->game;
		_tmp39_ = _tmp42_->mode == GAME_MODE_PLAY;
	} else {
		_tmp39_ = FALSE;
	}
	if (_tmp39_) {
		result = FALSE;
		return result;
	}
	marks = NULL;
	marks_length1 = 0;
	_marks_size_ = marks_length1;
	if (!self->priv->_show_possibilities) {
		SudokuGame* _tmp61_;
		SudokuBoard* _tmp62_;
		gint _tmp63_ = 0;
		gboolean* _tmp64_;
		if (!self->priv->initialized_earmarks) {
			gboolean _tmp43_ = FALSE;
			gboolean _tmp44_ = FALSE;
			if (self->priv->_initialize_earmarks) {
				SudokuGame* _tmp45_;
				_tmp45_ = self->priv->game;
				_tmp44_ = _tmp45_->mode == GAME_MODE_PLAY;
			} else {
				_tmp44_ = FALSE;
			}
			if (_tmp44_) {
				SudokuGame* _tmp46_;
				SudokuBoard* _tmp47_;
				gdouble _tmp48_;
				gdouble _tmp49_;
				_tmp46_ = self->priv->game;
				_tmp47_ = _tmp46_->board;
				_tmp48_ = sudoku_board_get_previous_played_time (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp43_ = _tmp49_ == 0.0;
			} else {
				_tmp43_ = FALSE;
			}
			if (_tmp43_) {
				SudokuGame* _tmp50_;
				SudokuBoard* _tmp51_;
				gint _tmp52_ = 0;
				gboolean* _tmp53_;
				_tmp50_ = self->priv->game;
				_tmp51_ = _tmp50_->board;
				_tmp53_ = sudoku_board_get_possibilities_as_bool_array (_tmp51_, self->priv->row, self->priv->col, &_tmp52_);
				marks = (g_free (marks), NULL);
				marks = _tmp53_;
				marks_length1 = _tmp52_;
				_marks_size_ = marks_length1;
				{
					gint num = 0;
					num = 1;
					{
						gboolean _tmp54_ = FALSE;
						_tmp54_ = TRUE;
						while (TRUE) {
							gboolean* _tmp56_;
							gint _tmp56__length1;
							gboolean* _tmp57_;
							gint _tmp57__length1;
							gboolean _tmp58_;
							if (!_tmp54_) {
								gint _tmp55_;
								_tmp55_ = num;
								num = _tmp55_ + 1;
							}
							_tmp54_ = FALSE;
							_tmp56_ = marks;
							_tmp56__length1 = marks_length1;
							if (!(num <= _tmp56__length1)) {
								break;
							}
							_tmp57_ = marks;
							_tmp57__length1 = marks_length1;
							_tmp58_ = _tmp57_[num - 1];
							if (_tmp58_) {
								SudokuGame* _tmp59_;
								SudokuBoard* _tmp60_;
								_tmp59_ = self->priv->game;
								_tmp60_ = _tmp59_->board;
								sudoku_board_enable_earmark (_tmp60_, self->priv->row, self->priv->col, num);
							}
						}
					}
				}
			}
			self->priv->initialized_earmarks = TRUE;
		}
		_tmp61_ = self->priv->game;
		_tmp62_ = _tmp61_->board;
		_tmp64_ = sudoku_board_get_earmarks (_tmp62_, self->priv->row, self->priv->col, &_tmp63_);
		marks = (g_free (marks), NULL);
		marks = _tmp64_;
		marks_length1 = _tmp63_;
		_marks_size_ = marks_length1;
	} else {
		gint _tmp65_;
		gint _tmp66_;
		_tmp65_ = sudoku_cell_view_get_value (self);
		_tmp66_ = _tmp65_;
		if (_tmp66_ == 0) {
			SudokuGame* _tmp67_;
			SudokuBoard* _tmp68_;
			gint _tmp69_ = 0;
			gboolean* _tmp70_;
			_tmp67_ = self->priv->game;
			_tmp68_ = _tmp67_->board;
			_tmp70_ = sudoku_board_get_possibilities_as_bool_array (_tmp68_, self->priv->row, self->priv->col, &_tmp69_);
			marks = (g_free (marks), NULL);
			marks = _tmp70_;
			marks_length1 = _tmp69_;
			_marks_size_ = marks_length1;
		}
	}
	_tmp71_ = marks;
	_tmp71__length1 = marks_length1;
	if (_tmp71_ != NULL) {
		gdouble possibility_size = 0.0;
		gdouble height = 0.0;
		SudokuGame* _tmp72_;
		SudokuBoard* _tmp73_;
		gint _tmp74_;
		gint _tmp75_;
		gdouble width = 0.0;
		SudokuGame* _tmp76_;
		SudokuBoard* _tmp77_;
		gint _tmp78_;
		gint _tmp79_;
		gint num = 0;
		possibility_size = (gtk_widget_get_allocated_height ((GtkWidget*) self) / self->priv->size_ratio) / 2;
		cairo_set_font_size (c, possibility_size);
		_tmp72_ = self->priv->game;
		_tmp73_ = _tmp72_->board;
		_tmp74_ = sudoku_board_get_block_rows (_tmp73_);
		_tmp75_ = _tmp74_;
		height = ((gdouble) gtk_widget_get_allocated_height ((GtkWidget*) self)) / _tmp75_;
		_tmp76_ = self->priv->game;
		_tmp77_ = _tmp76_->board;
		_tmp78_ = sudoku_board_get_block_cols (_tmp77_);
		_tmp79_ = _tmp78_;
		width = ((gdouble) gtk_widget_get_allocated_width ((GtkWidget*) self)) / _tmp79_;
		num = 0;
		{
			gint row_tmp = 0;
			row_tmp = 0;
			{
				gboolean _tmp80_ = FALSE;
				_tmp80_ = TRUE;
				while (TRUE) {
					SudokuGame* _tmp82_;
					SudokuBoard* _tmp83_;
					gint _tmp84_;
					gint _tmp85_;
					if (!_tmp80_) {
						gint _tmp81_;
						_tmp81_ = row_tmp;
						row_tmp = _tmp81_ + 1;
					}
					_tmp80_ = FALSE;
					_tmp82_ = self->priv->game;
					_tmp83_ = _tmp82_->board;
					_tmp84_ = sudoku_board_get_block_rows (_tmp83_);
					_tmp85_ = _tmp84_;
					if (!(row_tmp < _tmp85_)) {
						break;
					}
					{
						gint col_tmp = 0;
						col_tmp = 0;
						{
							gboolean _tmp86_ = FALSE;
							_tmp86_ = TRUE;
							while (TRUE) {
								SudokuGame* _tmp88_;
								SudokuBoard* _tmp89_;
								gint _tmp90_;
								gint _tmp91_;
								gint _tmp92_;
								gboolean* _tmp93_;
								gint _tmp93__length1;
								gboolean _tmp94_;
								if (!_tmp86_) {
									gint _tmp87_;
									_tmp87_ = col_tmp;
									col_tmp = _tmp87_ + 1;
								}
								_tmp86_ = FALSE;
								_tmp88_ = self->priv->game;
								_tmp89_ = _tmp88_->board;
								_tmp90_ = sudoku_board_get_block_cols (_tmp89_);
								_tmp91_ = _tmp90_;
								if (!(col_tmp < _tmp91_)) {
									break;
								}
								_tmp92_ = num;
								num = _tmp92_ + 1;
								_tmp93_ = marks;
								_tmp93__length1 = marks_length1;
								_tmp94_ = _tmp93_[num - 1];
								if (_tmp94_) {
									gboolean _tmp95_ = FALSE;
									gchar* text = NULL;
									gchar* _tmp98_;
									SudokuGame* _tmp99_;
									SudokuBoard* _tmp100_;
									gint _tmp101_;
									gint _tmp102_;
									const gchar* _tmp103_;
									if (self->priv->_show_warnings) {
										SudokuGame* _tmp96_;
										SudokuBoard* _tmp97_;
										_tmp96_ = self->priv->game;
										_tmp97_ = _tmp96_->board;
										_tmp95_ = !sudoku_board_is_possible (_tmp97_, self->priv->row, self->priv->col, num);
									} else {
										_tmp95_ = FALSE;
									}
									if (_tmp95_) {
										cairo_set_source_rgb (c, 1.0, 0.0, 0.0);
									} else {
										cairo_set_source_rgb (c, 0.0, 0.0, 0.0);
									}
									_tmp98_ = g_strdup_printf ("%d", num);
									text = _tmp98_;
									cairo_save (c);
									_tmp99_ = self->priv->game;
									_tmp100_ = _tmp99_->board;
									_tmp101_ = sudoku_board_get_block_rows (_tmp100_);
									_tmp102_ = _tmp101_;
									cairo_translate (c, col_tmp * width, ((_tmp102_ - row_tmp) - 1) * height);
									_tmp103_ = text;
									sudoku_cell_view_print_centered (self, c, _tmp103_, width, height);
									cairo_restore (c);
									_g_free0 (text);
								}
							}
						}
					}
				}
			}
		}
	}
	if (self->priv->_show_warnings) {
		gboolean _tmp105_ = FALSE;
		gint _tmp106_;
		gint _tmp107_;
		_tmp106_ = sudoku_cell_view_get_value (self);
		_tmp107_ = _tmp106_;
		if (_tmp107_ == 0) {
			SudokuGame* _tmp108_;
			SudokuBoard* _tmp109_;
			_tmp108_ = self->priv->game;
			_tmp109_ = _tmp108_->board;
			_tmp105_ = sudoku_board_count_possibilities (_tmp109_, self->priv->row, self->priv->col) == 0;
		} else {
			_tmp105_ = FALSE;
		}
		_tmp104_ = _tmp105_;
	} else {
		_tmp104_ = FALSE;
	}
	if (_tmp104_) {
		cairo_set_font_size (c, gtk_widget_get_allocated_height ((GtkWidget*) self) / self->priv->size_ratio);
		cairo_set_source_rgb (c, 1.0, 0.0, 0.0);
		sudoku_cell_view_print_centered (self, c, "X", (gdouble) gtk_widget_get_allocated_width ((GtkWidget*) self), (gdouble) gtk_widget_get_allocated_height ((GtkWidget*) self));
	}
	result = FALSE;
	marks = (g_free (marks), NULL);
	return result;
}

static void
sudoku_cell_view_print_centered (SudokuCellView* self,
                                 cairo_t* c,
                                 const gchar* text,
                                 gdouble width,
                                 gdouble height)
{
	cairo_font_extents_t font_extents = {0};
	cairo_font_extents_t _tmp0_ = {0};
	cairo_text_extents_t text_extents = {0};
	cairo_text_extents_t _tmp1_ = {0};
	cairo_text_extents_t _tmp2_;
	cairo_text_extents_t _tmp3_;
	cairo_font_extents_t _tmp4_;
	cairo_font_extents_t _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (text != NULL);
	cairo_font_extents (c, &_tmp0_);
	font_extents = _tmp0_;
	cairo_text_extents (c, text, &_tmp1_);
	text_extents = _tmp1_;
	_tmp2_ = text_extents;
	_tmp3_ = text_extents;
	_tmp4_ = font_extents;
	_tmp5_ = font_extents;
	cairo_move_to (c, ((width - _tmp2_.width) / 2) - _tmp3_.x_bearing, ((height + _tmp4_.height) / 2) - _tmp5_.descent);
	cairo_show_text (c, text);
}

void
sudoku_cell_view_cell_changed_cb (SudokuCellView* self,
                                  gint row,
                                  gint col,
                                  gint old_val,
                                  gint new_val)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (row == self->priv->row) {
		_tmp0_ = col == self->priv->col;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		sudoku_cell_view_set_value (self, new_val);
		g_object_notify ((GObject*) self, "value");
	}
}

void
sudoku_cell_view_clear (SudokuCellView* self)
{
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = _tmp0_->board;
	sudoku_board_disable_all_earmarks (_tmp1_, self->priv->row, self->priv->col);
}

static gboolean
sudoku_cell_view_warn_incorrect_solution (SudokuCellView* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_show_warnings) {
		GtkPopover* _tmp5_;
		_tmp5_ = self->priv->popover;
		_tmp4_ = _tmp5_ == NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GtkPopover* _tmp6_;
		_tmp6_ = self->priv->earmark_popover;
		_tmp3_ = _tmp6_ == NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = !self->priv->left_control;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = !self->priv->right_control;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		SudokuGame* _tmp7_;
		SudokuBoard* _tmp8_;
		_tmp7_ = self->priv->game;
		_tmp8_ = _tmp7_->board;
		_tmp0_ = sudoku_board_solved (_tmp8_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gint
sudoku_cell_view_get_value (SudokuCellView* self)
{
	gint result;
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->game;
	_tmp1_ = _tmp0_->board;
	result = sudoku_board_get (_tmp1_, self->priv->row, self->priv->col);
	return result;
}

void
sudoku_cell_view_set_value (SudokuCellView* self,
                            gint value)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	SudokuGame* _tmp7_;
	SudokuBoard* _tmp8_;
	SudokuGame* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_cell_view_get_is_fixed (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		SudokuGame* _tmp2_;
		_tmp2_ = self->priv->game;
		if (_tmp2_->mode == GAME_MODE_PLAY) {
			return;
		}
	}
	if (value == 0) {
		SudokuGame* _tmp3_;
		SudokuBoard* _tmp4_;
		SudokuGame* _tmp6_;
		_tmp3_ = self->priv->game;
		_tmp4_ = _tmp3_->board;
		if (sudoku_board_get (_tmp4_, self->priv->row, self->priv->col) != 0) {
			SudokuGame* _tmp5_;
			_tmp5_ = self->priv->game;
			sudoku_game_remove (_tmp5_, self->priv->row, self->priv->col);
		}
		_tmp6_ = self->priv->game;
		if (_tmp6_->mode == GAME_MODE_PLAY) {
			return;
		}
	}
	_tmp7_ = self->priv->game;
	_tmp8_ = _tmp7_->board;
	if (value == sudoku_board_get (_tmp8_, self->priv->row, self->priv->col)) {
		return;
	}
	_tmp9_ = self->priv->game;
	sudoku_game_insert (_tmp9_, self->priv->row, self->priv->col, value);
	g_object_notify_by_pspec ((GObject *) self, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_VALUE_PROPERTY]);
}

gboolean
sudoku_cell_view_get_is_fixed (SudokuCellView* self)
{
	gboolean result;
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	gboolean* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->game;
	_tmp1_ = _tmp0_->board;
	_tmp2_ = _tmp1_->is_fixed;
	_tmp2__length1 = _tmp1_->is_fixed_length1;
	_tmp2__length2 = _tmp1_->is_fixed_length2;
	_tmp3_ = _tmp2_[(self->priv->row * _tmp2__length2) + self->priv->col];
	result = _tmp3_;
	return result;
}

gboolean
sudoku_cell_view_get_show_possibilities (SudokuCellView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_possibilities;
	return result;
}

void
sudoku_cell_view_set_show_possibilities (SudokuCellView* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_possibilities = value;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES_PROPERTY]);
}

gboolean
sudoku_cell_view_get_initialize_earmarks (SudokuCellView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_initialize_earmarks;
	return result;
}

void
sudoku_cell_view_set_initialize_earmarks (SudokuCellView* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_initialize_earmarks = value;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_INITIALIZE_EARMARKS_PROPERTY]);
}

gboolean
sudoku_cell_view_get_show_warnings (SudokuCellView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_warnings;
	return result;
}

void
sudoku_cell_view_set_show_warnings (SudokuCellView* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_warnings = value;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_SHOW_WARNINGS_PROPERTY]);
}

gboolean
sudoku_cell_view_get_selected (SudokuCellView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_selected;
	return result;
}

void
sudoku_cell_view_set_selected (SudokuCellView* self,
                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_cell_view_get_selected (self);
	if (old_value != value) {
		self->priv->_selected = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_SELECTED_PROPERTY]);
	}
}

gboolean
sudoku_cell_view_get_highlighted_background (SudokuCellView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_highlighted_background;
	return result;
}

void
sudoku_cell_view_set_highlighted_background (SudokuCellView* self,
                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_cell_view_get_highlighted_background (self);
	if (old_value != value) {
		self->priv->_highlighted_background = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_HIGHLIGHTED_BACKGROUND_PROPERTY]);
	}
}

gboolean
sudoku_cell_view_get_highlighted_value (SudokuCellView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_highlighted_value;
	return result;
}

void
sudoku_cell_view_set_highlighted_value (SudokuCellView* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_cell_view_get_highlighted_value (self);
	if (old_value != value) {
		self->priv->_highlighted_value = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_HIGHLIGHTED_VALUE_PROPERTY]);
	}
}

static void
sudoku_cell_view_class_init (SudokuCellViewClass * klass,
                             gpointer klass_data)
{
	sudoku_cell_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SudokuCellView_private_offset);
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) sudoku_cell_view_real_button_press_event;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) sudoku_cell_view_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_cell_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_cell_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_cell_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_VALUE_PROPERTY, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_VALUE_PROPERTY] = g_param_spec_int ("value", "value", "value", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_IS_FIXED_PROPERTY, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_IS_FIXED_PROPERTY] = g_param_spec_boolean ("is-fixed", "is-fixed", "is-fixed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES_PROPERTY, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES_PROPERTY] = g_param_spec_boolean ("show-possibilities", "show-possibilities", "show-possibilities", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_INITIALIZE_EARMARKS_PROPERTY, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_INITIALIZE_EARMARKS_PROPERTY] = g_param_spec_boolean ("initialize-earmarks", "initialize-earmarks", "initialize-earmarks", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SHOW_WARNINGS_PROPERTY, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_SHOW_WARNINGS_PROPERTY] = g_param_spec_boolean ("show-warnings", "show-warnings", "show-warnings", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SELECTED_PROPERTY, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_SELECTED_PROPERTY] = g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_HIGHLIGHTED_BACKGROUND_PROPERTY, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_HIGHLIGHTED_BACKGROUND_PROPERTY] = g_param_spec_boolean ("highlighted-background", "highlighted-background", "highlighted-background", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_HIGHLIGHTED_VALUE_PROPERTY, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_HIGHLIGHTED_VALUE_PROPERTY] = g_param_spec_boolean ("highlighted-value", "highlighted-value", "highlighted-value", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
sudoku_cell_view_instance_init (SudokuCellView * self,
                                gpointer klass)
{
	self->priv = sudoku_cell_view_get_instance_private (self);
	self->priv->size_ratio = (gdouble) 2;
	self->priv->_show_warnings = TRUE;
}

static void
sudoku_cell_view_finalize (GObject * obj)
{
	SudokuCellView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
	_g_object_unref0 (self->priv->popover);
	_g_object_unref0 (self->priv->earmark_popover);
	_g_object_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->number_picker);
	_g_object_unref0 (self->priv->earmark_picker);
	_g_object_unref0 (self->priv->key_controller);
	G_OBJECT_CLASS (sudoku_cell_view_parent_class)->finalize (obj);
}

static GType
sudoku_cell_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SudokuCellViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_cell_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuCellView), 0, (GInstanceInitFunc) sudoku_cell_view_instance_init, NULL };
	GType sudoku_cell_view_type_id;
	sudoku_cell_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "SudokuCellView", &g_define_type_info, 0);
	SudokuCellView_private_offset = g_type_add_instance_private (sudoku_cell_view_type_id, sizeof (SudokuCellViewPrivate));
	return sudoku_cell_view_type_id;
}

GType
sudoku_cell_view_get_type (void)
{
	static volatile gsize sudoku_cell_view_type_id__once = 0;
	if (g_once_init_enter (&sudoku_cell_view_type_id__once)) {
		GType sudoku_cell_view_type_id;
		sudoku_cell_view_type_id = sudoku_cell_view_get_type_once ();
		g_once_init_leave (&sudoku_cell_view_type_id__once, sudoku_cell_view_type_id);
	}
	return sudoku_cell_view_type_id__once;
}

static void
_vala_sudoku_cell_view_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	SudokuCellView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
	switch (property_id) {
		case SUDOKU_CELL_VIEW_VALUE_PROPERTY:
		g_value_set_int (value, sudoku_cell_view_get_value (self));
		break;
		case SUDOKU_CELL_VIEW_IS_FIXED_PROPERTY:
		g_value_set_boolean (value, sudoku_cell_view_get_is_fixed (self));
		break;
		case SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES_PROPERTY:
		g_value_set_boolean (value, sudoku_cell_view_get_show_possibilities (self));
		break;
		case SUDOKU_CELL_VIEW_INITIALIZE_EARMARKS_PROPERTY:
		g_value_set_boolean (value, sudoku_cell_view_get_initialize_earmarks (self));
		break;
		case SUDOKU_CELL_VIEW_SHOW_WARNINGS_PROPERTY:
		g_value_set_boolean (value, sudoku_cell_view_get_show_warnings (self));
		break;
		case SUDOKU_CELL_VIEW_SELECTED_PROPERTY:
		g_value_set_boolean (value, sudoku_cell_view_get_selected (self));
		break;
		case SUDOKU_CELL_VIEW_HIGHLIGHTED_BACKGROUND_PROPERTY:
		g_value_set_boolean (value, sudoku_cell_view_get_highlighted_background (self));
		break;
		case SUDOKU_CELL_VIEW_HIGHLIGHTED_VALUE_PROPERTY:
		g_value_set_boolean (value, sudoku_cell_view_get_highlighted_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sudoku_cell_view_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	SudokuCellView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
	switch (property_id) {
		case SUDOKU_CELL_VIEW_VALUE_PROPERTY:
		sudoku_cell_view_set_value (self, g_value_get_int (value));
		break;
		case SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES_PROPERTY:
		sudoku_cell_view_set_show_possibilities (self, g_value_get_boolean (value));
		break;
		case SUDOKU_CELL_VIEW_INITIALIZE_EARMARKS_PROPERTY:
		sudoku_cell_view_set_initialize_earmarks (self, g_value_get_boolean (value));
		break;
		case SUDOKU_CELL_VIEW_SHOW_WARNINGS_PROPERTY:
		sudoku_cell_view_set_show_warnings (self, g_value_get_boolean (value));
		break;
		case SUDOKU_CELL_VIEW_SELECTED_PROPERTY:
		sudoku_cell_view_set_selected (self, g_value_get_boolean (value));
		break;
		case SUDOKU_CELL_VIEW_HIGHLIGHTED_BACKGROUND_PROPERTY:
		sudoku_cell_view_set_highlighted_background (self, g_value_get_boolean (value));
		break;
		case SUDOKU_CELL_VIEW_HIGHLIGHTED_VALUE_PROPERTY:
		sudoku_cell_view_set_highlighted_value (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
sudoku_view_get_instance_private (SudokuView* self)
{
	return G_STRUCT_MEMBER_P (self, SudokuView_private_offset);
}

static void
sudoku_view_set_selected (SudokuView* self,
                          gint cell_row,
                          gint cell_col)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->selected_row >= 0) {
		_tmp0_ = self->priv->selected_col >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SudokuCellView** _tmp1_;
		gint _tmp1__length1;
		gint _tmp1__length2;
		SudokuCellView* _tmp2_;
		SudokuCellView** _tmp3_;
		gint _tmp3__length1;
		gint _tmp3__length2;
		SudokuCellView* _tmp4_;
		_tmp1_ = self->priv->cells;
		_tmp1__length1 = self->priv->cells_length1;
		_tmp1__length2 = self->priv->cells_length2;
		_tmp2_ = _tmp1_[(self->priv->selected_row * _tmp1__length2) + self->priv->selected_col];
		sudoku_cell_view_set_selected (_tmp2_, FALSE);
		_tmp3_ = self->priv->cells;
		_tmp3__length1 = self->priv->cells_length1;
		_tmp3__length2 = self->priv->cells_length2;
		_tmp4_ = _tmp3_[(self->priv->selected_row * _tmp3__length2) + self->priv->selected_col];
		gtk_widget_queue_draw ((GtkWidget*) _tmp4_);
	}
	self->priv->selected_row = cell_row;
	self->priv->selected_col = cell_col;
	if (self->priv->selected_row >= 0) {
		_tmp5_ = self->priv->selected_col >= 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		SudokuCellView** _tmp6_;
		gint _tmp6__length1;
		gint _tmp6__length2;
		SudokuCellView* _tmp7_;
		_tmp6_ = self->priv->cells;
		_tmp6__length1 = self->priv->cells_length1;
		_tmp6__length2 = self->priv->cells_length2;
		_tmp7_ = _tmp6_[(self->priv->selected_row * _tmp6__length2) + self->priv->selected_col];
		sudoku_cell_view_set_selected (_tmp7_, TRUE);
	}
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		SudokuView* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->game);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static gboolean
_sudoku_view_draw_board_gtk_widget_draw (GtkWidget* _sender,
                                         cairo_t* cr,
                                         gpointer self)
{
	gboolean result;
	result = sudoku_view_draw_board ((SudokuView*) self, cr);
	return result;
}

static void
__lambda13_ (SudokuView* self)
{
	SudokuGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->game;
	_tmp1_ = sudoku_game_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkDrawingArea* _tmp3_;
		_tmp3_ = self->priv->drawing;
		gtk_widget_show ((GtkWidget*) _tmp3_);
	} else {
		GtkDrawingArea* _tmp4_;
		_tmp4_ = self->priv->drawing;
		gtk_widget_hide ((GtkWidget*) _tmp4_);
	}
}

static void
___lambda13__sudoku_game_paused_changed (SudokuGame* _sender,
                                         gpointer self)
{
	__lambda13_ ((SudokuView*) self);
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		SudokuView* self;
		self = _data10_->_data9_->self;
		block9_data_unref (_data10_->_data9_);
		_data10_->_data9_ = NULL;
		g_slice_free (Block10Data, _data10_);
	}
}

static gboolean
________lambda14_ (Block10Data* _data10_)
{
	Block9Data* _data9_;
	SudokuView* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	_data9_ = _data10_->_data9_;
	self = _data9_->self;
	_tmp0_ = sudoku_game_get_paused (_data9_->game);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	sudoku_view_set_selected (self, _data10_->cell_row, _data10_->cell_col);
	sudoku_view_update_highlights (self);
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
_________lambda14__gtk_widget_focus_in_event (GtkWidget* _sender,
                                              GdkEventFocus* event,
                                              gpointer self)
{
	gboolean result;
	result = ________lambda14_ (self);
	return result;
}

static gboolean
________lambda15_ (Block10Data* _data10_)
{
	Block9Data* _data9_;
	SudokuView* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	_data9_ = _data10_->_data9_;
	self = _data9_->self;
	_tmp0_ = sudoku_game_get_paused (_data9_->game);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	sudoku_view_set_selected (self, -1, -1);
	sudoku_view_update_highlights (self);
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
_________lambda15__gtk_widget_focus_out_event (GtkWidget* _sender,
                                               GdkEventFocus* event,
                                               gpointer self)
{
	gboolean result;
	result = ________lambda15_ (self);
	return result;
}

static void
________lambda16_ (Block10Data* _data10_,
                   GObject* s,
                   GParamSpec* p)
{
	Block9Data* _data9_;
	SudokuView* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	_data9_ = _data10_->_data9_;
	self = _data9_->self;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	if (self->priv->_show_possibilities) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = self->priv->_show_warnings;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		SudokuBoard* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = _data9_->game->board;
		_tmp4_ = sudoku_board_get_broken (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->previous_board_broken_state;
	}
	if (_tmp0_) {
		SudokuBoard* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = _data9_->game->board;
		_tmp7_ = sudoku_board_get_broken (_tmp6_);
		_tmp8_ = _tmp7_;
		self->priv->previous_board_broken_state = _tmp8_;
	}
	sudoku_view_update_highlights (self);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
_________lambda16__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self)
{
	________lambda16_ (self, _sender, pspec);
}

SudokuView*
sudoku_view_construct (GType object_type,
                       SudokuGame* game)
{
	SudokuView * self = NULL;
	Block9Data* _data9_;
	SudokuGame* _tmp0_;
	GtkOverlay* _tmp1_;
	GtkOverlay* _tmp2_;
	GtkDrawingArea* _tmp3_;
	GtkDrawingArea* _tmp4_;
	GtkGrid* _tmp5_;
	SudokuGame* _tmp8_;
	SudokuGame* _tmp9_;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp10_;
	GtkCssProvider* _tmp11_;
	GtkGrid* _tmp12_;
	GtkGrid* _tmp13_;
	GtkGrid* _tmp14_;
	GtkGrid* _tmp15_;
	GtkGrid* _tmp16_;
	GtkGrid* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkGrid* _tmp19_;
	GtkStyleContext* _tmp20_;
	GtkCssProvider* _tmp21_;
	GtkGrid** blocks = NULL;
	SudokuBoard* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	SudokuBoard* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	GtkGrid** _tmp28_;
	gint blocks_length1;
	gint blocks_length2;
	SudokuBoard* _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	SudokuBoard* _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	SudokuCellView** _tmp60_;
	GtkOverlay* _tmp93_;
	GtkDrawingArea* _tmp94_;
	GtkOverlay* _tmp95_;
	GtkGrid* _tmp96_;
	GtkGrid* _tmp97_;
	GtkOverlay* _tmp98_;
	GtkDrawingArea* _tmp99_;
	g_return_val_if_fail (game != NULL, NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (game);
	_g_object_unref0 (_data9_->game);
	_data9_->game = _tmp0_;
	self = (SudokuView*) g_object_new (object_type, NULL);
	_data9_->self = g_object_ref (self);
	gtk_frame_set_shadow_type ((GtkFrame*) self, GTK_SHADOW_NONE);
	g_object_set ((GtkAspectFrame*) self, "obey-child", FALSE, NULL);
	g_object_set ((GtkAspectFrame*) self, "ratio", (gfloat) 1, NULL);
	_tmp1_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->overlay);
	self->priv->overlay = _tmp1_;
	_tmp2_ = self->priv->overlay;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
	_tmp3_ = (GtkDrawingArea*) gtk_drawing_area_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->drawing);
	self->priv->drawing = _tmp3_;
	_tmp4_ = self->priv->drawing;
	g_signal_connect_object ((GtkWidget*) _tmp4_, "draw", (GCallback) _sudoku_view_draw_board_gtk_widget_draw, self, 0);
	_tmp5_ = self->priv->grid;
	if (_tmp5_ != NULL) {
		GtkOverlay* _tmp6_;
		GtkGrid* _tmp7_;
		_tmp6_ = self->priv->overlay;
		_tmp7_ = self->priv->grid;
		gtk_container_remove ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
	}
	_tmp8_ = _g_object_ref0 (_data9_->game);
	_g_object_unref0 (self->game);
	self->game = _tmp8_;
	_tmp9_ = self->game;
	g_signal_connect_object (_tmp9_, "paused-changed", (GCallback) ___lambda13__sudoku_game_paused_changed, self, 0);
	_tmp10_ = gtk_css_provider_new ();
	css_provider = _tmp10_;
	_tmp11_ = css_provider;
	gtk_css_provider_load_from_resource (_tmp11_, "/org/gnome/Sudoku/ui/gnome-sudoku.css");
	_tmp12_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->grid);
	self->priv->grid = _tmp12_;
	_tmp13_ = self->priv->grid;
	gtk_grid_set_row_spacing (_tmp13_, 2);
	_tmp14_ = self->priv->grid;
	gtk_grid_set_column_spacing (_tmp14_, 2);
	_tmp15_ = self->priv->grid;
	gtk_grid_set_column_homogeneous (_tmp15_, TRUE);
	_tmp16_ = self->priv->grid;
	gtk_grid_set_row_homogeneous (_tmp16_, TRUE);
	_tmp17_ = self->priv->grid;
	_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) _tmp17_);
	gtk_style_context_add_class (_tmp18_, "board");
	_tmp19_ = self->priv->grid;
	_tmp20_ = gtk_widget_get_style_context ((GtkWidget*) _tmp19_);
	_tmp21_ = css_provider;
	gtk_style_context_add_provider (_tmp20_, (GtkStyleProvider*) _tmp21_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp22_ = _data9_->game->board;
	_tmp23_ = sudoku_board_get_block_rows (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = _data9_->game->board;
	_tmp26_ = sudoku_board_get_block_cols (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_new0 (GtkGrid*, (_tmp24_ * _tmp27_) + 1);
	blocks = _tmp28_;
	blocks_length1 = _tmp24_;
	blocks_length2 = _tmp27_;
	{
		gint block_row = 0;
		block_row = 0;
		{
			gboolean _tmp29_ = FALSE;
			_tmp29_ = TRUE;
			while (TRUE) {
				SudokuBoard* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				if (!_tmp29_) {
					gint _tmp30_;
					_tmp30_ = block_row;
					block_row = _tmp30_ + 1;
				}
				_tmp29_ = FALSE;
				_tmp31_ = _data9_->game->board;
				_tmp32_ = sudoku_board_get_block_rows (_tmp31_);
				_tmp33_ = _tmp32_;
				if (!(block_row < _tmp33_)) {
					break;
				}
				{
					gint block_col = 0;
					block_col = 0;
					{
						gboolean _tmp34_ = FALSE;
						_tmp34_ = TRUE;
						while (TRUE) {
							SudokuBoard* _tmp36_;
							gint _tmp37_;
							gint _tmp38_;
							GtkGrid* block_grid = NULL;
							GtkGrid* _tmp39_;
							GtkGrid* _tmp40_;
							GtkGrid* _tmp41_;
							GtkGrid* _tmp42_;
							GtkGrid* _tmp43_;
							GtkGrid* _tmp44_;
							GtkStyleContext* _tmp45_;
							GtkGrid* _tmp46_;
							GtkStyleContext* _tmp47_;
							GtkCssProvider* _tmp48_;
							GtkGrid* _tmp49_;
							GtkGrid* _tmp50_;
							GtkGrid** _tmp51_;
							gint _tmp51__length1;
							gint _tmp51__length2;
							GtkGrid* _tmp52_;
							GtkGrid* _tmp53_;
							if (!_tmp34_) {
								gint _tmp35_;
								_tmp35_ = block_col;
								block_col = _tmp35_ + 1;
							}
							_tmp34_ = FALSE;
							_tmp36_ = _data9_->game->board;
							_tmp37_ = sudoku_board_get_block_cols (_tmp36_);
							_tmp38_ = _tmp37_;
							if (!(block_col < _tmp38_)) {
								break;
							}
							_tmp39_ = (GtkGrid*) gtk_grid_new ();
							g_object_ref_sink (_tmp39_);
							block_grid = _tmp39_;
							_tmp40_ = block_grid;
							gtk_grid_set_row_spacing (_tmp40_, 1);
							_tmp41_ = block_grid;
							gtk_grid_set_column_spacing (_tmp41_, 1);
							_tmp42_ = block_grid;
							gtk_grid_set_column_homogeneous (_tmp42_, TRUE);
							_tmp43_ = block_grid;
							gtk_grid_set_row_homogeneous (_tmp43_, TRUE);
							_tmp44_ = block_grid;
							_tmp45_ = gtk_widget_get_style_context ((GtkWidget*) _tmp44_);
							gtk_style_context_add_class (_tmp45_, "block");
							_tmp46_ = block_grid;
							_tmp47_ = gtk_widget_get_style_context ((GtkWidget*) _tmp46_);
							_tmp48_ = css_provider;
							gtk_style_context_add_provider (_tmp47_, (GtkStyleProvider*) _tmp48_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
							_tmp49_ = self->priv->grid;
							_tmp50_ = block_grid;
							gtk_grid_attach (_tmp49_, (GtkWidget*) _tmp50_, block_col, block_row, 1, 1);
							_tmp51_ = blocks;
							_tmp51__length1 = blocks_length1;
							_tmp51__length2 = blocks_length2;
							_tmp52_ = block_grid;
							_tmp53_ = _g_object_ref0 (_tmp52_);
							_g_object_unref0 (_tmp51_[(block_row * _tmp51__length2) + block_col]);
							_tmp51_[(block_row * _tmp51__length2) + block_col] = _tmp53_;
							_g_object_unref0 (block_grid);
						}
					}
				}
			}
		}
	}
	_tmp54_ = _data9_->game->board;
	_tmp55_ = sudoku_board_get_rows (_tmp54_);
	_tmp56_ = _tmp55_;
	_tmp57_ = _data9_->game->board;
	_tmp58_ = sudoku_board_get_cols (_tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = g_new0 (SudokuCellView*, (_tmp56_ * _tmp59_) + 1);
	self->priv->cells = (_vala_array_free (self->priv->cells, self->priv->cells_length1 * self->priv->cells_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->cells = _tmp60_;
	self->priv->cells_length1 = _tmp56_;
	self->priv->cells_length2 = _tmp59_;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp61_ = FALSE;
			_tmp61_ = TRUE;
			while (TRUE) {
				SudokuBoard* _tmp63_;
				gint _tmp64_;
				gint _tmp65_;
				if (!_tmp61_) {
					gint _tmp62_;
					_tmp62_ = row;
					row = _tmp62_ + 1;
				}
				_tmp61_ = FALSE;
				_tmp63_ = _data9_->game->board;
				_tmp64_ = sudoku_board_get_rows (_tmp63_);
				_tmp65_ = _tmp64_;
				if (!(row < _tmp65_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp66_ = FALSE;
						_tmp66_ = TRUE;
						while (TRUE) {
							Block10Data* _data10_;
							SudokuBoard* _tmp68_;
							gint _tmp69_;
							gint _tmp70_;
							SudokuCellView* cell = NULL;
							SudokuCellView* _tmp71_;
							SudokuCellView* _tmp72_;
							SudokuCellView* _tmp73_;
							SudokuCellView* _tmp74_;
							SudokuCellView** _tmp75_;
							gint _tmp75__length1;
							gint _tmp75__length2;
							SudokuCellView* _tmp76_;
							SudokuCellView* _tmp77_;
							GtkGrid** _tmp78_;
							gint _tmp78__length1;
							gint _tmp78__length2;
							SudokuBoard* _tmp79_;
							gint _tmp80_;
							gint _tmp81_;
							SudokuBoard* _tmp82_;
							gint _tmp83_;
							gint _tmp84_;
							GtkGrid* _tmp85_;
							SudokuCellView* _tmp86_;
							SudokuBoard* _tmp87_;
							gint _tmp88_;
							gint _tmp89_;
							SudokuBoard* _tmp90_;
							gint _tmp91_;
							gint _tmp92_;
							_data10_ = g_slice_new0 (Block10Data);
							_data10_->_ref_count_ = 1;
							_data10_->_data9_ = block9_data_ref (_data9_);
							if (!_tmp66_) {
								gint _tmp67_;
								_tmp67_ = col;
								col = _tmp67_ + 1;
							}
							_tmp66_ = FALSE;
							_tmp68_ = _data9_->game->board;
							_tmp69_ = sudoku_board_get_cols (_tmp68_);
							_tmp70_ = _tmp69_;
							if (!(col < _tmp70_)) {
								block10_data_unref (_data10_);
								_data10_ = NULL;
								break;
							}
							_tmp71_ = sudoku_cell_view_new (row, col, &self->game);
							g_object_ref_sink (_tmp71_);
							cell = _tmp71_;
							_data10_->cell_row = row;
							_data10_->cell_col = col;
							_tmp72_ = cell;
							g_signal_connect_data ((GtkWidget*) _tmp72_, "focus-in-event", (GCallback) _________lambda14__gtk_widget_focus_in_event, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
							_tmp73_ = cell;
							g_signal_connect_data ((GtkWidget*) _tmp73_, "focus-out-event", (GCallback) _________lambda15__gtk_widget_focus_out_event, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
							_tmp74_ = cell;
							g_signal_connect_data ((GObject*) _tmp74_, "notify::value", (GCallback) _________lambda16__g_object_notify, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
							_tmp75_ = self->priv->cells;
							_tmp75__length1 = self->priv->cells_length1;
							_tmp75__length2 = self->priv->cells_length2;
							_tmp76_ = cell;
							_tmp77_ = _g_object_ref0 (_tmp76_);
							_g_object_unref0 (_tmp75_[(row * _tmp75__length2) + col]);
							_tmp75_[(row * _tmp75__length2) + col] = _tmp77_;
							_tmp78_ = blocks;
							_tmp78__length1 = blocks_length1;
							_tmp78__length2 = blocks_length2;
							_tmp79_ = _data9_->game->board;
							_tmp80_ = sudoku_board_get_block_rows (_tmp79_);
							_tmp81_ = _tmp80_;
							_tmp82_ = _data9_->game->board;
							_tmp83_ = sudoku_board_get_block_cols (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp85_ = _tmp78_[((row / _tmp81_) * _tmp78__length2) + (col / _tmp84_)];
							_tmp86_ = cell;
							_tmp87_ = _data9_->game->board;
							_tmp88_ = sudoku_board_get_block_cols (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp90_ = _data9_->game->board;
							_tmp91_ = sudoku_board_get_block_rows (_tmp90_);
							_tmp92_ = _tmp91_;
							gtk_grid_attach (_tmp85_, (GtkWidget*) _tmp86_, col % _tmp89_, row % _tmp92_, 1, 1);
							_g_object_unref0 (cell);
							block10_data_unref (_data10_);
							_data10_ = NULL;
						}
					}
				}
			}
		}
	}
	_tmp93_ = self->priv->overlay;
	_tmp94_ = self->priv->drawing;
	gtk_overlay_add_overlay (_tmp93_, (GtkWidget*) _tmp94_);
	_tmp95_ = self->priv->overlay;
	_tmp96_ = self->priv->grid;
	gtk_container_add ((GtkContainer*) _tmp95_, (GtkWidget*) _tmp96_);
	_tmp97_ = self->priv->grid;
	gtk_widget_show_all ((GtkWidget*) _tmp97_);
	_tmp98_ = self->priv->overlay;
	gtk_widget_show ((GtkWidget*) _tmp98_);
	_tmp99_ = self->priv->drawing;
	gtk_widget_hide ((GtkWidget*) _tmp99_);
	blocks = (_vala_array_free (blocks, blocks_length1 * blocks_length2, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (css_provider);
	block9_data_unref (_data9_);
	_data9_ = NULL;
	return self;
}

SudokuView*
sudoku_view_new (SudokuGame* game)
{
	return sudoku_view_construct (TYPE_SUDOKU_VIEW, game);
}

static void
sudoku_view_update_highlights (SudokuView* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean has_selection = FALSE;
	gint cell_value = 0;
	g_return_if_fail (self != NULL);
	if (self->priv->selected_row >= 0) {
		_tmp0_ = self->priv->selected_col >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	has_selection = _tmp0_;
	cell_value = -1;
	if (has_selection) {
		SudokuCellView** _tmp1_;
		gint _tmp1__length1;
		gint _tmp1__length2;
		SudokuCellView* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp1_ = self->priv->cells;
		_tmp1__length1 = self->priv->cells_length1;
		_tmp1__length2 = self->priv->cells_length2;
		_tmp2_ = _tmp1_[(self->priv->selected_row * _tmp1__length2) + self->priv->selected_col];
		_tmp3_ = sudoku_cell_view_get_value (_tmp2_);
		_tmp4_ = _tmp3_;
		cell_value = _tmp4_;
	}
	{
		gint col_tmp = 0;
		col_tmp = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				SudokuGame* _tmp7_;
				SudokuBoard* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = col_tmp;
					col_tmp = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = self->game;
				_tmp8_ = _tmp7_->board;
				_tmp9_ = sudoku_board_get_cols (_tmp8_);
				_tmp10_ = _tmp9_;
				if (!(col_tmp < _tmp10_)) {
					break;
				}
				{
					gint row_tmp = 0;
					row_tmp = 0;
					{
						gboolean _tmp11_ = FALSE;
						_tmp11_ = TRUE;
						while (TRUE) {
							SudokuGame* _tmp13_;
							SudokuBoard* _tmp14_;
							gint _tmp15_;
							gint _tmp16_;
							gboolean _tmp17_ = FALSE;
							gboolean _tmp18_ = FALSE;
							SudokuCellView** _tmp38_;
							gint _tmp38__length1;
							gint _tmp38__length2;
							SudokuCellView* _tmp39_;
							gboolean _tmp40_ = FALSE;
							gboolean _tmp41_ = FALSE;
							SudokuCellView** _tmp46_;
							gint _tmp46__length1;
							gint _tmp46__length2;
							SudokuCellView* _tmp47_;
							if (!_tmp11_) {
								gint _tmp12_;
								_tmp12_ = row_tmp;
								row_tmp = _tmp12_ + 1;
							}
							_tmp11_ = FALSE;
							_tmp13_ = self->game;
							_tmp14_ = _tmp13_->board;
							_tmp15_ = sudoku_board_get_rows (_tmp14_);
							_tmp16_ = _tmp15_;
							if (!(row_tmp < _tmp16_)) {
								break;
							}
							if (has_selection) {
								_tmp18_ = self->priv->_highlighter;
							} else {
								_tmp18_ = FALSE;
							}
							if (_tmp18_) {
								gboolean _tmp19_ = FALSE;
								gboolean _tmp20_ = FALSE;
								if (col_tmp == self->priv->selected_col) {
									_tmp20_ = TRUE;
								} else {
									_tmp20_ = row_tmp == self->priv->selected_row;
								}
								if (_tmp20_) {
									_tmp19_ = TRUE;
								} else {
									gboolean _tmp21_ = FALSE;
									SudokuGame* _tmp22_;
									SudokuBoard* _tmp23_;
									gint _tmp24_;
									gint _tmp25_;
									SudokuGame* _tmp26_;
									SudokuBoard* _tmp27_;
									gint _tmp28_;
									gint _tmp29_;
									_tmp22_ = self->game;
									_tmp23_ = _tmp22_->board;
									_tmp24_ = sudoku_board_get_block_cols (_tmp23_);
									_tmp25_ = _tmp24_;
									_tmp26_ = self->game;
									_tmp27_ = _tmp26_->board;
									_tmp28_ = sudoku_board_get_block_cols (_tmp27_);
									_tmp29_ = _tmp28_;
									if ((col_tmp / _tmp25_) == (self->priv->selected_col / _tmp29_)) {
										SudokuGame* _tmp30_;
										SudokuBoard* _tmp31_;
										gint _tmp32_;
										gint _tmp33_;
										SudokuGame* _tmp34_;
										SudokuBoard* _tmp35_;
										gint _tmp36_;
										gint _tmp37_;
										_tmp30_ = self->game;
										_tmp31_ = _tmp30_->board;
										_tmp32_ = sudoku_board_get_block_rows (_tmp31_);
										_tmp33_ = _tmp32_;
										_tmp34_ = self->game;
										_tmp35_ = _tmp34_->board;
										_tmp36_ = sudoku_board_get_block_rows (_tmp35_);
										_tmp37_ = _tmp36_;
										_tmp21_ = (row_tmp / _tmp33_) == (self->priv->selected_row / _tmp37_);
									} else {
										_tmp21_ = FALSE;
									}
									_tmp19_ = _tmp21_;
								}
								_tmp17_ = _tmp19_;
							} else {
								_tmp17_ = FALSE;
							}
							_tmp38_ = self->priv->cells;
							_tmp38__length1 = self->priv->cells_length1;
							_tmp38__length2 = self->priv->cells_length2;
							_tmp39_ = _tmp38_[(row_tmp * _tmp38__length2) + col_tmp];
							sudoku_cell_view_set_highlighted_background (_tmp39_, _tmp17_);
							if (has_selection) {
								_tmp41_ = self->priv->_highlighter;
							} else {
								_tmp41_ = FALSE;
							}
							if (_tmp41_) {
								SudokuCellView** _tmp42_;
								gint _tmp42__length1;
								gint _tmp42__length2;
								SudokuCellView* _tmp43_;
								gint _tmp44_;
								gint _tmp45_;
								_tmp42_ = self->priv->cells;
								_tmp42__length1 = self->priv->cells_length1;
								_tmp42__length2 = self->priv->cells_length2;
								_tmp43_ = _tmp42_[(row_tmp * _tmp42__length2) + col_tmp];
								_tmp44_ = sudoku_cell_view_get_value (_tmp43_);
								_tmp45_ = _tmp44_;
								_tmp40_ = cell_value == _tmp45_;
							} else {
								_tmp40_ = FALSE;
							}
							_tmp46_ = self->priv->cells;
							_tmp46__length1 = self->priv->cells_length1;
							_tmp46__length2 = self->priv->cells_length2;
							_tmp47_ = _tmp46_[(row_tmp * _tmp46__length2) + col_tmp];
							sudoku_cell_view_set_highlighted_value (_tmp47_, _tmp40_);
						}
					}
				}
			}
		}
	}
}

static gboolean
sudoku_view_draw_board (SudokuView* self,
                        cairo_t* c)
{
	SudokuGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = self->game;
	_tmp1_ = sudoku_game_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gint board_length = 0;
		GtkGrid* _tmp3_;
		gchar* text = NULL;
		gchar* _tmp4_;
		cairo_text_extents_t extents = {0};
		const gchar* _tmp5_;
		cairo_text_extents_t _tmp6_ = {0};
		cairo_text_extents_t _tmp7_;
		cairo_text_extents_t _tmp8_;
		const gchar* _tmp9_;
		_tmp3_ = self->priv->grid;
		board_length = gtk_widget_get_allocated_width ((GtkWidget*) _tmp3_);
		cairo_set_source_rgba (c, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
		cairo_paint (c);
		cairo_select_font_face (c, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
		cairo_set_font_size (c, gtk_widget_get_allocated_width ((GtkWidget*) self) * 0.125);
		_tmp4_ = g_strdup (_ ("Paused"));
		text = _tmp4_;
		_tmp5_ = text;
		cairo_text_extents (c, _tmp5_, &_tmp6_);
		extents = _tmp6_;
		_tmp7_ = extents;
		_tmp8_ = extents;
		cairo_move_to (c, (board_length / 2.0) - (_tmp7_.width / 2.0), (board_length / 2.0) + (_tmp8_.height / 2.0));
		cairo_set_source_rgb (c, (gdouble) 1, (gdouble) 1, (gdouble) 1);
		_tmp9_ = text;
		cairo_show_text (c, _tmp9_);
		_g_free0 (text);
	}
	result = FALSE;
	return result;
}

void
sudoku_view_clear (SudokuView* self)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				SudokuGame* _tmp2_;
				SudokuBoard* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->game;
				_tmp3_ = _tmp2_->board;
				_tmp4_ = sudoku_board_get_rows (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(i < _tmp5_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							SudokuGame* _tmp8_;
							SudokuBoard* _tmp9_;
							gint _tmp10_;
							gint _tmp11_;
							SudokuCellView** _tmp12_;
							gint _tmp12__length1;
							gint _tmp12__length2;
							SudokuCellView* _tmp13_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = j;
								j = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = self->game;
							_tmp9_ = _tmp8_->board;
							_tmp10_ = sudoku_board_get_cols (_tmp9_);
							_tmp11_ = _tmp10_;
							if (!(j < _tmp11_)) {
								break;
							}
							_tmp12_ = self->priv->cells;
							_tmp12__length1 = self->priv->cells_length1;
							_tmp12__length2 = self->priv->cells_length2;
							_tmp13_ = _tmp12_[(i * _tmp12__length2) + j];
							sudoku_cell_view_clear (_tmp13_);
						}
					}
				}
			}
		}
	}
}

void
sudoku_view_hide_popovers (SudokuView* self)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				SudokuGame* _tmp2_;
				SudokuBoard* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->game;
				_tmp3_ = _tmp2_->board;
				_tmp4_ = sudoku_board_get_rows (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(i < _tmp5_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							SudokuGame* _tmp8_;
							SudokuBoard* _tmp9_;
							gint _tmp10_;
							gint _tmp11_;
							SudokuCellView** _tmp12_;
							gint _tmp12__length1;
							gint _tmp12__length2;
							SudokuCellView* _tmp13_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = j;
								j = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = self->game;
							_tmp9_ = _tmp8_->board;
							_tmp10_ = sudoku_board_get_cols (_tmp9_);
							_tmp11_ = _tmp10_;
							if (!(j < _tmp11_)) {
								break;
							}
							_tmp12_ = self->priv->cells;
							_tmp12__length1 = self->priv->cells_length1;
							_tmp12__length2 = self->priv->cells_length2;
							_tmp13_ = _tmp12_[(i * _tmp12__length2) + j];
							sudoku_cell_view_hide_both_popovers (_tmp13_);
						}
					}
				}
			}
		}
	}
}

gboolean
sudoku_view_get_show_warnings (SudokuView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_warnings;
	return result;
}

void
sudoku_view_set_show_warnings (SudokuView* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_warnings = value;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				SudokuGame* _tmp2_;
				SudokuBoard* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->game;
				_tmp3_ = _tmp2_->board;
				_tmp4_ = sudoku_board_get_rows (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(i < _tmp5_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							SudokuGame* _tmp8_;
							SudokuBoard* _tmp9_;
							gint _tmp10_;
							gint _tmp11_;
							SudokuCellView** _tmp12_;
							gint _tmp12__length1;
							gint _tmp12__length2;
							SudokuCellView* _tmp13_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = j;
								j = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = self->game;
							_tmp9_ = _tmp8_->board;
							_tmp10_ = sudoku_board_get_cols (_tmp9_);
							_tmp11_ = _tmp10_;
							if (!(j < _tmp11_)) {
								break;
							}
							_tmp12_ = self->priv->cells;
							_tmp12__length1 = self->priv->cells_length1;
							_tmp12__length2 = self->priv->cells_length2;
							_tmp13_ = _tmp12_[(i * _tmp12__length2) + j];
							sudoku_cell_view_set_show_warnings (_tmp13_, self->priv->_show_warnings);
						}
					}
				}
			}
		}
	}
	g_object_notify_by_pspec ((GObject *) self, sudoku_view_properties[SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY]);
}

gboolean
sudoku_view_get_show_possibilities (SudokuView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_possibilities;
	return result;
}

void
sudoku_view_set_show_possibilities (SudokuView* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_possibilities = value;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				SudokuGame* _tmp2_;
				SudokuBoard* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->game;
				_tmp3_ = _tmp2_->board;
				_tmp4_ = sudoku_board_get_rows (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(i < _tmp5_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							SudokuGame* _tmp8_;
							SudokuBoard* _tmp9_;
							gint _tmp10_;
							gint _tmp11_;
							SudokuCellView** _tmp12_;
							gint _tmp12__length1;
							gint _tmp12__length2;
							SudokuCellView* _tmp13_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = j;
								j = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = self->game;
							_tmp9_ = _tmp8_->board;
							_tmp10_ = sudoku_board_get_cols (_tmp9_);
							_tmp11_ = _tmp10_;
							if (!(j < _tmp11_)) {
								break;
							}
							_tmp12_ = self->priv->cells;
							_tmp12__length1 = self->priv->cells_length1;
							_tmp12__length2 = self->priv->cells_length2;
							_tmp13_ = _tmp12_[(i * _tmp12__length2) + j];
							sudoku_cell_view_set_show_possibilities (_tmp13_, value);
						}
					}
				}
			}
		}
	}
	g_object_notify_by_pspec ((GObject *) self, sudoku_view_properties[SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY]);
}

gboolean
sudoku_view_get_initialize_earmarks (SudokuView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_initialize_earmarks;
	return result;
}

void
sudoku_view_set_initialize_earmarks (SudokuView* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_initialize_earmarks = value;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				SudokuGame* _tmp2_;
				SudokuBoard* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->game;
				_tmp3_ = _tmp2_->board;
				_tmp4_ = sudoku_board_get_rows (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(i < _tmp5_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							SudokuGame* _tmp8_;
							SudokuBoard* _tmp9_;
							gint _tmp10_;
							gint _tmp11_;
							SudokuCellView** _tmp12_;
							gint _tmp12__length1;
							gint _tmp12__length2;
							SudokuCellView* _tmp13_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = j;
								j = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = self->game;
							_tmp9_ = _tmp8_->board;
							_tmp10_ = sudoku_board_get_cols (_tmp9_);
							_tmp11_ = _tmp10_;
							if (!(j < _tmp11_)) {
								break;
							}
							_tmp12_ = self->priv->cells;
							_tmp12__length1 = self->priv->cells_length1;
							_tmp12__length2 = self->priv->cells_length2;
							_tmp13_ = _tmp12_[(i * _tmp12__length2) + j];
							sudoku_cell_view_set_initialize_earmarks (_tmp13_, value);
						}
					}
				}
			}
		}
	}
	g_object_notify_by_pspec ((GObject *) self, sudoku_view_properties[SUDOKU_VIEW_INITIALIZE_EARMARKS_PROPERTY]);
}

gboolean
sudoku_view_get_highlighter (SudokuView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_highlighter;
	return result;
}

void
sudoku_view_set_highlighter (SudokuView* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_highlighter = value;
	g_object_notify_by_pspec ((GObject *) self, sudoku_view_properties[SUDOKU_VIEW_HIGHLIGHTER_PROPERTY]);
}

static void
sudoku_view_class_init (SudokuViewClass * klass,
                        gpointer klass_data)
{
	sudoku_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SudokuView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY, sudoku_view_properties[SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY] = g_param_spec_boolean ("show-warnings", "show-warnings", "show-warnings", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY, sudoku_view_properties[SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY] = g_param_spec_boolean ("show-possibilities", "show-possibilities", "show-possibilities", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_INITIALIZE_EARMARKS_PROPERTY, sudoku_view_properties[SUDOKU_VIEW_INITIALIZE_EARMARKS_PROPERTY] = g_param_spec_boolean ("initialize-earmarks", "initialize-earmarks", "initialize-earmarks", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_HIGHLIGHTER_PROPERTY, sudoku_view_properties[SUDOKU_VIEW_HIGHLIGHTER_PROPERTY] = g_param_spec_boolean ("highlighter", "highlighter", "highlighter", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
sudoku_view_instance_init (SudokuView * self,
                           gpointer klass)
{
	self->priv = sudoku_view_get_instance_private (self);
	self->priv->previous_board_broken_state = FALSE;
	self->priv->selected_row = -1;
	self->priv->selected_col = -1;
	self->priv->_show_warnings = FALSE;
	self->priv->_show_possibilities = FALSE;
	self->priv->_initialize_earmarks = FALSE;
	self->priv->_highlighter = FALSE;
}

static void
sudoku_view_finalize (GObject * obj)
{
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_VIEW, SudokuView);
	_g_object_unref0 (self->game);
	self->priv->cells = (_vala_array_free (self->priv->cells, self->priv->cells_length1 * self->priv->cells_length2, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->overlay);
	_g_object_unref0 (self->priv->drawing);
	_g_object_unref0 (self->priv->grid);
	G_OBJECT_CLASS (sudoku_view_parent_class)->finalize (obj);
}

static GType
sudoku_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SudokuViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuView), 0, (GInstanceInitFunc) sudoku_view_instance_init, NULL };
	GType sudoku_view_type_id;
	sudoku_view_type_id = g_type_register_static (gtk_aspect_frame_get_type (), "SudokuView", &g_define_type_info, 0);
	SudokuView_private_offset = g_type_add_instance_private (sudoku_view_type_id, sizeof (SudokuViewPrivate));
	return sudoku_view_type_id;
}

GType
sudoku_view_get_type (void)
{
	static volatile gsize sudoku_view_type_id__once = 0;
	if (g_once_init_enter (&sudoku_view_type_id__once)) {
		GType sudoku_view_type_id;
		sudoku_view_type_id = sudoku_view_get_type_once ();
		g_once_init_leave (&sudoku_view_type_id__once, sudoku_view_type_id);
	}
	return sudoku_view_type_id__once;
}

static void
_vala_sudoku_view_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_VIEW, SudokuView);
	switch (property_id) {
		case SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY:
		g_value_set_boolean (value, sudoku_view_get_show_warnings (self));
		break;
		case SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY:
		g_value_set_boolean (value, sudoku_view_get_show_possibilities (self));
		break;
		case SUDOKU_VIEW_INITIALIZE_EARMARKS_PROPERTY:
		g_value_set_boolean (value, sudoku_view_get_initialize_earmarks (self));
		break;
		case SUDOKU_VIEW_HIGHLIGHTER_PROPERTY:
		g_value_set_boolean (value, sudoku_view_get_highlighter (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sudoku_view_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_VIEW, SudokuView);
	switch (property_id) {
		case SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY:
		sudoku_view_set_show_warnings (self, g_value_get_boolean (value));
		break;
		case SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY:
		sudoku_view_set_show_possibilities (self, g_value_get_boolean (value));
		break;
		case SUDOKU_VIEW_INITIALIZE_EARMARKS_PROPERTY:
		sudoku_view_set_initialize_earmarks (self, g_value_get_boolean (value));
		break;
		case SUDOKU_VIEW_HIGHLIGHTER_PROPERTY:
		sudoku_view_set_highlighter (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

