/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.rmi.UnmarshalException;
import java.rmi.dgc.DGC;
import java.rmi.dgc.Lease;
import java.rmi.dgc.VMID;
import java.rmi.server.ObjID;
import java.rmi.server.Operation;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import java.rmi.server.UID;
import java.util.ArrayList;
import sun.misc.ObjectInputFilter;
import sun.rmi.transport.Connection;
import sun.rmi.transport.StreamRemoteCall;
import sun.rmi.transport.tcp.TCPConnection;

public final class DGCImpl_Stub
extends RemoteStub
implements DGC {
    private static final Operation[] operations = new Operation[]{new Operation("void clean(java.rmi.server.ObjID[], long, java.rmi.dgc.VMID, boolean)"), new Operation("java.rmi.dgc.Lease dirty(java.rmi.server.ObjID[], long, java.rmi.dgc.Lease)")};
    private static final long interfaceHash = -669196253586618813L;
    private static int DGCCLIENT_MAX_DEPTH = 6;
    private static int DGCCLIENT_MAX_ARRAY_SIZE = 10000;

    public DGCImpl_Stub() {
    }

    public DGCImpl_Stub(RemoteRef ref) {
        super(ref);
    }

    @Override
    public void clean(ObjID[] $param_arrayOf_ObjID_1, long $param_long_2, VMID $param_VMID_3, boolean $param_boolean_4) throws RemoteException {
        try {
            StreamRemoteCall call = (StreamRemoteCall)this.ref.newCall(this, operations, 0, -669196253586618813L);
            call.setObjectInputFilter(new LeaseFilter());
            try {
                ObjectOutput out = call.getOutputStream();
                out.writeObject($param_arrayOf_ObjID_1);
                out.writeLong($param_long_2);
                out.writeObject($param_VMID_3);
                out.writeBoolean($param_boolean_4);
            }
            catch (IOException e) {
                throw new MarshalException("error marshalling arguments", e);
            }
            this.ref.invoke(call);
            this.ref.done(call);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedException("undeclared checked exception", e);
        }
    }

    @Override
    public Lease dirty(ObjID[] $param_arrayOf_ObjID_1, long $param_long_2, Lease $param_Lease_3) throws RemoteException {
        try {
            Lease $result;
            StreamRemoteCall call = (StreamRemoteCall)this.ref.newCall(this, operations, 1, -669196253586618813L);
            call.setObjectInputFilter(new LeaseFilter());
            try {
                ObjectOutput out = call.getOutputStream();
                out.writeObject($param_arrayOf_ObjID_1);
                out.writeLong($param_long_2);
                out.writeObject($param_Lease_3);
            }
            catch (IOException e) {
                throw new MarshalException("error marshalling arguments", e);
            }
            this.ref.invoke(call);
            Connection connection = call.getConnection();
            try {
                ObjectInput in = call.getInputStream();
                $result = (Lease)in.readObject();
            }
            catch (IOException | ClassCastException | ClassNotFoundException e) {
                if (connection instanceof TCPConnection) {
                    ((TCPConnection)connection).getChannel().free(connection, false);
                }
                call.discardPendingRefs();
                throw new UnmarshalException("error unmarshalling return", e);
            }
            finally {
                this.ref.done(call);
            }
            return $result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedException("undeclared checked exception", e);
        }
    }

    private static ObjectInputFilter.Status leaseFilter(ObjectInputFilter.FilterInfo filterInfo) {
        if (filterInfo.depth() > (long)DGCCLIENT_MAX_DEPTH) {
            return ObjectInputFilter.Status.REJECTED;
        }
        Class<?> clazz = filterInfo.serialClass();
        if (clazz != null) {
            while (clazz.isArray()) {
                if (filterInfo.arrayLength() >= 0L && filterInfo.arrayLength() > (long)DGCCLIENT_MAX_ARRAY_SIZE) {
                    return ObjectInputFilter.Status.REJECTED;
                }
                clazz = clazz.getComponentType();
            }
            if (clazz.isPrimitive()) {
                return ObjectInputFilter.Status.ALLOWED;
            }
            return clazz == UID.class || clazz == VMID.class || clazz == Lease.class || Throwable.class.isAssignableFrom(clazz) && clazz.getClassLoader() == Object.class.getClassLoader() || clazz == StackTraceElement.class || clazz == ArrayList.class || clazz == Object.class || clazz.getName().equals("java.util.Collections$UnmodifiableList") || clazz.getName().equals("java.util.Collections$UnmodifiableCollection") || clazz.getName().equals("java.util.Collections$UnmodifiableRandomAccessList") ? ObjectInputFilter.Status.ALLOWED : ObjectInputFilter.Status.REJECTED;
        }
        return ObjectInputFilter.Status.UNDECIDED;
    }

    private static final class LeaseFilter
    implements ObjectInputFilter {
        private LeaseFilter() {
        }

        @Override
        public ObjectInputFilter.Status checkInput(ObjectInputFilter.FilterInfo info) {
            return DGCImpl_Stub.leaseFilter(info);
        }
    }
}

