/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.example.java_scripts;

import com.sun.star.awt.Rectangle;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.chart.XChartDocument;
import com.sun.star.chart.XDiagram;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.document.XEmbeddedObjectSupplier;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.provider.XScriptContext;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCellRange;
import com.sun.star.table.XTableChart;
import com.sun.star.table.XTableCharts;
import com.sun.star.table.XTableChartsSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.util.Date;
import java.util.Random;

public class MemoryUsage {
    public void updateMemoryUsage(XScriptContext ctxt) throws Exception {
        XSpreadsheet sheet = this.createSpreadsheet(ctxt);
        Runtime runtime = Runtime.getRuntime();
        Random generator = new Random();
        Date date = new Date();
        int len = (int)(generator.nextFloat() * (float)runtime.freeMemory() / 5.0f);
        byte[] bytes = new byte[len];
        this.addData(sheet, date.toString(), runtime.totalMemory(), runtime.freeMemory());
        this.addChart(sheet);
    }

    private XSpreadsheet createSpreadsheet(XScriptContext ctxt) throws Exception {
        XComponentLoader loader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)ctxt.getDesktop());
        XComponent comp = loader.loadComponentFromURL("private:factory/scalc", "_blank", 4, new PropertyValue[0]);
        XSpreadsheetDocument doc = (XSpreadsheetDocument)UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)comp);
        XIndexAccess index = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)doc.getSheets());
        XSpreadsheet sheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)index.getByIndex(0));
        return sheet;
    }

    private void addData(XSpreadsheet sheet, String date, long total, long free) throws Exception {
        sheet.getCellByPosition(0, 0).setFormula("Used");
        sheet.getCellByPosition(0, 1).setFormula("Free");
        sheet.getCellByPosition(0, 2).setFormula("Total");
        sheet.getCellByPosition(1, 0).setValue((double)(total - free));
        sheet.getCellByPosition(1, 1).setValue((double)free);
        sheet.getCellByPosition(1, 2).setValue((double)total);
    }

    private void addChart(XSpreadsheet sheet) throws Exception {
        Rectangle rect = new Rectangle();
        rect.X = 500;
        rect.Y = 3000;
        rect.Width = 10000;
        rect.Height = 8000;
        XCellRange range = (XCellRange)UnoRuntime.queryInterface(XCellRange.class, (Object)sheet);
        XCellRange myRange = range.getCellRangeByName("A1:B2");
        XCellRangeAddressable rangeAddr = (XCellRangeAddressable)UnoRuntime.queryInterface(XCellRangeAddressable.class, (Object)myRange);
        CellRangeAddress myAddr = rangeAddr.getRangeAddress();
        CellRangeAddress[] addr = new CellRangeAddress[]{myAddr};
        XTableChartsSupplier supp = (XTableChartsSupplier)UnoRuntime.queryInterface(XTableChartsSupplier.class, (Object)sheet);
        XTableCharts charts = supp.getCharts();
        charts.addNewByName("Example", rect, addr, false, true);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        XNameAccess chartsAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)charts);
        XTableChart tchart = (XTableChart)UnoRuntime.queryInterface(XTableChart.class, (Object)chartsAccess.getByName("Example"));
        XEmbeddedObjectSupplier eos = (XEmbeddedObjectSupplier)UnoRuntime.queryInterface(XEmbeddedObjectSupplier.class, (Object)tchart);
        XComponent xifc = eos.getEmbeddedObject();
        XChartDocument xChart = (XChartDocument)UnoRuntime.queryInterface(XChartDocument.class, (Object)xifc);
        XMultiServiceFactory xDocMSF = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xChart);
        Object diagObject = xDocMSF.createInstance("com.sun.star.chart.PieDiagram");
        XDiagram xDiagram = (XDiagram)UnoRuntime.queryInterface(XDiagram.class, (Object)diagObject);
        xChart.setDiagram(xDiagram);
        XPropertySet propset = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xChart.getTitle());
        propset.setPropertyValue("String", (Object)"JVM Memory Usage");
    }
}

