/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestWrapper;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.PushBuilder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.util.ParameterMap;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.URLEncoder;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.Parameters;
import org.apache.tomcat.util.res.StringManager;

class ApplicationHttpRequest
extends HttpServletRequestWrapper {
    private static final StringManager sm = StringManager.getManager(ApplicationHttpRequest.class);
    protected static final String[] specials = new String[]{"jakarta.servlet.include.request_uri", "jakarta.servlet.include.context_path", "jakarta.servlet.include.servlet_path", "jakarta.servlet.include.path_info", "jakarta.servlet.include.query_string", "jakarta.servlet.include.mapping", "jakarta.servlet.forward.request_uri", "jakarta.servlet.forward.context_path", "jakarta.servlet.forward.servlet_path", "jakarta.servlet.forward.path_info", "jakarta.servlet.forward.query_string", "jakarta.servlet.forward.mapping"};
    private static final int SPECIALS_FIRST_FORWARD_INDEX = 6;
    protected final Context context;
    protected String contextPath = null;
    protected final boolean crossContext;
    protected DispatcherType dispatcherType = null;
    protected Map<String, String[]> parameters = null;
    private boolean parsedParams = false;
    protected String pathInfo = null;
    private String queryParamString = null;
    protected String queryString = null;
    protected Object requestDispatcherPath = null;
    protected String requestURI = null;
    protected String servletPath = null;
    private HttpServletMapping mapping = null;
    protected Session session = null;
    protected final Object[] specialAttributes = new Object[specials.length];

    public ApplicationHttpRequest(HttpServletRequest httpServletRequest, Context context, boolean bl) {
        super(httpServletRequest);
        this.context = context;
        this.crossContext = bl;
        this.setRequest(httpServletRequest);
    }

    public ServletContext getServletContext() {
        if (this.context == null) {
            return null;
        }
        return this.context.getServletContext();
    }

    public Object getAttribute(String string) {
        if (string.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            return this.dispatcherType;
        }
        if (string.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            if (this.requestDispatcherPath != null) {
                return this.requestDispatcherPath.toString();
            }
            return null;
        }
        int n = this.getSpecial(string);
        if (n == -1) {
            return this.getRequest().getAttribute(string);
        }
        if (this.specialAttributes[n] == null && this.specialAttributes[6] == null && n >= 6) {
            return this.getRequest().getAttribute(string);
        }
        return this.specialAttributes[n];
    }

    public Enumeration<String> getAttributeNames() {
        return new AttributeNamesEnumerator();
    }

    public void removeAttribute(String string) {
        if (!this.removeSpecial(string)) {
            this.getRequest().removeAttribute(string);
        }
    }

    public void setAttribute(String string, Object object) {
        if (string.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            this.dispatcherType = (DispatcherType)object;
            return;
        }
        if (string.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            this.requestDispatcherPath = object;
            return;
        }
        if (!this.setSpecial(string, object)) {
            this.getRequest().setAttribute(string, object);
        }
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        if (this.context == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        int n = string.indexOf(35);
        if (n > -1) {
            this.context.getLogger().warn((Object)sm.getString("applicationHttpRequest.fragmentInDispatchPath", new Object[]{string}));
            string = string.substring(0, n);
        }
        if (string.startsWith("/")) {
            return this.context.getServletContext().getRequestDispatcher(string);
        }
        String string2 = (String)this.getAttribute("jakarta.servlet.include.servlet_path");
        if (string2 == null) {
            string2 = this.getServletPath();
        }
        String string3 = this.getPathInfo();
        Object object = null;
        object = string3 == null ? string2 : string2 + string3;
        int n2 = ((String)object).lastIndexOf(47);
        String string4 = null;
        string4 = this.context.getDispatchersUseEncodedPaths() ? (n2 >= 0 ? URLEncoder.DEFAULT.encode(((String)object).substring(0, n2 + 1), StandardCharsets.UTF_8) + string : URLEncoder.DEFAULT.encode((String)object, StandardCharsets.UTF_8) + string) : (n2 >= 0 ? ((String)object).substring(0, n2 + 1) + string : (String)object + string);
        return this.context.getServletContext().getRequestDispatcher(string4);
    }

    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getParameter(String string) {
        this.parseParameters();
        String[] stringArray = this.parameters.get(string);
        if (stringArray == null) {
            return null;
        }
        return stringArray[0];
    }

    public Map<String, String[]> getParameterMap() {
        this.parseParameters();
        return this.parameters;
    }

    public Enumeration<String> getParameterNames() {
        this.parseParameters();
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String string) {
        this.parseParameters();
        return this.parameters.get(string);
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        if (this.getPathInfo() == null || this.getServletContext() == null) {
            return null;
        }
        return this.getServletContext().getRealPath(this.getPathInfo());
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        return RequestUtil.getRequestURL((HttpServletRequest)this);
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpServletMapping getHttpServletMapping() {
        return this.mapping;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean bl) {
        if (this.crossContext) {
            if (this.context == null) {
                return null;
            }
            if (this.session != null && this.session.isValid()) {
                return this.session.getSession();
            }
            HttpSession httpSession = super.getSession(false);
            if (bl && httpSession == null) {
                httpSession = super.getSession(true);
            }
            if (httpSession != null) {
                Session session = null;
                try {
                    session = this.context.getManager().findSession(httpSession.getId());
                    if (session != null && !session.isValid()) {
                        session = null;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (session == null && bl) {
                    session = this.context.getManager().createSession(httpSession.getId());
                }
                if (session != null) {
                    session.access();
                    this.session = session;
                    return this.session.getSession();
                }
            }
            return null;
        }
        return super.getSession(bl);
    }

    public boolean isRequestedSessionIdValid() {
        if (this.crossContext) {
            String string = this.getRequestedSessionId();
            if (string == null) {
                return false;
            }
            if (this.context == null) {
                return false;
            }
            Manager manager = this.context.getManager();
            if (manager == null) {
                return false;
            }
            Session session = null;
            try {
                session = manager.findSession(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return session != null && session.isValid();
        }
        return super.isRequestedSessionIdValid();
    }

    public PushBuilder newPushBuilder() {
        ServletRequest servletRequest = this.getRequest();
        while (servletRequest instanceof ServletRequestWrapper) {
            servletRequest = ((ServletRequestWrapper)servletRequest).getRequest();
        }
        if (servletRequest instanceof RequestFacade) {
            return ((RequestFacade)servletRequest).newPushBuilder((HttpServletRequest)this);
        }
        return null;
    }

    public void recycle() {
        if (this.session != null) {
            this.session.endAccess();
        }
    }

    void setContextPath(String string) {
        this.contextPath = string;
    }

    void setPathInfo(String string) {
        this.pathInfo = string;
    }

    void setQueryString(String string) {
        this.queryString = string;
    }

    void setRequest(HttpServletRequest httpServletRequest) {
        super.setRequest((ServletRequest)httpServletRequest);
        this.dispatcherType = (DispatcherType)httpServletRequest.getAttribute("org.apache.catalina.core.DISPATCHER_TYPE");
        this.requestDispatcherPath = httpServletRequest.getAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH");
        this.contextPath = httpServletRequest.getContextPath();
        this.pathInfo = httpServletRequest.getPathInfo();
        this.queryString = httpServletRequest.getQueryString();
        this.requestURI = httpServletRequest.getRequestURI();
        this.servletPath = httpServletRequest.getServletPath();
        this.mapping = httpServletRequest.getHttpServletMapping();
    }

    void setRequestURI(String string) {
        this.requestURI = string;
    }

    void setServletPath(String string) {
        this.servletPath = string;
    }

    void parseParameters() {
        if (this.parsedParams) {
            return;
        }
        this.parameters = new ParameterMap<String, String[]>();
        this.parameters.putAll(this.getRequest().getParameterMap());
        this.mergeParameters();
        ((ParameterMap)this.parameters).setLocked(true);
        this.parsedParams = true;
    }

    void setQueryParams(String string) {
        this.queryParamString = string;
    }

    void setMapping(HttpServletMapping httpServletMapping) {
        this.mapping = httpServletMapping;
    }

    protected boolean isSpecial(String string) {
        for (String string2 : specials) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    protected int getSpecial(String string) {
        for (int i = 0; i < specials.length; ++i) {
            if (!specials[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    protected boolean setSpecial(String string, Object object) {
        for (int i = 0; i < specials.length; ++i) {
            if (!specials[i].equals(string)) continue;
            this.specialAttributes[i] = object;
            return true;
        }
        return false;
    }

    protected boolean removeSpecial(String string) {
        for (int i = 0; i < specials.length; ++i) {
            if (!specials[i].equals(string)) continue;
            this.specialAttributes[i] = null;
            return true;
        }
        return false;
    }

    private String[] mergeValues(String[] stringArray, String[] stringArray2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            arrayList.addAll(Arrays.asList(stringArray));
        }
        if (stringArray2 != null) {
            arrayList.addAll(Arrays.asList(stringArray2));
        }
        return arrayList.toArray(new String[0]);
    }

    private void mergeParameters() {
        if (this.queryParamString == null || this.queryParamString.length() < 1) {
            return;
        }
        Parameters parameters = new Parameters();
        MessageBytes messageBytes = MessageBytes.newInstance();
        messageBytes.setString(this.queryParamString);
        String string = this.getCharacterEncoding();
        Charset charset = null;
        if (string != null) {
            try {
                charset = B2CConverter.getCharset((String)string);
                messageBytes.setCharset(charset);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                charset = StandardCharsets.ISO_8859_1;
            }
        }
        parameters.setQuery(messageBytes);
        parameters.setQueryStringCharset(charset);
        parameters.handleQueryParameters();
        Enumeration enumeration = parameters.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String[] stringArray = parameters.getParameterValues(string2);
            String[] stringArray2 = this.parameters.get(string2);
            if (stringArray2 == null) {
                this.parameters.put(string2, stringArray);
                continue;
            }
            this.parameters.put(string2, this.mergeValues(stringArray, stringArray2));
        }
    }

    protected class AttributeNamesEnumerator
    implements Enumeration<String> {
        protected int pos = -1;
        protected final int last;
        protected final Enumeration<String> parentEnumeration;
        protected String next = null;

        public AttributeNamesEnumerator() {
            int n = -1;
            this.parentEnumeration = ApplicationHttpRequest.this.getRequest().getAttributeNames();
            for (int i = ApplicationHttpRequest.this.specialAttributes.length - 1; i >= 0; --i) {
                if (ApplicationHttpRequest.this.getAttribute(specials[i]) == null) continue;
                n = i;
                break;
            }
            this.last = n;
        }

        @Override
        public boolean hasMoreElements() {
            return this.pos != this.last || this.next != null || (this.next = this.findNext()) != null;
        }

        @Override
        public String nextElement() {
            if (this.pos != this.last) {
                for (int i = this.pos + 1; i <= this.last; ++i) {
                    if (ApplicationHttpRequest.this.getAttribute(specials[i]) == null) continue;
                    this.pos = i;
                    return specials[i];
                }
            }
            String string = this.next;
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.next = this.findNext();
            return string;
        }

        protected String findNext() {
            String string = null;
            while (string == null && this.parentEnumeration.hasMoreElements()) {
                String string2 = this.parentEnumeration.nextElement();
                if (ApplicationHttpRequest.this.isSpecial(string2)) continue;
                string = string2;
            }
            return string;
        }
    }
}

