/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Setting;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

abstract class ConnectionSettingsBase<T extends Throwable> {
    private final Log log = LogFactory.getLog(ConnectionSettingsBase.class);
    private final StringManager sm = StringManager.getManager(ConnectionSettingsBase.class);
    private final String connectionId;
    static final int MAX_WINDOW_SIZE = Integer.MAX_VALUE;
    static final int MIN_MAX_FRAME_SIZE = 16384;
    static final int MAX_MAX_FRAME_SIZE = 0xFFFFFF;
    static final long UNLIMITED = 0x100000000L;
    static final int MAX_HEADER_TABLE_SIZE = 65536;
    static final int DEFAULT_HEADER_TABLE_SIZE = 4096;
    static final boolean DEFAULT_ENABLE_PUSH = true;
    static final long DEFAULT_MAX_CONCURRENT_STREAMS = 0x100000000L;
    static final int DEFAULT_INITIAL_WINDOW_SIZE = 65535;
    static final int DEFAULT_MAX_FRAME_SIZE = 16384;
    static final long DEFAULT_MAX_HEADER_LIST_SIZE = 32768L;
    Map<Setting, Long> current = new ConcurrentHashMap<Setting, Long>();
    Map<Setting, Long> pending = new ConcurrentHashMap<Setting, Long>();

    ConnectionSettingsBase(String string) {
        this.connectionId = string;
        this.current.put(Setting.HEADER_TABLE_SIZE, 4096L);
        this.current.put(Setting.ENABLE_PUSH, 1L);
        this.current.put(Setting.MAX_CONCURRENT_STREAMS, 0x100000000L);
        this.current.put(Setting.INITIAL_WINDOW_SIZE, 65535L);
        this.current.put(Setting.MAX_FRAME_SIZE, 16384L);
        this.current.put(Setting.MAX_HEADER_LIST_SIZE, 32768L);
    }

    final void set(Setting setting, long l) throws T {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.sm.getString("connectionSettings.debug", new Object[]{this.connectionId, this.getEndpointName(), setting, Long.toString(l)}));
        }
        switch (setting) {
            case HEADER_TABLE_SIZE: {
                this.validateHeaderTableSize(l);
                break;
            }
            case ENABLE_PUSH: {
                this.validateEnablePush(l);
                break;
            }
            case MAX_CONCURRENT_STREAMS: {
                break;
            }
            case INITIAL_WINDOW_SIZE: {
                this.validateInitialWindowSize(l);
                break;
            }
            case MAX_FRAME_SIZE: {
                this.validateMaxFrameSize(l);
                break;
            }
            case MAX_HEADER_LIST_SIZE: {
                break;
            }
            case UNKNOWN: {
                return;
            }
        }
        this.set(setting, (Long)l);
    }

    synchronized void set(Setting setting, Long l) {
        this.current.put(setting, l);
    }

    final int getHeaderTableSize() {
        return this.getMinInt(Setting.HEADER_TABLE_SIZE);
    }

    final boolean getEnablePush() {
        long l = this.getMin(Setting.ENABLE_PUSH);
        return l != 0L;
    }

    final long getMaxConcurrentStreams() {
        return this.getMax(Setting.MAX_CONCURRENT_STREAMS);
    }

    final int getInitialWindowSize() {
        return this.getMaxInt(Setting.INITIAL_WINDOW_SIZE);
    }

    final int getMaxFrameSize() {
        return this.getMaxInt(Setting.MAX_FRAME_SIZE);
    }

    final long getMaxHeaderListSize() {
        return this.getMax(Setting.MAX_HEADER_LIST_SIZE);
    }

    private synchronized long getMin(Setting setting) {
        Long l = this.pending.get((Object)setting);
        long l2 = this.current.get((Object)setting);
        if (l == null) {
            return l2;
        }
        return Math.min(l, l2);
    }

    private synchronized int getMinInt(Setting setting) {
        long l = this.getMin(setting);
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    private synchronized long getMax(Setting setting) {
        Long l = this.pending.get((Object)setting);
        long l2 = this.current.get((Object)setting);
        if (l == null) {
            return l2;
        }
        return Math.max(l, l2);
    }

    private synchronized int getMaxInt(Setting setting) {
        long l = this.getMax(setting);
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    private void validateHeaderTableSize(long l) throws T {
        if (l > 65536L) {
            String string = this.sm.getString("connectionSettings.headerTableSizeLimit", new Object[]{this.connectionId, Long.toString(l)});
            this.throwException(string, Http2Error.PROTOCOL_ERROR);
        }
    }

    private void validateEnablePush(long l) throws T {
        if (l > 1L) {
            String string = this.sm.getString("connectionSettings.enablePushInvalid", new Object[]{this.connectionId, Long.toString(l)});
            this.throwException(string, Http2Error.PROTOCOL_ERROR);
        }
    }

    private void validateInitialWindowSize(long l) throws T {
        if (l > Integer.MAX_VALUE) {
            String string = this.sm.getString("connectionSettings.windowSizeTooBig", new Object[]{this.connectionId, Long.toString(l), Long.toString(Integer.MAX_VALUE)});
            this.throwException(string, Http2Error.FLOW_CONTROL_ERROR);
        }
    }

    private void validateMaxFrameSize(long l) throws T {
        if (l < 16384L || l > 0xFFFFFFL) {
            String string = this.sm.getString("connectionSettings.maxFrameSizeInvalid", new Object[]{this.connectionId, Long.toString(l), Integer.toString(16384), Integer.toString(0xFFFFFF)});
            this.throwException(string, Http2Error.PROTOCOL_ERROR);
        }
    }

    abstract void throwException(String var1, Http2Error var2) throws T;

    abstract String getEndpointName();
}

