/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.tomcat.Jar;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.descriptor.web.WebXml;
import org.apache.tomcat.util.descriptor.web.WebXmlParser;
import org.xml.sax.InputSource;

public class FragmentJarScannerCallback
implements JarScannerCallback {
    private static final String FRAGMENT_LOCATION = "META-INF/web-fragment.xml";
    private final WebXmlParser webXmlParser;
    private final boolean delegate;
    private final boolean parseRequired;
    private final Map<String, WebXml> fragments = new HashMap<String, WebXml>();
    private boolean ok = true;

    public FragmentJarScannerCallback(WebXmlParser webXmlParser, boolean bl, boolean bl2) {
        this.webXmlParser = webXmlParser;
        this.delegate = bl;
        this.parseRequired = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(Jar jar, String string, boolean bl) throws IOException {
        InputStream inputStream = null;
        WebXml webXml = new WebXml();
        webXml.setWebappJar(bl);
        webXml.setDelegate(this.delegate);
        try {
            if (bl && this.parseRequired) {
                inputStream = jar.getInputStream(FRAGMENT_LOCATION);
            }
            if (inputStream == null) {
                webXml.setDistributable(true);
            } else {
                String string2 = jar.getURL(FRAGMENT_LOCATION);
                InputSource inputSource = new InputSource(string2);
                inputSource.setByteStream(inputStream);
                if (!this.webXmlParser.parseWebXml(inputSource, webXml, true)) {
                    this.ok = false;
                }
            }
        }
        finally {
            this.addFragment(webXml, jar.getJarFileURL());
        }
    }

    private String extractJarFileName(URL uRL) {
        String string = uRL.toString();
        if (string.endsWith("!/")) {
            string = string.substring(0, string.length() - 2);
        }
        return string.substring(string.lastIndexOf(47) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(File file, String string, boolean bl) throws IOException {
        block17: {
            WebXml webXml = new WebXml();
            webXml.setWebappJar(bl);
            webXml.setDelegate(this.delegate);
            File file2 = new File(file, FRAGMENT_LOCATION);
            try {
                if (file2.isFile()) {
                    try (FileInputStream fileInputStream = new FileInputStream(file2);){
                        InputSource inputSource = new InputSource(file2.toURI().toURL().toString());
                        inputSource.setByteStream(fileInputStream);
                        if (!this.webXmlParser.parseWebXml(inputSource, webXml, true)) {
                            this.ok = false;
                        }
                        break block17;
                    }
                }
                webXml.setDistributable(true);
            }
            finally {
                this.addFragment(webXml, file.toURI().toURL());
            }
        }
    }

    private void addFragment(WebXml webXml, URL uRL) {
        webXml.setURL(uRL);
        if (webXml.getName() == null) {
            webXml.setName(uRL.toString());
        }
        webXml.setJarName(this.extractJarFileName(uRL));
        if (this.fragments.containsKey(webXml.getName())) {
            String string = webXml.getName();
            this.fragments.get(string).addDuplicate(uRL.toString());
            webXml.setName(uRL.toString());
        }
        this.fragments.put(webXml.getName(), webXml);
    }

    public void scanWebInfClasses() {
    }

    public boolean isOk() {
        return this.ok;
    }

    public Map<String, WebXml> getFragments() {
        return this.fragments;
    }
}

